/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
/* $Id: data.h,v 1.4 1993/05/17 16:41:32 gbourhis Exp $ */

#ifndef HAS_DATA_H_BEEN_INCLUDED_BEFORE
#define HAS_DATA_H_BEEN_INCLUDED_BEFORE

#include "collage.h"
#include "pal.h"

#define	D_CHAR		1
#define	D_INT		2
#define	D_FLOAT		3
#define	D_TEXT		4

struct data_rec {
		char	*name;
		int	type;
		int	xdim,ydim;
		int	xmag,ymag;
		IntOrFloat min;
		IntOrFloat max;
		char	*buff;
		float	*fbuff;
		XImage	*image;
		XImage	*doodleImage;
		char	hasPalette;
		Palette	*pal;
		struct view_rec	*V;
		};

typedef struct data_rec Cdata;

extern	Cdata	*CdataSearchByName();
extern	Cdata	*RasDataSearchByName();
extern	Cdata	*CopyCdata();
extern	Cdata	*CdataNew();
extern	int	InitCdata();
extern	void	CdataAddEntry();

#endif /* ! HAS_DATA_H_BEEN_INCLUDED_BEFORE */
