SUBROUTINE MySolver(Model, Solver, dt, Transient)
  Use DefUtils
  IMPLICIT NONE
  TYPE(Solver_t) :: Solver
  TYPE(Model_t) :: Model
  REAL(KIND=dp) :: dt
  LOGICAL :: Transient

  INTEGER :: N
  TYPE(Mesh_t), POINTER :: Mesh
  LOGICAL :: AllocationsDone = .FALSE.
  REAL(KIND=dp), ALLOCATABLE :: Matrix(:,:), Vector(:)

  INTEGER :: i
  TYPE(Element_t), POINTER :: Element

  REAL(KIND=dp) :: Norm

  SAVE AllocationsDone, Matrix, Vector

  IF(.NOT.AllocationsDone) THEN
     Mesh => GetMesh(Solver)
     N = Mesh % MaxElementNodes
     ALLOCATE(Matrix(N,N))
     ALLOCATE(Vector(N))
  END IF
  
  DO i = 1, GetNOFActive(Solver)
     Element => GetActiveElement(i)
     N = GetElementNOFNodes(Element)
     CALL ComputeLocal(Element, N, Matrix, Vector)
     CALL DefaultUpdateEquations(Matrix, Vector, Element)
  END DO

  CALL DefaultFinishAssembly(Solver)
  CALL DefaultDirichletBCs(Solver)
  Norm = DefaultSolve(Solver)

CONTAINS

  SUBROUTINE ComputeLocal(Element, N, Matrix, Vector)
    TYPE(Element_t), POINTER :: Element
    INTEGER :: N
    REAL(KIND=dp) :: Matrix(:,:)
    REAL(KIND=dp) :: Vector(:)

    TYPE(Nodes_t) :: Nodes

    TYPE(GaussIntegrationPoints_t) :: IP

    INTEGER :: i
    REAL(KIND=dp) :: detJ, Basis(N), dBasisdx(N,3)
    LOGICAL :: stat

    SAVE Nodes

    Matrix = 0.0d0
    Vector = 0.0d0

    CALL GetElementNodes(Nodes, Element)

    IP = GaussPoints(Element)

    DO i = 1, IP % n
       stat = ElementInfo(Element, Nodes, &
            IP % u(i), IP % v(i), IP % w(i), &
            detJ, Basis, dBasisdx)

       Matrix(1:N, 1:N) = Matrix(1:N, 1:N) + &
            MATMUL(dBasisdx, TRANSPOSE(dBasisdx)) * IP % s(i) * detJ

       Vector(1:N) = Vector(1:N) + Basis * IP % s(i) * detJ
    END DO

  END SUBROUTINE ComputeLocal
END SUBROUTINE MySolver
