#ifndef DEFIN_H
#define DEFIN_H 1

#include "fem.h"


typedef struct {
         NodalData temp;
         NodalData disp;
         NodalData stress;
         NodalData von_Mises;
         NodalData max_shear;
       } AllData;

#define FILENAME_SIZE 80
#define MAX_LAYER 201

#ifndef IS_MAIN /* global variables are defined in the file that contains
                   the main function */

/***********************************************************************
 * Global variables
 ***********************************************************************/

extern bool done; /* variable to hold the parameter Done  */
extern bool disp_vec; /* variable for the param. Disp. vector */
extern bool disp_x;  /* variable for the param. Displacement x */
extern bool disp_y;  /*         -//-            Displacement y */
extern bool disp_z;  /*         -//-            Displacement z */
extern bool stress_x;  /*         -//-               Stress x */
extern bool stress_y;  /*         -//-               Stress y */
extern bool stress_z;   /*         -//-               Stress z */
extern bool stress_xy; /*         -//-               Stress xy */
extern bool stress_xz; /*         -//-               Stress xz */
extern bool stress_yz; /*         -//-               Stress yz */
extern bool stress_vec;  /*         -//-               stress vector */
extern bool von_Mises;   /* variable for the parameter von Mises */
extern bool max_shear;   /* variable for the parameter max shear */
extern bool temperature;  /* variable for the param. temperature */
extern bool auto_update; /* variable for the parameter Auto-update */

extern int step_nr; /* variable for the parameter Step nr */
extern int inc_nr;  /*           -//-             Inc nr  */
extern int shell_elem;  /* variable for the parameter shell element layer*/

extern char *temp_filename; /* string for the parameter choose file. If         
                             temp_filename is something else than NULL it is   
                             instantly copied to the variable "filename" which  
                             is defined in the main function */
extern char *pic_time;  /* string for the parameter time, no meaningful value  
                        */
                           
#endif
#endif
