#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: connect.c,v 1.8 1993/08/27 18:57:36 gbourhis Exp $";
#endif
#include <stdio.h>

#include <dtm/dtm.h>
#include <dtm/srv.h>

#include "collab.h"
#include "list.h"
#include "client.h"

#define MAX_PORT_NAME_SIZE 80
#define DTM_Mode(isAsync) (Async ? DTM_ASYNC : DTM_SYNC)

extern List conList;
extern int Async;
extern int debug;

CLIENT *GetClientByAddress(address)
char *address;
{
CLIENT *c;

	c = (CLIENT *) ListHead(conList);
	while(c) {
	    if (c->isAClient) {
		if (debug) {
			printf("comparing \"%s\" with \"%s\"\n",
				address,c->outPortAddress);
			}
		if (!strcmp(address,c->outPortAddress))
			return(c);
		}
	    c = (CLIENT *) ListNext(conList);
	    }
	return(NULL);

}

#if 0
CLIENT *GetClientByInPort(inPort)
int inPort;
{
CLIENT *c;
	c = (CLIENT *) ListHead(conList);
	while(c) {
	    if (c->isAClient) {
		if (inPort == c->inPort)
			return(c);
		}
	    c = (CLIENT *) ListNext(conList);
	    }
	return(NULL);
}

CLIENT *GetClientByName(id)
char *id;
{
CLIENT *c;
	c = (CLIENT *) ListHead(conList);
	while(c) {
	    if (c->isAClient) {
		if (strcmp(c->name, id) == 0)
			return(c);
		}
	    c = (CLIENT *) ListNext(conList);
	    }
	return(NULL);
}
#endif				/* 0 */


SendAddress(port,address)
int port;
char *address;
{
char header[1024];

	SRVsetClass(header);
	SRVsetFunction(header,SRV_FUNC_CONNECT);
	SRVsetID(header,"collage server");
	SRVsetInPort(header,address);
	if (debug) {
		printf("SendAddress(): Sending header \"%s\" to port %d\n",
			header,port);
		}

	DTMbeginWrite(port,header,strlen(header)+1);
	DTMendWrite(port);

	if (debug) {
		fputs("Message sent.\n", stdout);
		}
}


OldSendAddress(port,address)
int port;
char *address;
{
char header[256];

	DTMsetClass(header);
	strcat(header,address);
	strcat(header, " ");
	if (debug) {
		printf("SendAddress(): Sending header \"%s\" to port %d\n",
		header,port);
		}

	DTMbeginWrite(port,header,strlen(header)+1);
	DTMendWrite(port);

	if (debug) {
		fputs("Message sent.\n", stdout);
		}
}



char * DEFUN(LocalStringCopy,(string),
	     char *string)
{
char *ptr;

	ptr = (char *) MALLOC(strlen(string) +1);
	if (ptr) {
		strcpy(ptr,string);
		}
	return(ptr);
}


CheckForOlderVersion(conList,c)
List *conList;
CLIENT *c;
{
CLIENT *tmp;
int max;
char *maxString;
char header[1024];
char warning[512];


	/* find max */
	max = 0;
	maxString = (char *) 0;
	tmp = (CLIENT *) ListHead(conList);
	while(tmp) {
		if (tmp->versionNumber > max) {
			max = tmp->versionNumber;
			maxString = tmp->versionName;
			}
		tmp = (CLIENT *) ListNext(conList);
		}
	if (c->versionNumber < max)  {
		sprintf(warning,"Collage Server Warning: Your version of collage is out of date\nThe latest version in this session is %s\nNew version may be found on ftp.ncsa.uiuc.edu\n",maxString);
		MSGsetClass(header);
		MSGsetString(header,warning);
		DTMwriteMsg(c->outPort,header,strlen(header)+1,0,0,0);
		printf("New client \"%s\" is running %s\n",
					c->name,c->versionName);
		printf("which uses protocol version %d\n",
					c->versionNumber);
		printf("The latest version in this session is %s\n",
			maxString);
		printf("which uses protocol version %d.\n",max);
		printf("New versions of collage may be found on ftp.ncsa.uiuc.edu\n\n");
		}
	else if (debug) {
		printf("New client %s is running version %s\n",
				c->name,c->versionName);
		printf("Which uses protocol number %d\n",c->versionNumber);
		}	
}

CLIENT * DEFUN(ConnectNewClient,(address,conList,id,versionName,versionNumber),
	       char *address AND
	       List conList AND
	       char *id AND
	       char *versionName AND
	       int versionNumber)
{
CLIENT *c;
char newInPort[80];
char buff[256];

	if (!(c = (CLIENT *) MALLOC(sizeof(CLIENT)))) {
		ErrMesg("Out of Memory");
		return(NULL);
		}

        if ( DTMERROR ==
	    (c->inPort = DTMmakeInPort(":0", DTM_DEFAULT))) {
                sprintf(buff,"Can't make DTM in port: %s\n", 
			DTMerrmsg(1));
		ErrMesg(buff);
		FREE(c);
                return(NULL);
                }
	if ( DTMERROR ==
	    (c->outPort = DTMmakeOutPort(address, DTM_Mode(Async)))) {
		sprintf(buff,"Can't make DTM out port %s:%s\n",
			address,DTMerrmsg(1));
		ErrMesg(buff);
		FREE(c);
		return(NULL);
		}


	if (!(c->inPortAddress = (char *) MALLOC(MAX_PORT_NAME_SIZE))) {
		ErrMesg("Out of Memory\n");
		FREE(c);
		return(NULL);
		}
	if (!(c->outPortAddress = (char *) MALLOC(strlen(address)+1))) {
		ErrMesg("Out of Memory\n");
		FREE(c);
		return(NULL);
		}
	strcpy(c->outPortAddress,address);
	DTMgetPortAddr(c->inPort,c->inPortAddress,MAX_PORT_NAME_SIZE);
	if (debug) {
		printf("ConnectNewClient: outPort = %d, outPortAddress= %s\n",
				c->outPort,c->outPortAddress);
		printf("ConnectNewClient: inPort = %d, inPortAddress= %s\n",
				c->inPort,c->inPortAddress);
		}
	SendAddress(c->outPort,c->inPortAddress);
	c->name = id;
	c->timeOut = 0;
	c->isAClient = TRUE;
	c->versionName = LocalStringCopy(versionName);
	c->versionNumber = versionNumber;

	CheckForOlderVersion(conList,c);

	ListAddEntry(conList,c);

	if (debug) {
		printf("client at address %s (%s) added (port %d)\n",
			address,c->outPortAddress,c->inPort);
		}

	return c;
	
}


RemoveSpaces(s)
char *s;
{
register char *p;
	p = s;
	while (*p) {
		if (*p != ' ')
			*s++ = *p++;
		else 
			p++;
		}
	*s = '\0';
}

CLIENT *RecvAddress(address,id,versionName,versionNumber)
char *address;
char *id;
char *versionName;
int versionNumber;
{
CLIENT *c;

	if (debug)  {
		printf("RecvAddress(): Just received address \"%s\"\n",
			address);
		}

	RemoveSpaces(address);
	if (debug)  {
		printf("RecvAddress(): after spaces removed = \"%s\"\n",
			address);
		}
	if (c = GetClientByAddress(address))
		return c; /* already connected ----> ignore */

	/* else connect */

	return
		ConnectNewClient(address,conList,id,versionName,versionNumber);

}

RemoveClient(client)
CLIENT *client;
{
CLIENT *c;

	if (debug) {
		printf("Just dropped client %s at address %s\n",
			client->name,client->inPortAddress);
		}

	ListDeleteEntry(conList,client);

	if (client->name)
		FREE(client->name);

	FREE(client);
	
	c = (CLIENT *) ListHead(conList);
	while (c) {
		if (c->isAClient)
			return;
		c = (CLIENT *) ListNext(conList);
		}

	if (debug) {
		fputs("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n", stdout);
		fputs("server: No more clients... exiting\n", stdout);
		fputs("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n", stdout);
		}
	exit(0);

}
