/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: hist.c,v 1.7 1993/07/21 21:58:59 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>

#include <dtm/dtm.h>
#include <dtm/col.h>
#include <dtm/dol.h>
#include "collageP.h"
#include "net.h"
#include "view.h"
#include "list.h"
#include "hist.h"


#define	HIST_BORDER	20

#ifndef MALLOC
#define MALLOC  malloc
#define FREE    free
#endif


extern void GotDelete();


static Display *myDpy;
static Widget rootWidget;
static List histList;



static Histogram *
HistSearchByName(name)
char *name;
{
	Histogram *hist;

	hist = (Histogram *) ListHead(histList);
	while(hist)
	{
		if (!strcmp(hist->data->name, name))
			return(hist);
		hist = (Histogram *) ListNext(histList);
	}
	return(0);
}


static void
CBHistDone(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	Histogram *hist = (Histogram *)client_data;

	XtPopdown(hist->shell);
	hist->isUp = False;
}


static void
CBHistExpose(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	Histogram *hist = (Histogram *)client_data;
	XWindowAttributes attr;
	int width, height, extra;
	int i, x, y, max, val, lastval;
	unsigned long pixValue;
	char buff[256];

	if (hist->isUp == False)
	{
		hist->isUp = True;
	}

	XGetWindowAttributes(myDpy, XtWindow(hist->drawArea), &attr);
	width = attr.width - (2 * HIST_BORDER) - (5 * hist->fWidth);
	height = attr.height - (2 * HIST_BORDER) - (4 * hist->fHeight);

	XSetForeground(myDpy, hist->histGC, hist->fg);
	XSetBackground(myDpy, hist->histGC, hist->bg);

	XClearWindow(myDpy, XtWindow(hist->drawArea));

	max = 0;
	for (i=0; i < hist->vcnt; i++)
	{
		if (hist->vals[i] > max)
		{
			max = hist->vals[i];
		}
	}

	sprintf(buff, "Selected Area (%d,%d) to (%d,%d)",
		hist->start_x, hist->start_y, hist->end_x, hist->end_y);
	val = (width / 2) - (hist->fWidth * strlen(buff) / 2);
	XDrawString(myDpy, XtWindow(hist->drawArea), hist->histGC,
		(HIST_BORDER + (5 * hist->fWidth) + val),
		(HIST_BORDER + hist->fHeight + (hist->fHeight / 2)),
		buff, strlen(buff));

	if (max <= (height / (2 * hist->fHeight)))
	{
		for (val = 0; val <= max; val++)
		{
			y = (val * height) / max;
			sprintf(buff, "%4d", val);
			XDrawString(myDpy, XtWindow(hist->drawArea),
				hist->histGC,
				HIST_BORDER,
				(height - y + HIST_BORDER +
					(2 * hist->fHeight) +
					(hist->fHeight / 2)),
				buff, strlen(buff));
			XDrawLine(myDpy, XtWindow(hist->drawArea), hist->histGC,
				(HIST_BORDER + (5 * hist->fWidth) - 3),
				(height - y + HIST_BORDER +
					(2 * hist->fHeight)),
				(HIST_BORDER + (5 * hist->fWidth) + 3),
				(height - y + HIST_BORDER +
					(2 * hist->fHeight)));
		}
	}
	else
	{
		extra = height / (2 * hist->fHeight);
		for (i = 0; i <= extra; i++)
		{
			y = (i * height) / extra;
			val = (y * max) / height;
			sprintf(buff, "%4d", val);
			XDrawString(myDpy, XtWindow(hist->drawArea),
				hist->histGC,
				HIST_BORDER,
				(height - y + HIST_BORDER +
					(2 * hist->fHeight) +
					(hist->fHeight / 2)),
				buff, strlen(buff));
			XDrawLine(myDpy, XtWindow(hist->drawArea), hist->histGC,
				(HIST_BORDER + (5 * hist->fWidth) - 3),
				(height - y + HIST_BORDER +
					(2 * hist->fHeight)),
				(HIST_BORDER + (5 * hist->fWidth) + 3),
				(height - y + HIST_BORDER +
					(2 * hist->fHeight)));
		}
	}

	lastval = -1;
	extra = width / ((hist->data->type!=D_FLOAT ? 4 : 11) * hist->fWidth);
				/* number of intervals */

	for (i = 0; i <= extra; i++)
	{
		float interv_pos;

		x = (i * width) / extra;
		interv_pos = (float)(x*(hist->vcnt-1)) / (float)width + .4999;
		val = (int)interv_pos;
		if (val == lastval)
		{
			continue;
		}
		if (hist->data->type == D_FLOAT)
		  {
			float delta, cv;
			delta = (hist->data->max.f - hist->data->min.f) /
			  hist->vcnt;
			cv = hist->data->min.f + (val+.4999)*delta;
			sprintf(buff, "%.4g", cv);
		  }
		else if (hist->data->type == D_INT)
		  {
			int range = hist->data->max.i - hist->data->min.i;
			sprintf(buff, "%d", hist->data->min.i +
				(((2*val+1)*(range+1))/hist->vcnt - 1)/2);
		  }
		else
			sprintf(buff, "%d",
				(((2*val+1)*256)/hist->vcnt - 1)/2);

		XDrawString(myDpy, XtWindow(hist->drawArea), hist->histGC,
			(HIST_BORDER + (5 * hist->fWidth) + x - ((hist->fWidth *
				strlen(buff)) / 2)),
			(height + HIST_BORDER + (3 * hist->fHeight) + 5),
                        buff, strlen(buff));
		XDrawLine(myDpy, XtWindow(hist->drawArea), hist->histGC,
			(HIST_BORDER + (5 * hist->fWidth) + x),
			(HIST_BORDER + (2 * hist->fHeight) + height - 3),
			(HIST_BORDER + (5 * hist->fWidth) + x),
			(HIST_BORDER + (2 * hist->fHeight) + height + 3));
		lastval = val;
	}

	XDrawLine(myDpy, XtWindow(hist->drawArea), hist->histGC,
		(HIST_BORDER + (5 * hist->fWidth)),
		(HIST_BORDER + (2 * hist->fHeight)),
		(HIST_BORDER + (5 * hist->fWidth)),
		(HIST_BORDER + (2 * hist->fHeight) + height));
	XDrawLine(myDpy, XtWindow(hist->drawArea), hist->histGC,
		(HIST_BORDER + (5 * hist->fWidth)),
		(HIST_BORDER + (2 * hist->fHeight) + height),
		(HIST_BORDER + (5 * hist->fWidth) + width),
		(HIST_BORDER + (2 * hist->fHeight) + height));

	for (i = 0; i < hist->vcnt; i++)
	{
		int x, y;
		unsigned int w, h;

		val = hist->vals[i];
		if (val == 0)
		{
			continue;
		}
		if (i == 0)
		{
			x = 0;
		}
		else
		{
			x = (((2 * i - 1) * width) / (hist->vcnt-1)) / 2 + 1;
		}
		w = (((2 * i + 1) * width) / (hist->vcnt-1)) / 2 + 1 - x;
		if (w == 0)
		  w = 1;
		x = x + HIST_BORDER + (5 * hist->fWidth);
		y = (val * height) / max;
		h = y;
		y = height - y + HIST_BORDER + (2 * hist->fHeight);
		if (hist->data->type == D_CHAR)
		  pixValue = (unsigned long)((((2*i+1)*256)/hist->vcnt - 1)/2);
		else
		  pixValue = (unsigned long)((((2*i+1)*NCOLORS)/hist->vcnt - 1)
					     / 2) + BASE_PIX;
		XSetForeground(myDpy, hist->histGC, pixValue);
		XFillRectangle(myDpy, XtWindow(hist->drawArea), hist->histGC,
			x, y, w, h);
	}
}


static void
CollectHist(hist, x1, y1, x2, y2)
	Histogram *hist;
	int x1, y1, x2, y2;
{
	Cdata *data = hist->data;
	int i, x, y;
	unsigned char *ptr;

	if (x1 < x2)
	{
		hist->start_x = x1 / data->xmag;
		hist->end_x = x2 / data->xmag;
	}
	else
	{
		hist->start_x = x2 / data->xmag;
		hist->end_x = x1 / data->xmag;
	}

	if (y1 < y2)
	{
		hist->start_y = y1 / data->ymag;
		hist->end_y = y2 / data->ymag;
	}
	else
	{
		hist->start_y = y2 / data->ymag;
		hist->end_y = y1 / data->ymag;
	}

	for (i=0; i < hist->vcnt; i++)
	{
		hist->vals[i] = 0;
	}

	if (data->type == D_FLOAT)
	  {
	    float cv;

	    for (y = hist->start_y; y <= hist->end_y; y++)
		for (x = hist->start_x; x <= hist->end_x; x++)
		  {
			cv = data->fbuff[y*data->xdim/data->xmag+x];

			i = ((cv - data->min.f)*(float)hist->vcnt)/
			  (data->max.f - data->min.f);

			hist->vals[(i>hist->vcnt-1) ? hist->vcnt-1 : i]++;
		  }
	  }
	else if (data->type == D_INT)
	  {
	    int
	      cv,
	      range = data->max.i - data->min.i;

	    for (y = hist->start_y; y <= hist->end_y; y++)
		for (x = hist->start_x; x <= hist->end_x; x++)
		  {
			cv = ((int *)data->fbuff)[y*data->xdim/data->xmag+x];

			i = (hist->vcnt*(cv-data->min.i))/(range+1);

			hist->vals[i]++;
		  }
	  }
	else			/* data->type == D_CHAR */
	  {
	    int cv;

	    for (y = hist->start_y; y <= hist->end_y; y++)
		for (x = hist->start_x; x <= hist->end_x; x++)
		  {
			cv = (int)*((unsigned char *)data->buff +
				    (y * data->xdim) + x);

			hist->vals[(hist->vcnt*cv)/256]++;
		  }
	  }

}

static void
CBchangeInterval(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	XmSelectionBoxCallbackStruct *call_data;
{
	Histogram *hist = (Histogram *)client_data;
	char *value;
	int vcnt;

	if (call_data->reason == XmCR_OK)
	  {
        	XmStringGetLtoR(call_data->value, XmSTRING_DEFAULT_CHARSET,
				&value);

		sscanf(value,"%d", &vcnt);
		if (vcnt > 1)
		  {
			hist->vcnt = vcnt;
			if (!(hist->vals =
			      (int *)realloc(hist->vals, vcnt * sizeof(int))))
			  ErrMesg
			    ("Out of Memory making Histogram value array\n");
			else
			  {
			    CollectHist(hist, hist->start_x*hist->data->xmag,
					hist->start_y*hist->data->ymag,
					hist->end_x*hist->data->xmag,
					hist->end_y*hist->data->ymag);
			    CBHistExpose(w, client_data, call_data->event);
			  }
		  }
	  }

	XtDestroyWidget(w);
}

static void
CBGetIntervNumber(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	Histogram *hist = (Histogram *)client_data;
	Cardinal i;
	Arg argList[3];
	Widget dialog;
	XmString label;
	char buff[512];

	sprintf(buff,
		"Enter Number of intervals for histogram of %s",
		hist->data->name);

        label = XmStringCreateSimple(buff);

        i = 0;
	XtSetArg(argList[i], XtNtitle, "Define Number of intervals"); i++;
        XtSetArg(argList[i], XmNselectionLabelString, label); i++;
        dialog = XmCreatePromptDialog(hist->shell, "intervalDialog", argList,
				      i);

	XmStringFree(label);

        XtAddCallback(dialog, XmNokCallback, CBchangeInterval, (caddr_t)hist);
        XtAddCallback(dialog, XmNcancelCallback, CBchangeInterval,
	  (caddr_t)hist);

	XtManageChild(dialog);
}


static void
CBHistStruct(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	if (event->type == ConfigureNotify)
	{
		CBHistExpose(w, client_data, event);
	}
}


static void
CBHistMap(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	Histogram *hist = (Histogram *)client_data;

	if (event->type == MapNotify)
	{
		hist->isUp = True;
	}
	else if (event->type == UnmapNotify)
	{
		hist->isUp = False;
	}
}


static Histogram *
HistCreate(vroot, data)
	Widget vroot;
	Cdata *data;
{
	Histogram *hist;
	Widget mainWindow, pulldown, b;
	XGCValues gcval;
	XmString label;
	Cardinal i;
	Arg argList[30];
	char buff[256];

	if (!(hist = (Histogram *) MALLOC (sizeof(Histogram))))
	{
		ErrMesg("Out of Memory making Histogram\n");
		return(0);
	}
	if (data->type == D_INT && (data->max.i - data->min.i) < NCOLORS)
		hist->vcnt = (data->max.i - data->min.i) + 1;
	else if (data->type == D_INT || data->type == D_FLOAT)
		hist->vcnt = NCOLORS;
	else
		hist->vcnt = 256;
	if (!(hist->vals = (int *)MALLOC(hist->vcnt * sizeof(int))))
	{
		ErrMesg("Out of Memory making Histogram value array\n");
		return(0);
	}
	hist->data = data;

	sprintf(buff, "Histogram of %s", data->name);
	i = 0;
	XtSetArg(argList[i], XmNallowShellResize, True); i++;
	XtSetArg(argList[i], XtNtitle, buff); i++;
	XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        XtSetArg(argList[i], XmNdeleteResponse, XmUNMAP); i++;
        XtSetArg(argList[i], XmNcolormap,
		 DefaultColormapOfScreen(XtScreen(vroot))); i++;
	hist->shell = XtCreatePopupShell("Histogram", transientShellWidgetClass,
					vroot, argList, i);

	mainWindow = XmCreateForm(hist->shell, "Histogram", argList, i);
	XtManageChild(mainWindow);

	i = 0;
        XtSetArg(argList[i], XmNwidth, 400); i++;
        XtSetArg(argList[i], XmNheight, 300); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        hist->menuBar = XmCreateMenuBar(mainWindow, "menuBar" ,argList, i);
        XtManageChild(hist->menuBar);

	i = 0;
        XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
        pulldown = XmCreatePulldownMenu(hist->menuBar, "pulldown",
                                                        argList, i);

	i = 0;
        label = XmStringCreateLtoR("File", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'F'); i++;
        b = XmCreateCascadeButton(hist->menuBar, "button", argList, i);
        XtManageChild(b);

	i = 0;
        label = XmStringCreateLtoR("Done", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i], XmNmnemonic, 'D'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        b = XmCreatePushButtonGadget(pulldown, "button", argList, i);
        XtAddCallback(b, XmNactivateCallback, CBHistDone, (caddr_t)hist);
	XtManageChild(b);


	i = 0;
        XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
        pulldown = XmCreatePulldownMenu(hist->menuBar, "pulldown",
                                                        argList, i);

	i = 0;
        label = XmStringCreateLtoR("Options", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'O'); i++;
        b = XmCreateCascadeButton(hist->menuBar, "button", argList, i);
        XtManageChild(b);

	i = 0;
        label = XmStringCreateLtoR("Number of Intervals",
				   XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i], XmNmnemonic, 'I'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        b = XmCreatePushButtonGadget(pulldown, "button", argList, i);
        XtAddCallback(b, XmNactivateCallback, CBGetIntervNumber,
		      (caddr_t)hist);
	XtManageChild(b);

	i = 0;
        XtSetArg(argList[i], XmNtopWidget, hist->menuBar); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNx, 0); i++;
        XtSetArg(argList[i], XmNy, 30); i++;
        XtSetArg(argList[i], XmNwidth, 400); i++;
        XtSetArg(argList[i], XmNheight, 300); i++;
        hist->drawArea = XmCreateForm(mainWindow, "Histogram", argList, i);
        XtManageChild(hist->drawArea);
        XtAddEventHandler(hist->drawArea, ExposureMask, 0,
                                CBHistExpose, (caddr_t)hist);
        XtAddEventHandler(hist->drawArea, StructureNotifyMask, 0,
                                CBHistStruct, (caddr_t)hist);

        XtAddEventHandler(hist->shell, StructureNotifyMask, 0,
                                CBHistMap, (caddr_t)hist);

	hist->histGC = XtGetGC(hist->drawArea, 0, &gcval);
	hist->font = XQueryFont(myDpy, XGContextFromGC(hist->histGC));
	if (!hist->font)
	{
		hist->fWidth = 13;
		hist->fHeight = 13;
	}
	else
	{
		hist->fWidth = hist->font->max_bounds.width;
		hist->fHeight = hist->font->max_bounds.ascent +
				      hist->font->max_bounds.descent;
	}
	hist->start_x = 0;
	hist->start_y = 0;
	hist->end_x = 0;
	hist->end_y = 0;
	
        XtSetArg(argList[0], XmNforeground, &(hist->fg));
        XtSetArg(argList[1], XmNbackground, &(hist->bg));
        XtGetValues(hist->drawArea, argList, 2);

	ListAddEntry(histList, hist);
	hist->isUp = FALSE;

	return(hist);
}


void
HistInternalChange(name, x1, y1, x2, y2)
	char *name;
	int x1, y1, x2, y2;
{
	Cdata *d;
	View *V;
	Histogram *hist;

	d = CdataSearchByName(name);
	if ((d != NULL)&&(d->V->type == V_RASTER))
	{
		V = d->V;
		hist = HistSearchByName(name);
		if (hist == NULL)
		{
			hist = HistCreate(V->shell, d);
		}
		CollectHist(hist, x1, y1, x2, y2);
		if (hist->isUp == False)
		{
			XtPopup(hist->shell, XtGrabNone);
			XSetWindowColormap(myDpy, XtWindow(hist->shell),
				V->cmap);
			XSetWindowColormap(myDpy, XtWindow(hist->drawArea),
				V->cmap);
		}
		else
		{
			XClearArea(myDpy, XtWindow(hist->drawArea), 0, 0, 0, 0,
					True);
		}
	}
}


static void
GotHist(data, new)
	Col *data;
	int new;
{
	Cdata *d;
	View *V;
	Histogram *hist;

	if ((data->selType == COL_AREA)&&(!strcmp(data->func, "HISTOGRAM")))
	{
		d = CdataSearchByName(data->title);
		if ((d != NULL)&&(d->V->type == V_RASTER))
		{
			V = d->V;
			hist = HistSearchByName(data->title);
			if (hist == NULL)
			{
				hist = HistCreate(V->shell, d);
			}
			CollectHist(hist,
				(int)(data->data[0].x), (int)(data->data[0].y),
				(int)(data->data[1].x), (int)(data->data[1].y));
			if (hist->isUp == False)
			{
				XtPopup(hist->shell, XtGrabNone);
				XSetWindowColormap(myDpy, XtWindow(hist->shell),
					V->cmap);
				XSetWindowColormap(myDpy,
					XtWindow(hist->drawArea), V->cmap);
			}
			else
			{
				XClearArea(myDpy, XtWindow(hist->drawArea),
					0, 0, 0, 0, True);
			}
		}
	}
	else if (data->selType == COL_AREA)
	{
		fprintf(stderr, "Don't recognize Area Select with function (%s)\n", data->func);
	}
}


static void
GotHistDOL(data, new)
	Dol *data;
	int new;
{
	if ((data->selType == DOL_AREA)&&(!strcmp(data->func, "HISTOGRAM")))
	{
		Cdata *d;
		View *V;
		Histogram *hist;

		d = CdataSearchByName(data->title);
		if ((d != NULL)&&(d->V->type == V_RASTER))
		{
			V = d->V;
			hist = HistSearchByName(data->title);
			if (hist == NULL)
			{
				hist = HistCreate(V->shell, d);
			}
			CollectHist(hist,
				(int)(data->data[0]), (int)(data->data[1]),
				(int)(data->data[2]), (int)(data->data[3]));
			if (hist->isUp == False)
			{
				XtPopup(hist->shell, XtGrabNone);
				XSetWindowColormap(myDpy, XtWindow(hist->shell),
					V->cmap);
				XSetWindowColormap(myDpy,
					XtWindow(hist->drawArea), V->cmap);
			}
			else
			{
				XClearArea(myDpy, XtWindow(hist->drawArea),
					0, 0, 0, 0, True);
			}
		}
	}
}


void
HistSetup(rwidget)
	Widget rwidget;
{
	rootWidget = rwidget;
	myDpy = XtDisplay(rootWidget);
	histList = ListCreate();
	NetRegisterModule("Histogram", NETCOL, GotHist, (caddr_t)1, GotHist,
			  (caddr_t)0, GotDelete, (caddr_t)0);
	NetRegisterModule("Histogram", NETDOL, GotHistDOL, (caddr_t)1,
			  GotHistDOL, (caddr_t)0, GotDelete, (caddr_t)0);
}

