%***************************************************************************
%  FILE = sym.red 				Sun Oct 30 21:56:56 EST 1988
% 
%  Procedures in this file:
%  
%  SYMI SYMA SYM BUBSRT HERMITIAN ORDERINDEX1 EXCHANGE CNVRTN 
%  CNVRTINDEX INDXN SGNSYM SYMSZE CNJFLG TRACESYM MULTIP
%  MULTIP1 MAKEDIFSYM
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

FLUID '(SYMI!*);   	% flag for diagonal syms to be regarded as regular
SYMI!* := 'NIL;
FLUID '(BUBSRT!*);	% global vector

% symi applies symmetry relations to an indexed object and returns
% the new object with a canonical index, or 0.

SYMBOLIC PROCEDURE SYMI (INP);
BEGIN SCALAR LEX, LEX1, SYMI!*, TNSR;
  IF (NOT MYCADDR (INP) OR 
     NOT (LEX1 := GET (TNSR := MYCADR (INP), 'SYMMETRY))
     OR INTINDEX (MYCADDR (INP)) )
     AND NOT DERIV (MYCADDR (INP), 'NIL) THEN
    RETURN (INP);    			% no index or no symmetry.
  LEX := SYMA (MYCADDR (INP), MAKEDIFSYM (MYCADDR (INP), LEX1),
	GET (TNSR, 'CONCOV));  % do the index
  LEX1 := FORMRDR (TNSR, MYCAR (LEX), MYCADDDR (INP));  % new form
  IF MYCADDR (LEX) THEN LEX1 := CONJRDR (LEX1);  % conjugate flag set
  IF MYCADR (LEX) = 0 THEN RETURN (0)    % sym sez 0
  ELSE IF MYCADR (LEX) < 0 THEN RETURN (LIST ('MINUS, LEX1)) % got a minus
  ELSE RETURN (LEX1);
END;

% syma applies symmetries to a normal index, by using cnvrtindex and
% calling sym.

SYMBOLIC PROCEDURE SYMA (INDEX, SYMLST, CONCOV);
BEGIN SCALAR SYMI!*, LEX;
  IF NOT SYMLST THEN RETURN (LIST (INDEX, 1));
  SYMI!* := 'T;    % dont want 0 if diagonal and its given e.g [a,b]
  LEX := SYM (CNVRTINDEX (INDEX, CONCOV OR 'T), SYMLST);
  RETURN (LIST (CNVRTINDEX (MYCAR (LEX), 'NIL), MYCADR (LEX), MYCADDR (LEX)));
END;

FLUID '(CFLG);    % conjugation flag

% sym applies the symmetries described in the symlist to the integer
% index supplied. to make things easier when moving parts of the index
% around to form the canonical index, the elements of the index are
% written to a globally defined vector bubsrt* (unless there are just
% two elements, in which case the symmetrization is trivial).
% sym returns a list of the form (index, sign, cflag),
% where index is the canonical index, sign is the net sign of the symmetries
% applied (or 0 if they force it), and cflag indicates the need for 
% conjugation.

SYMBOLIC PROCEDURE SYM (INDEX, SYMLIST);
BEGIN SCALAR SGN, I, N, LEX, BSYM, BINDEX, LEX1;
  IF NOT SYMLIST THEN RETURN (LIST (INDEX, 1))
  ELSE IF NOT MYCADDR (INDEX) THEN     	% only 2 elements, do it quick.
    IF MYCAR (INDEX) > MYCADR (INDEX) THEN  % need to reverse
      RETURN (LIST (LIST (MYCADR (INDEX), MYCAR (INDEX)), 
          SGNSYM (SYMLIST), CNJFLG (SYMLIST)))
    ELSE IF MYCAR (INDEX) < MYCADR (INDEX) THEN  % are in order and !=
      RETURN (LIST (INDEX, ABS (SGNSYM (SYMLIST))))
    ELSE IF NOT (SGNSYM (SYMLIST) < 0) THEN   % are = with symmetry or diagonal
           RETURN (LIST (INDEX, 1))
    ELSE RETURN (LIST (INDEX, 0));      % are = with antisymmetry

  BSYM := SYMLIST;
  BINDEX := INDEX;
  BUBSRT!* := MKVECT (LENGTH (INDEX) + 1);  % define vector
  I := 1;
  WHILE INDEX DO <<		% copy index to vector
    PUTV (BUBSRT!*, I, MYCAR (INDEX));
    INDEX := MYCDR (INDEX);
    I := I + 1
  >>;

  SGN := 1;
  CFLG := 'NIL;
  LOOP:
    IF ATOM (MYCAAR (SYMLIST)) THEN GO TO AFTERLOOP;
    SGN := BUBSRT (MYCDAR (SYMLIST), SGNSYM (SYMLIST) * SYMSZE (SYMLIST),
                SGN, CNJFLG (SYMLIST));
    IF SGN = 0 THEN RETURN (LIST (INDEX, 0));
    SYMLIST := MYCDR (SYMLIST);
  GO TO LOOP;
  AFTERLOOP:
  WHILE NOT I = 1 DO <<
    I := I - 1;
    INDEX := GETV (BUBSRT!*, I) . INDEX
  >>;
  IF MYCAR (SYMLIST) THEN <<  	% there is also a hermitian symmetry.
    LEX := HERMITIAN (INDEX, MYCDAR (SYMLIST));  % flip each pair indicated
    IF MYCDR (LEX) THEN <<	% the flip is ordered below what it was,
	 	                % has it violated the other symmetries?
      LEX1 := SYM (MYCAR (LEX), REVERSE (MYCDR (REVERSE (BSYM))));
      IF MYCAR (LEX1) = MYCAR (LEX) THEN <<  % its still the same, so ok.
        INDEX := MYCAR (LEX);
        CFLG := NOT CFLG		% hermitian means another conjugate.
      >>
    >>
  >>;
  RETURN (LIST (INDEX, SGN, CFLG));
END;

% bubsrt implements a bubble sort algorithm to sort an index into
% canonical form. bubsrt is called by sym for each independent symmetry
% the object has. the index is in a global vector, and bubsrt returns
% the net sign of the symmetrizations so far applied. the conjugate flag
% is global (this is sloppy, but easier to do).

SYMBOLIC PROCEDURE BUBSRT (LIS, LEN, SGN, LCFLG);
BEGIN SCALAR N, I, J, K, L, SZE, LEX, SGNS;
  SGNS := SIGN (LEN);  		% sign of the symmetry.
  SZE := MAX (1, ABS (LEN));    % block size; 0 --> 1.
  N := LENGTH (LIS);		% lis = pointer list.
  I := 1;
  WHILE NOT (I = N) DO <<      % this is a standard algorithm.
    J := I;
    BEGIN;
      LOOP:
      LEX := ORDERINDEX1 (K := NTH (LIS, J),  % see if blocks are ordered
                          L := NTH (LIS, J + 1), SZE);
      IF ((LEN < 0) AND (LEX = 0)) OR ((LEN = 0) AND NOT (LEX = 0))
              THEN <<   % antisymmetry and blocks =, or diagonal and !=
                      SGN := 0;
                      I := N - 1;  % below i gets inc'ed, and we leave the while
                      LEX := 1;
                      GO TO AFTERLOOP;
              >>;
      J := J - 1;
      IF NOT LEX = -1 THEN GO TO AFTERLOOP;	% if lex is 1 or 0 its done.
      EXCHANGE (K, L, SZE);     	% exchange blocks
      LCFLG AND (CFLG := NOT CFLG);   % and update the conjugate flag
      SGN := SGN * SGNS;		% and update the net sign.
      IF J < 1 THEN GO TO AFTERLOOP;
      GO TO LOOP;
      AFTERLOOP:
    END;
    I := I + 1
  >>;
  RETURN (SGN); 	% net sign so far.
END;

% hermitian applies the hermitian symmetry to an index by exchanging
% pairs of indices pointed to by the pointer list plst. if the result
% of this operation is ordered less than the original index, then
% it is returned, along with a flag set to 't to indicate that something
% was done.

SYMBOLIC PROCEDURE HERMITIAN (INDEX, PLST);
BEGIN SCALAR LIS, LEX, I;
  LEX := INDEX;
  I := 1;
  WHILE INDEX DO <<
    IF I = MYCAR (PLST) THEN <<	% current position = a pointer
      LIS := MYCAR (INDEX) . (MYCADR (INDEX) . LIS); % put the next 2 in backward
      INDEX := MYCDDR (INDEX);
      PLST := MYCDR (PLST);
      I := I + 2
    >> ELSE <<  % put these on in order.
      LIS := MYCAR (INDEX) . LIS;
      INDEX := MYCDR (INDEX);
      I := I + 1
    >>
  >>;
  LIS := REVERSE (LIS);
    % note: orderindex returns 'e if the indices are =, 't if they are ordered
    % and 'nil if they are not. so this only says yes if they are ordered, not
    % if they are merely =.
  RETURN (LIS . (ORDERINDEX (LIS, LEX) EQ 'T));
END;

% orderindex1 determines if the elements of an index pointed to
% by i and j and of size sze are canonically ordered. it returns
% -1, 0, or 1 depending on whether the i block is less than, 
% equal to, or greater than the j block, respectively.
% note that the index has been written into a vector for faster
% accessing.

SYMBOLIC PROCEDURE ORDERINDEX1 (I, J, SZE);
BEGIN SCALAR K;
  K := 1;
  LOOP:
    IF K > SZE THEN RETURN (0)
    ELSE IF GETV (BUBSRT!*, I) < GETV (BUBSRT!*, J) THEN RETURN (1)
    ELSE IF GETV (BUBSRT!*, I) > GETV (BUBSRT!*, J) THEN RETURN (-1);
    I := I + 1;
    J := J + 1;
    K := K + 1;
    GO TO LOOP;
END;

% exchange takes sublists of length len beginning at pointers
% n and m and exchanges them. this routine does the real work of
% forming a canonical index, and is called by bubsrt.

SYMBOLIC PROCEDURE EXCHANGE (N, M, LEN);
BEGIN SCALAR I, TMP;
  I := 1;
  WHILE NOT (I > LEN) DO <<  % exchange one at a time, until entire block moved
    TMP := GETV (BUBSRT!*, N);
    PUTV (BUBSRT!*, N, GETV (BUBSRT!*, M));
    PUTV (BUBSRT!*, M, TMP);
    N := N + 1;
    M := M + 1;
    I := I + 1
  >>;
END;

% cnvrtn takes its input and does one of 3 things to it depending
% on the form of the input:
% 1. if the input is a number less than 32, the input is returned.
% 2. if the input is a number not less than 32, it is converted to
%    a character string.
% 3. if the input is a character string, it is converted to a number.
% in all cases cnvrtn (cnvrtn (input)) = input. (input is never a list). 
% essentially, the number is a decimal equivalent of the base 128 representation
% of the ascii character string. (or something like that)

SYMBOLIC PROCEDURE CNVRTN (INP);
BEGIN SCALAR LEX, LEX1;
  IF FIXP (INP) AND INP < 32 THEN RETURN (INP)   % these are never touched.
  ELSE IF IDP (INP) THEN <<	% input is a string.
    LEX := EXPLODE (INP);
    IF LENGTH (LEX) = 1 THEN RETURN (MASCII (INP)); % single char
    LEX1 := 0;
    WHILE LEX DO <<		% generate number
      LEX1 := LEX1 * 128 + MASCII (MYCAR (LEX));
      LEX := MYCDR (LEX)
    >>;
    RETURN (LEX1)
  >>
  ELSE IF INP < 127 THEN RETURN (MASCII (INP))  % result is a single char.
  ELSE IF FIXP (INP) THEN <<
    WHILE NOT (INP = 0) DO <<	% chop number up to generate chars of string.
      LEX := MASCII (REMAINDER (INP, 128)) . LEX;
      INP := QUOTIENT (INP, 128)
    >>;
    RETURN (MAKENAME (LEX))
  >>;
END;

GLOBAL '(OFFSET);

SYMBOLIC SETQ (OFFSET, 1000000000);  % used to push shifted indices around.

% cnvrtindex applies cnvrtn to a whole index to translate it to or from
% a form that sym can use (i.e strictly integer indices). the concov list
% is only used to decide which way a shifted index will be pushed (if its
% going up, it moves left, otherwise it moves right, this is accomplished
% by adding or subtracting that huge number above to the integer equivalent
% of the indice). the presence of the concov also acts as a flag to indicate
% which way the conversion is applied, since cnvrtindex is similar to cnvrtn;
% it goes both ways.

SYMBOLIC PROCEDURE CNVRTINDEX (INDEX, CONCOV);
BEGIN SCALAR LIS;
  IF CONCOV THEN <<   % convert from ordinary index to integer equivalent.
    WHILE INDEX DO <<
      IF CHECKTYPE (MYCAR (INDEX), '!*AT!*) THEN <<  % handle shifts
        IF MYCAR (CONCOV) > 0 THEN       % going right.
           LIS := (OFFSET + CNVRTN (MYCADAR (INDEX))) . LIS
        ELSE			       % going left
           LIS := (CNVRTN (MYCADAR (INDEX)) - OFFSET) . LIS;
      >>
         % this handles (nthelmnt index n). i'm not sure how.
      ELSE IF NOT ATOM (MYCAR (INDEX)) THEN LIS := (CNVRTN (MYCADAR (INDEX)) +
                CNVRTN (MYCADDAR (INDEX))) . LIS 
      ELSE LIS := CNVRTN (MYCAR (INDEX)) . LIS;
      IF (NOT (ATOM (CONCOV))) THEN CONCOV := MYCDR (CONCOV);
      INDEX := MYCDR (INDEX);
    >>;
    RETURN (REVERSE (LIS));
  >>
  ELSE <<	% convert back to normal form.
    WHILE INDEX DO <<
      IF MYCAR (INDEX) < 0 THEN   % only negs come from move left shifts
         LIS := LIST ('!*AT!*, CNVRTN (OFFSET + MYCAR (INDEX))) . LIS
      ELSE IF MYCAR (INDEX) > OFFSET THEN  % move right shift.
         LIS := LIST ('!*AT!*, CNVRTN (MYCAR (INDEX) - OFFSET)) . LIS
      ELSE
         LIS := CNVRTN (MYCAR (INDEX)) . LIS;	% ordinary index
      INDEX := MYCDR (INDEX);
    >>;
    RETURN (REVERSE (LIS));
  >>;
END;

% indxn returns the n'th pointer of the symmetry list. should be a macro.

SYMBOLIC PROCEDURE INDXN (LIS, N);
  NTH (MYCAR (LIS), N + 1);

% sgnsym returns the sign of the first indep symmetry in the sym list. 
% should be a macro.

SYMBOLIC PROCEDURE SGNSYM (LIS);
  IF (MYCAAAR (LIS) = 0 AND NOT SYMI!*) THEN 0
  ELSE SIGN (MYCAAAR (LIS));

% symsze returns the block size of the first indep symmetry in the sym list.

SYMBOLIC PROCEDURE SYMSZE (SYM);
BEGIN SCALAR N;
  N := ABS (MYCAAAR (SYM));
  IF SYMI!* AND N = 0 THEN RETURN (1)   % diagonal block size becomes 1
  ELSE RETURN (N);
END;

% cnjflg returns the conjugation flag of the first indep symmetry
% in the symmetry list. should be a macro.

SYMBOLIC PROCEDURE CNJFLG (SYM);
  MYCDAAR (SYM);

% tracesym searches through a product looking for contractions involving
% diagonal (or trace) symmetries where it can make an enormous improvement
% in performance. it replaces the contraction pair with a look-alike to
% the other indice in the diagonal symmetry, so that these are all coupled
% and run together. a complete description of what it does for every case
% is too long for here. tracesym is called only from preprocess.

FLUID '(NINDEX NCONCOV);

SYMBOLIC PROCEDURE TRACESYM (VALUE);
BEGIN SCALAR LEX, LEX1, I1, I2, REPLAC, SYM, INDEX,
    LEX2, LEX3, NINDEX, NCONCOV, INDEXO, INDEXC;
  COLLECTERMS (VALUE);
  LEX := CONTRACT (NINDEX, NCONCOV);
  INDEXO := MYCAR (LEX);      % visible output indices
  INDEXC := MYCADR (LEX);     % visible contraction indices
  LEX := VALUE;
  WHILE LEX DO <<
    LEX1 := MYCAR (LEX);
    LEX := MYCDR (LEX);
    IF CHECKTYPE (LEX1, 'DF) THEN LEX1 := MYCADR (LEX1);
    IF CHECKTYPE (LEX1, 'TIMES) THEN <<
      LEX := APPEND (MYCDDR (LEX1), LEX);
      LEX1 := MYCADR (LEX1)
    >>;
    IF CHECKTYPE (LEX1, 'RDR) AND NOT FREE1 (SYM :=
         GET (MYCADR (LEX1), 'SYMMETRY), 0) THEN <<
      INDEX := MYCADDR (LEX1);
      BEGIN;
      LOOP:
        IF FREE1 (SYM, 0) THEN GO TO AFTERLOOP;
        IF NOT MYCAAAR (SYM) = 0 THEN <<
          SYM := MYCDR (SYM);
          GO TO LOOP
        >>;
        I1 := NTH (INDEX, INDXN (SYM, 1));
        I2 := NTH (INDEX, INDXN (SYM, 2));
        SYM := MYCDR (SYM);
        IF (NOT ATOM (I1)) OR (NOT ATOM (I2)) THEN GO TO LOOP;  % avoid redoing
        IF FIXP (I1) AND FIXP (I2) THEN <<
          IF I1 = I2 THEN GO TO LOOP
        >>
        ELSE IF (FIXP (I1) AND MEMQ (I2, INDEXO)) OR
                (FIXP (I2) AND MEMQ (I1, INDEXO)) OR
                (MEMQ (I1, INDEXO) AND MEMQ (I2, INDEXO)) THEN GO TO LOOP;
        IF MEMQ (I2, INDEXC) THEN <<
          LEX2 := I1; I1 := I2; I2 := LEX2
        >>;
        LEX2 := ASSOC (I1, REPLAC);
        IF LEX2 THEN LEX2 := LIST (IND (MYCAR (LEX2)), IND (MYCADR (LEX2)));
        LEX3 := MYCADR (LEX2);

        IF FIXP (I2) THEN <<
          IF LEX2 THEN <<
            IF NOT MYCADR (LEX2) THEN <<
              REPLAC := (I1 . I2) . REPLAC;
              REPLAC := (MYCADR (LEX2) . I2) . REPLAC
            >>
          >>
          ELSE REPLAC := (I1 . I2) . REPLAC
        >>
        ELSE IF MEMQ (I2, INDEXO) THEN <<
          IF LEX2 THEN <<
            IF FIXP (LEX3) THEN REPLAC := (I1 . MYCADR (LEX2)) . REPLAC
            ELSE IF NOT MYCADR (LEX2) THEN <<
              REPLAC := (I1 . LIST (I2)) . REPLAC;
              REPLAC := (MYCADR (LEX2) . LIST (I2)) . REPLAC
            >>
          >>
          ELSE REPLAC := (I1 . LIST (I2)) . REPLAC
        >>
        ELSE IF LEX2 THEN <<
          IF FIXP (LEX3) THEN <<
            REPLAC := (I1 . MYCADR (LEX2)) . REPLAC;
            REPLAC := (I2 . MYCADR (LEX2)) . REPLAC
          >>
          ELSE IF MEMQ (LEX3, INDEXO) THEN <<
            REPLAC := (I1 . LIST (MYCADR (LEX2))) . REPLAC;
            REPLAC := (I2 . LIST (MYCADR (LEX2))) . REPLAC
          >>
          ELSE IF NOT I2 = MYCADR (LEX2) THEN
            REPLAC := (I2 . LIST (MYCADR (LEX2))) . REPLAC
        >>
        ELSE IF LEX2 := ASSOC (I2, REPLAC) THEN <<
          IF LEX2 THEN LEX2 := LIST (IND (MYCAR (LEX2)), IND (MYCADR (LEX2)));
          LEX3 := MYCADR (LEX2);
          IF FIXP (LEX3) THEN <<
            REPLAC := (I1 . MYCADR (LEX2)) . REPLAC;
            REPLAC := (I2 . MYCADR (LEX2)) . REPLAC
          >>
          ELSE IF MEMQ (LEX3, INDEXO) THEN <<
            REPLAC := (I1 . LIST (MYCADR (LEX2))) . REPLAC;
            REPLAC := (I2 . LIST (MYCADR (LEX2))) . REPLAC
          >>
          ELSE IF NOT I1 = MYCADR (LEX2) THEN
            REPLAC := (I1 . LIST (MYCADR (LEX2))) . REPLAC;
        >>
        ELSE REPLAC := (I1 . LIST (I2)) . REPLAC;
      GO TO LOOP;
      AFTERLOOP:
      END
    >>
  >>;
  RETURN (REPLACINDEX (VALUE, REPLAC));
END;

% multip determines the multiplicities of a given index in the given symmetry.
% does not work for hermitian symmetries yet.

SYMBOLIC PROCEDURE MULTIP (INDEX, SYMLST);
  IF NOT SYMLST THEN 1
  ELSE EVAL ('TIMES . FOR EACH X IN SYMLST COLLECT MULTIP1 (INDEX, X));

SYMBOLIC PROCEDURE MULTIP1 (INDEX, SYM);
BEGIN SCALAR SYMI!*, SGN, LEX, LEN, PTR, MULTIP, LP, S, PF;
  SYMI!* := 'T;
  SGN := SGNSYM (LIST (SYM));
  LEN := SYMSZE (LIST (SYM));
  PTR := MYCDR (SYM);
  LP := LENGTH (PTR);
  WHILE PTR DO <<
    LEX := SUBLIST (INDEX, MYCAR (PTR), LEN);
    MULTIP := (LEX . ((MYCDR (ASSOC (LEX, MULTIP)) OR 0) + 1)) . MULTIP;
    PTR := MYCDR (PTR)
  >>;
  S := 0;
  PF := 1;
  WHILE (S < LP) DO <<
    LEX := MYCDAR (MULTIP);
    IF SGN < 0 AND LEX > 1 THEN LP := 0;  % anti-symmetry and same indices
    S := S + LEX;
    PF := PF * FACTORIAL (LEX);
    MULTIP := MYCDR (MULTIP)
  >>;
  RETURN (FACTORIAL (LP) / PF);
END;

% makedifsym constructs a symmetry list for the portion of INDEX which follows
% the derivative operator, and appends it to the intrinsic symmetry list SYMLST

SYMBOLIC PROCEDURE MAKEDIFSYM (INDEX, SYMLST);
BEGIN SCALAR LEX, LEX1, I;
  LEX := FDERIV (INDEX);
  IF NOT LEX THEN RETURN (SYMLST)
  ELSE IF MYCADR (LEX) EQ '!#BR THEN <<
    I := MYCAR (LEX) + 1;
    LEX1 := FDERIV (PNTH (INDEX, I));
    LEX1 := CONS ('(1), ZPN (I,
            	I - 2 + (MYCAR (LEX1) OR (LENGTH (INDEX) - I + 2)), 1));
    IF LENGTH (LEX1) = 2 THEN RETURN (SYMLST);
    RETURN (APPEND (SYMLST, LIST (LEX1)))
  >>;
END;

;END;

