%***************************************************************************
%  FILE = dif.red 				Sun Oct 30 22:28:34 EST 1988
% 
%  Procedures in this file:
%  
%  PARSEBAR IDIFF NDIFF NDIFF1 SPLITDIFF COV* DIFCON DIFCON1 
%  PRINTDIF IPRTDF DIFFP DFRDR DFRDRMERGE SIMPPDF PRINTPDF
%  CNVRTDIF
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);
GLOBAL '(ALPHALIST!*);
FLUID '(FLG INDEX);	% index to be split, and flg for operator type.

PUT('!|, 'STAT, 'PARSEBAR);	% attach the parsing function.

% parsebar is the routine which takes care of derivative operators in
% an object index. it converts the | operator to the atom '#BR, and the
% || operator to '#DBR. Note: these particular operators act on all
% following indices and are left at the top level of the index, unlike
% shift operators.

SYMBOLIC PROCEDURE PARSEBAR;
BEGIN SCALAR LEX;
  LEX := XREAD ('T);
  IF ATOM (LEX) THEN RETURN (LIST ('!#BR, LEX))
      			% have ||a
  ELSE IF MYCAR (LEX) EQ '!#BR THEN RETURN LIST ('!#DBR, MYCADR (LEX))
      			% have |||a --> error
  ELSE IF MYCAR (LEX) EQ '!#DBR THEN MERROR ('("bad derivative operator"),
                 'T, 'PARSEBAR)	
      			% just |a
  ELSE RETURN LIST ('!#BR, LEX);
END;

FLUID '(TNSR);
GLOBAL '(!*DIFTMP DPCT!*);

% idiff handles the derivative operations indicated in the object index
% by successively applying the operations indicated. idiff is called only
% from preprocess.

SYMBOLIC PROCEDURE IDIFF (TNSRI, INDEX);
BEGIN SCALAR FLG, INDEXO, TNSR1, FLG1, LEX, LEX1;
  INDEXO := SPLITDIFF ();	% get object index, was prepended with '#br
  IF NOT INDEXO AND MYCAR (INDEX) EQ '!#DBR THEN <<
    INDEX := '!#BR . MYCDR (INDEX);
    IF MYCADDR (INDEX) AND MYCADDR (INDEX) NEQ '!#DBR AND 
            MYCADDR (INDEX) NEQ '!#BR THEN
      INDEX := APPEND (HEAD (INDEX, 2), '!#DBR . MYCDDR (INDEX))
  >>;
  TNSR1 := TNSRI;		% name of object
  IF DERIV (MYCDR (INDEX), 'NIL) THEN FLG1 := 'T  % only one operation to do
  ELSE FLG1 := 'NIL;		% more than 1, we need intermediate objects
  LOOP:				% for each operation
    IF NOT INDEX THEN GO TO AFTERLOOP;	% ate it all, we're done
    LEX := SPLITDIFF ();	% get indices the op applies to
    IF NOT FLG THEN <<		% was a normal derivative (nb. flg not flg1)
      LEX1 := INDEXO;		% save object index
      INDEXO := MYCAR (CONTRACT (   % look for contractions
              APPEND (INDEXO, LEX), APPEND (GET (TNSRI, 'CONCOV),
              CNSTN (-1, LENGTH (LEX))) ));
      TNSR1 := NDIFF (TNSR1, LEX1, LEX, INDEXO, FLG1);
      IF NOT INDEXED (TNSR1) THEN RETURN (TNSR1)  % got 0
    >> ELSE <<			% covariant deriv, must do 1 index at a time
      INDEXO := APPEND (INDEXO, LIST (LEX));
      TNSR1 := MYCAR (COV!* (LIST (TNSR1)));
      IF NOT INDEXED (TNSR1) THEN RETURN (TNSR1)	% got 0
    >>;
  GO TO LOOP;
  AFTERLOOP:
  RETURN (LIST ('RDR, TNSR1, INDEXO));		% indexed temp
END;

% ndiff handles normal derivatives of indexed objects. depending 
% on circumstances, it may return either an indexed temporary or 
% an unevaluated 'df form as returned from ndiff1. it tries to 
% minimize the amount of work done in doing derivatives in an 
% expression by looking through the Derivative Partial Computation 
% Table (dpct*) set up below. if the current derivative form 
% matches one already computed, the temporary object holding the 
% derivative is returned. otherwise, the closest match is used to
% form a new derivative. this is all very scary.

SYMBOLIC PROCEDURE NDIFF (TNSRI, INDEX, INDEXD, INDEXO, FLG);
BEGIN SCALAR TNSR1, LEX1, LEX2, LEX3, LEX;
  			% not available for saving
  IF NOT (LENGTH (INDEX) + (LEX1 := LEX3 := LEX2 := LENGTH (INDEXD)) -
       LENGTH (INDEXO)) = 0 OR NOT ARBINDEX (INDEXO) THEN
          RETURN (NDIFF1 (TNSRI, INDEX, INDEXD, INDEXO, FLG));
  TNSR1 := TNSRI;
  LEX := DPCT!*;	% look for nearest match
  WHILE LEX AND NOT (LEX2 = 0) DO <<
    IF MYCAAR (LEX) EQ TNSRI AND (LEX2 := MIN (0, MIN (LEX2, LEX1
      - MYCADAR (LEX)))) < LEX3 THEN <<
      TNSR1 := MYCADDAR (LEX);	% nearest match so far
      LEX := MYCDR (LEX);
      LEX3 := LEX2
    >> ELSE <<
      LEX2 := LEX3;
      LEX := MYCDR (LEX)
    >>
  >>;
  IF LEX2 = 0 THEN RETURN (TNSR1);	% exact match
  INDEX := APPEND (INDEX, HEAD (INDEXD, LEX1 - LEX2));
  INDEXD := PNTH (INDEXD, LEX1 - LEX2 + 1);
  LEX := NDIFF1 (TNSRI, INDEX, INDEXD, INDEXO, FLG);  
  IF NOT CHECKTYPE (LEX, 'DF) THEN DPCT!* := LIST (TNSRI, LEX1, LEX) . DPCT!*;
  RETURN (LEX)
END;

% ndiff1 actually performs the evaluation of a normal derivative
% to produce either an indexed temporary or an unevaled (as yet)
% 'df form. if certain conditions apply, (which presumably will
% result in a time saving) a temporary is computed rather than
% the 'df form. the 'df form looks like 
% ('df (rdr <name> <index>) ('rdr <coord-vector> <d1>) ..)
% Note that TNSR is global from PREPROCESS.

SYMBOLIC PROCEDURE NDIFF1 (TNSRI, INDEX, INDEXD, INDEXO, FLG);
BEGIN SCALAR LIS, LEX, LEX1, LEX2, REPLAC, INDEXDC;
  LEX := MKCOORDS (TMPNAMES(), 'NIL);		% coordinate vector
  PUT (LEX, 'CONCOV, '(-1));            % fudge the concov to get it covariant
  LIS := 'DF . LIS;			% unevaled form begins with 'df
  IF NOT INDEX AND NOT INDEXED (TNSRI) THEN LIS := TNSRI . LIS  % scalar derivative
  ELSE LIS := LIST ('RDR, TNSRI, INDEX) . LIS;  % put the object in
  INDEXDC := INDEXD;
  WHILE INDEXD DO <<			% all the deriv indices
    LIS := LIST ('RDR, LEX, LIST (MYCAR (INDEXD))) . LIS;
    INDEXD := MYCDR (INDEXD)
  >>;
  LIS := REVERSE (LIS);
   % if TNSRI is implicit, we will wait to do the eval, it messes things up
   % to do it now.
  IF INTINDEX (INDEXO) AND NOT GET (TNSRI, 'IMPLICIT) THEN RETURN (REVAL (LIS));
  LEX2 := GET (TNSRI, 'SYMMETRY);
  % if this object has more symmetry than the output on the left of the ==
  % then compute a temp, or if there are pending deriv operations.

  IF !*DIFTMP OR FLG OR  
       MULTIP (HEAD (ALPHALIST!*, LENGTH (INDEXO)), GET (TNSR, 'SYMMETRY)) <
       MULTIP (HEAD (ALPHALIST!*, LENGTH (INDEXO)), LEX2) THEN <<
    LEX := TMPNAMES();		% make a temp name
    IF LENGTH (APPEND (INDEX, INDEXDC)) = LENGTH (INDEXO) THEN
        PUT (LEX, 'SYMMETRY, LEX2);	%  ?
    % we make a replacement to ensure that the indices used have no
    % user defined limits to their runs.
    LEX2 := HEAD (ALPHALIST!*, LENGTH (INDEXO));
    REPLAC := PAIR (INDEXO, LEX2);
    RETURN (LEX := EVALTNSR1 (LEX, LEX2,
                REPLACINDEX (LIS, REPLAC), 'NIL))
  >>
  ELSE RETURN (LIS);	% return 'df form
END;

% splitdiff looks at the global index and removes pieces as determined by
% the derivative operators found. covariant derivative indices are removed
% one at a time whereas normal derivative indices are removed in chunks.

SYMBOLIC PROCEDURE SPLITDIFF ();
BEGIN SCALAR N, LEX, LEX1;
  IF NOT FLG THEN <<		% currently a normal derivative
    LEX1 := MYCAR (INDEX);
    INDEX := MYCDR (INDEX);
    IF LEX1 EQ '!#DBR THEN <<	% covariant derifvative operator
      FLG := 'T;		% flag it
      LEX := MYCAR (INDEX);
      INDEX := MYCDR (INDEX)
    >>
    ELSE <<
      N := MYCAR (FDERIV (INDEX)) OR (LENGTH (INDEX) + 1);
      LEX := HEAD (INDEX, N - 1);	% index chunk
      INDEX := PNTH (INDEX, N)		% whats left
    >>
  >>
  ELSE IF MYCAR (INDEX) EQ '!#BR THEN <<	% normal derivative operator
    FLG := 'NIL;			% unset flag
    LEX := SPLITDIFF ()
  >>
  ELSE <<
    LEX := MYCAR (INDEX);
    INDEX := MYCDR (INDEX)
  >>;
  RETURN (LEX);
END;

PUT ('COV, 'SIMPFN, 'COV!*);

% cov* computes covariant derivatives of objects (tensors and spinors,
% there is no christoffel symbol for frame indices???). if the object
% is shifted from a parent, then the covariant derivative of the parent
% is computed and shifted to match the object.

SYMBOLIC PROCEDURE COV!* (U);
BEGIN SCALAR TNSR, TNSR1, LEX, LEX1, LEX2, LEX3, LEX4, N, LIS;
  TNSR := GETNME (REVAL (MYCAR (U)), 'COV);
  IF NOT INDEXED (TNSR) THEN RETURN ('NIL . 1);
  IF MYCDR (LEX := GET (TNSR, 'CONJUGATE)) THEN % cov is a real op
    RETURN (MYCAR (GET (MYCAR (COV!* (LIST (MYCAR (LEX)))), 'CONJUGATE)) . 1);
  IF (LEX := GET (TNSR, '!#DBR)) AND (INDEXED (LEX) OR LEX = 0) THEN
    RETURN (LEX . 1);		% name or value already computed
  LEX := GET (TNSR, 'PNAME) OR TNSR;
  N := MYCAR (GET (TNSR, 'INDICES));
  IF NOT LEX EQ TNSR THEN <<	% input is not parent, i.e. its shifted
    LEX := COV!* (LIST (LEX));
    IF MYCAR (LEX) EQ 'NIL THEN TNSR1 := 0
    ELSE TNSR1 := MYCADR (SHIFT!* (LIST ('RDR, MYCAR (LEX),	% shift to match
             GENSHFT (HEAD (ALPHALIST!*, N + 1), 
                     GET (MYCAR (LEX), 'CONCOV),
                     APPEND (GET (TNSR, 'CONCOV), LIST (-1)))),
                        'NIL));
    PUT (TNSR, '!#DBR, TNSR1);	% store name or value on object
    RETURN (TNSR1 . 1)
  >> ELSE <<
    TNSR1 := MAKENAME (APPEND (EXPLODE (TNSR), '(!# C D))); % deriv name
    WRITE ("computing ", TNSR1);
    TERPRI ();
    LEX := HEAD (ALPHALIST!*, N OR 0);
    LEX1 := NTH (ALPHALIST!*, N + 1);
    LEX2 := APPEND (LEX, LIST (LEX1));

% note: this section needs to be upgraded so one only computes the christoffel
% symbols required for the types of indices in the object. this includes the
% frame equivalents, which currently do not exist.

% this ought to work, note frchristoffel is not defined.
    LEX4:= LIST (ISITTEN (TNSR) AND MYCAR (CHRISTOFFEL2!* ('NIL)),
                ISITFR (TNSR) AND MYCAR (FRCHRISTOFFEL!* ('NIL)),
                ISITSP (TNSR) AND MYCAR (SPCHRISTOFFEL!* ('NIL)),
                ISITSP (TNSR) AND MYCAR (GET (MYCAR (SPCHRISTOFFEL!* ('NIL)),
                                        'CONJUGATE)));

%    IF ISITSP (TNSR) THEN   	% need spinor christoffels too
%      LEX4 := LIST (MYCAR (CHRISTOFFEL2!* ('NIL)), 
%                'NIL,       	
%                MYCAR (SPCHRISTOFFEL!* ('NIL)),
%                MYCAR (GET (MYCAR (SPCHRISTOFFEL!* ('NIL)), 'CONJUGATE)))
%    ELSE
%      LEX4 := LIST (MYCAR (CHRISTOFFEL2!* ('NIL)), 'NIL, 'NIL, 'NIL);
    LEX3 := 'PLUS .		% generate expression for derivative
          LIST ('RDR, TNSR, APPEND (LEX, LIST ('!#BR, LEX1)))
               . DIFCON (TNSR, LEX4, LEX, LIST (LEX1));
    MKTNSR!* (TNSR1, APPEND (GET (TNSR, 'CONCOV), '(-1)),
              GET (TNSR, 'SYMMETRY), 'NIL, 'NIL);
    EVALTNSR1 (TNSR1, LEX2, LEX3, 'NIL);
    IF LENGTH (GET (TNSR1, 'TVALUE)) = 0 THEN <<
      KILL (TNSR1);
      TNSR1 := 0	% is 0
    >>
    ELSE PROTECT!* (TNSR1, 'W);
    PUT (TNSR, '!#DBR, TNSR1);	% store name or value on object
    CLEANER ('COV);
    RETURN (TNSR1 . 1)
  >>;
END;

% difcon creates a list of contractions with various christoffel symbols
% provided in ltnsr1 for use by the covariant derivative routine. the object
% name is tnsr, its index is index, and the covariant derivative index
% is index1.

SYMBOLIC PROCEDURE DIFCON (TNSR, LTNSR1, INDEX, INDEX1);
  BEGIN SCALAR I, LEX, LIS, CONCOV;
  IF NOT INDEX THEN RETURN ('NIL);	% scalar (?), no contractions
  CONCOV := GET (TNSR, 'CONCOV); 
  I := 1;
  WHILE CONCOV DO << 		% do for each index of the object
    IF (LEX := DIFCON1 (I, MYCAR (CONCOV), TNSR, LTNSR1, INDEX, INDEX1))
      THEN LIS := LEX . LIS;	% there is a contraction, add it to the list
    I := I + 1;			% pointer to contraction indice
    CONCOV := MYCDR (CONCOV)
  >>;
  RETURN (REVERSE (LIS));
END;

% difcon1 creates a product of an object and a contraction with
% a christoffel symbol in the given index.
% note all christoffel symbols used here (second tensor kind and
% spinor) have an index structure (+ - -).

SYMBOLIC PROCEDURE DIFCON1 (N, CN, TNSR, LTNSR1, INDEX, INDEX1);
BEGIN SCALAR LEX, LEX2;
  LEX2 := INSERT (INDEX, '!#1, N, 'T);	% contraction indice
  IF NOT (LEX := NTH (LTNSR1, ABS (CN))) THEN RETURN ('NIL) % no op
  ELSE IF CN > 0 THEN		% contravariant indice
    RETURN (LIST ('TIMES, LIST ('RDR, TNSR, LEX2), 
      LIST ('RDR, LEX, 
      APPEND (LIST (NTH (INDEX, N), '!#1), INDEX1))))
  ELSE				% covariant indice
    RETURN (LIST ('MINUS, LIST ('TIMES, 	% with change of sign
       LIST ('RDR, TNSR, LEX2),
       LIST ('RDR, LEX,
       APPEND (LIST ('!#1, NTH (INDEX, N)), INDEX1)))));
END;

PUT ('LIE, 'SIMPFN, 'LIE!*);

% lis* compute the lie derivative of the given object in the direction
% of the given vector. if the object
% is shifted from a parent, then the lie derivative of the parent
% is computed and shifted to match the object.

SYMBOLIC PROCEDURE LIE!* (U);
BEGIN SCALAR TNSR, VEC, TNSR1, LEX, LEX1, LEX2, LEX3, LEX4, N, LIS;
  TNSR := GETNME (REVAL (MYCAR (U)), 'LIE);
  VEC := GETNME (REVAL (MYCADR (U)), 'LIE);
  IF NOT MYCAR (GET (VEC, 'INDICES)) = 1 THEN
    MERROR (LIST ("Lie requires a vector:", VEC), 'T, 'LIE);
  IF MYCDR (LEX := GET (TNSR, 'CONJUGATE)) THEN
    RETURN (MYCAR (GET (LIE!* (LIST (MYCAR (LEX), VEC)), 'CONJUGATE)));
  N := MYCAR (GET (TNSR, 'INDICES));
  TNSR1 := MAKENAME (APPEND (APPEND (EXPLODE (TNSR), EXPLODE (VEC)),
                            '(!# L I E)));
  WRITE ("computing ", TNSR1);
  TERPRI ();
  IF MYCAR (GET (VEC, 'CONCOV)) < 0 THEN 	% need contravariant vector
    VEC := MYCADR (SHIFT!* (LIST ('RDR, VEC, '((!*AT!* a!#))), 'NIL));
  LEX := HEAD (ALPHALIST!*, N OR 0);
  MKTNSR!* (TNSR1, GET (TNSR, 'CONCOV), SUBST (1, 0, GET (TNSR, 'SYMMETRY)),
                           'NIL, 'NIL);
  LEX3 := 'PLUS . LIST ('TIMES, 
                  LIST ('RDR, TNSR, APPEND (LEX, '(!#BR !#1))),
		  LIST ('RDR, VEC, '(!#1)))
  		  . LDIFCON (TNSR, VEC, LEX);

  EVALTNSR1 (TNSR1, LEX, LEX3, 'NIL);
  PROTECT!* (TNSR1, 'W);
  CLEANER ('LIE);
  RETURN (TNSR1 . 1);
END;

% ldifcon creates a list of contractions with the vector tnsr1.

SYMBOLIC PROCEDURE LDIFCON (TNSR, TNSR1, INDEX);
BEGIN SCALAR I, LEX, LIS, CONCOV;
  IF NOT INDEX THEN RETURN ('NIL);
  CONCOV := GET (TNSR, 'CONCOV);
  I := 1;
  WHILE CONCOV DO <<
    IF (LEX := LDIFCON1 (I, MYCAR (CONCOV), TNSR, TNSR1, INDEX)) THEN <<
       LIS := LEX . LIS;
       CONCOV := MYCDR (CONCOV)
    >>;
    I := I + 1
  >>;
  RETURN (REVERSE (LIS));
END;

% ldifcon1 generates the contractions for each indice of the object whose
% lie derivative is being computed (tnsr) with the indices of the vector's
% derivative.

SYMBOLIC PROCEDURE LDIFCON1 (N, CN, TNSR, TNSR1, INDEX);
BEGIN SCALAR LEX, LEX2;
  LEX2 := INSERT (INDEX, '!#1, N, 'T);
  IF CN > 0 THEN		% contravariant index
    RETURN (LIST ('MINUS, LIST ('TIMES,
		LIST ('RDR, TNSR, LEX2),
	   LIST ('RDR, TNSR1, LIST (NTH (INDEX, N), '!#BR, '!#1)))))
  ELSE				% covariant index
    RETURN (LIST ('TIMES,
		LIST ('RDR, TNSR, LEX2),
	   LIST ('RDR, TNSR1, LIST ('!#1, '!#BR, NTH (INDEX, N)))));
END;

PUT ('DF, 'SPECPRN, 'PRINTDIF);	% attach the print function
GLOBAL '(YMIN!* YCOORD!*);

% printdf is not strictly part of the tensor system, (although it has a
% required hook for indexed objects) but is intended to pretty-up 
% the output of Reduce derivative forms.

SYMBOLIC PROCEDURE PRINTDIF (U);
BEGIN;
  IF !*NAT AND CHECKTYPE (MYCAR (U), 'RDR) THEN RETURN (IPRTDF (U)); % hook for indexed obj
  IF NOT !*NAT THEN PRIN2!* ('DF!();	% dont pretty print
  MAPRINT (MYCAR (U), 0);			% print object
  IF NOT !*NAT THEN PRIN2!* (',);
  U := MYCDR (U);
  YCOORD!* := YCOORD!* - 1;
  IF YCOORD!* < YMIN!* THEN YMIN!* := YCOORD!*;
  WHILE MYCDR (U) DO <<			% print derivs subscripted (nat on)
    PRIN2!* (MYCAR (U));
    PRIN2!* (",");
    U := MYCDR (U)
  >>;
  PRIN2!* (MYCAR (U));
  IF NOT !*NAT THEN PRIN2!* ('));
  YCOORD!* := YCOORD!* + 1;
  IF YCOORD!* > YMAX!* THEN YMAX!* := YCOORD!*;
END;

FLUID '(COORDS);
GLOBAL '(INDICETEN);

% iprtdf is the pretty-print routine for derivatives of indexed objects.
% this is only used when implicit objects have had derivatives taken that
% necessarily remain unevaluated.

SYMBOLIC PROCEDURE IPRTDF (U);
BEGIN SCALAR TNSR, INDEX, DIFL, DIFI, I;
  TNSR := MYCADAR (U);		% object name
  INDEX := MYCADDAR (U);		% object index
  U := MYCDR (U);			% deriv wrt these
  WHILE U DO <<			% look at each deriv name
    I := LOOK (COORDS, MYCAR (U), MYCAR (INDICETEN));
    IF NOT I THEN DIFL := MYCAR (U) . DIFL	% not a coord name
    ELSE <<	% is a coordinate name, use an index from the coord vector.
      IF FIXP (MYCADR (U)) THEN <<	% repeat count
        DIFI := APPEND (CNSTN (I, MYCADR (U)), DIFI);
        U := MYCDR (U)
      >>
      ELSE DIFI := I . DIFI	% only 1
    >>;
    U := MYCDR (U)
  >>;
  IF DIFI THEN INDEX := APPEND (INDEX, '!#BR . REVERSE (DIFI));
  IF NOT DIFL THEN RETURN (PRINTRDR (LIST (TNSR, INDEX)));
  PRIN2!* ("DF (");	% need to messy-print the non-coord derivs.
  PRINTRDR (LIST (TNSR, INDEX));
  PRIN2!* (",");
  PRIN2!* (REVERSE (DIFL));
  PRIN2!* (")");
END;

%
% apply df to indexed objects
%

SYMBOLIC PROCEDURE DFRDR (EX1, INDET);
BEGIN SCALAR LEX;
    IF MYCAR (EX1) EQ 'DF THEN <<
        IF NOT (LEX := DFRDR (MYCADR (EX1), INDET)) THEN RETURN ('NIL);
        IF MYCAR (LEX) EQ 'DF THEN RETURN ('DF . (MYCADR (LEX) .
% derad gets the deriv ops in a canonical order
			 DERAD (MYCADDR (LEX), MYCDDR (EX1))));
        ELSE RETURN ('DF . (LEX . MYCDDR (EX1)))
    >>;
    IF INTINDEX (MYCADDR (EX1)) AND GET (MYCADR (EX1), 'IMPLICIT) THEN <<
        IF NOT DEPENDS (MYCADR (EX1), INDET) THEN RETURN ('NIL);
    >>;
    RETURN (DFRDRMERGE (EX1, INDET));
END;

% this function merges the derivative ops applied to an indexed object
% via a call to df. They ops are sorted by SYMI if they are members of the
% coordinates. 

SYMBOLIC PROCEDURE DFRDRMERGE (FORM, INDET);
BEGIN SCALAR LEX; INTEGER I;
   IF (NOT INTINDEX (MYCADDR (FORM)) OR NOT GET (MYCADR (FORM), 'IMPLICIT))
          AND MEMQ (INDET, COORDS) THEN <<
       I := LOOK (COORDS, INDET, MYCAR (INDICETEN));
       LEX := REVERSE (MYCADDR (FORM));
       IF (MYCADR (FDERIV (LEX)) EQ '!#BR) THEN
           RETURN (MYCAR (FKERN (SYMI (LIST ('RDR, MYCADR (FORM),
                    APPEND (MYCADDR (FORM), LIST (I)))))));
       ELSE
	   RETURN (MYCAR (FKERN (LIST ('RDR, MYCADR (FORM), APPEND (MYCADDR (FORM), 
                              LIST ('!#BR, I))))));
   >> ELSE RETURN (LIST ('DF, FORM, INDET));
END;

PUT ('PDF, 'SIMPFN, 'SIMPPDF);

SYMBOLIC PROCEDURE SIMPPDF (U);
BEGIN SCALAR EXP, INDEX;
  EXP := MYCAR (U);
  INDEX := MYCADR (U);
  IF ATOM (INDEX) OR MYCAR (INDEX) NEQ 'FINDEX OR
                NOT MYCADDR (INDEX) THEN
    MERROR (LIST ("invalid index: ", MYCDDR (INDEX)), 'T, 'PDF);
  IF MEMQ ('!#DBR, INDEX) OR MEMQ ('!#BR, INDEX) THEN
    MERROR ('("derivative op illegal in index"), 'T, 'PDF);
  EXP := REVAL (EXP);
  RETURN (MKSQ (LIST ('PDF, EXP, INDEX), 1));
END;

PUT ('PDF, 'SPECPRN, 'PRINTPDF);	% attach the print function
GLOBAL '(YMAX!* YMIN!* YCOORD!*);

SYMBOLIC PROCEDURE PRINTPDF (U);
<<
  IF NOT !*NAT THEN <<
    PRIN2!* ("PDF (");
    MAPRINT (MYCAR (U), 0);
    PRIN2!* (", [");
    PRIN2!* (MYCAR (MYCDDADR (U)));
    FOR EACH X IN MYCDR (MYCDDADR (U)) DO <<PRIN2!* (","), PRIN2!* (X)>>;
    PRIN2!* ("])")
  >> ELSE <<
    PRIN2!* ("(");
    MAPRINT (MYCAR (U), 0);
    PRIN2!* (")");
    YCOORD!* := YCOORD!* - 1;
    IF YCOORD!* < YMIN!* THEN YMIN!* := YCOORD!*;
    PRIN2!* ("|");
    FOR EACH X IN MYCDDADR (U) DO << PRIN2!* (DNNAME (X)), PRIN2!* (" ")>>;
    YCOORD!* := YCOORD!* + 1
  >>
>>;

% If we call this routine, then INDEX has a normal derivative operator,
% does not have a covariant derivative op, and an integer index.
% This routine converts the k[0,|1] form to the df ((RDR k (0)), t) form

SYMBOLIC PROCEDURE CNVRTDIF (TNSR, INDEX);
BEGIN SCALAR LIS, LEX;
    LEX := FDERIV (INDEX);
    LIS := LIST ('DF, LIST ('RDR, TNSR, HEAD (INDEX, MYCAR (LEX) - 1)));  % put the object in
    LEX := PNTH (INDEX, MYCAR (LEX) + 1);
    LEX := FOREACH X IN LEX COLLECT NTH (COORDS, X - MYCAR (INDICETEN) + 1);
    RETURN (REVAL (APPEND (LIS, LEX)));
END;

;END;
