/*
******************************************************************************
*					           NCSA CompositeTool 1.1
*						   18 April 1990
* 
* NCSA CompositeTool 1.1 source code and documentation are in the public
* domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
******************************************************************************
*/
/* cat > headers/all.h << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* all.h: common include files for CompositeTool	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% */

#include        <suntool/sunview.h>
#include        <suntool/panel.h>
#include        <suntool/canvas.h>
#include        <suntool/walkmenu.h>
#include        <sys/file.h>
#include        <sys/dir.h>
#include        <sys/stat.h>
#include        <sys/types.h>
#include        <math.h>
#include        <stdio.h>
/* #include        <usercore.h> */	/* Why? */

/* #include	"const.h" */
/* #include	"struct.h" */
/* #include	"ext.h" */
/* EOF */

/* cat > headers/const.h << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* const.h: constants for CompositeTool			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% */

#define         N_image         20
#define         N_vector        20
#define         N_contour       20
#define         N_text          40
#define         N_frame         10
#define         N_panel         10
#define         N_pbutton       116
#define         N_pslider       4
#define         N_ptext         59
	/* 4 messages for the base frame header. 1 message for the feature
	   frame */
#define         N_pmessage      5
#define         N_xscr          1152
#define         N_yscr		900
#define         N_hpix          1142
#define         N_vpix          890
	/* 1.1 addition */
#define		MAXNAMELEN	255
/* EOF */

/* cat > headers/struct.h << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* struct.h: structure declarations for CompositeTool	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% */

struct s_text
{
	int             holder;
	int             sw;
	char            body[80];
	int             xpos;
	char            prefont[60];
	int             ypos;
	char            postfont[20];
	int             color;
};
struct s_contour
{
	int             holder;
	int             sw;
	char            fname[MAXNAMELEN + 1];	/* changed in 1.1 */
	int             color;
	int             first;
	int             last;
	int             interval;
	int             dis;
	int             xpos;
	int             ypos;
	int             xpts;
	int             ypts;
};
struct s_feature
{
	int             holder;
	int             xax_sw;
	int             xax_thick;
	int             xax_color;
	int             xax_bot;
	int             xax_top;
	int             yax_sw;
	int             yax_thick;
	int             yax_color;
	int             yax_left;
	int             yax_right;
	int             xgr_sw;
	int             xgr_thick;
	int             xgr_color;
	int             xgr_space;
	int             ygr_sw;
	int             ygr_thick;
	int             ygr_color;
	int             ygr_space;
	int             xt1_sw;
	int             xt1_thick;
	int             xt1_color;
	int             xt1_bot;
	int             xt1_top;
	int             xt1_space;
	int             xt1_len;
	int             xt1_direc;
	int             yt1_sw;
	int             yt1_thick;
	int             yt1_color;
	int             yt1_left;
	int             yt1_right;
	int             yt1_space;
	int             yt1_len;
	int             yt1_direc;
	int             xt2_sw;
	int             xt2_thick;
	int             xt2_color;
	int             xt2_bot;
	int             xt2_top;
	int             xt2_space;
	int             xt2_len;
	int             xt2_direc;
	int             yt2_sw;
	int             yt2_thick;
	int             yt2_color;
	int             yt2_left;
	int             yt2_right;
	int             yt2_space;
	int             yt2_len;
	int             yt2_direc;
};
struct s_image
{
	int             holder;
	int             sw;
	char            fname[MAXNAMELEN + 1];	/* changed in 1.1 */
	int             xpos;
	int             ypos;
	int             xpts;
	int             ypts;
};
struct s_vector
{
	int             holder;
	int             sw;
	char            xname[MAXNAMELEN + 1];	/* changed in 1.1 */
	int             xpos;
	char            yname[MAXNAMELEN + 1];	/* changed in 1.1 */
	int             ypos;
	int             xpts;
	int             ypts;
	int             xstart;
	int             xend;
	int             xinterval;
	int             ystart;
	int             yend;
	int             yinterval;
	int             xdis;
	int             ydis;
	int             color;
	int             maxlen;
	int             xzero;
	float           xscale;
	int             yzero;
	float           yscale;
};
struct s_grid
{
	int             holder;
	int             sw;
	int             xpix;
	int             ypix;
	int             color;
};
struct s_colorbar
{
	int             holder;
	int             sw;
	int             xpos;
	int             ypos;
	int             xpts;
	int             ypts;
};
struct s_scrdump
{
	int             holder;
	int             xstart;
	int             ystart;
	char            fname[MAXNAMELEN + 1];	/* changed in 1.1 */
	int             xend;
	int             yend;
};

/* EOF */
/* cat > headers/ext.h << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* ext.h: extern declarations for CompositeTool		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% */

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
extern
int             tag_to_string(),        string_to_tag(),
                write_string(),         read_string();
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
extern
int		msg_draw(),		msg_move(),	x_start,	y_start;
extern
int							x_end,		y_end;
extern
int							x_interval,	y_interval;
extern
int		mouse_msg(),		kbyte_msg(),	draw_box();
extern
int		sw_flash,		sw_draw,		sw_move;
extern
int		odd_read();
extern
int		check_file(),		resetb_feature();
extern
int		event_dump(),		event_colorbar(),	event_image(),
		event_contour(),	event_vector(),		event_text();
extern
int		reset_mcolorbar(),	reset_mcontour(),	reset_mimage(),
		reset_mtext(),		reset_mvector();
extern
int		sw_palette,		confirm_palette(),	reset_palette(),
		sw_grid,		confirm_grid(),		reset_grid(),
		sw_colorbar,		confirm_colorbar(),	reset_colorbar(),
		sw_image,	sw_i[5],confirm_image(),	reset_image(),
		sw_contour,	sw_c[5],confirm_contour(),	reset_contour(),
		sw_vector,	sw_v[5],confirm_vector(),	reset_vector(),
		sw_text,	sw_t[5],confirm_text(),		reset_text();
extern
int                     draw_colorbar(),null_colorbar(),ok_colorbar(),
                nc,     draw_contour(), null_contour(), ok_contour(),
                        draw_grid(),    null_grid(),    ok_grid(),
                nf,     draw_feature(),	null_feature(),	nosho_feature(),
                ni,     draw_image(),   null_image(),   ok_image(),
                nt,     draw_text(),    null_text(),    ok_text(),
                nv,     draw_vector(),  null_vector(),  ok_vector(),    draw_vector1();
extern
int             con_row(),con_col();
extern
int		info_msg(),	warn_msg(),	warn_msgt();
extern
int             bad_data(),     canvas_done(),  load_rgb(),     no_op();
extern
int             make_fr(),      make_pb(),      make_pm(),      make_pmnn(),
                make_pt(),	make_ps();
extern
int             my_ftoa(),      my_itoa(),      my_atof(),      my_isint(),
                my_isfloat(),   my_stripfn(),   my_otod();
extern
int             p0(),p1(),p2(),p3(),p4(),p5(),p6(),p7(),p8(),p9(),
                p10(),p11(),p12(),p13(),p14(),p15(),p16(),p17(),p18(),p19(),
                p20(),p21(),p22(),p23(),p24(),p25(),p26(),p27(),p28(),p29(),
                p30(),p31(),p32(),p33(),p34(),p35(),p36(),p37(),p38(),p39(),
                p40(),p41(),p42(),p43(),p44(),p45(),p46(),p47(),p48(),p49(),
                p50(),p51(),p52(),p53(),p54(),p55(),p56(),p57(),p58(),p59(),
                p60(),p61(),p62(),p63(),p64(),p65(),p66(),p67(),p68(),p69(),
                p70(),p71(),p72(),p73(),p74(),p75(),p76(),p77(),p78(),p79(),
                p80(),p81(),p82(),p83(),p84(),p85(),p86(),p87(),p88(),p89(),
                p90(),p91(),p92(),p93(),p94(),p95(),p96(),p97(),p98(),p99(),
                p100(),p101(),p102(),p103(),p104(),p105(),p106(),p107(),p108(),p109(),
		p110(),p111(),p112(),p113(),p114(),p115();
extern
int             cpw_event(),	cpw_check();
extern
int     (*fdp[])();
extern
int     (*bnp[])();
extern
int		s0(),s1(),s2(),s3();
extern
int     (*snp[])();
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
extern
Frame           fr[N_frame],
                c_frame;
extern
Panel           pa[N_panel];
extern
Panel_item      pb[N_pbutton],
                pt[N_ptext],
                ps[N_pslider],
                pm[N_pmessage];
extern
Canvas          canvas;
extern
Pixwin          *cpw,*bpw;
extern
Pixrect		*x1_save,*x2_save,*y1_save,*y2_save;
extern
struct mpr_data *x1_ptr,*x2_ptr,*y1_ptr,*y2_ptr;
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
extern
int             clear_color,
                csw_dump,	csw_colorbar,	csw_text,
		csw_image,	csw_contour,	csw_vector;
		msg_no;
extern
short int	rw_toggle[N_image + N_contour + N_vector + N_text];
extern
char            c_cmsn[24],
                b_cmsn[24];

extern
struct	stat	my_stat;
extern
struct  s_text  text[N_text+1];
extern
struct  s_contour con[N_contour+1];
extern
struct  s_feature feat[N_image + N_contour + N_vector];
extern
struct  s_image image[N_image+1];
extern
struct  s_vector vec[N_vector+1];
extern
struct  s_grid  grid,tgrid;
extern
struct  s_colorbar cbar,tcbar;
extern
struct  s_scrdump  sdump;
/*      --------        */
extern
unsigned char   red[256],	green[256],	blue[256];
extern
char            pfn[256],	txt[256],       msg[256];
extern
char		compat_hdr[40];
/* EOF */

/* cat > headers/define.h << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* define.h: definitions for CompositeTool		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% */

int		x_start,	y_start;
int		x_end,		y_end;
int		x_interval,	y_interval;
int		sw_flash,		sw_draw,		sw_move;
int		sw_palette,
		sw_grid,
		sw_colorbar,
		sw_image,	sw_i[5],
		sw_contour,	sw_c[5],
		sw_vector,	sw_v[5],
		sw_text,	sw_t[5];
int                   
                nc,  
                    
                nf,
                ni,
                nt,
                nv;
int     (*fdp[])() =
                {
                no_op,  /* fr  0 */
                p13,    /* fr  1 */
                p16,    /* fr  2 */
                p22,    /* fr  3 */
                p30,    /* fr  4 */
                p41,    /* fr  5 */
                p46,    /* fr  6 */
                p58,    /* fr  7 */
                p70,    /* fr  8 */
                p88,    /* fr  9 */
                };
int     (*bnp[])() =
                {
                p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,
                p10,p11,p12,p13,p14,p15,p16,p17,p18,p19,
                p20,p21,p22,p23,p24,p25,p26,p27,p28,p29,
                p30,p31,p32,p33,p34,p35,p36,p37,p38,p39,
                p40,p41,p42,p43,p44,p45,p46,p47,p48,p49,
                p50,p51,p52,p53,p54,p55,p56,p57,p58,p59,
                p60,p61,p62,p63,p64,p65,p66,p67,p68,p69,
                p70,p71,p72,p73,p74,p75,p76,p77,p78,p79,
                p80,p81,p82,p83,p84,p85,p86,p87,p88,p89,
                p90,p91,p92,p93,p94,p95,p96,p97,p98,p99,
                p100,p101,p102,p103,p104,p105,p106,p107,p108,p109,
		p110,p111,p112,p113,p114,p115
                };
int     (*snp[])() =
                {
		s0,s1,s2,s3
		};
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
Frame           fr[N_frame],
                c_frame;
Panel           pa[N_panel];
Panel_item      pb[N_pbutton],
                pt[N_ptext],
                ps[N_pslider],
                pm[N_pmessage];
Canvas          canvas;
Pixwin          *cpw,*bpw;
Pixrect		*x1_save,*x2_save,*y1_save,*y2_save;
struct mpr_data *x1_ptr,*x2_ptr,*y1_ptr,*y2_ptr;
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
int             clear_color,
                csw_dump,	csw_colorbar,	csw_text,
		csw_image,	csw_contour,	csw_vector;
		msg_no;
short int	rw_toggle[N_image + N_contour + N_vector + N_text];
char            c_cmsn[24],
                b_cmsn[24];

struct	stat	my_stat;
struct  s_text  text[N_text+1];
struct  s_contour con[N_contour+1];
struct  s_feature feat[N_image + N_contour + N_vector];
struct  s_image image[N_image+1];
struct  s_vector vec[N_vector+1];
struct  s_grid grid,tgrid;
struct  s_colorbar cbar,tcbar;
struct  s_scrdump  sdump;
/*      --------        */
unsigned char   red[256],	green[256],	blue[256];
char            pfn[256],	txt[256],       msg[256];
char		compat_hdr[40];
/*      --------        */

Pixfont *font_panel_button, *font_panel;
int base_frame_up;

char	msg2[256];

/* EOF */

/* cat > headers/newext.h << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* newext.h: new declarations for CompositeTool		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% */

#define DEBUG	1 

#include <string.h>		/* SUN BUG (386i - 4.0.1)! Cannot put
				   string.h after sunwindow/defaults.h.
				   ERRORS! */
#include <sunwindow/defaults.h>		/* for defaults database */
#include <fcntl.h>			/* for open system call */

#include "df.h"

#define DEFAULT_FONT_PANEL "/CompositeTool/Font_panel"
#define DEFAULT_FONT_PANEL_BUTTON "/CompositeTool/Font_panel_button"
#define DEFAULT_INITIAL_PALETTE_FILE "/CompositeTool/Initial_palette_file"
#define DEFAULT_LOGO_PALETTE_FILE "/CompositeTool/Logo_palette_file"
#define DEFAULT_LOGO_IMAGE_FILE "/CompositeTool/Logo_image_file"
#define DEFAULT_TEXT_FONT_DIR "/CompositeTool/Text_font_dir"
#define DEFAULT_TEXT_FONT "/CompositeTool/Text_font"

extern int errno;

extern Pixfont *font_panel_button, *font_panel;
extern int base_frame_up;
extern char msg2[256];
extern unsigned char palette [768];
extern char pfntmp[256];
extern int grid_down;
extern struct s_grid lgrid;
extern char dprefont[60];
extern char dpostfont[20];
extern char fn_new_defaults[32];
extern char fntmp[MAXNAMELEN + 1];
extern char util_read_dir[MAXNAMELEN + 1];
extern Panel_item	util_pc_save,
			util_pb_saveall;

extern void bad_data2 ();
extern int check_image ();
extern int check_palette ();
extern char *get_defaults ();
extern void move_defaults ();
extern int info_msg2 ();
extern char *itoa ();
extern int load_contour_image ();
extern int load_image ();
extern int load_vector_image ();
extern Panel make_p ();
extern void pad_image ();
extern void reverse ();
extern int store_image ();
extern void unpad_image ();
extern int xstrcmp ();
extern int xstrlen ();
extern Notify_value main_destroy_interposer ();
extern int getdirname ();
extern int getbasename ();
extern int swapdirnames ();
extern int set_frame_label ();
extern int strip_wspace ();
extern int util_proc_saveall ();

extern void adjust_colormap ();
extern void set_colormap ();
extern void reset_colormap ();
extern void set_frame_colormap ();
extern void set_panel_colormap ();
extern void set_canvas_colormap ();

/* EOF */

/* cat > headers/newdefine.h << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* newdefine.h: new definitions for CompositeTool	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% */

/*      --------        */

Pixfont        *font_panel_button, *font_panel;
int             base_frame_up;
struct s_image  s_logo_image;
char            msg2[256];
unsigned char   palette[768];
char            pfntmp[MAXNAMELEN + 1];	/* temporary palette filename */
int             grid_down;
struct s_grid   lgrid;
char            dprefont[60];
char            dpostfont[20];
char            fn_new_defaults[32];
char            util_read_dir[MAXNAMELEN + 1];

Panel_item      util_pc_save,
		util_pb_saveall;

/* EOF */
/* cat > src+obj/main.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* main: main program					*/
/*	 CompositeTool authors:				*/
/*	 	1.0	- Mark Stupar			*/
/*	 	1.1	- Martin Knapp-Cordes		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */
/* #include "define.h" */
/* #include "newdefine.h" */

main (argc, argv)
	int             argc;
	char          **argv;
{
	register int    y;
	register int    i;
	char           *s;
	char           *font_panel_file, *font_panel_button_file;
	char           *logo_palette, *logo_image;
	char           *initial_palette;
	char           *text_font_dir, *text_font;

	strcpy (compat_hdr, "1988 July 19 format\n");

/* ~~~~~ base frame not up - for error messages ~~~~~~ */

	base_frame_up = FALSE;

/* ~~~~~ grid not down ~~~~~ */

	grid_down = FALSE;

/* ~~~~~ get fonts ~~~~~ */

	if ((font_panel_file = get_defaults (DEFAULT_FONT_PANEL)) == NULL)
	{
		bad_data2 ("No panel font file in private or master defaults database, CompositeTool terminated.",
			   "Incorrect installation or change. Check defaults database with defaultsedit.");
		exit (-1);
	}
	if ((font_panel = pf_open (font_panel_file)) == NULL)
	{
		sprintf (msg, "File = %s - Incorrect file name or nonexistent font. Check defaults database with defaultsedit.", font_panel_file);
		bad_data2 ("Could not load panel font file, CompositeTool terminated.", msg);
		exit (-1);
	}
	if ((font_panel_button_file = get_defaults (DEFAULT_FONT_PANEL_BUTTON)) == NULL)
	{
		bad_data2 ("No panel button font file in private or master defaults database, CompositeTool terminated.",
			   "Incorrect installation or change. Check defaults database with defaultsedit.");
		exit (-1);
	};
	if ((font_panel_button = pf_open (font_panel_button_file)) == NULL)
	{
		sprintf (msg, "File = %s - Incorrect file name or nonexistent font. Check defaults database with defaultsedit.", font_panel_file);
		bad_data2 ("Could not load panel button font file, Compositetool terminated", msg);
		exit (-1);
	}
	msg_no = 0;
	for (i = 0; i < N_image + N_contour + N_vector + N_text; i++)
		*(rw_toggle + i) = FALSE;
	sw_draw = sw_move = sw_flash = FALSE;
	csw_dump = csw_colorbar = csw_text = csw_image = csw_image = csw_contour = FALSE;
	csw_vector = FALSE;
	sw_palette = sw_text = sw_grid = sw_image = sw_vector = 0;
	sw_contour = sw_colorbar = 0;
	for (i = 0; i < 5; i++)
	{
		sw_i[i] = sw_c[i] = sw_v[i] = sw_t[i] = 0;
	}

/* ~~~~~ get default text font directory and default text font ~~~~~ */

	if ((text_font_dir = get_defaults (DEFAULT_TEXT_FONT_DIR)) == NULL)
	{
		bad_data2 ("No default text font directory in private or master defaults database, CompositeTool terminated.",
			   "Incorrect installation or change. Check defaults database with defaultsedit.");
		exit (-1);
	}
	strcpy (dprefont, text_font_dir);
	if ((text_font = get_defaults (DEFAULT_TEXT_FONT)) == NULL)
	{
		bad_data2 ("No default text font file in private or master defaults database, CompositeTool terminated.",
			   "Incorrect installation or change. Check defaults database with defaultsedit.");
		exit (-1);
	}
	strcpy (dpostfont, text_font);
	for (i = 0; i < N_text; i++)
		null_text (&text[i]);

	for (i = 0; i < N_image; i++)
		null_image (&image[i]);
	for (i = 0; i < N_image + N_contour + N_vector; i++)
		null_feature (&feat[i]);
	for (i = 0; i < N_contour; i++)
		null_contour (&con[i]);
	for (i = 0; i < N_vector; i++)
		null_vector (&vec[i]);
	null_colorbar (&cbar);
	null_grid (&grid);

/* ~~~~~ load logo palette ~~~~~ */

	if ((logo_palette = get_defaults (DEFAULT_LOGO_PALETTE_FILE)) == NULL)
	{
		bad_data2 ("No logo palette file in private or master defaults database, CompositeTool terminated.",
			   "Incorrect installation or change. Check defaults database with defaultsedit.");
		exit (-1);
	}
	if (load_rgb (logo_palette, 1))	/* error on loading */
		exit (-1);

	strcpy (sdump.fname, "");
	clear_color = 0;
	cbar.xpos = 800;
	cbar.ypos = 200;
	cbar.xpts = 100;
	cbar.ypts = 256;
	grid.xpix = 100;
	grid.ypix = 100;
	grid.color = 255;
	sdump.xstart = sdump.ystart = sdump.xend = sdump.yend = 0;
	s = b_cmsn;
	*s++ = 'x';
	my_itoa (getpid (), s);
	strcpy (c_cmsn, b_cmsn);
	strcat (c_cmsn, "x");

	fr[0] = window_create (NULL, FRAME,
			       WIN_X, 0,
			       WIN_Y, 0,
			       WIN_HEIGHT, 1,
			       WIN_WIDTH, 1,
			       0);
	c_frame = window_create (fr[0], FRAME,
				 WIN_SHOW, FALSE,
				 WIN_X, (N_xscr - 308) / 2,
				 WIN_Y, (N_yscr - 219) / 2,
				 WIN_HEIGHT, 219 + 10,
				 WIN_WIDTH, 308 + 10,
				 0);
	canvas = window_create (c_frame, CANVAS,
				WIN_SHOW, FALSE,
				CANVAS_AUTO_SHRINK, FALSE,
				CANVAS_FIXED_IMAGE, FALSE,
				CANVAS_RETAINED, TRUE,
				CANVAS_WIDTH, N_hpix,
				CANVAS_HEIGHT, N_vpix,
				WIN_X, 0,
				WIN_Y, 0,
				0);
	bpw = (Pixwin *) window_get (fr[0], WIN_PIXWIN);
	cpw = canvas_pixwin (canvas);

	set_colormap ();

	window_set (c_frame, WIN_SHOW, TRUE, 0);
	window_set (canvas, WIN_SHOW, TRUE, 0);

/* ~~~~~ load logo image ~~~~~ */

	if ((logo_image = get_defaults (DEFAULT_LOGO_IMAGE_FILE)) == NULL)
	{
		bad_data2 ("No logo image file in private or master defaults database, CompositeTool terminated.",
			   "Incorrect installation or change. Check defaults database with defaultsedit.");
		exit (-1);
	}
	strcpy (s_logo_image.fname, logo_image);
	s_logo_image.xpos = 0;
	s_logo_image.ypos = 0;
	s_logo_image.xpts = 308;
	s_logo_image.ypts = 219;

	if (draw_image (&s_logo_image, 1))	/* error on loading */
		exit (-1);

	system ("sleep 3");
	window_set (fr[0],
		    FRAME_SHOW_LABEL, TRUE,
		    FRAME_NO_CONFIRM, FALSE,
		    WIN_X, 0,
		    WIN_Y, 0,
		    WIN_HEIGHT, 180,	/* added 23 for new message line */
		    WIN_WIDTH, 900,
		    FRAME_DONE_PROC, no_op,
/*		    FRAME_INHERIT_COLORS, TRUE, */
		    0);
	(void) set_frame_label (fr[0]);

	(void) notify_interpose_destroy_func (fr[0], main_destroy_interposer);

	y = (int) window_get (fr[0], WIN_Y, 0);
	if (y > N_yscr - (int) window_get (fr[0], WIN_HEIGHT, 0) - 600)
		y = 0;
	else
		y = (int) window_get (fr[0], WIN_HEIGHT, 0);
	window_set (c_frame,
		    WIN_SHOW, FALSE,
		    FRAME_DONE_PROC, canvas_done,
		    WIN_X, 0,
		    WIN_Y, y,
		    WIN_HEIGHT, 600,
		    WIN_WIDTH, N_hpix + 10,
		    0);
	window_set (canvas,
		    WIN_SHOW, FALSE,
		    WIN_EVENT_PROC, cpw_event,
		    WIN_CONSUME_PICK_EVENT, LOC_DRAG,
		    WIN_IGNORE_PICK_EVENT, MS_MIDDLE,
		    WIN_IGNORE_PICK_EVENT, MS_RIGHT,
		    0);
	pa[0] = window_create (fr[0], PANEL, 0);
	window_set (pa[0],
		    WIN_IGNORE_PICK_EVENT, MS_MIDDLE,
		    WIN_IGNORE_PICK_EVENT, MS_RIGHT,
		    0);

/* added 23 to each y for new message line */
	make_pb (0, 10, 114, 0, 9, "Canvas");
	make_pb (1, 115, 102, 0, 9, "FinalPic");
	make_pb (2, 115, 125, 0, 9, "Clear");
	make_pb (3, 235, 102, 0, 9, "Palette");
	make_pb (4, 235, 125, 0, 9, "Grid");
	make_pb (5, 330, 102, 0, 9, "ColorBar");
	make_pb (6, 330, 125, 0, 9, "Text");
	make_pb (7, 455, 102, 0, 9, "Image");
	make_pb (8, 455, 125, 0, 9, "Contour");
	make_pb (9, 550, 102, 0, 9, "Vector");
	make_pb (10, 550, 125, 0, 9, "Feature");
	make_pb (11, 670, 114, 0, 9, "FileUtil");
	make_pb (12, 785, 114, 0, 9, "Quit");
	window_set (fr[0], WIN_SHOW, FALSE, 0);

/* ~~~~~ load initial palette ~~~~~ */

	if ((initial_palette = get_defaults (DEFAULT_INITIAL_PALETTE_FILE)) == NULL)
	{
		bad_data2 ("No initial palette file in private or master defaults database, CompositeTool terminated.",
			   "Incorrect installation or change. Check defaults database with defaultsedit.");
		exit (-1);
	}
	strcpy (pfn, initial_palette);
	if (load_rgb (pfn, 1))	/* error on loading */
		exit (-1);

	x1_save = mem_create (N_hpix, 1, 8);
	x1_ptr = mpr_d (x1_save);
	x2_save = mem_create (N_hpix, 1, 8);
	x2_ptr = mpr_d (x2_save);
	y1_save = mem_create (1, N_vpix, 8);	/* temp storage for filling last column of odd width images */
	y1_ptr = mpr_d (y1_save);
	y2_save = mem_create (1, N_vpix, 8);
	y2_ptr = mpr_d (y2_save);

	for (i = 1; i <= 9; i++)
	{
		fr[i] = NULL;
		pa[i] = NULL;
	}

	reset_colormap ();

	make_pm (0, 10, 10, 0, "");
	make_pm (1, 10, 33, 0, "");
	make_pm (2, 10, 56, 0, "");
	make_pm (3, 10, 79, 0, "");

/* ~~~~~ utility frame initializations ~~~~~~ */

	util_read_dir[0] = '\0';

/* ~~~~~ base frame up - for error messages ~~~~~~ */

	base_frame_up = TRUE;

	info_msg ("", "Base frame brought up.", "");

	window_main_loop (fr[0]);
	return;
}
/* EOF */
/* cat > src+obj/bad_data.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* bad_data: one-line error message			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	bad_data(s) char *s;
{
	info_msg("          ----- ERROR MESSAGE -----",
		 s,
		 "          ----- ERROR MESSAGE -----");
	return;
}
/* EOF */
/* cat > src+obj/canvas_done.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* canvas_done: put away the canvas			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	canvas_done()
{
        window_set(     canvas,WIN_SHOW,FALSE,0);
        window_set(     c_frame,WIN_SHOW,FALSE,0);
        panel_set(      pb[0],PANEL_SHOW_ITEM,TRUE,0);
	reset_mcolorbar();
	reset_mcontour();
	reset_mimage();
	reset_mtext();
	reset_mvector();
	info_msg("","Canvas put away and all draw and move buttons deactivated.","");
        return;
}
/* EOF */
/* cat > src+obj/check_file.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* check_file: return 0 if ok, 1 if file not openable,	*/
/*	       2 if badpts for non-HDF files, 3 if HDF	*/
/*	       file with new values, DFerror if HDF	*/
/*	       error.					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	check_file(s, w1, h1, w2, h2, n)

		   char	*s;
		   int	*w1, *h1, *w2, *h2;
		   int	n;	 /* sequence number of image in HDF file */
{
	int		f, size, i, dummy;
	DF		*file;

	if ((file = DFopen (s, DFACC_READ, 0)) == NULL)
	{
		if (DFerror == DFE_FNF)		/* file not found error */
			return (1);
		else if (DFerror == DFE_NOTDFFILE)	/* regular file */
		{
			stat(s,&my_stat);
			size = (*w1) * (*h1);
			if (my_stat.st_size != size) return(2);
			return (0);
		}
		else
			return (DFerror);	/* other HDF error */
	}
	DFclose (file);
	for (i = 0; i < n; i++)
		if (DFR8getdims (s, w2, h2, &dummy)) 
			return (DFerror);		/* other HDF error */
	if ((*w1) != (*w2) || (*h1) != (*h2))
		return (3);			/* new size */
	else
		return (0);
	
}
/* EOF */
/* cat > src+obj/con_col.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* con_col: draw the contour "columns"			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	con_col(value,h,s) int value; unsigned char *h;
                           struct s_contour *s;
{
        int             col_done,ph,use1;
        unsigned char   *t,*u,*p,*q;
        register int    k,use;
            ph = s->xpts * (s->ypts - 1);
        for (k = 0; k < s->xpts; k++)
           {t = h + k;
            u = h + ph + k;
            p = t;
            col_done = FALSE;
            while (col_done == FALSE)
                 {if (*p < value && col_done == FALSE)
                    {while (*p < value && p < u) p += s->xpts;
                     if (p == u)
                       {col_done = TRUE;
                        if (*p > value)
                          {use = (p - t) / (s->xpts + 0);
                           pw_put(cpw,s->xpos + k,s->ypos + use - 1,s->color);
                          }
                       }   
                     else if (*p > value)
                            {use = (p - t) / (s->xpts + 0);
                             pw_put(cpw,s->xpos + k,s->ypos + use - 1,s->color);
                            }
                     else;
                    }
                  if (*p == value && col_done == FALSE)
                    {q = p;
                     while (*q == value && q < u) q += s->xpts;
                     if (q == u) col_done = TRUE;
                     use = (p - t) / (s->xpts + 0);
                     use1 = (q - p) / (s->xpts + 0);
                     pw_put(cpw,s->xpos + k,s->ypos + use - 1 + use1/2,s->color);
                     p = q;
                    }
                  if (*p > value && col_done == FALSE)
                    {while (*p > value && p < u) p += s->xpts;
                     if (p == u)
                       {col_done = TRUE;
                        if (*p < value)
                          {use = (p - t) / (s->xpts + 0);
                           pw_put(cpw,s->xpos + k,s->ypos + use - 1,s->color);
                          }
                       }   
                     else if (*p < value)
                            {use = (p - t) / (s->xpts + 0);
                             pw_put(cpw,s->xpos + k,s->ypos + use - 1,s->color);
                            }
                     else;
                    }
                 }   
           }
        return;
}
/* EOF */
/* cat > src+obj/con_row.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* con_row: draw the contour "rows"			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int     con_row(value,h,s) int value; unsigned char *h;
                             struct s_contour *s;
{
        int             row_done,ph;
        unsigned char   *t,*u,*p,*q;
        register int    k;
        for (k = 0; k < s->ypts; k++)
           {ph = s->xpts * k;
            t = h + ph;
            u = t + s->xpts - 1;
            p = t;
            row_done = FALSE;
            while (row_done == FALSE)
                 {if (*p < value && row_done == FALSE)
                    {while (*p < value && p < u) p++;
                     if (p == u)
                       {row_done = TRUE;
                        if (*p > value)
                           pw_put(cpw,s->xpos + p - t - 1,s->ypos + k,s->color);
                       } 
                     else if (*p > value)
                             pw_put(cpw,s->xpos + p - t - 1,s->ypos + k,s->color);
                     else;
                    }
                  if (*p == value && row_done == FALSE)
                    {q = p;
                     while (*q == value && q < u) q++;
                     if (q == u) row_done = TRUE;
                     pw_put(cpw,s->xpos + p - t - 1 + (q - p)/2,s->ypos + k,s->color);
                     p = q;
                    }
                  if (*p > value && row_done == FALSE)
                    {while (*p > value && p < u) p++;
                     if (p == u)
                       {row_done = TRUE;
                        if (*p < value)
                           pw_put(cpw,s->xpos + p - t - 1,s->ypos + k,s->color);
                       } 
                     else if (*p < value)
                             pw_put(cpw,s->xpos + p - t - 1,s->ypos + k,s->color);
                     else;
                    }
                 }   
           }
        return;
}
/* EOF */
/* cat > src+obj/confirm_colorbar.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* confirm_colorbar: confirm TRUE if colorbar display	*/
/*		     is not stored data			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	confirm_colorbar()
{
	if (0 == cbar.xpts)	strcpy(txt,"");
	else			my_itoa(cbar.xpts,txt);
	if (0 != strcmp(txt,panel_get(pt[6],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == cbar.ypts)	strcpy(txt,"");
	else			my_itoa(cbar.ypts,txt);
	if (0 != strcmp(txt,panel_get(pt[7],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == cbar.xpos)	strcpy(txt,"");
	else			my_itoa(cbar.xpos,txt);
	if (0 != strcmp(txt,panel_get(pt[8],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == cbar.ypos)	strcpy(txt,"");
	else			my_itoa(cbar.ypos,txt);
	if (0 != strcmp(txt,panel_get(pt[9],PANEL_VALUE,0)))
           return(TRUE);
	return(FALSE);
}
/* EOF */
/* cat > src+obj/confirm_contour.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* confirm_contour: confirm TRUE if contour display is	*/
/*		    not stored data			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	confirm_contour()
{
	if (0 != strcmp(con[nc].fname,panel_get(pt[29],PANEL_VALUE,0)))
	   return(TRUE);
	if (0 == con[nc].xpts)	strcpy(txt,"");
	else			my_itoa(con[nc].xpts,txt);
	if (0 != strcmp(txt,panel_get(pt[30],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == con[nc].ypts)	strcpy(txt,"");
	else			my_itoa(con[nc].ypts,txt);
	if (0 != strcmp(txt,panel_get(pt[31],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == con[nc].xpos)	strcpy(txt,"");
	else			my_itoa(con[nc].xpos,txt);
	if (0 != strcmp(txt,panel_get(pt[32],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == con[nc].ypos)	strcpy(txt,"");
	else			my_itoa(con[nc].ypos,txt);
	if (0 != strcmp(txt,panel_get(pt[33],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == con[nc].color)	strcpy(txt,"");
	else			my_itoa(con[nc].color,txt);
	if (0 != strcmp(txt,panel_get(pt[34],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == con[nc].first)	strcpy(txt,"");
	else			my_itoa(con[nc].first,txt);
	if (0 != strcmp(txt,panel_get(pt[35],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == con[nc].last)	strcpy(txt,"");
	else			my_itoa(con[nc].last,txt);
	if (0 != strcmp(txt,panel_get(pt[36],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == con[nc].interval)	strcpy(txt,"");
	else			my_itoa(con[nc].interval,txt);
	if (0 != strcmp(txt,panel_get(pt[37],PANEL_VALUE,0)))
           return(TRUE);
	return(FALSE);
}
/* EOF */
/* cat > src+obj/confirm_grid.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* confirm_grid: confirm TRUE if grid display is not	*/
/*		 stored data				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	confirm_grid()
{
	if (0 == grid.color)	strcpy(txt,"");
	else			my_itoa(grid.color,txt);
	if (0 != strcmp(txt,panel_get(pt[2],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == grid.xpix)	strcpy(txt,"");
	else			my_itoa(grid.xpix,txt);
	if (0 != strcmp(txt,panel_get(pt[3],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == grid.ypix)	strcpy(txt,"");
	else			my_itoa(grid.ypix,txt);
	if (0 != strcmp(txt,panel_get(pt[4],PANEL_VALUE,0)))
           return(TRUE);
	return(FALSE);
}
/* EOF */
/* cat > src+obj/confirm_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* confirm_image: confirm TRUE if image display is not	*/
/*		  stored data				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	confirm_image()
{
	if (0 != strcmp(image[ni].fname,panel_get(pt[27],PANEL_VALUE,0)))
	   return(TRUE);
	if (0 == image[ni].xpts)	strcpy(txt,"");
	else			my_itoa(image[ni].xpts,txt);
	if (0 != strcmp(txt,panel_get(pt[23],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == image[ni].ypts)	strcpy(txt,"");
	else			my_itoa(image[ni].ypts,txt);
	if (0 != strcmp(txt,panel_get(pt[24],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == image[ni].xpos)	strcpy(txt,"");
	else			my_itoa(image[ni].xpos,txt);
	if (0 != strcmp(txt,panel_get(pt[25],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == image[ni].ypos)	strcpy(txt,"");
	else			my_itoa(image[ni].ypos,txt);
	if (0 != strcmp(txt,panel_get(pt[26],PANEL_VALUE,0)))
           return(TRUE);
	return(FALSE);
}
/* EOF */
/* cat > src+obj/confirm_palette.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* confirm_palette: confirm TRUE if palette display is	*/
/*		    not stored data			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	confirm_palette()
{
	if (0 != strcmp(pfn,panel_get(pt[0],PANEL_VALUE,0)))
	   return(TRUE);
	if (0 == clear_color)
	   strcpy(txt,"");
	else
	   my_itoa(clear_color,txt);
	if (0 != strcmp(txt,panel_get(pt[1],PANEL_VALUE,0)))
	   return(TRUE);
	return(FALSE);
}
/* EOF */
/* cat > src+obj/confirm_text.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* confirm_text: confirm TRUE if text display is not	*/
/*		 stored data				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	confirm_text()
{
	if (0 == text[nt].color)	strcpy(txt,"");
	else			my_itoa(text[nt].color,txt);
	if (0 != strcmp(txt,panel_get(pt[11],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == text[nt].xpos)	strcpy(txt,"");
	else			my_itoa(text[nt].xpos,txt);
	if (0 != strcmp(txt,panel_get(pt[12],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == text[nt].ypos)	strcpy(txt,"");
	else			my_itoa(text[nt].ypos,txt);
	if (0 != strcmp(txt,panel_get(pt[13],PANEL_VALUE,0)))
           return(TRUE);
	if (0 != strcmp(text[nt].body,panel_get(pt[14],PANEL_VALUE,0)))
	   return(TRUE);
	if (0 != strcmp(text[nt].prefont,panel_get(pt[15],PANEL_VALUE,0)))
	   return(TRUE);
	if (0 != strcmp(text[nt].postfont,panel_get(pt[16],PANEL_VALUE,0)))
	   return(TRUE);
	return(FALSE);
}
/* EOF */
/* cat > src+obj/confirm_vector.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* confirm_vector: confirm TRUE if vector display is	*/
/*		   not stored data			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	confirm_vector()
{
	float	f;
	if (0 != strcmp(vec[nv].xname,panel_get(pt[39],PANEL_VALUE,0)))
	   return(TRUE);
	if (0 != strcmp(vec[nv].yname,panel_get(pt[40],PANEL_VALUE,0)))
	   return(TRUE);
	if (0 == vec[nv].xpts)	strcpy(txt,"");
	else			my_itoa(vec[nv].xpts,txt);
	if (0 != strcmp(txt,panel_get(pt[41],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].ypts)	strcpy(txt,"");
	else			my_itoa(vec[nv].ypts,txt);
	if (0 != strcmp(txt,panel_get(pt[42],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].xpos)	strcpy(txt,"");
	else			my_itoa(vec[nv].xpos,txt);
	if (0 != strcmp(txt,panel_get(pt[43],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].ypos)	strcpy(txt,"");
	else			my_itoa(vec[nv].ypos,txt);
	if (0 != strcmp(txt,panel_get(pt[44],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].xzero)	strcpy(txt,"");
	else			my_itoa(vec[nv].xzero,txt);
	if (0 != strcmp(txt,panel_get(pt[45],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].yzero)	strcpy(txt,"");
	else			my_itoa(vec[nv].yzero,txt);
	if (0 != strcmp(txt,panel_get(pt[46],PANEL_VALUE,0)))
           return(TRUE);
	if (FALSE == my_isfloat(panel_get(pt[47],PANEL_VALUE,0)))
	   return(TRUE);
	my_atof(&f,panel_get(pt[47],PANEL_VALUE,0));
	if ( vec[nv].xscale != f)
	   return(TRUE);
	if (0 == vec[nv].xstart)	strcpy(txt,"");
	else			my_itoa(vec[nv].xstart,txt);
	if (0 != strcmp(txt,panel_get(pt[48],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].ystart)	strcpy(txt,"");
	else			my_itoa(vec[nv].ystart,txt);
	if (0 != strcmp(txt,panel_get(pt[49],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].xend)	strcpy(txt,"");
	else			my_itoa(vec[nv].xend,txt);
	if (0 != strcmp(txt,panel_get(pt[50],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].yend)	strcpy(txt,"");
	else			my_itoa(vec[nv].yend,txt);
	if (0 != strcmp(txt,panel_get(pt[51],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].xinterval)	strcpy(txt,"");
	else			my_itoa(vec[nv].xinterval,txt);
	if (0 != strcmp(txt,panel_get(pt[52],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].yinterval)	strcpy(txt,"");
	else			my_itoa(vec[nv].yinterval,txt);
	if (0 != strcmp(txt,panel_get(pt[53],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].color)	strcpy(txt,"");
	else			my_itoa(vec[nv].color,txt);
	if (0 != strcmp(txt,panel_get(pt[54],PANEL_VALUE,0)))
           return(TRUE);
	if (0 == vec[nv].maxlen)	strcpy(txt,"");
	else			my_itoa(vec[nv].maxlen,txt);
	if (0 != strcmp(txt,panel_get(pt[55],PANEL_VALUE,0)))
           return(TRUE);
	if (FALSE == my_isfloat(panel_get(pt[56],PANEL_VALUE,0)))
	   return(TRUE);
	my_atof(&f,panel_get(pt[56],PANEL_VALUE,0));
	if ( vec[nv].yscale != f)
	   return(TRUE);
	return(FALSE);
}
/* EOF */
/* cat > src+obj/cpw_check.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* cpw_check: TRUE if a frame is using the canvas	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	cpw_check()
{
	if (csw_dump == TRUE)
	   {bad_data("File Utility frame using canvas mouse until you specify otherwise.");
	    return(TRUE);
	   }
	if (csw_colorbar == TRUE)
	   {bad_data("ColorBar frame using canvas mouse until you specify otherwise.");
	    return(TRUE);
	   }
	if (csw_image == TRUE)
	   {bad_data("Image frame using canvas mouse until you specify otherwise.");
	    return(TRUE);
	   }
	if (csw_contour == TRUE)
	   {bad_data("Contour frame using canvas mouse until you specify otherwise.");
	    return(TRUE);
	   }
	if (csw_text == TRUE)
	   {bad_data("Text frame using canvas mouse until you specify otherwise.");
	    return(TRUE);
	   }
	if (csw_vector == TRUE)
	   {bad_data("Vector frame using canvas mouse until you specify otherwise.");
	    return(TRUE);
	   }
	return(FALSE);
}
/* EOF */
/* cat > src+obj/cpw_event.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* cpw_event: canvas events, pixwin is cpw            	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	cpw_event(c,e) Canvas c; Event *e;
{
	int	x     = event_x(e),
		y     = event_y(e),
		down,
		drag,
		up,
		leave;
	if	(event_id(e) == LOC_WINEXIT)
		{drag	= FALSE;
		 down	= FALSE;
		 up	= FALSE;
		 leave	= TRUE;
		}
	else if	(event_id(e) == LOC_DRAG)
		{drag	= TRUE;
		 down	= FALSE;
		 up	= FALSE;
		 leave	= FALSE;
		}
	else if	(event_id(e) == MS_LEFT && event_is_down(e))
		{drag	= FALSE;
		 down	= TRUE;
		 up	= FALSE;
		 leave	= FALSE;
		}
	else if	(event_id(e) == MS_LEFT && event_is_up(e))
		{drag	= FALSE;
		 down	= FALSE;
		 up	= TRUE;
		 leave	= FALSE;
		}
	else
		{down	= FALSE;
		 drag	= FALSE;
		 up	= FALSE;
		 leave	= FALSE;
		}
        if      (csw_dump     == TRUE)	event_dump(	x,y,down,drag,up,leave);
        else if	(csw_colorbar == TRUE)	event_colorbar(	x,y,down,drag,up,leave);
        else if	(csw_text     == TRUE)	event_text(	x,y,down,drag,up,leave);
        else if	(csw_image    == TRUE)	event_image(	x,y,down,drag,up,leave);
        else if	(csw_contour  == TRUE)	event_contour(	x,y,down,drag,up,leave);
        else if	(csw_vector   == TRUE)	event_vector(	x,y,down,drag,up,leave);
	else    return;
}
/* EOF */
/* cat > src+obj/draw_box.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_box: for mouse operations on the canvas		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	draw_box(s,x1,y1,x2,y2)
		 char	*s;
		 int	x1,y1,x2,y2;
{

	if	(0 == strcmp(s,"read"))
		{pw_read(x1_save,0,0,N_hpix,1,PIX_SRC,cpw,0,y1);
		 pw_read(x2_save,0,0,N_hpix,1,PIX_SRC,cpw,0,y2);
		 pw_read(y1_save,0,0,1,N_vpix,PIX_SRC,cpw,x1,0);
		 pw_read(y2_save,0,0,1,N_vpix,PIX_SRC,cpw,x2,0);
		}
	else if	(0 == strcmp(s,"write"))
		{pw_write(cpw,0,y1,N_hpix,1,PIX_SRC,x1_save,0,0);
		 pw_write(cpw,0,y2,N_hpix,1,PIX_SRC,x2_save,0,0);
		 pw_write(cpw,x1,0,1,N_vpix,PIX_SRC,y1_save,0,0);
		 pw_write(cpw,x2,0,1,N_vpix,PIX_SRC,y2_save,0,0);
		}
	else if	(0 == strcmp(s,"draw"))
		{pw_vector(cpw,x1,y1,x1,y2,PIX_SRC,255);
		 pw_vector(cpw,x1,y2,x2,y2,PIX_SRC,255);
		 pw_vector(cpw,x2,y2,x2,y1,PIX_SRC,255);
		 pw_vector(cpw,x2,y1,x1,y1,PIX_SRC,255);
		}
	else;
	return;
}
/* EOF */
/* cat > src+obj/draw_colorbar.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_colorbar: draw the colorbar on the canvas	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	draw_colorbar(s) struct s_colorbar *s;
{
        int             c;
        float           f = 255.00001/s->ypts;
        register int    i;
        for (i = 0; i < s->ypts; i++)
           {c = f * i;
	    pw_rop(cpw,s->xpos,
		       s->ypos + s->ypts - 1 - i,
		       s->xpts,
		       1,
		   PIX_SRC | ((c) << 5),NULL,0,0);
           }
        return;
}
/* EOF */
/* cat > src+obj/draw_contour.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_contour: draw a contour on the canvas		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int     draw_contour(s, n) struct s_contour *s;
			   int n; /* sequence number of image in HDF file */
{
	int	z;
	int	nxpts, nypts, filetype;

	z = check_image (s->fname, &(s->xpts), &(s->ypts), &nxpts, &nypts, n, &filetype);
	if	(z == 1)
	{
		sprintf (msg, "File = %s", s->fname);
                bad_data2 ("Cannot open contour file, request ignored.", msg);
                return;
	}
        else if (z == 2)
	{
		sprintf (msg, "File = %s", s->fname);
                bad_data2 ("X-pts * Y-pts != contour filesize, request ignored.", msg);
                return;
	}
	else if (z == 3)
	{
		sprintf (msg, "File = %s", s->fname);
		bad_data2 ("Not enough images in HDF file for contour image, request ignored.", msg);
		return;
	}
	else if (z < 0)		/* HDF error */
	{
		sprintf (msg, "HDF file error (DFerror = %d) for contour image, request ignored.", z);
		sprintf (msg2, "File = %s", s->fname);
		bad_data2 (msg, msg2);
		return;
	}
	if (z == 4)		/* HDF - different size */
	{
		sprintf (msg, "File = %s, old(x=%d,y=%d), new(x=%d,y=%d)", s->fname, s->xpts, s->ypts, nxpts, nypts);
		info_msg2 ("           ----- INFORMATION MESSAGE -----",
			   "HDF file image dimensions used for contour image.", msg,
			   "           ----- INFORMATION MESSAGE -----");
		z = 0;
		s->xpts = nxpts;
		s->ypts = nypts;
	}
        if (z == 0)
	{
        	unsigned char   *h;
        	int             cfirst,clast,cinterval,f;
        	register int    i,j;

        	if (s->first < 0)          cfirst = 0;
        	else if (s->first > 255)   cfirst = 255;
        	else                       cfirst = s->first;
        	if (s->last < cfirst)      clast = cfirst;
        	else if (s->last > 255)    clast = 255;
        	else                       clast = s->last;
        	if (s->interval < 1)       cinterval = 9999;
        	else                       cinterval = s->interval;
		if (NULL == (h = (unsigned char *)calloc(s->xpts * s->ypts,
							  sizeof(unsigned char))))
		{
			bad_data ("Cannot allocate contour memory, request ignored.");
		     	return;
		}
		if (load_contour_image (s->fname, s->xpts, s->ypts, h, n))
		{
			free ((char *) h);
			return;
		}
        	for (i = cfirst; i <= clast; i += cinterval)
		{
           		con_row(i,h,s);
            	      	con_col(i,h,s);
           	}
        	free((char *) h);
        	return;
	}
	else
	{
		bad_data("This contour error message is not possible.");
		return;
	}
}
/* EOF */
/* cat > src+obj/draw_feature.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_feature: draw the overlay features		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	draw_feature(s,n,z) struct s_feature *s;
			    int	n,z;
{

	int		x1,x2,y1,y2;
	int		t,u,c;
	register int	i;
	if (n >= N_image + N_contour)
	   {x1 = vec[n - N_image - N_contour].xpos;
	    y2 = vec[n - N_image - N_contour].ypos;
	    x2 = x1 - 1 + vec[n - N_image - N_contour].xpts;
	    y1 = y2 - 1 + vec[n - N_image - N_contour].ypts;
	   }
	else if (n < N_image)
	   {x1 = image[n].xpos;
	    y2 = image[n].ypos;
	    x2 = x1 - 1 + image[n].xpts;
	    y1 = y2 - 1 + image[n].ypts;
	   }
	else
	   {x1 = con[n - N_image].xpos;
	    y2 = con[n - N_image].ypos;
	    x2 = x1 - 1 + con[n - N_image].xpts;
	    y1 = y2 - 1 + con[n - N_image].ypts;
	   }
	if (x1 > x2 || y2 > y1)
	   {bad_data("start/end pts prob:  remember features uses STORED values, not displayed.");
	    return(1);
	   }

	if (TRUE == s->xgr_sw)
	   {t = s->xgr_thick / 2;
	    if (z == FALSE)	c = clear_color;
	    else		c = s->xgr_color;
	    for (i = x1 + s->xgr_space; i < x2; i += s->xgr_space)
		pw_rop(cpw,i - t,y2,s->xgr_thick,y1 - y2 + 1,
		       PIX_SRC | ((c) << 5),NULL,0,0);
	   }

	if (TRUE == s->ygr_sw)
	   {t = s->ygr_thick / 2;
	    if (z == TRUE)	c = s->ygr_color;
	    else		c = clear_color;
	    for (i = y1 - s->ygr_space; i > y2; i -= s->ygr_space)
		pw_rop(cpw,x1,i - t,x2 - x1 + 1,s->ygr_thick,
		       PIX_SRC | ((c) << 5),NULL,0,0);
	   }

	if (TRUE == s->xax_sw)
	   {if (z == TRUE)	c = s->xax_color;
	    else		c = clear_color;
	    if (s->yax_sw == FALSE || (s->yax_sw == TRUE && s->yax_left == FALSE &&
		s->yax_right == FALSE))
	       {if (s->xax_bot == TRUE)
		   pw_rop(cpw,x1,
			      y1 + 1,
			      x2 - x1 + 1,
			      s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	        if (s->xax_top == TRUE)
		   pw_rop(cpw,x1,
			      y2 - s->xax_thick,
			      x2 - x1 + 1,
			      s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	       }
	    if (s->yax_sw == TRUE && s->yax_left == TRUE && s->yax_right == FALSE)
	       {if (s->xax_bot == TRUE)
		   pw_rop(cpw,x1 - s->yax_thick,
			      y1 + 1,
			      x2 - x1 + 1 + s->yax_thick,
			      s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	        if (s->xax_top == TRUE)
		   pw_rop(cpw,x1 - s->yax_thick,
			      y2 - s->xax_thick,
			      x2 - x1 + 1 + s->yax_thick,
			      s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	       }
	
	    if (s->yax_sw == TRUE && s->yax_left == FALSE && s->yax_right == TRUE)
	       {if (s->xax_bot == TRUE)
		   pw_rop(cpw,x1,
			      y1 + 1,
			      x2 - x1 + 1 + s->yax_thick,
			      s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	        if (s->xax_top == TRUE)
		   pw_rop(cpw,x1,
			      y2 - s->xax_thick,
			      x2 - x1 + 1 + s->yax_thick,
			      s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	       }
	
	    if (s->yax_sw == TRUE && s->yax_left == TRUE  && s->yax_right == TRUE)
	       {if (s->xax_bot == TRUE)
		   pw_rop(cpw,x1 - s->yax_thick,
			      y1 + 1,
			      x2 - x1 + 1 + s->yax_thick +s->yax_thick,
			      s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	        if (s->xax_top == TRUE)
		   pw_rop(cpw,x1 - s->yax_thick,
			      y2 - s->xax_thick,
			      x2 - x1 + 1 + s->yax_thick + s->yax_thick,
			      s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	       }
	
	   }

	if (TRUE == s->yax_sw)
	   {if (z == TRUE)	c = s->yax_color;
	    else		c = clear_color;
	    if (s->xax_sw == FALSE || (s->xax_sw == TRUE && s->xax_bot == FALSE &&
		s->xax_top == FALSE))
	       {if (s->yax_left == TRUE)
		   pw_rop(cpw,x1 - s->yax_thick,
			      y2,
			      s->yax_thick,
			      y1 - y2 + 1,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	        if (s->yax_right == TRUE)
		   pw_rop(cpw,x2 + 1,
			      y2,
			      s->yax_thick,
			      y1 - y2 + 1,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	       }
	    if (s->xax_sw == TRUE && s->xax_bot == TRUE && s->xax_top == FALSE)
	       {if (s->yax_left == TRUE)
		   pw_rop(cpw,x1 - s->yax_thick,
			      y2,
			      s->yax_thick,
			      y1 - y2 + 1 + s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	        if (s->yax_right == TRUE)
		   pw_rop(cpw,x2 + 1,
			      y2,
			      s->yax_thick,
			      y1 - y2 + 1 + s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	       }
	
	    if (s->xax_sw == TRUE && s->xax_bot == FALSE && s->xax_top == TRUE)
	       {if (s->yax_left == TRUE)
		   pw_rop(cpw,x1 - s->yax_thick,
			      y2 - s->xax_thick,
			      s->yax_thick,
			      y1 - y2 + 1 +s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	        if (s->yax_right == TRUE)
		   pw_rop(cpw,x2 + 1,
			      y2 - s->xax_thick,
			      s->yax_thick,
			      y1 - y2 + 1 + s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	       }
	
	    if (s->xax_sw == TRUE && s->xax_bot == TRUE  && s->xax_top == TRUE)
	       {if (s->yax_left == TRUE)
		   pw_rop(cpw,x1 - s->yax_thick,
			      y2 - s->xax_thick,
			      s->yax_thick,
			      y1 - y2 + 1 + s->xax_thick + s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	        if (s->yax_right == TRUE)
		   pw_rop(cpw,x2 + 1,
			      y2 - s->xax_thick,
			      s->yax_thick,
			      y1 - y2 + 1 +s->xax_thick + s->xax_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	       }

	   }

	if (TRUE == s->xt2_sw)
	   {if (z == TRUE)	c = s->xt2_color;
	    else		c = clear_color;
	    t = s->xt2_thick / 2;
	    if (s->xt2_direc == FALSE && s->xt2_bot == TRUE)
	       for (i = x1; i <= x2; i += s->xt2_space)
		   pw_rop(cpw,i - t,
			      y1 - s->xt2_len + 1,
			      s->xt2_thick,
			      s->xt2_len,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->xt2_direc == FALSE && s->xt2_top == TRUE)
	       for (i = x1; i <= x2; i += s->xt2_space)
		   pw_rop(cpw,i - t,
			      y2,
			      s->xt2_thick,
			      s->xt2_len,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->xt2_direc == TRUE && s->xt2_bot == TRUE)
	       for (i = x1; i <= x2; i += s->xt2_space)
		   pw_rop(cpw,i - t,
			      y1 + 1,
			      s->xt2_thick,
			      s->xt2_len,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->xt2_direc == TRUE && s->xt2_top == TRUE)
	       for (i = x1; i <= x2; i += s->xt2_space)
		   pw_rop(cpw,i - t,
			      y2 - s->xt2_len,
			      s->xt2_thick,
			      s->xt2_len,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	   }

	if (TRUE == s->yt2_sw)
	   {if (z == TRUE)	c = s->yt2_color;
	    else		c = clear_color;
	    t = s->yt2_thick / 2;
	    if (s->yt2_direc == FALSE && s->yt2_left == TRUE)
	       for (i = y1; i >= y2; i -= s->yt2_space)
		   pw_rop(cpw,x1,
			      i - t,
			      s->yt2_len,
			      s->yt2_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->yt2_direc == FALSE && s->yt2_right == TRUE)
	       for (i = y1; i >= y2; i -= s->yt2_space)
		   pw_rop(cpw,x2 - s->yt2_len + 1,
			      i - t,
			      s->yt2_len,
			      s->yt2_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->yt2_direc == TRUE && s->yt2_left == TRUE)
	       for (i = y1; i >= y2; i -= s->yt2_space)
		   pw_rop(cpw,x1 - s->yt2_len,
			      i - t,
			      s->yt2_len,
			      s->yt2_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->yt2_direc == TRUE && s->yt2_right == TRUE)
	       for (i = y1; i >= y2; i -= s->yt2_space)
		   pw_rop(cpw,x2 + 1,
			      i - t,
			      s->yt2_len,
			      s->yt2_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	   }

	if (TRUE == s->xt1_sw)
	   {if (z == TRUE)	c = s->xt1_color;
	    else		c = clear_color;
	    t = s->xt1_thick / 2;
	    if (s->xt1_direc == FALSE && s->xt1_bot == TRUE)
	       for (i = x1; i <= x2; i += s->xt1_space)
		   pw_rop(cpw,i - t,
			      y1 - s->xt1_len + 1,
			      s->xt1_thick,
			      s->xt1_len,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->xt1_direc == FALSE && s->xt1_top == TRUE)
	       for (i = x1; i <= x2; i += s->xt1_space)
		   pw_rop(cpw,i - t,
			      y2,
			      s->xt1_thick,
			      s->xt1_len,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->xt1_direc == TRUE && s->xt1_bot == TRUE)
	       for (i = x1; i <= x2; i += s->xt1_space)
		   pw_rop(cpw,i - t,
			      y1 + 1,
			      s->xt1_thick,
			      s->xt1_len,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->xt1_direc == TRUE && s->xt1_top == TRUE)
	       for (i = x1; i <= x2; i += s->xt1_space)
		   pw_rop(cpw,i - t,
			      y2 - s->xt1_len,
			      s->xt1_thick,
			      s->xt1_len,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	   }

	if (TRUE == s->yt1_sw)
	   {if (z == TRUE)	c = s->yt1_color;
	    else		c = clear_color;
	    t = s->yt1_thick / 2;
	    if (s->yt1_direc == FALSE && s->yt1_left == TRUE)
	       for (i = y1; i >= y2; i -= s->yt1_space)
		   pw_rop(cpw,x1,
			      i - t,
			      s->yt1_len,
			      s->yt1_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->yt1_direc == FALSE && s->yt1_right == TRUE)
	       for (i = y1; i >= y2; i -= s->yt1_space)
		   pw_rop(cpw,x2 - s->yt1_len + 1,
			      i - t,
			      s->yt1_len,
			      s->yt1_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->yt1_direc == TRUE && s->yt1_left == TRUE)
	       for (i = y1; i >= y2; i -= s->yt1_space)
		   pw_rop(cpw,x1 - s->yt1_len,
			      i - t,
			      s->yt1_len,
			      s->yt1_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	    if (s->yt1_direc == TRUE && s->yt1_right == TRUE)
	       for (i = y1; i >= y2; i -= s->yt1_space)
		   pw_rop(cpw,x2 + 1,
			      i - t,
			      s->yt1_len,
			      s->yt1_thick,
			  PIX_SRC | ((c) << 5),NULL,0,0);
	   }

        return(0);
}
/* EOF */
/* cat > src+obj/draw_grid.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_grid: draw the grid on the canvas		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	draw_grid(s) struct s_grid *s;
{
	int			n = PIX_SRC | ((s->color) << 5);
        register int            i;
        pw_vector(cpw,0,0,N_hpix-1,N_vpix-1,PIX_SRC,s->color);
        pw_vector(cpw,0,N_vpix-1,N_hpix-1,0,PIX_SRC,s->color);
        for (i=s->xpix; i < N_hpix; i += s->xpix)
	    pw_rop(cpw,i,0,1,N_vpix,n,NULL,0,0);
        for (i=s->ypix; i < N_vpix; i += s->ypix)
	    pw_rop(cpw,0,i,N_hpix,1,n,NULL,0,0);
        return;
}
/* EOF */
/* cat > src+obj/draw_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_image: draw an image on the canvas		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int 
draw_image (s, n)
	struct s_image *s;
	int             n;	/* sequence number of image in HDF file */
{
	int             z;
	int             nxpts, nypts, filetype;

	z = check_image (s->fname, &(s->xpts), &(s->ypts), &nxpts, &nypts, n, &filetype);
	if (z == 1)
	{
		if (base_frame_up)
		{
			sprintf (msg, "File = %s", s->fname);
			bad_data2 ("Cannot open image file, request ignored.", msg);
			return (-1);
		}
		else
		{
			sprintf (msg, "File = %s - Incorrect file name or nonexistent file. Check defaults database with defaultsedit.", s->fname);
			bad_data2 ("Cannot open image file, CompositeTool terminated.", msg);
			return (-1);
		}
	}
	else if (z == 2)
	{
		if (base_frame_up)
		{
			sprintf (msg, "File = %s", s->fname);
			bad_data2 ("X-pts * Y-pts != image filesize, request ignored.", msg);
			return (-1);
		}
		else
		{
			sprintf (msg, "File = %s - Correct raw image file? Check defaults database with defaultsedit.", s->fname);
			bad_data2 ("X-pts * Y-pts != image filesize, CompositeTool terminated.", msg);
			return (-1);
		}
	}
	else if (z == 3)
	{
		if (base_frame_up)
		{
			sprintf (msg, "File = %s", s->fname);
			bad_data2 ("Not enough images in HDF file, request ignored.", msg);
			return (-1);
		}
		else
		{
			sprintf (msg, "File = %s - Correct HDF file? Check defaults database with defaultsedit.", s->fname);
			bad_data2 ("Not enough images in HDF file, CompositeTool terminated.", msg);
			return (-1);
		}
	}
	else if (z < 0)		/* HDF error */
	{
		if (base_frame_up)
		{
			sprintf (msg, "HDF file error (DFerror = %d), request ignored.", z);
			sprintf (msg2, "File = %s", s->fname);
			bad_data2 (msg, msg2);
			return (-1);
		}
		else
		{
			sprintf (msg, "HDF file error (DFerror = %d), CompositeTool terminated.", z);
			sprintf (msg2, "File = %s - Bad HDF file. Check defaults database with defaultsedit.", s->fname);
			bad_data2 (msg, msg2);
			return (-1);
		}
	}
	if (z == 4)		/* HDF - different size */
	{
		if (base_frame_up)
		{
			sprintf (msg, "File = %s, old(x=%d,y=%d), new(x=%d,y=%d).", s->fname, s->xpts, s->ypts, nxpts, nypts);
			info_msg2 ("          ----- INFORMATION MESSAGE -----",
				   "HDF file image dimensions used", msg,
			           "          ----- INFORMATION MESSAGE -----");
		}
		else		/* logo file only */
		{
			sprintf (msg, "file = %s - Check defaults database with defaultsedit.", s->fname);
			bad_data2 ("HDF file dimensions disagree with required values, CompositeTool terminated.", msg);
			return (-1);
		}
		z = 0;
		s->xpts = nxpts;
		s->ypts = nypts;
	}
	if (z == 0)
	{
		struct pixrect *i;
		i = mem_create (s->xpts, s->ypts, 8);
		if (load_image (s->fname, s->xpts, s->ypts, s->xpos, s->ypos, i, n))
			return (-1);
		pw_rop (cpw, s->xpos, s->ypos, s->xpts, s->ypts, PIX_SRC, i, 0, 0);
		return (0);
	}
	else
	{
		bad_data ("This image draw error is not possible.");
		return (-1);
	}
}
/* EOF */
/* cat > src+obj/draw_text.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_text: draw a text on the canvas			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	draw_text(s) struct s_text *s;
{
        struct pixfont  *f;
        strcpy(txt,s->prefont);
        strcat(txt,"/");
        strcat(txt,s->postfont);
        if (NULL == (f = pf_open(txt)))
           {bad_data("Can not open font file, request ignored.");
	    return;
	   }
        pw_ttext(cpw,s->xpos,s->ypos,PIX_SRC | ((s->color) << 5),f,s->body);
        pf_close(f);
        return;
}
/* EOF */
/* cat > src+obj/draw_vector.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_vector: draw a vector on the canvas		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	draw_vector(flag, s, n) int flag; struct s_vector *s;
				int n; /* sequence number of x-image in HDF
					  file. y-image follows x-image if 
					  same HDF file or sequence number if
					  different HDF file */
{
        int		maxx,maxy,startx,starty,
			intervalx,intervaly,endx,endy;
        int             f,b;
        unsigned char   *x,*y;
        register int    i,j;

	int	z;
	int	nxpts, nypts, filetype;

        if (s->xzero < 128)     maxx    = 255 - s->xzero;
        else                    maxx    = s->xzero;
        if (s->yzero < 128)     maxy    = 255 - s->yzero;
        else                    maxy    = s->yzero;
        if (flag == TRUE)
          {startx       = s->xdis;
           intervalx    = 9999;
           endx         = startx;
           starty       = s->ydis;
           intervaly    = 9999;
           endy         = starty;
           if (startx < 0 || startx >= s->xpts ||
	       starty < 0 || starty >= s->ypts)
	      return;
          }
        else
            {if (s->xstart < 0)         startx  = 0;
             else if (s->xstart >= s->xpts)     startx  = s->xpts - 1;
             else                               startx  = s->xstart;
             if (s->xinterval < 1)              intervalx = 9999;
             else                               intervalx = s->xinterval;
             if (s->xend < 0)           endx    = 0;
             else if (s->xend >= s->xpts)       endx    = s->xpts - 1;
             else                               endx    = s->xend;
             if (s->ystart < 0)         starty  = 0;
             else if (s->ystart >= s->ypts)     starty  = s->ypts - 1;
             else                               starty  = s->ystart;
             if (s->yinterval < 1)              intervaly = 9999;
             else                               intervaly = s->yinterval;
             if (s->yend < 0)           endy    = 0;
             else if (s->yend >= s->ypts)       endy    = s->ypts - 1;
             else                               endy    = s->yend;
            }

	z = check_image (s->xname, &(s->xpts), &(s->ypts), &nxpts, &nypts, n, &filetype);
	if	(z == 1)
	{
		sprintf (msg, "File = %s", s->xname);
                bad_data2 ("Cannot open x-image file, request ignored.", msg);
                return;
        }
        else if (z == 2)
	{
		sprintf (msg, "File = %s", s->xname);
                bad_data2 ("X-pts * Y-pts != x-image filesize, request ignored.", msg);
                return;
        }
	else if (z == 3)
	{
		sprintf (msg, "File = %s", s->xname);
		bad_data2 ("Not enough images in HDF file for x-image, request ignored.", msg);
		return;
	}
	else if (z < 0)		/* HDF error */
	{
		sprintf (msg, "HDF file error (DFerror = %d) for x-image, request ignored.", z);
		sprintf (msg2, "File = %s", s->xname);
		bad_data2 (msg, msg2);
		return;
	}
	if (z == 4)		/* HDF - different size */
	{
		sprintf (msg, "File = %s, old(x=%d,y=%d), new(x=%d,y=%d)", s->xname, s->xpts, s->ypts, nxpts, nypts);
		info_msg2 ("          ----- INFORMATION MESSAGE -----",
			   "HDF file x-image dimensions used", msg,
			   "          ----- INFORMATION MESSAGE -----");
		z = 0;
		s->xpts = nxpts;
		s->ypts = nypts;
	}
	z = check_image (s->yname, &(s->xpts), &(s->ypts), &nxpts, &nypts,
			 (! strcmp (s->xname, s->yname)) ? n + 1 : n, &filetype);
	if	(z == 1)
	{
		sprintf (msg, "File = %s", s->yname);
                bad_data2 ("Cannot open y-image file, request ignored.", msg);
                return;
        }
        else if (z == 2)
	{
		sprintf (msg, "File = %s", s->yname);
                bad_data2 ("X-pts * Y-pts != y-image filesize, request ignored.", msg);
                return;
        }
	else if (z == 3)
	{
		sprintf (msg, "File = %s", s->yname);
		bad_data2 ("Not enough images in HDF file for y-image, request ignored.", msg);
		return;
	}
	else if (z < 0)		/* HDF error */
	{
		sprintf (msg, "HDF file error (DFerror = %d) for y-image, request ignored.", z);
		sprintf (msg2, "File = %s", s->yname);
		bad_data2 (msg, msg2);
		return;
	}
	if (z == 4)		/* HDF - different size */
	{
		sprintf (msg, "File = %s, x-image(x=%d,y=%d), y-image(x=%d,y=%dr)", s->yname, s->xpts, s->ypts, nxpts, nypts);
		bad_data2 ("X-image different size than y-image, request ignored.", msg);
		return;
	}
        if (NULL == (x = (unsigned char *)calloc(s->xpts * s->ypts,sizeof(unsigned char))))
	{
        	bad_data ("Cannot allocate x-image memory, request ignored.");
		return;
        }
	if (load_vector_image (s->xname, s->xpts, s->ypts, x, n, 0)) /* 0 == x-image */
	{
		free ((char *) x);
		return;
	}
        if (NULL == (y = (unsigned char *)calloc(s->xpts * s->ypts,sizeof(unsigned char))))
	{
        	bad_data ("Cannot allocate y-image memory, request ignored.");
		free ((char *) x);
		return;
        }
	if (load_vector_image (s->yname, s->xpts, s->ypts, y, n, 1)) /* 1 == y-image */
	{
		free ((char *) x);
		free ((char *) y);
		return;
	}
        for (j = starty; j <= endy; j += intervaly)
            for (i = startx; i <= endx; i += intervalx)
               draw_vector1(s,x,y,s->xpos + i,s->ypos + j,
                            s->xpts * (s->ypts - j - 1) + i,maxx,maxy);
/*
               draw_vector1(s,x,y,s->xpos + i,s->ypos + s->ypts - 1 - j,
                            s->xpts * (s->ypts - j - 1) + i,maxx,maxy);
*/
        free((char *) x);
        free((char *) y);
        return;
}
/* EOF */
/* cat > src+obj/draw_vector1.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* draw_vector1: draw vector arrowhead			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	draw_vector1(s,x,y,xc,yc,off,maxx,maxy)
                     struct s_vector *s;
		     unsigned char *x,*y;
                     int xc,yc,off,maxx,maxy;
{
        register int            i,j;
        int                     a,b,xuse,yuse,xp0,yp0,xp1,yp1;
        float                   xv,yv,lv,st,ct,hlen = 6.,hwid = 3.;
        i = *(x + off);
        j = *(y + off);
        if (s->maxlen == 0 ||
           (s->xscale < .0001 && s->xscale > -.0001 &&
            s->yscale < .0001 && s->yscale > -.0001) ||
           (i == s->xzero && j == s->yzero))
          {pw_vector(cpw,xc+2,yc-2,xc+2,yc+2,PIX_SRC,s->color);
           pw_vector(cpw,xc+2,yc+2,xc-2,yc+2,PIX_SRC,s->color);
           pw_vector(cpw,xc-2,yc+2,xc-2,yc-2,PIX_SRC,s->color);
           pw_vector(cpw,xc-2,yc-2,xc+2,yc-2,PIX_SRC,s->color);
           return;
          }
        xv = s->xscale * (i - s->xzero) / (maxx + 0.);
        yv = s->yscale * (j - s->yzero) / (maxy + 0.);
        lv = sqrt(xv * xv + yv * yv);
        st = yv / lv;
        ct = xv / lv;
        xuse = s->maxlen * xv * .5;
        yuse = s->maxlen * yv * .5;
        xp0 = xc - xuse;
        yp0 = yc + yuse;
        xp1 = xc + xuse;
        yp1 = yc - yuse;
        pw_vector(cpw,xp0,yp0,xp1,yp1,PIX_SRC,s->color);
        a = - hlen * ct - hwid * st;
        b =   hlen * st - hwid * ct;
        pw_vector(cpw,xp1,yp1,xp1+a,yp1+b,PIX_SRC,s->color);
        a = - hlen * ct + hwid * st;
        b =   hlen * st + hwid * ct;
        pw_vector(cpw,xp1,yp1,xp1+a,yp1+b,PIX_SRC,s->color);
        return;
}
/* EOF */
/* cat > src+obj/event_colorbar.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* event_colorbar: canvas events, pixwin is cpw		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	event_colorbar(x,y,down,drag,up,leave) int x,y,down,drag,up,leave;
{
	char		c[10],
			d[10];
	if (sw_draw == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_colorbar(&tcbar))
		   {reset_mcolorbar();
		    return;
		   }
		tcbar.xpos = x;
		tcbar.ypos = y;
		my_itoa(x,c);
		my_itoa(y,d);
		panel_set(pt[8],PANEL_VALUE,c,0);
		panel_set(pt[9],PANEL_VALUE,d,0);
		draw_colorbar(&tcbar);
		return;
	       }
	    mouse_msg(x,y);
	    panel_set(pm[2],PANEL_LABEL_STRING,"",0);
	    return;
	   }
	if (sw_move == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_colorbar(&tcbar))
		   {reset_mcolorbar();
		    return;
		   }
                x_start = tcbar.xpos - 1;
                x_end   = tcbar.xpos + tcbar.xpts;
                y_start = tcbar.ypos - 1;
                y_end   = tcbar.ypos + tcbar.ypts;
                draw_box("read",x_start,y_start,x_end,y_end);
                draw_box("draw",x_start,y_start,x_end,y_end);
                x_interval = x;
                y_interval = y;
               } 
            else if (drag == TRUE)
               {draw_box("write",x_start,y_start,x_end,y_end);
                x_start += (x - x_interval);
                x_end   += (x - x_interval);
                y_start += (y - y_interval);
                y_end   += (y - y_interval);
                x_interval = x;
                y_interval = y;
                draw_box("read",x_start,y_start,x_end,y_end);
                draw_box("draw",x_start,y_start,x_end,y_end);
               }
/*
            else if (leave == TRUE)
               draw_box("write",x_start,y_start,x_end,y_end);
*/
            else if (up == TRUE)
               {draw_box("write",x_start,y_start,x_end,y_end);
		if (FALSE == ok_colorbar(&tcbar))
		   {reset_mcolorbar();
		    return;
		   }
		pw_rop(cpw,tcbar.xpos,tcbar.ypos,
			   tcbar.xpts,tcbar.ypts,
			   PIX_SRC | ((clear_color) << 5),NULL,0,0);
                tcbar.xpos = x_start + 1;
                tcbar.ypos = y_start + 1;
		draw_colorbar(&tcbar);
		my_itoa(tcbar.xpos,c);
		my_itoa(tcbar.ypos,d);
		panel_set(pt[8],PANEL_VALUE,c,0);
		panel_set(pt[9],PANEL_VALUE,d,0);
               }
            else;
            mouse_msg(x,y);
            panel_set(pm[2],PANEL_LABEL_STRING,"",0);
            return;
           }
}
/* EOF */
/* cat > src+obj/event_contour.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* event_contour: canvas events, pixwin is cpw		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	event_contour(x,y,down,drag,up,leave) int x,y,down,drag,up,leave;
{
	char		c[10],
			d[10];
	if (sw_draw == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_contour(&con[N_contour], 1))
		   {reset_mcontour();
		    return;
		   }
		con[N_contour].xpos = x;
		con[N_contour].ypos = y;
		my_itoa(x,c);
		my_itoa(y,d);
		panel_set(pt[32],PANEL_VALUE,c,0);
		panel_set(pt[33],PANEL_VALUE,d,0);
		draw_contour(&con[N_contour], 1);
		return;
	       }
	    mouse_msg(x,y);
	    panel_set(pm[2],PANEL_LABEL_STRING,"",0);
	    return;
	   }
	if (sw_move == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_contour(&con[N_contour], 1))
		   {reset_mcontour();
		    return;
		   }
                x_start = con[N_contour].xpos - 1;
                x_end   = con[N_contour].xpos + con[N_contour].xpts;
                y_start = con[N_contour].ypos - 1;
                y_end   = con[N_contour].ypos + con[N_contour].ypts;
                draw_box("read",x_start,y_start,x_end,y_end);
                draw_box("draw",x_start,y_start,x_end,y_end);
                x_interval = x;
                y_interval = y;
	       }
	    else if (drag == TRUE)
               {draw_box("write",x_start,y_start,x_end,y_end);
                x_start += (x - x_interval);
                x_end   += (x - x_interval);
                y_start += (y - y_interval);
                y_end   += (y - y_interval);
                x_interval = x;
                y_interval = y;
                draw_box("read",x_start,y_start,x_end,y_end);
                draw_box("draw",x_start,y_start,x_end,y_end);
               }
/*
            else if (leave == TRUE)
               draw_box("write",x_start,y_start,x_end,y_end);
*/
            else if (up == TRUE)
               {draw_box("write",x_start,y_start,x_end,y_end);
                if (FALSE == ok_contour(&con[N_contour], 1))
                   {reset_mcontour();
                    return;
                   }
		pw_rop(cpw,con[N_contour].xpos,con[N_contour].ypos,
			   con[N_contour].xpts,con[N_contour].ypts,
			   PIX_SRC | ((clear_color) << 5),NULL,0,0);
                con[N_contour].xpos = x_start + 1;
                con[N_contour].ypos = y_start + 1;
                draw_contour(&con[N_contour], 1);
                my_itoa(con[N_contour].xpos,c);
                my_itoa(con[N_contour].ypos,d);
		panel_set(pt[32],PANEL_VALUE,c,0);
		panel_set(pt[33],PANEL_VALUE,d,0);
	       }
	    else;
	    mouse_msg(x,y);
	    panel_set(pm[2],PANEL_LABEL_STRING,"",0);
	    return;
	   }
}
/* EOF */
/* cat > src+obj/event_dump.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* event_dump: canvas events, pixwin is cpw		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	event_dump(x,y,down,drag,up,leave) int x,y,down,drag,up,leave;
{
	char		c[10],
			d[10];

	mouse_msg(x,y);
	if (down == TRUE)
	   {sdump.xstart = sdump.xend = x;
	    sdump.ystart = sdump.yend = y;
	    draw_box("read",sdump.xstart,sdump.ystart,sdump.xend,sdump.yend);
	    my_itoa(x,c);
	    my_itoa(y,d);
	    panel_set(pt[18],PANEL_VALUE,c,0);
	    panel_set(pt[20],PANEL_VALUE,c,0);
	    panel_set(pt[19],PANEL_VALUE,d,0);
	    panel_set(pt[21],PANEL_VALUE,d,0);
	   }
	else if (drag == TRUE)
	   {draw_box("write",sdump.xstart,sdump.ystart,sdump.xend,sdump.yend);
	    sdump.xend = x;
	    if ((sdump.xend - sdump.xstart +1) % 2 != 0) sdump.xend -= 1;
	    sdump.yend = y;
	    draw_box("read",sdump.xstart,sdump.ystart,sdump.xend,sdump.yend);
	    draw_box("draw",sdump.xstart,sdump.ystart,sdump.xend,sdump.yend);
	    my_itoa(sdump.xend,c);
	    my_itoa(y,d);
	    panel_set(pt[20],PANEL_VALUE,c,0);
	    panel_set(pt[21],PANEL_VALUE,d,0);
	   }
	else if (up == TRUE || leave == TRUE)
	   draw_box("write",sdump.xstart,sdump.ystart,sdump.xend,sdump.yend);
	else;
	kbyte_msg(sdump.xend - sdump.xstart + 1,
		  sdump.yend - sdump.ystart + 1);
	return;
}
/* EOF */
/* cat > src+obj/event_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* event_image: canvas events, pixwin is cpw		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	event_image(x,y,down,drag,up,leave) int x,y,down,drag,up,leave;
{
	char		c[10],
			d[10];
	if (sw_draw == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_image(&image[N_image], 1))
		   {reset_mimage();
		    return;
		   }
		image[N_image].xpos = x;
		image[N_image].ypos = y;
		my_itoa(x,c);
		my_itoa(y,d);
		panel_set(pt[25],PANEL_VALUE,c,0);
		panel_set(pt[26],PANEL_VALUE,d,0);
		draw_image(&image[N_image], 1);
		return;
	       }
	    mouse_msg(x,y);
	    panel_set(pm[2],PANEL_LABEL_STRING,"",0);
	    return;
	   }
	if (sw_move == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_image(&image[N_image], 1))
		   {reset_mimage();
		    return;
		   }
                x_start = image[N_image].xpos - 1;
                x_end   = image[N_image].xpos + image[N_image].xpts;
                y_start = image[N_image].ypos - 1;
                y_end   = image[N_image].ypos + image[N_image].ypts;
                draw_box("read",x_start,y_start,x_end,y_end);
                draw_box("draw",x_start,y_start,x_end,y_end);
                x_interval = x;
                y_interval = y;
	       }
	    else if (drag == TRUE)
               {draw_box("write",x_start,y_start,x_end,y_end);
                x_start += (x - x_interval);
                x_end   += (x - x_interval);
                y_start += (y - y_interval);
                y_end   += (y - y_interval);
                x_interval = x;
                y_interval = y;
                draw_box("read",x_start,y_start,x_end,y_end);
                draw_box("draw",x_start,y_start,x_end,y_end);
               }
/*
	    else if (leave == TRUE)
               draw_box("write",x_start,y_start,x_end,y_end);
*/
	    else if (up == TRUE)
               {draw_box("write",x_start,y_start,x_end,y_end);
                if (FALSE == ok_image(&image[N_image], 1))
                   {reset_mimage();
                    return;
                   }
		pw_rop(cpw,image[N_image].xpos,image[N_image].ypos,
			   image[N_image].xpts,image[N_image].ypts,
			   PIX_SRC | ((clear_color) << 5),NULL,0,0);
		image[N_image].xpos = x_start + 1;
		image[N_image].ypos = y_start + 1;
		draw_image(&image[N_image], 1);
		my_itoa(image[N_image].xpos,c);
		my_itoa(image[N_image].ypos,d);
		panel_set(pt[25],PANEL_VALUE,c,0);
		panel_set(pt[26],PANEL_VALUE,d,0);
               }
	    else;
	    mouse_msg(x,y);
	    panel_set(pm[2],PANEL_LABEL_STRING,"",0);
	    return;
	   }
}
/* EOF */
/* cat > src+obj/event_text.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* event_text: canvas events, pixwin is cpw		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	event_text(x,y,down,drag,up,leave) int x,y,down,drag,up,leave;
{
	char		c[10],
			d[10];
	register int	i;
	if (sw_draw == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_text(&text[N_text]))
		   {reset_mtext();
		    return;
		   }
		text[N_text].xpos = x;
		text[N_text].ypos = y;
		my_itoa(x,c);
		my_itoa(y,d);
		panel_set(pt[12],PANEL_VALUE,c,0);
		panel_set(pt[13],PANEL_VALUE,d,0);
		draw_text(&text[N_text]);
		return;
	       }
	    mouse_msg(x,y);
	    panel_set(pm[2],PANEL_LABEL_STRING,"",0);
	    return;
	   }
	if (sw_move == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_text(&text[N_text]))
		   {reset_mtext();
		    return;
		   }
		x_start = text[N_text].xpos;
		x_end   = text[N_text].xpos + 20;
		y_start = text[N_text].ypos - 20;
		y_end   = text[N_text].ypos;
	        draw_box("read",x_start,y_start,x_end,y_end);
	        draw_box("draw",x_start,y_start,x_end,y_end);
		x_interval = x;
		y_interval = y;
	       }
	    else if (drag == TRUE)
	       {draw_box("write",x_start,y_start,x_end,y_end);
		x_start += (x - x_interval);
		x_end   += (x - x_interval);
		y_start += (y - y_interval);
		y_end   += (y - y_interval);
		x_interval = x;
		y_interval = y;
	        draw_box("read",x_start,y_start,x_end,y_end);
	        draw_box("draw",x_start,y_start,x_end,y_end);
	       }
/*
	    else if (leave == TRUE)
	        draw_box("write",x_start,y_start,x_end,y_end);
*/
	    else if (up == TRUE)
	       {draw_box("write",x_start,y_start,x_end,y_end);
		if (FALSE == ok_text(&text[N_text]))
		   {reset_mtext();
		    return;
		   }
		i = text[N_text].color;
		text[N_text].color = clear_color;
		draw_text(&text[N_text]);
		text[N_text].xpos = x_start;
		text[N_text].ypos = y_start + 20;
		my_itoa(text[N_text].xpos,c);
		my_itoa(text[N_text].ypos,d);
		panel_set(pt[12],PANEL_VALUE,c,0);
		panel_set(pt[13],PANEL_VALUE,d,0);
		text[N_text].color = i;
		draw_text(&text[N_text]);
	       }
	    else;
	    mouse_msg(x,y);
	    panel_set(pm[2],PANEL_LABEL_STRING,"",0);
	    return;
	   }
}
/* EOF */
/* cat > src+obj/event_vector.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* event_vector:  canvas events, pixwin is cpw		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	event_vector(x,y,down,drag,up,leave) int x,y,down,drag,up,leave;
{
	char		c[10],
			d[10];
	register int	i;
	if (sw_draw == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_vector(&vec[N_vector], 1))
		   {reset_mvector();
		    return;
		   }
		vec[N_vector].xpos = x;
		vec[N_vector].ypos = y;
		my_itoa(x,c);
		my_itoa(y,d);
		panel_set(pt[43],PANEL_VALUE,c,0);
		panel_set(pt[44],PANEL_VALUE,d,0);
		draw_vector(FALSE,&vec[N_vector], 1);
		return;
	       }
	    mouse_msg(x,y);
	    panel_set(pm[2],PANEL_LABEL_STRING,"",0);
	    return;
	   }
	if (sw_move == TRUE)
	   {if (down == TRUE)
	       {if (FALSE == ok_vector(&vec[N_vector], 1))
		   {reset_mvector();
		    return;
		   }
                x_start = vec[N_vector].xpos - 1;
                x_end   = vec[N_vector].xpos + vec[N_vector].xpts;
                y_start = vec[N_vector].ypos - 1;
                y_end   = vec[N_vector].ypos + vec[N_vector].ypts;
                draw_box("read",x_start,y_start,x_end,y_end);
                draw_box("draw",x_start,y_start,x_end,y_end);
                x_interval = x;
                y_interval = y;
	       }
	    else if (drag == TRUE)
               {draw_box("write",x_start,y_start,x_end,y_end);
                x_start += (x - x_interval);
                x_end   += (x - x_interval);
                y_start += (y - y_interval);
                y_end   += (y - y_interval);
                x_interval = x;
                y_interval = y;
                draw_box("read",x_start,y_start,x_end,y_end);
                draw_box("draw",x_start,y_start,x_end,y_end);
               }
/*
            else if (leave == TRUE)
               draw_box("write",x_start,y_start,x_end,y_end);
*/
            else if (up == TRUE)
               {draw_box("write",x_start,y_start,x_end,y_end);
                if (FALSE == ok_vector(&vec[N_vector], 1))
                   {reset_mvector();
                    return;
                   }
		i = vec[N_vector].color;
		vec[N_vector].color = clear_color;
		draw_vector(FALSE,&vec[N_vector], 1);
		vec[N_vector].color = i;
                vec[N_vector].xpos = x_start + 1;
                vec[N_vector].ypos = y_start + 1;
                draw_vector(FALSE,&vec[N_vector], 1);
		my_itoa(vec[N_vector].xpos,c);
		my_itoa(vec[N_vector].ypos,d);
		panel_set(pt[43],PANEL_VALUE,c,0);
		panel_set(pt[44],PANEL_VALUE,d,0);
               }
            else;
            mouse_msg(x,y);
            panel_set(pm[2],PANEL_LABEL_STRING,"",0);
            return;
           }
}
/* EOF */
/* cat > src+obj/info_msg.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* info_msg: put three messages on the main panel	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	info_msg(p,q,r) char *p,*q,*r;
{
	char	m[10],*s,*t;
	msg_no++;
	my_itoa(msg_no,m);
	if (strlen(p) <= strlen(m))
	   panel_set(pm[0],PANEL_LABEL_STRING,m,0);
	else
	   {s = m;
	    t = p;
	    while (*s) *t++ = *s++;
	    panel_set(pm[0],PANEL_LABEL_STRING,p,0);
	   }
	panel_set(pm[1],PANEL_LABEL_STRING,q,0);
	panel_set(pm[2],PANEL_LABEL_STRING,r,0);
	panel_set (pm[3], PANEL_LABEL_STRING, "", 0);
	return;
}
/* EOF */
/* cat > src+obj/kbyte_msg.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* kbyte_msg: state the kbytes to dump screen to file	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	kbyte_msg(x,y) int	x,y;
{
	char		*s;
	if ( x <= 0 || y <= 0)
  strcpy(txt,"*** WARNING *** won't work:  start-end points specify nonpositive area.");
	else
	   {strcpy(txt,"Kbytes memory and disk to dump = ");
	    s = txt;
	    while (*s) s++;
	    my_itoa(((x * y) >> 10) + 1, s);
	    while (*s) s++;
	    strcat(s,", xpts = ");
	    while (*s) s++;
	    my_itoa(x,s);
	    while (*s) s++;
	    strcat(s,", ypts = ");
	    while (*s) s++;
	    my_itoa(y,s);
	    while (*s) s++;
	    *s++ = '.';
	    *s   = '\0';
	   }
	panel_set(pm[2],PANEL_LABEL_STRING,txt,0);
	return;
}
/* EOF */
/* cat > src+obj/load_rgb.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* load_rgb: load the red, blue, and green arrays for	*/
/*	     the palette				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int
load_rgb (rawpfn, n)
	char *rawpfn;
		/* input: unprocessed palette filename.
		   returns: stripped palette filename if loaded. */
	int n;
		/* sequence number of palette in HDF file */
{
	int		z, i, f;
	unsigned char *p_palette;
	char s[MAXNAMELEN + 1];	

	strcpy (s, rawpfn);
	(void) strip_wspace (s);
	if (strlen (s) == 0)
	{
		if (base_frame_up)
		{
			bad_data ("Empty palette file, request ignored.");
		 	return (-1);
		}
		else
		{
			sprintf (msg, "Empty palette file. Check defaults database with defaultsedit.", s);
			bad_data2 ("Cannot open palette file, CompositeTool terminated.", msg);
			return (-1);
		}
	}
	
	z = check_palette (s, n);
	if	(z == 1)
	{
		if (base_frame_up)
		{
			sprintf (msg, "File = %s", s);
			bad_data2 ("Cannot open palette file, request ignored.", msg);
		 	return (-1);
		}
		else
		{
			sprintf (msg, "File = %s - Incorrect file name or nonexistent file. Check defaults database with defaultsedit.", s);
			bad_data2 ("Cannot open palette file, CompositeTool terminated.", msg);
			return (-1);
		}
	}
	else if	(z == 2)
	{
		if (base_frame_up)
		{
			sprintf (msg, "File = %s", s);
			bad_data2 ("Palette size != 768, request ignored.", msg);
		 	return (-1);
		}
		else
		{
			sprintf (msg, "File = %s - Correct raw palette file? Check defaults database with defaultsedit.", s);
			bad_data2 ("Palette size != 768, CompositeTool terminated.", msg);
			return (-1);
		}
	}
	else if (z == 3)
	{
		if (base_frame_up)
		{
			sprintf (msg, "File = %s", s);
			bad_data2 ("Not enough palettes in HDF file, request ignored.", msg);
		 	return (-1);
		}
		else
		{
			sprintf (msg, "File = %s - Correct HDF file? Check defaults database with defaultsedit.", s);
			bad_data2 ("Not enough palettes in HDF file, CompositeTool terminated.", msg);
			return (-1);
		}
	}
	else if (z < 0)		/* HDF error */
	{
		if (base_frame_up)
		{
			sprintf (msg, "HDF file error (DFerror = %d), request ignored.", z);
			sprintf (msg2, "File = %s", s);
			bad_data2 (msg, msg2);
			return (-1);
		}
		else
		{
			sprintf (msg, "HDF file error (DFerror = %d), CompositeTool terminated.", z);
			sprintf (msg2, "File = %s - Bad HDF file. Check defaults database with defaultsedit.", s);
			bad_data2 (msg, msg2);
			return (-1);
		}
	}

	if (DFPgetpal (s, palette))
	{
		f = open (s, O_RDONLY);		/* should not fail */
		read (f, red, 256);
		read (f, green, 256);
		read (f, blue, 256);
		close (f);
	}
	else 
	{
		for (i = 1; i < n; i++)		/* should not fail */
			DFPgetpal (s, palette);
		p_palette = palette;
		for (i = 0; i < 256; i++) /* put in red, green, blue arrays */
		{
			red[i] = *p_palette++;
			green[i] = *p_palette++;
			blue[i] = *p_palette++;
		}
		DFPrestart ();
	}

	adjust_colormap ();
/*
        *red         = *green         = *blue         = 255;
        *(red + 255) = *(green + 255) = *(blue + 255) = 0;
        *(red + 254) = *(green + 254) = *(blue + 254) = 255;
        *(red + 253) = *(green + 253) = *(blue + 253) = 0;
*/

	strcpy (rawpfn, s);
        return (0);
}
/* EOF */
/* cat > src+obj/make_fr.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* make_fr: make a frame				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	make_fr(n,x,y,h,w,s) int n,x,y,h,w; char *s;
{
        fr[n]   = window_create(fr[0],FRAME,
                FRAME_SHOW_LABEL,               TRUE,
                FRAME_NO_CONFIRM,               TRUE,
                WIN_X,                          x,
                WIN_Y,                          y,
                WIN_HEIGHT,                     h,
                WIN_WIDTH,                      w,
                FRAME_DONE_PROC,                *fdp[n],
                FRAME_LABEL,                    s,
		FRAME_SHOW_SHADOW,		FALSE,
                0);
	set_frame_colormap (fr[n], b_cmsn);
        return;
}
/* EOF */
/* cat > src+obj/make_pb.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* make_pb: make a panel button				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	make_pb(n,x,y,a,w,s) int n,x,y,a,w; char *s;
{
        pb[n]   = panel_create_item(pa[a],PANEL_BUTTON,
                PANEL_ITEM_X,                   x,
                PANEL_ITEM_Y,                   y,
                PANEL_LABEL_IMAGE,
			panel_button_image(pa[a],s,w,font_panel_button),
                PANEL_NOTIFY_PROC,              *bnp[n],
                0);
        return;
}
/* EOF */
/* cat > src+obj/make_pm.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* make_pm: make a panel message to be referenced in	*/
/*	    the pgm					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	make_pm(n,x,y,a,s) int n,x,y,a; char *s;
{
        pm[n]   = panel_create_item(pa[a],PANEL_MESSAGE,
                PANEL_ITEM_X,                   x,
                PANEL_ITEM_Y,                   y,
                PANEL_LABEL_STRING,             s,
                PANEL_LABEL_BOLD,               TRUE,
                0);
        return;
}
/* EOF */
/* cat > src+obj/make_pmnn.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* make_pmnn: make a panel message never referenced in	*/
/* 	      the pgm					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	make_pmnn(x,y,a,s) int x,y,a; char *s;
{
                panel_create_item(pa[a],PANEL_MESSAGE,
                PANEL_ITEM_X,                   x,
                PANEL_ITEM_Y,                   y,
                PANEL_LABEL_STRING,             s,
                PANEL_LABEL_BOLD,               TRUE,
                0);
        return;
}
/* EOF */
/* cat > src+obj/make_ps.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* make_ps: make a panel slider				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	make_ps(n,x,y,w,i,j,a,s) int n,x,y,w,i,j,a; char *s;
{
        ps[n]   = panel_create_item(pa[a],PANEL_SLIDER,
                PANEL_LAYOUT,                   PANEL_HORIZONTAL,
                PANEL_SHOW_RANGE,               TRUE,
                PANEL_SHOW_VALUE,               TRUE,
                PANEL_ITEM_X,                   x,
                PANEL_ITEM_Y,                   y,
                PANEL_SLIDER_WIDTH,             w,
                PANEL_MIN_VALUE,                i,
                PANEL_MAX_VALUE,                j,
                PANEL_LABEL_STRING,             s,
                PANEL_NOTIFY_PROC,              *snp[n],
                0);
        return;
}
/* EOF */
/* cat > src+obj/make_pt.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* make_pt: make a panel text				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	make_pt(n,x,y,a,d,e,s) int n,x,y,a,d,e; char *s;
{
        pt[n]   = panel_create_item(pa[a],PANEL_TEXT,
                PANEL_ITEM_X,                   x,
                PANEL_ITEM_Y,                   y,
                PANEL_VALUE_STORED_LENGTH,      d,
                PANEL_VALUE_DISPLAY_LENGTH,     e,
                PANEL_LABEL_STRING,             s,
                PANEL_LABEL_BOLD,               TRUE,
                0);
        return;
}
/* EOF */
/* cat > src+obj/mouse_msg.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* mouse_msg: state the current mouse canvas position	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	mouse_msg(x,y) int	x,y;
{
	char		*s;
	strcpy(txt,panel_get(pm[0],PANEL_LABEL_STRING,0));
	*(txt + 10) = '\0';
	panel_set(pm[0],PANEL_LABEL_STRING,txt,0);
	strcpy(txt,"Mouse now at x = ");
	s = txt;
	while (*s) s++;
	my_itoa(x,s);
	while (*s) s++;
	strcat(	s,", y = ");
	while (*s) s++;
	my_itoa(y,s);
	while (*s) s++;
	*s++ = '.';
	*s   = '\0';
	panel_set(pm[1],PANEL_LABEL_STRING,txt,0);
	return;
}
/* EOF */
/* cat > src+obj/msg_draw.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* msg_draw: say draw button activated for some frame	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	msg_draw(s) char *s;
{
	strcpy(txt,"          ");
	strcat(txt,s);
	strcat(txt,"  move the mouse into the canvas to the point");
	info_msg(txt,"where you want the origin to be, then click the mouse button.","");
	return;
}
/* EOF */
/* cat > src+obj/msg_move.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* msg_move: say move button activated for some frame	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	msg_move(s) char *s;
{
	strcpy(txt,"          ");
	strcat(txt,s);
	strcat(txt,"  move the mouse into the canvas and press the mouse button (hold");
	info_msg(txt,
		 "it down).  Drag the mouse to some other point and release it.  The data",
		 "is moved according to the vector you have just defined.");
	return;
}
/* EOF */
/* cat > src+obj/my_atof.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* my_atof: my alpha to floating point			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	my_atof(f,s) float *f; char *s;
{
        float           n;
        char            c,*t;
        if (*s == '\0') {*f = 0.; return;}
        while (*s == ' ') s++;
        t = s;
        while (*t && *t != '.') t++;
        if (*t == '\0') {*f = atoi(s); return;}
        *t = '\0';
        *f = atoi(s);
        *t++ = '.';
        if (*t == '\0') return;
        s = t;
        while (*t >= '0' && *t <= '9') t++;
        c = *t;
        *t = '\0';
        n = 1.;
        while (s < t) {n *= 10.; *f += (*s - '0') / n; s++;}
        *t = c;
        return;
}
/* EOF */
/* cat > src+obj/my_ftoa.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* my_ftoa: my floating point to alpha			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	my_ftoa(f,d,s) float f; int d; char *s;
{
        register int            n;
        n = f;
        my_itoa(n,s);
        n = f;
        while (n > 0) {s++; n /= 10;}
        *s++ = '.';
        n = f;
        f -= n;
        while (d-- > 0) f *= 10.;
        n = f;
        my_itoa(n,s);
        return;
}
/* EOF */
/* cat > src+obj/my_isfloat.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* my_isfloat: is the char string a floating point	*/
/*	       number?					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	my_isfloat(s) char *s;
{
        char            *t;
        if (*s == '\0') return(TRUE);
        while (*s == ' ') s++;
        t = s;
        while (*t && *t != '.') t++;
        if (*t == '\0') return(my_isint(s));
        if (*t != '.') return(FALSE);
        *t = '\0';
        if (FALSE == my_isint(s)) return(FALSE);
        *t++ = '.';
        if (FALSE == my_isint(t)) return(FALSE);
        return(TRUE);
}
/* EOF */
/* cat > src+obj/my_isint.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* my_isint: is the char string an integer?		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	my_isint(s) char *s;
{
        char            *t;
        if (*s == '\0') return(TRUE);
        while (*s == ' ') s++;
        if (*s == '-') s++;
        t = s;
        while (*t) t++;
        t--;
        while(*t == ' ') *t-- = '\0';
        while (*s) {if (*s < '0' || *s > '9') return(FALSE); s++;}
        return(TRUE);
}
/* EOF */
/* cat > src+obj/my_itoa.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* my_itoa: my integer to alpha				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	my_itoa(n,s) int n; char *s;
{
        char                    *t;
        register int            j;
        if (n == 0) {*s++ = '0'; *s = '\0'; return;}
        if (n < 0) {*s++ = '-'; n = - n;}
        if (n < 10) {*s++ = '0' + n; *s = '\0'; return;}
        t = s;
        j = n;
        while (j > 0) {t++; j /= 10;}
        *t-- = '\0';
        while (t > s) {j = n/10; *t-- = '0' + n - 10*j; n /= 10;}
        *t = '0' +j;
        return;
}
/* EOF */
/* cat > src+obj/my_otod.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* my_otod: my octal to decimal integer			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	my_otod(n) int n;
{
        char            s[8],*t;
        register int    k,m;
        k       = 0;
        m       = 1;
        my_itoa(n,s);
        t = s;
        while (*t) t++;
        t--;
        while (t > s) {k += m * (*t - '0'); m *= 8; t--;}
        k += m * (*t - '0');
        return(k);
}
/* EOF */
/* cat > src+obj/my_stripfn.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* my_stripfn: my strip file name			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	my_stripfn(s) char *s;
{
        char            *t;
        if (*s == '\0') return;
        t = s;
        while (*t == ' ') t++;
        while (*t != ' ' && *t) *s++ = *t++;
        *s = '\0';
        return;
}
/* EOF */
/* cat > src+obj/no_op.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* no_op: no operation					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	no_op()
{
        return;
}
/* EOF */
/* cat > src+obj/nosho_feature.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* nosho_feature: no-sho the features frame elements	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	nosho_feature()
{
	panel_set(pb[107],PANEL_SHOW_ITEM,FALSE,0);
	panel_set(pb[108],PANEL_SHOW_ITEM,FALSE,0);
	panel_set(pb[110],PANEL_SHOW_ITEM,FALSE,0);
	panel_set(pb[111],PANEL_SHOW_ITEM,FALSE,0);
	panel_set(pb[112],PANEL_SHOW_ITEM,FALSE,0);
	panel_set(ps[  0],PANEL_SHOW_ITEM,FALSE,0);
	panel_set(ps[  1],PANEL_SHOW_ITEM,FALSE,0);
	panel_set(ps[  2],PANEL_SHOW_ITEM,FALSE,0);
	panel_set(ps[  3],PANEL_SHOW_ITEM,FALSE,0);
        return;
}
/* EOF */
/* cat > src+obj/null_colorbar.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* null_colorbar: null the colorbar structure		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	null_colorbar(s) struct s_colorbar *s;
{
        s -> sw         = FALSE;
        s -> xpos       = 0;
        s -> ypos       = 0;
        s -> xpts       = 100;
        s -> ypts       = 256;
        return;
}
/* EOF */
/* cat > src+obj/null_contour.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* null_contour: null a contour data structure		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	null_contour(s) struct s_contour *s;
{
        s -> sw         = FALSE;
        strcpy(s -> fname,"");
        s -> color      = 255;
        s -> first      = 0;
        s -> last       = 255;
        s -> interval   = 32;
        s -> dis        = 0;
        s -> xpos       = 0;
        s -> ypos       = 0;
        s -> xpts       = 0;
        s -> ypts       = 0;
        return;
}
/* EOF */
/* cat > src+obj/null_feature.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* null_feature: null a feature structure		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	null_feature(s) struct s_feature *s;
{
        s -> xax_sw     = FALSE;
        s -> xax_thick  = 1;
        s -> xax_color  = 255;
        s -> xax_bot    = TRUE;
        s -> xax_top    = TRUE;
        s -> yax_sw     = FALSE;
        s -> yax_thick  = 1;
        s -> yax_color  = 255;
        s -> yax_left   = TRUE;
        s -> yax_right  = TRUE;
        s -> xgr_sw     = FALSE;
        s -> xgr_thick  = 1;
        s -> xgr_color  = 255;
        s -> xgr_space  = 64;
        s -> ygr_sw     = FALSE;
        s -> ygr_thick  = 1;
        s -> ygr_color  = 255;
        s -> ygr_space  = 64;
        s -> xt1_sw     = FALSE;
        s -> xt1_thick  = 1;
        s -> xt1_color  = 255;
        s -> xt1_bot    = TRUE;
        s -> xt1_top    = TRUE;
        s -> xt1_space  = 32;
        s -> xt1_len    = 10;
        s -> xt1_direc  = FALSE;
        s -> yt1_sw     = FALSE;
        s -> yt1_thick  = 1;
        s -> yt1_color  = 255;
        s -> yt1_left   = TRUE;
        s -> yt1_right  = TRUE;
        s -> yt1_space  = 32;
        s -> yt1_len    = 10;
        s -> yt1_direc  = FALSE;
        s -> xt2_sw     = FALSE;
        s -> xt2_thick  = 1;
        s -> xt2_color  = 255;
        s -> xt2_bot    = TRUE;
        s -> xt2_top    = TRUE;
        s -> xt2_space  = 8;
        s -> xt2_len    = 5;
        s -> xt2_direc  = FALSE;
        s -> yt2_sw     = FALSE;
        s -> yt2_thick  = 1;
        s -> yt2_color  = 255;
        s -> yt2_left   = TRUE;
        s -> yt2_right  = TRUE;
        s -> yt2_space  = 8;
        s -> yt2_len    = 5;
        s -> yt2_direc  = FALSE;
        return;
}
/* EOF */
/* cat > src+obj/null_grid.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* null_grid: null the grid structure			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	null_grid(s) struct s_grid *s;
{
        s -> sw         = FALSE;
        s -> xpix       = 100;
        s -> ypix       = 100;
        s -> color      = 255;
        return;
}
/* EOF */
/* cat > src+obj/null_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* null_image: null an image structure			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	null_image(s) struct s_image *s;
{
        s -> sw         = FALSE;
        strcpy(s -> fname,"");
        s -> xpos       = 0;
        s -> ypos       = 0;
        s -> xpts       = 0;
        s -> ypts       = 0;
        return;
}
/* EOF */
/* cat > src+obj/null_text.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* null_text: null a text structure			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	null_text(s) struct s_text *s;
{
        s -> sw         = FALSE;
        strcpy(s -> body,"");
        strcpy(s -> prefont, dprefont);
        strcpy(s -> postfont, dpostfont);
        s -> xpos       = 0;
        s -> ypos       = 0;
        s -> color      = 0;
        return;
}
/* EOF */
/* cat > src+obj/null_vector.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* null_vector: null a vector structure			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	null_vector(s) struct s_vector *s;
{
        s -> sw         = FALSE;
        strcpy(s -> xname,"");
        strcpy(s -> yname,"");
        s -> xpos       = 0;
        s -> ypos       = 0;
        s -> xpts       = 0;
        s -> ypts       = 0;
        s -> xstart     = 0;
        s -> xend       = 0;
        s -> xinterval  = 50;
        s -> ystart     = 0;
        s -> yend       = 0;
        s -> yinterval  = 50;
        s -> color      = 255;
        s -> maxlen     = 30;
        s -> xzero      = 128;
        s -> xscale     = 1.;
        s -> yscale     = 1.;
        s -> yzero      = 128;
        s -> xdis       = 0;
        s -> ydis       = 0;
        return;
}
/* EOF */
/* cat > src+obj/ok_colorbar.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* ok_colorbar: is the structure ok for the displayed	*/
/*		colorbar?				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	ok_colorbar(s) struct s_colorbar *s;
{
        if	(FALSE == my_isint(panel_get(pt[6],PANEL_VALUE,0)))
		{bad_data("X-points not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[6],PANEL_VALUE,0)) < 1)
		{bad_data("X-points < 1, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[7],PANEL_VALUE,0)))
		{bad_data("Y-points not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[7],PANEL_VALUE,0)) < 1)
		{bad_data("Y-points < 1, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[8],PANEL_VALUE,0)))
		{bad_data("X-origin not integer, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[9],PANEL_VALUE,0)))
		{bad_data("Y-origin not integer, request ignored.");
		 return(FALSE);
		}
	else
        	{s->xpts = atoi(panel_get(pt[6],PANEL_VALUE,0));
        	 s->ypts = atoi(panel_get(pt[7],PANEL_VALUE,0));
        	 s->xpos = atoi(panel_get(pt[8],PANEL_VALUE,0));
        	 s->ypos = atoi(panel_get(pt[9],PANEL_VALUE,0));
        	 return(TRUE);
		}
}
/* EOF */
/* cat > src+obj/ok_contour.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* ok_contour: is the structure ok for the displayed	*/
/*	       contour?					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int
ok_contour (s, n)
	struct s_contour *s;
	int n;
		/* input: sequence number of image in HDF file */
{
        register int             i;
	int xv, yv, *pxv, *pyv, nxv, nyv, filetype;
	char *xs, *ys;
	char tmpfn[MAXNAMELEN + 1];

        if	(FALSE == my_isint(panel_get(pt[30],PANEL_VALUE,0)))
		{bad_data("X-points not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[30],PANEL_VALUE,0)) < 0)
		{bad_data("X-points < 0, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[31],PANEL_VALUE,0)))
		{bad_data("Y-points not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[31],PANEL_VALUE,0)) < 0)
		{bad_data("Y-points < 0, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[32],PANEL_VALUE,0)))
		{bad_data("X-origin not integer, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[33],PANEL_VALUE,0)))
		{bad_data("Y-origin not integer, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[34],PANEL_VALUE,0)))
		{bad_data("Color not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[34],PANEL_VALUE,0)) < 0 ||
		 atoi(panel_get(pt[34],PANEL_VALUE,0)) > 255)
		{bad_data("Color < 0 or > 255, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[35],PANEL_VALUE,0)))
		{bad_data("Start color not integer, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[36],PANEL_VALUE,0)))
		{bad_data("End color not integer, request ignored.");
		 return(FALSE);
		}
	else if	(FALSE == my_isint(panel_get(pt[37],PANEL_VALUE,0)))
		{bad_data("Interval not integer, request ignored.");
		 return(FALSE);
		}
	else
	{
		pxv = (xstrlen ((xs = panel_get (pt[30], PANEL_VALUE, 0))) == 0) ? NULL : &xv;
		if (pxv != NULL)
			xv = atoi (xs);
		pyv = (xstrlen ((ys = panel_get (pt[31], PANEL_VALUE, 0))) == 0) ? NULL : &yv;
		if (pyv != NULL)
			yv = atoi (ys);
		strcpy (tmpfn, panel_get (pt[29], PANEL_VALUE, 0));
		if (xstrlen (tmpfn) == 0) /* no file */
		{
			bad_data ("No contour image file given, request ignored.");
			return (FALSE);
		}
		else
		{
			(void) strip_wspace (tmpfn);
			i = check_image (tmpfn, pxv, pyv, &nxv, &nyv, n, &filetype);
		}
		if (i == 1)
		{
			bad_data ("Cannot open contour image file, request ignored.");
                 	return (FALSE);
                }
		else if	(i == 2)
		{
			if (pxv == NULL && pyv != NULL)
			{
				bad_data ("No X points given - not HDF file, request ignored.");
				return (FALSE);
			}
			else if (pxv != NULL && pyv == NULL)
			{
				bad_data ("No Y points given - not HDF file, request ignored.");
				return (FALSE);
			}
			else if (xv == 0)
			{
				bad_data ("X-points < 1, request ignored.");
				return (FALSE);
			}
			else if (yv == 0)
			{
				bad_data ("Y-points < 1, request ignored.");
				return (FALSE);
			}
			else
			{
				bad_data ("X-pts*Y-pts != contour image filesize, request ignored.");
                 		return (FALSE);
                	}
		}
		else if (i == 3)
		{
			bad_data ("Not enough images in HDF file for contour image, request ignored");
			return (FALSE);
		}
		else if (i < 0)		/* HDF error */
		{
			sprintf (msg, "HDF file error (DFerror = %d) for contour image, request ignored.", i);
			bad_data (msg);
			return (FALSE);
		}
		if (i == 4)
		{
/*
			info_msg ("          ----- INFORMATION MESSAGE -----",
				  "HDF file contour image dimensions used",
				  "          ----- INFORMATION MESSAGE -----");
*/
			sprintf (msg, "%d", nxv);  
			panel_set_value (pt[30], msg);
			sprintf (msg, "%d", nyv);
			panel_set_value (pt[31], msg);
			xv = nxv;
			yv = nyv;
			i = 0;
		}
		if (i == 0)
		{
			strcpy(s->fname, tmpfn);
			panel_set (pt[29], PANEL_VALUE, tmpfn, 0);
			s->xpts = xv;
			s->ypts = yv;
			s->xpos = atoi(panel_get(pt[32],PANEL_VALUE,0));
			s->ypos = atoi(panel_get(pt[33],PANEL_VALUE,0));
			s->color = atoi(panel_get(pt[34],PANEL_VALUE,0));
			s->first = atoi(panel_get(pt[35],PANEL_VALUE,0));
			s->last = atoi(panel_get(pt[36],PANEL_VALUE,0));
			s->interval = atoi(panel_get(pt[37],PANEL_VALUE,0));
			return (TRUE);
		}
		else
		{
			bad_data("This ok_contour error is not possible.");
			return(FALSE);
		}
	}
}
/* EOF */
/* cat > src+obj/ok_grid.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* ok_grid: is the structure ok for the displayed grid?	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	ok_grid(s) struct s_grid *s;
{
        if	(FALSE == my_isint(panel_get(pt[2],PANEL_VALUE,0)))
		{bad_data("Color not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[2],PANEL_VALUE,0)) < 0 ||
		 atoi(panel_get(pt[2],PANEL_VALUE,0)) > 255)
		{bad_data("Color < 0 or > 255, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[3],PANEL_VALUE,0)))
		{bad_data("Pix/x-grid not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[3],PANEL_VALUE,0)) < 1)
		{bad_data("Pix/x-grid < 1, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[4],PANEL_VALUE,0)))
		{bad_data("Pix/y-grid not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[4],PANEL_VALUE,0)) < 1)
		{bad_data("Pix/y-grid < 1, request ignored.");
		 return(FALSE);
		}
	else
        	{s->color = atoi(panel_get(pt[2],PANEL_VALUE,0));
        	 s->xpix = atoi(panel_get(pt[3],PANEL_VALUE,0));
        	 s->ypix = atoi(panel_get(pt[4],PANEL_VALUE,0));
        	 return(TRUE);
		}
}
/* EOF */
/* cat > src+obj/ok_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* ok_image: is the structure ok for the displayed	*/
/*	     image?					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int
ok_image (s, n)
	struct s_image *s;
	int n;
		/* input: sequence number of image in HDF file. */
{
	register int	i;
	int xv, yv, *pxv, *pyv, nxv, nyv, filetype;
	char *xs, *ys;
	char tmpfn[MAXNAMELEN + 1];

        if	(FALSE == my_isint(panel_get(pt[23],PANEL_VALUE,0)))
		{bad_data("X-points not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[23],PANEL_VALUE,0)) < 0) 
		{bad_data("X-points < 0, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[24],PANEL_VALUE,0)))
		{bad_data("Y-points not integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[24],PANEL_VALUE,0)) < 0)
		{bad_data("Y-points < 0, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[25],PANEL_VALUE,0)))
		{bad_data("X-origin not integer, request ignored.");
		return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[26],PANEL_VALUE,0)))
		{bad_data("Y-origin not integer, request ignored.");
		 return(FALSE);
		}
	else
	{
		pxv = (xstrlen ((xs = panel_get (pt[23], PANEL_VALUE, 0))) == 0) ? NULL : &xv;
		if (pxv != NULL)
			xv = atoi (xs);
		pyv = (xstrlen ((ys = panel_get (pt[24], PANEL_VALUE, 0))) == 0) ? NULL : &yv;
		if (pyv != NULL)
			yv = atoi (ys);
		strcpy (tmpfn, panel_get (pt[27], PANEL_VALUE, 0));
		if (xstrlen (tmpfn) == 0) /* no file */
		{
			bad_data ("No image file given, request ignored.");
			return (FALSE);
		}
		else
		{
			(void) strip_wspace (tmpfn);
			i = check_image (tmpfn, pxv, pyv, &nxv, &nyv, n, &filetype);
		}
		if (i == 1)
		{
			bad_data ("Cannot open image file, request ignored.");
                 	return (FALSE);
                }
		else if	(i == 2)
		{
			if (pxv == NULL && pyv != NULL)
			{
				bad_data ("No X points given - not HDF file, request ignored.");
				return (FALSE);
			}
			else if (pxv != NULL && pyv == NULL)
			{
				bad_data ("No Y points given - not HDF file, request ignored.");
				return (FALSE);
			}
			else if (xv == 0)
			{
				bad_data ("X-points < 1, request ignored.");
				return (FALSE);
			}
			else if (yv == 0)
			{
				bad_data ("Y-points < 1, request ignored.");
				return (FALSE);
			}
			else
			{
				bad_data ("X-pts*Y-pts != image filesize, request ignored.");
                 		return (FALSE);
                	}
		}
		else if (i == 3)
		{
			bad_data ("Not enough images in HDF file, request ignored");
			return (FALSE);
		}
		else if (i < 0)		/* HDF error */
		{
			sprintf (msg, "HDF file error (DFerror = %d) for image, request ignored.", i);
			bad_data (msg);
			return (FALSE);
		}
		if (i == 4)
		{
/*
			info_msg ("          ----- INFORMATION MESSAGE -----",
				  "HDF file image dimensions used",
				  "          ----- INFORMATION MESSAGE -----");
*/
			sprintf (msg, "%d", nxv);  
			panel_set_value (pt[23], msg);
			sprintf (msg, "%d", nyv);
			panel_set_value (pt[24], msg);
			xv = nxv;
			yv = nyv;
			i = 0;
		}
		if (i == 0)
		{
			s->xpts = xv;
			s->ypts = yv;
			s->xpos = atoi(panel_get(pt[25],PANEL_VALUE,0));
			s->ypos = atoi(panel_get(pt[26],PANEL_VALUE,0));
			strcpy(s->fname, tmpfn);
			panel_set (pt[27], PANEL_VALUE, tmpfn, 0);
			return (TRUE);
		}
		else
		{
			bad_data("This ok_image error is not possible.");
			return(FALSE);
		}
	}
}
/* EOF */
/* cat > src+obj/ok_text.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* ok_text: is the structure ok for the displayed text?	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	ok_text(s) struct s_text *s;
{
        struct pixfont          *f;

        if	(FALSE == my_isint(panel_get(pt[11],PANEL_VALUE,0)))
		{bad_data("Color is not an integer, request ignored.");
		 return(FALSE);
		}
        else if	(atoi(panel_get(pt[11],PANEL_VALUE,0)) < 0 ||
		 atoi(panel_get(pt[11],PANEL_VALUE,0)) > 255)
		{bad_data("Color < 0 or > 255, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[12],PANEL_VALUE,0)))
		{bad_data("X-origin not integer, request ignored.");
		 return(FALSE);
		}
        else if	(FALSE == my_isint(panel_get(pt[13],PANEL_VALUE,0)))
		{bad_data("Y-origin not integer, request ignored.");
		 return(FALSE);
		}
	else;
        strcpy(txt,panel_get(pt[15],PANEL_VALUE,0));
        strcat(txt,"/");
        strcat(txt,panel_get(pt[16],PANEL_VALUE,0));
        if	(NULL == (f = pf_open(txt)))
		{bad_data("Cannot open the font file, request ignored.");
		 return(FALSE);
		}
	else
		{pf_close(f);
		 s->color = atoi(panel_get(pt[11],PANEL_VALUE,0));
		 s->xpos = atoi(panel_get(pt[12],PANEL_VALUE,0));
		 s->ypos = atoi(panel_get(pt[13],PANEL_VALUE,0));
		 strcpy(s->body,panel_get(pt[14],PANEL_VALUE,0));
		 strcpy(s->prefont,panel_get(pt[15],PANEL_VALUE,0));
		 strcpy(s->postfont,panel_get(pt[16],PANEL_VALUE,0));
		 return(TRUE);
		}
}
/* EOF */
/* cat > src+obj/ok_vector.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* ok_vector: is the structure ok for the displayed	*/
/*	      vector?					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int
ok_vector (s, n)
	struct s_vector *s;
	int             n;
		/* input: sequence number of x-image in HDF file.
			  y-image follows x-image if same HDF file
			  or sequence number if different HDF file */
{
	int             i;
	int             xv, yv, *pxv, *pyv, nxv, nyv, filetype;
	char           *xs, *ys;
	char           *fxs, *fys;
	char            tmpfnx[MAXNAMELEN + 1];
	char            tmpfny[MAXNAMELEN + 1];

	if (FALSE == my_isint (panel_get (pt[41], PANEL_VALUE, 0)))
	{
		bad_data ("X-points not integer, request ignored.");
		return (FALSE);
	}
	else if (atoi (panel_get (pt[41], PANEL_VALUE, 0)) < 0)
	{
		bad_data ("X-points < 0,request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[42], PANEL_VALUE, 0)))
	{
		bad_data ("Y-points not integer, request ignored.");
		return (FALSE);
	}
	else if (atoi (panel_get (pt[42], PANEL_VALUE, 0)) < 0)
	{
		bad_data ("Y-points < 0,request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[43], PANEL_VALUE, 0)))
	{
		bad_data ("X-origin not integer, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[44], PANEL_VALUE, 0)))
	{
		bad_data ("Y-origin not integer, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[55], PANEL_VALUE, 0)))
	{
		bad_data ("Max vector length not integer, request ignored.");
		return (FALSE);
	}
	else if (atoi (panel_get (pt[55], PANEL_VALUE, 0)) < 0)
	{
		bad_data ("Max vector length < 0, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[54], PANEL_VALUE, 0)))
	{
		bad_data ("Vector color not integer, request ignored.");
		return (FALSE);
	}
	else if (atoi (panel_get (pt[54], PANEL_VALUE, 0)) < 0 ||
		 atoi (panel_get (pt[54], PANEL_VALUE, 0)) > 255)
	{
		bad_data ("Vector color not >=0 and <= 255, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[48], PANEL_VALUE, 0)))
	{
		bad_data ("X-start not integer, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[49], PANEL_VALUE, 0)))
	{
		bad_data ("Y-start not integer, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[50], PANEL_VALUE, 0)))
	{
		bad_data ("X-end not integer, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[51], PANEL_VALUE, 0)))
	{
		bad_data ("Y-end not integer, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[52], PANEL_VALUE, 0)))
	{
		bad_data ("X-interval not integer, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[53], PANEL_VALUE, 0)))
	{
		bad_data ("Y-interval not integer, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[45], PANEL_VALUE, 0)))
	{
		bad_data ("X-color=0 not integer, request ignored.");
		return (FALSE);
	}
	else if (atoi (panel_get (pt[45], PANEL_VALUE, 0)) < 0 ||
		 atoi (panel_get (pt[45], PANEL_VALUE, 0)) > 255)
	{
		bad_data ("X-color=0 not >= 0 and <= 255, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isint (panel_get (pt[46], PANEL_VALUE, 0)))
	{
		bad_data ("Y-color=0 not integer, request ignored.");
		return (FALSE);
	}
	else if (atoi (panel_get (pt[46], PANEL_VALUE, 0)) < 0 ||
		 atoi (panel_get (pt[46], PANEL_VALUE, 0)) > 255)
	{
		bad_data ("Y-color=0 not >= 0 and <= 255, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isfloat (panel_get (pt[47], PANEL_VALUE, 0)))
	{
		bad_data ("X-scale is not floating point, request ignored.");
		return (FALSE);
	}
	else if (FALSE == my_isfloat (panel_get (pt[56], PANEL_VALUE, 0)))
	{
		bad_data ("Y-scale is not floating point, request ignored.");
		return (FALSE);
	}
	else
	{
		pxv = (xstrlen ((xs = panel_get (pt[41], PANEL_VALUE, 0))) == 0) ? NULL : &xv;
		if (pxv != NULL)
			xv = atoi (xs);
		pyv = (xstrlen ((ys = panel_get (pt[42], PANEL_VALUE, 0))) == 0) ? NULL : &yv;
		if (pyv != NULL)
			yv = atoi (ys);
		strcpy (tmpfnx, panel_get (pt[39], PANEL_VALUE, 0));
		if (xstrlen (tmpfnx) == 0)	/* no file */
		{
			bad_data ("No vector x-image file given, request ignored.");
			return (FALSE);
		}
		else
		{
			(void) strip_wspace (tmpfnx);
			i = check_image (tmpfnx, pxv, pyv, &nxv, &nyv, n, &filetype);
		}
		if (i == 1)
		{
			bad_data ("Cannot open vector x-image file, request ignored.");
			return (FALSE);
		}
		else if (i == 2)
		{
			if (pxv == NULL && pyv != NULL)
			{
				bad_data ("No X points given - not HDF file, request ignored.");
				return (FALSE);
			}
			else if (pxv != NULL && pyv == NULL)
			{
				bad_data ("No Y points given - not HDF file, request ignored.");
				return (FALSE);
			}
			else if (xv == 0)
			{
				bad_data ("X-points < 1, request ignored.");
				return (FALSE);
			}
			else if (yv == 0)
			{
				bad_data ("Y-points < 1, request ignored.");
				return (FALSE);
			}
			else
			{
				bad_data ("X-pts*Y-pts != vector x-image filesize, request ignored.");
				return (FALSE);
			}
		}
		else if (i == 3)
		{
			bad_data ("Not enough images in HDF file for vector x-image, request ignored");
			return (FALSE);
		}
		else if (i < 0)	/* HDF error */
		{
			sprintf (msg, "HDF file error (DFerror = %d) for vector x-image, request ignored.", i);
			bad_data (msg);
			return (FALSE);
		}
		if (i == 4)
		{
/*
			info_msg ("          ----- INFORMATION MESSAGE -----",
				  "HDF file vector x-image dimensions used",
				  "          ----- INFORMATION MESSAGE -----");
*/
			sprintf (msg, "%d", nxv);
			panel_set_value (pt[41], msg);
			sprintf (msg, "%d", nyv);
			panel_set_value (pt[42], msg);
			xv = nxv;
			yv = nyv;
			i = 0;
		}
/*
		pxv = (xstrlen((xs = panel_get (pt[41], PANEL_VALUE, 0))) == 0) ? NULL : &xv;
		if (pxv != NULL)
			xv = atoi (xs);
*/
		xv = atoi (panel_get (pt[41], PANEL_VALUE, 0));
/*
		pyv = (xstrlen((ys = panel_get (pt[42], PANEL_VALUE, 0))) == 0) ? NULL : &yv;
		if (pyv != NULL)
			yv = atoi (ys);
*/
		yv = atoi (panel_get (pt[42], PANEL_VALUE, 0));
		strcpy (tmpfny, panel_get (pt[40], PANEL_VALUE, 0));
		if (xstrlen (tmpfny) == 0)	/* no y-image filename give */
		{
			if (filetype == 0)	/* not HDF file */
			{
				bad_data ("No vector y-image file given (vector x-image not HDF file), request ignored.");
				return (FALSE);
			}
			else	/* HDF file */
				i = check_image (tmpfnx, &xv, &yv, &nxv, &nyv, n + 1, &filetype);
		}
		else
		{
			(void) strip_wspace (tmpfny);
			i = check_image (tmpfny, &xv, &yv, &nxv, &nyv, (!xstrcmp (tmpfnx, tmpfny)) ? n + 1 : n, &filetype);
		}
		if (i == 1)
		{
			bad_data ("Cannot open vector y-image file, request ignored.");
			return (FALSE);
		}
		else if (i == 2)
		{
			bad_data ("X-pts*Y-pts != vector y-image filesize, request ignored.");
			return (FALSE);
		}
		else if (i == 3)
		{
			bad_data ("Not enough images in HDF file for vector y-image, request ignored");
			return (FALSE);
		}
		else if (i < 0)	/* HDF error */
		{
			sprintf (msg, "HDF file error (DFerror = %d) for vector y-image, request ignored.", i);
			bad_data (msg);
			return (FALSE);
		}
		if (i == 4)
		{
			sprintf (msg, "x-image(x=%d,y=%d), y-image(x=%d,y=%d)", xv, yv, nxv, nyv);
			bad_data2 ("Vector x-image different size than vector y-image, request ignored.", msg);
			return (FALSE);
		}
		if (i == 0)
		{
			float           f;

			panel_set (pt[39], PANEL_VALUE, tmpfnx, 0);
			strcpy (s->xname, tmpfnx);
			if (xstrlen (tmpfny) == 0)
			{
				panel_set (pt[40], PANEL_VALUE, tmpfnx, 0);
				strcpy (s->yname, tmpfnx);
			}
			else
			{
				panel_set (pt[40], PANEL_VALUE, tmpfny, 0);
				strcpy (s->yname, tmpfny);
			}
			s->xpts = xv;
			s->ypts = yv;
			s->xpos = atoi (panel_get (pt[43], PANEL_VALUE, 0));
			s->ypos = atoi (panel_get (pt[44], PANEL_VALUE, 0));
			s->maxlen = atoi (panel_get (pt[55], PANEL_VALUE, 0));
			s->color = atoi (panel_get (pt[54], PANEL_VALUE, 0));
			s->xend = atoi (panel_get (pt[50], PANEL_VALUE, 0));
			s->xstart = atoi (panel_get (pt[48], PANEL_VALUE, 0));
			s->ystart = atoi (panel_get (pt[49], PANEL_VALUE, 0));
			s->yend = atoi (panel_get (pt[51], PANEL_VALUE, 0));
			s->xinterval = atoi (panel_get (pt[52], PANEL_VALUE, 0));
			s->yinterval = atoi (panel_get (pt[53], PANEL_VALUE, 0));
			s->xzero = atoi (panel_get (pt[45], PANEL_VALUE, 0));
			s->yzero = atoi (panel_get (pt[46], PANEL_VALUE, 0));
			sscanf (panel_get (pt[47], PANEL_VALUE, 0), "%f", &f);
			s->xscale = f;
			sscanf (panel_get (pt[56], PANEL_VALUE, 0), "%f", &f);
			s->yscale = f;
			return (TRUE);
		}
		else
		{
			bad_data ("This ok_vector error is not possible.");
			return (FALSE);
		}
	}
}
/* EOF */
/* cat > src+obj/p0.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p0: p0 button - show the canvas			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p0()
{
        window_set(	c_frame,WIN_SHOW,TRUE,0);
        window_set(	canvas,WIN_SHOW,TRUE,0);
        pw_rop(		cpw,0,0,
                        window_get(canvas,WIN_WIDTH,0),
                        window_get(canvas,WIN_HEIGHT,0),
                        PIX_SRC | ((clear_color) << 5),NULL,0,0);
        panel_set(      pb[0],PANEL_SHOW_ITEM,FALSE,0);
	info_msg("","Canvas brought up.","");
	return;
}
/* EOF */
/* cat > src+obj/p1.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p1: p1 button - execute FinalPic			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p1()
{
	int		z = 0;
        register int    i;
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	    return;
	  }
        pw_rop(cpw,0,0,N_hpix,N_vpix,
               PIX_SRC | ((clear_color) << 5),NULL,0,0);
        for (i=0; i<N_image; i++)
            if  (TRUE == image[i].sw)
		{draw_image(&image[i], 1);
		 if (0 != draw_feature(&feat[i],i,TRUE)) z = 1;
		}
        for (i=0; i<N_contour; i++)
            if  (TRUE == con[i].sw)
		{draw_contour(&con[i], 1);
		 if (0 != draw_feature(&feat[i + N_image],
						 i + N_image,TRUE)) z = 2;
		}
        for (i=0; i<N_vector; i++)
            if  (TRUE == vec[i].sw)
		{draw_vector(FALSE,&vec[i], 1);
		 if (0 != draw_feature(&feat[i + N_image + N_contour],
						 i + N_image + N_contour,TRUE)) z = 3;
		}
        if      (TRUE == cbar.sw)       draw_colorbar(  &cbar);
        for (i=0; i<N_text; i++)
            if  (TRUE == text[i].sw)    draw_text(      &text[i]);
        if      (TRUE == grid.sw)       draw_grid(      &grid);
	if (z == 0)
	   info_msg("","FinalPic completed.","");
	else
	   bad_data("Problem in FinalPic execution.");
        return;
}
/* EOF */
/* cat > src+obj/p2.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p2: p2 button - execute Clear			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p2()
{
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	    return;
	  }
        pw_rop(cpw,0,0,N_hpix,N_vpix,
                   PIX_SRC | ((clear_color) << 5),NULL,0,0);
	info_msg("","Canvas cleared.","");
        return;
}
/* EOF */
/* cat > src+obj/p3.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p3: p3 button - create palette frame			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p3()
{
        char		s[8];
	register int	y;

        panel_set(              pb[3],PANEL_SHOW_ITEM,FALSE,0);
	y = (int)window_get(fr[0],WIN_Y,0);
	if (y > N_yscr - (int)window_get(fr[0],WIN_HEIGHT,0) - 75)
	   y = 0;
	else
	   y = (int)window_get(fr[0],WIN_HEIGHT,0);
        make_fr( 1,
		 10,y,
		 75,600,
		"CompositeTool 1.1 Palette (tag 'p')"
	       );
	pa[1] = make_p (fr[1]);
/*
        pa[1] = window_create(  fr[1],PANEL,0);
*/
	window_set(pa[1],WIN_IGNORE_PICK_EVENT,MS_MIDDLE,0);
	window_set(pa[1],WIN_IGNORE_PICK_EVENT,MS_RIGHT,0);
        make_pb(	13,10, 5,1,7,"Done");
        make_pb(        14,90, 5,1,2," ");
        make_pt(        0,120,10,1,79,43,"Load palette:");
        make_pb(        15,90,27,1,2," ");
        make_pt(        1,120,32,1, 3,3,"Load background color:");
        panel_set(		pt[0],PANEL_VALUE,pfn,0);
        if (clear_color == 0)
	   panel_set(		pt[1],PANEL_VALUE,"",0);
        else
	   {my_itoa(clear_color,s);
	    panel_set(		pt[1],PANEL_VALUE,s,0);
	   }
        window_set(		fr[1],WIN_SHOW,TRUE,0);
	info_msg("","Palette frame brought up.","");
        return;
}
/* EOF */
/* cat > src+obj/p4.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p4: p4 button - create grid frame			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p4()
{
	register int	y;

        panel_set(      pb[4],PANEL_SHOW_ITEM,FALSE,0);
	y = (int)window_get(fr[0],WIN_Y,0);
	if (y > N_yscr - (int)window_get(fr[0],WIN_HEIGHT,0) - 150)
	   y = 0;
	else
	   y = (int)window_get(fr[0],WIN_HEIGHT,0);
        make_fr( 2,
		 20,y,
		 150,375,
		"CompositeTool 1.1 Grid (tag 'g')"
	       );
	pa[2] = make_p (fr[2]);
/*
        pa[2] = window_create(  fr[2],PANEL,
				WIN_FONT, font_panel, 0);
*/
	window_set(pa[2],WIN_IGNORE_PICK_EVENT,MS_MIDDLE,0);
	window_set(pa[2],WIN_IGNORE_PICK_EVENT,MS_RIGHT,0);
        make_pb(	16, 10, 5,2,7,"Done");
	if (0 == grid.sw)
	   make_pb(        17, 10,52,2,21,"FinalPic toggle (OFF)");
	else
	   make_pb(        17, 10,52,2,21,"FinalPic toggle (ON) ");
        make_pb(        18, 10,77,2,24," STORE  displayed values");
        make_pb(        19, 10,99,2,24,"DISCARD displayed values");
        make_pb(        20,220,77,2,8," DRAW it");
        make_pb(        21,220,99,2,8,"ERASE it");
        make_pt(         2,220,10,2,3,3,"     Color:");
        make_pt(         3,220,32,2,4,4,"Pix/x-grid:");
        make_pt(         4,220,54,2,4,4,"Pix/y-grid:");
        p19();
        window_set(     fr[2],WIN_SHOW,TRUE,0);
        return;  
}
/* EOF */
/* cat > src+obj/p5.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p5: p5 button - create colorbar frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p5()
{
	register int	y;

        panel_set(      pb[5],PANEL_SHOW_ITEM,FALSE,0);
	y = (int)window_get(fr[0],WIN_Y,0);
	if (y > N_yscr - (int)window_get(fr[0],WIN_HEIGHT,0) - 192)
	   y = 0;
	else
	   y = (int)window_get(fr[0],WIN_HEIGHT,0);
        make_fr( 3,
		 30,y,
		 /* 192,395, */
		 192, 415,
		"CompositeTool 1.1 ColorBar (tag 'b')"
	       );
	pa[3] = make_p (fr[3]);
/*
        pa[3] = window_create(	fr[3],PANEL,0);
*/
	window_set(pa[3],WIN_IGNORE_PICK_EVENT,MS_MIDDLE,0);
	window_set(pa[3],WIN_IGNORE_PICK_EVENT,MS_RIGHT,0);
        make_pb(	22, 10,  5,3,7,"Done");
	if (0 == cbar.sw)
        	make_pb(23, 10, 52,3,21,"FinalPic toggle (OFF)");
	else
        	make_pb(23, 10, 52,3,21,"FinalPic toggle (ON) ");
        make_pb(        24, 10, 74,3,24," STORE  displayed values");
        make_pb(        25, 10, 96,3,24,"DISCARD displayed values");
        make_pb(        26, 10,118,3, 8," DRAW it");
        make_pb(        27, 10,140,3, 8,"ERASE it");
	make_pb(	28,100,118,3, 8,"ms draw");
	panel_set(	pb[28],PANEL_SHOW_ITEM,FALSE,0);
	make_pb(	84,100,129,3, 9,"mouse mv");
        make_pb(        29, 90, 16,3, 2," ");
        make_pt(        5,120, 21,3,3,3,"Show color:");
        make_pt(        6,250, 54,3,4,4,"X-points:");
        make_pt(        7,250, 76,3,4,4,"Y-points:");
        make_pt(        8,250, 98,3,4,4,"X-origin:");
        make_pt(        9,250,120,3,4,4,"Y-origin:");
        p25();
        window_set(     fr[3],WIN_SHOW,TRUE,0);
        return;
}
/* EOF */
/* cat > src+obj/p6.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p6: p6 button - create text frame			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p6()
{
	register int	y;

        panel_set(      pb[6],PANEL_SHOW_ITEM,FALSE,0);
	y = (int)window_get(fr[0],WIN_Y,0);
	if (y > N_yscr - (int)window_get(fr[0],WIN_HEIGHT,0) - 250)
	   y = 0;
	else
	   y = (int)window_get(fr[0],WIN_HEIGHT,0);
        make_fr( 4,
		 40,y,
		 250,460,
		"CompositeTool 1.1 Text (tag 't0')"
	       );
	pa[4] = make_p (fr[4]);
/*
        pa[4] = window_create(  fr[4],PANEL,0);
*/
	window_set(pa[4],WIN_IGNORE_PICK_EVENT,MS_MIDDLE,0);
	window_set(pa[4],WIN_IGNORE_PICK_EVENT,MS_RIGHT,0);
        make_pb(        30, 10,  5,4,7,"Done");
	if (0 == text[0].sw)
           make_pb(	31, 10, 52,4,21,"FinalPic toggle (OFF)");
	else
           make_pb(     31, 10, 52,4,21,"FinalPic toggle (ON) ");
        make_pb(        32, 10, 74,4,24," STORE  displayed values");
        make_pb(        33, 10, 96,4,24,"DISCARD displayed values");
        make_pmnn(          90, 10,4,"Tag Selector");
        make_pb(        36, 90, 27,4,2," ");
        make_pt(        10,120, 32,4,3,3,"Copy data from text tag:");
        make_pb(        37,190,  5,4,2,"-5");
        make_pb(        38,224,  5,4,1,"-");
        make_pb(        39,248,  5,4,1,"+");
        make_pb(        40,270,  5,4,2,"+5");
        make_pt(        11,228, 52,4, 3,3,"   Color:");
        make_pt(        12,228, 74,4, 4,4,"X-origin:");
        make_pt(        13,228, 96,4, 4,4,"Y-origin:");
	make_pt(        14, 10,162,4,79,40,"Text Body:");
        make_pt(        15, 10,184,4,59,30,"Font directory:");
        make_pt(        16, 10,206,4,19,19,"Font:");
        make_pb(        34, 10,118,4, 8," DRAW it");
        make_pb(        35, 10,140,4, 8,"ERASE it");
        make_pb(        82,100,118,4, 8,"ms draw");
	panel_set(	pb[82],PANEL_SHOW_ITEM,FALSE,0);
        make_pb(        83,100,129,4, 9,"mouse mv");
        nt      = 0;
        window_set(             fr[4],WIN_SHOW,TRUE,0);
        p33();
	return;
}
/* EOF */
/* cat > src+obj/p7.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p7: p7 button - create image frame			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p7()
{
	register int	y;

        panel_set(      pb[7],PANEL_SHOW_ITEM,FALSE,0);
	y = (int)window_get(fr[0],WIN_Y,0);
	if (y > N_yscr - (int)window_get(fr[0],WIN_HEIGHT,0) - 210)
	   y = 0;
	else
	   y = (int)window_get(fr[0],WIN_HEIGHT,0);
        make_fr( 6,
		 70,y,
		 210,425,
		"CompositeTool 1.1 Image (tag 'i0')"
	       );
	pa[6] = make_p (fr[6]);
/*
        pa[6] = window_create(  fr[6],PANEL,0);
*/
	window_set(pa[6],WIN_IGNORE_PICK_EVENT,MS_MIDDLE,0);
	window_set(pa[6],WIN_IGNORE_PICK_EVENT,MS_RIGHT,0);
        make_pb(        46, 10,  5,6,7,"Done");
	if (0 == image[0].sw)
           make_pb(	47, 10, 52,6,21,"FinalPic toggle (OFF)");
	else
           make_pb(     47, 10, 52,6,21,"FinalPic toggle (ON) ");
        make_pb(        48, 10, 74,6,24," STORE  displayed values");
        make_pb(        49, 10, 96,6,24,"DISCARD displayed values");
        make_pmnn(          90, 10,6,"Tag Selector");
        make_pb(        53, 90, 27,6,2," ");
        make_pt(        22,120, 32,6,3,3,"Copy data from image tag:");
        make_pb(        54,190,  5,6,2,"-5");
        make_pb(        55,224,  5,6,1,"-");
        make_pb(        56,248,  5,6,1,"+");
        make_pb(        57,270,  5,6,2,"+5");
	make_pt(        27, 10,162,6,79,43,"File:");
        make_pb(        50, 10,118,6,8," DRAW it");
        make_pb(        51, 10,140,6,8,"ERASE it");
        make_pb(        52,105,118,6,8,"ms draw");
	panel_set(	pb[52],PANEL_SHOW_ITEM,FALSE,0);
        make_pb(        85,105,129,6,9,"mouse mv");
        make_pt(        23,228, 52,6,4,4,"X-points:");
        make_pt(        24,228, 74,6,4,4,"Y-points:");
        make_pt(        25,228, 96,6,4,4,"X-origin:");
        make_pt(        26,228,118,6,4,4,"Y-origin:");
        ni      = 0;
        window_set(     fr[6],WIN_SHOW,TRUE,0);
        p49();
	return;
}
/* EOF */
/* cat > src+obj/p8.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p8: p8 button - create contour frame			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p8()
{
	register int	y;

        panel_set(      pb[8],PANEL_SHOW_ITEM,FALSE,0);
	y = (int)window_get(fr[0],WIN_Y,0);
	if (y > N_yscr - (int)window_get(fr[0],WIN_HEIGHT,0) - 210)
	   y = 0;
	else
	   y = (int)window_get(fr[0],WIN_HEIGHT,0);
        make_fr( 7,
		110,y,
		 210,550,
		"CompositeTool 1.1 Contour (tag 'c0')"
	       );
	pa[7] = make_p (fr[7]);
/*
        pa[7] = window_create(  fr[7],PANEL,0);
*/
	window_set(pa[7],WIN_IGNORE_PICK_EVENT,MS_MIDDLE,0);
	window_set(pa[7],WIN_IGNORE_PICK_EVENT,MS_RIGHT,0);
        make_pb(        58, 10,  5,7,7,"Done");
	if (0 == con[0].sw)
           make_pb(	59, 10, 52,7,21,"FinalPic toggle (OFF)");
	else
           make_pb(     59, 10, 52,7,21,"FinalPic toggle (ON) ");
        make_pb(        60, 10, 74,7,24," STORE  displayed values");
        make_pb(        61, 10, 96,7,24,"DISCARD displayed values");
        make_pmnn(          90, 10,7,"Tag Selector");
        make_pb(        65, 90, 27,7,2," ");
        make_pt(        28,120, 32,7,3,3,"Copy data from contour tag:");
        make_pb(        66,190,  5,7,2,"-5");
        make_pb(        67,224,  5,7,1,"-");
        make_pb(        68,248,  5,7,1,"+");
        make_pb(        69,270,  5,7,2,"+5");
	make_pt(        29, 10,162,7,79,50,"File:");
        make_pb(        62, 10,118,7,8," DRAW it");
        make_pb(        63, 10,140,7,8,"ERASE it");
        make_pb(        64,100,118,7,8,"ms draw");
	panel_set(	pb[64],PANEL_SHOW_ITEM,FALSE,0);
        make_pb(        86,100,129,7,9,"mouse mv");
        make_pt(        30,228, 52,7,4,4,"X-points:");
        make_pt(        31,228, 74,7,4,4,"Y-points:");
        make_pt(        32,228, 96,7,4,4,"X-origin:");
        make_pt(        33,228,118,7,4,4,"Y-origin:");
        make_pt(        34,228,140,7,3,3,"   Color:");
        make_pmnn(         390, 32,7,"Contour levels");
        make_pt(        35,390, 54,7,4,4,"Start color:");
        make_pt(        36,390, 76,7,4,4,"  End color:");
        make_pt(        37,390, 98,7,4,4,"   Interval:");
        nc      = 0;
        window_set(	fr[7],WIN_SHOW,TRUE,0);
        p61();
	return;
}
/* EOF */
/* cat > src+obj/p9.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p9: p9 button - create vector frame			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p9()
{
	register int	y;

        panel_set(      pb[9],PANEL_SHOW_ITEM,FALSE,0);
	y = (int)window_get(fr[0],WIN_Y,0);
	if (y > N_yscr - (int)window_get(fr[0],WIN_HEIGHT,0) - 230)
	   y = 0;
	else
	   y = (int)window_get(fr[0],WIN_HEIGHT,0);
        make_fr( 8,
		 90,y,
		 /* 230,750, */
		 240, 750,
		"CompositeTool 1.1 Vector (tag 'v0')"
	       );

	pa[8] = make_p (fr[8]);
/*
        pa[8] = window_create(  fr[8],PANEL,0);
*/
	window_set(pa[8],WIN_IGNORE_PICK_EVENT,MS_MIDDLE,0);
	window_set(pa[8],WIN_IGNORE_PICK_EVENT,MS_RIGHT,0);
        make_pb(        70, 10,  5,8,7,"Done");
	if (0 == vec[0].sw)
           make_pb(	71, 10, 52,8,21,"FinalPic toggle (OFF)");
	else
           make_pb(     71, 10, 52,8,21,"FinalPic toggle (ON) ");
        make_pb(        72, 10, 74,8,24," STORE  displayed values");
        make_pb(        73, 10, 96,8,24,"DISCARD displayed values");
        make_pmnn(          90, 10,8,"Tag Selector");
        make_pb(        77, 90, 27,8,2," ");
        make_pt(        38,120, 32,8,3,3,"Copy data from vector tag:");
        make_pb(        78,190,  5,8,2,"-5");
        make_pb(        79,224,  5,8,1,"-");
        make_pb(        80,248,  5,8,1,"+");
        make_pb(        81,270,  5,8,2,"+5");
	make_pt(        39, 10,169,8,79,60,"X-file:");
	make_pt(        40, 10,191,8,79,60,"Y-file:");
        make_pb(        74, 10,118,8,8," DRAW it");
        make_pb(        75, 10,140,8,8,"ERASE it");
        make_pb(        76,100,118,8,8,"ms draw");
	panel_set(	pb[76],PANEL_SHOW_ITEM,FALSE,0);
        make_pb(        87,100,129,8,9,"mouse mv");
        make_pt(        41,228, 52,8,4,4,"X-points:");
        make_pt(        42,228, 74,8,4,4,"Y-points:");
        make_pt(        43,228, 96,8,4,4,"X-origin:");
        make_pt(        44,228,118,8,4,4,"Y-origin:");
        make_pmnn(         370, 10,8,"Color/Scale data");
        make_pt(        45,370, 32,8,3,3,"X color=0 value:");
        make_pt(        46,370, 54,8,3,3,"Y color=0 value:");
        make_pt(        47,370, 76,8,8,8,"        X scale:");
        make_pt(        56,370, 98,8,8,8,"        Y scale:");
        make_pt(        54,370,120,8,3,3,"    Vector color:");
        make_pt(        55,370,142,8,4,4,"Max length (pix):");
        make_pmnn(         600, 10,8,"Points on image");
        make_pt(        48,600, 32,8,4,4,"   X-start:");
        make_pt(        49,600, 54,8,4,4,"   Y-start:");
        make_pt(        50,600, 76,8,4,4,"     X-end:");
        make_pt(        51,600, 98,8,4,4,"     Y-end:");
        make_pt(        52,600,120,8,4,4,"X-interval:");
        make_pt(        53,600,142,8,4,4,"Y-interval:");
        nv      = 0;
        window_set(	fr[8],WIN_SHOW,TRUE,0);
        p73();
	return;
}
/* EOF */
/* cat > src+obj/p10.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p10: p10 button - create feature frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p10()
{
	register int	y;

        panel_set(      pb[10],PANEL_SHOW_ITEM,FALSE,0);
	y = (int)window_get(fr[0],WIN_Y,0);
	if (y > N_yscr - (int)window_get(fr[0],WIN_HEIGHT,0) - 195)
	   y = 0;
	else
	   y = (int)window_get(fr[0],WIN_HEIGHT,0);
        make_fr( 9,
		 90,y,
		 /* 206,700, */
		 206, 710,
		"CompositeTool 1.1 Features (for tag 'i0')"
	       );
	pa[9] = make_p (fr[9]);
/*
        pa[9] = window_create(  fr[9],PANEL,0);
*/
	window_set(pa[9],WIN_IGNORE_PICK_EVENT,MS_MIDDLE,0);
	window_set(pa[9],WIN_IGNORE_PICK_EVENT,MS_RIGHT,0);
        make_pb(        88, 10,  5,9,7,"Done");
        make_pb(        89, 10, 32,9, 8," DRAW it");
        make_pb(        90, 10, 54,9, 8,"ERASE it");
        make_pb(       109,110,  5,9, 8,"Select");
        make_pt(        57,187, 10,9,3,3,"Image, Contour, or Vector tag:");
        make_pb(       113,110, 27,9, 8,"  Copy");
        make_pt(        58,187, 32,9,3,3,"features from another tag:");
        make_pb(       114,540,  5,9,12,"Features ON ");
        make_pb(       115,540, 27,9,12,"Features OFF");
        make_pb(        91,110, 54,9, 7,"x-axis");
        make_pb(        92,180, 54,9, 3,"off");
        make_pb(        93,110, 76,9, 7,"y-axis");
        make_pb(        94,180, 76,9, 3,"off");
        make_pb(        95,240, 54,9, 7,"x-grid");
        make_pb(        96,310, 54,9, 3,"off");
        make_pb(        97,240, 76,9, 7,"y-grid");
        make_pb(        98,310, 76,9, 3,"off");
        make_pb(        99,370, 54,9, 7,"x-tic1");
        make_pb(       100,440, 54,9, 3,"off");
        make_pb(       101,370, 76,9, 7,"y-tic1");
        make_pb(       102,440, 76,9, 3,"off");
        make_pb(       103,500, 54,9, 7,"x-tic2");
        make_pb(       104,570, 54,9, 3,"off");
        make_pb(       105,500, 76,9, 7,"y-tic2");
        make_pb(       106,570, 76,9, 3,"off");
	make_pm(	 4, 10, 92,9,"X-AXIS");
	make_ps(	 0, 10,114, 20,1, 10,9,"Thickness");
	make_ps(	 1, 10,136,512,0,255,9,"Color");
	make_ps(	 2,240,114,220,1,110,9,"Spacing (pix)");
	make_ps(	 3, 10,158, 20,1, 10,9,"Length   ");
        make_pb(       107,240,114,9,14,"left side off");
        make_pb(       108,380,114,9,14,"right side off");
        make_pb(       111,240,158,9,14,"left side off");
        make_pb(       112,380,158,9,14,"right side off");
        make_pb(       110,540,158,9, 7,"now OUT");
	panel_set(	pt[57],PANEL_VALUE,"i0",0);
	p109();
        window_set(	fr[9],WIN_SHOW,TRUE,0);
	return;
}
/* EOF */
/* cat > src+obj/p11.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p11: p11 button - create fileutil frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int
p11 ()
{
	register int    y;
	int             xpos, ypos;
	char           *getwd ();

	panel_set (pb[11], PANEL_SHOW_ITEM, FALSE, 0);
	y = (int) window_get (fr[0], WIN_Y, 0);
	if (y > N_yscr - (int) window_get (fr[0], WIN_HEIGHT, 0) - 225)
		y = 0;
	else
		y = (int) window_get (fr[0], WIN_HEIGHT, 0);
	make_fr (5,
		 100, y,
		 262, 660,
		 "CompositeTool 1.1 File Utility"
		);
	pa[5] = make_p (fr[5]);

	window_set (pa[5], WIN_IGNORE_PICK_EVENT, MS_MIDDLE, 0);
	window_set (pa[5], WIN_IGNORE_PICK_EVENT, MS_RIGHT, 0);
	make_pb (41, (xpos = 10), (ypos = 5), 5, 7, "Done");
	make_pt (17, (xpos = 10), (ypos += 25), 5, MAXNAMELEN, 50, "File:");
	make_pb (42, (xpos = 10), (ypos += 25), 5, 6, "WRITE");
	make_pmnn ((xpos = 75), (ypos), 5, "program settings to file.");
	make_pb (43, (xpos = 305), (ypos), 5, 6, "READ");
	make_pmnn ((xpos = 370), (ypos), 5, "program settings from file.");

	util_pb_saveall = panel_create_item (pa[5], PANEL_BUTTON,
					     PANEL_ITEM_X, (xpos = 10),
					     PANEL_ITEM_Y, (ypos += 25),
					     PANEL_LABEL_IMAGE,
					     panel_button_image (pa[5], "SAVE ALL", 9, font_panel_button),
					     PANEL_NOTIFY_PROC, util_proc_saveall,
					     0);

	strcpy (txt, "of screen to file.");
	make_pmnn ((xpos = 100), (ypos), 5, txt);
	make_pb (44, (xpos = 10), (ypos += 25), 5, 10, "SAVE PART");
	strcpy (txt, "of screen to file, based on start and end points below.");
	make_pmnn ((xpos = 100), (ypos), 5, txt);

	make_pt (18, (xpos = 100), (ypos += 25), 5, 4, 4, "X-pix start:");
	make_pt (20, (xpos = 260), (ypos), 5, 4, 4, "X-pix end:");
	make_pt (19, (xpos = 100), (ypos += 25), 5, 4, 4, "Y-pix start:");
	make_pt (21, (xpos = 260), (ypos), 5, 4, 4, "Y-pix end:");
	make_pb (45, (xpos = 100), (ypos += 25), 5, 7, "now OFF");

	strcpy (txt, "Load start and end points by mouse.");
	make_pmnn ((xpos = 175), (ypos), 5, txt);
	util_pc_save = panel_create_item (pa[5], PANEL_CYCLE,
					  PANEL_LABEL_X, (xpos = 10),
					  PANEL_LABEL_Y, (ypos +=25),
					  PANEL_CHOICE_STRINGS,
					  "Save palette and image as HDF 8-bit Raster Image Set",
					  "Save palette and compressed image as HDF 8-bit Raster Image Set",
					  "Save image only as raw raster", 0,
					  0);
	my_itoa (sdump.xstart, txt);
	panel_set (pt[18], PANEL_VALUE, txt, 0);
	my_itoa (sdump.ystart, txt);
	panel_set (pt[19], PANEL_VALUE, txt, 0);
	my_itoa (sdump.xend, txt);
	panel_set (pt[20], PANEL_VALUE, txt, 0);
	my_itoa (sdump.yend, txt);
	panel_set (pt[21], PANEL_VALUE, txt, 0);
	window_set (fr[5], WIN_SHOW, TRUE, 0);
	info_msg ("", "File Utility frame brought up.", "");
	return;
}
/* EOF */
/* cat > src+obj/p12.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p12: p12 button - quit comptool			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int 
p12 ()
{
	window_destroy (fr[0]);
	return;
}
/* EOF */
/* cat > src+obj/p13.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p13: p13 button - done with the palette frame	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p13 ()
{
	if (1 == sw_palette || FALSE == confirm_palette ())
	{
		window_destroy (pa[1]);
		window_destroy (fr[1]);
		pa[1] = fr[1] = NULL;
		panel_set (pb[3], PANEL_SHOW_ITEM, TRUE, 0);
		info_msg ("", "Palette frame put away.", "");
		sw_palette = 0;
		return;
	}
	panel_set (pb[13], PANEL_LABEL_IMAGE,
		   panel_button_image (pa[1], "CONFIRM", 7, NULL), 0);
	sw_palette = 1;
	warn_msg ();
	return;
}
/* EOF */
/* cat > src+obj/p14.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p14: p14 button - load the palette			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p14()
{
	char pfntmp[MAXNAMELEN + 1];

	reset_palette();
	strcpy (pfntmp, panel_get (pt[0], PANEL_VALUE, 0));
	if (load_rgb (pfntmp, 1))
	{
		panel_set (pt[0], PANEL_VALUE, pfn, 0);
		(void) load_rgb (pfn, 1);
		return;
	}
        strcpy(pfn, pfntmp);
	panel_set (pt[0], PANEL_VALUE, pfn, 0);
	
	reset_colormap ();

	info_msg("","Palette loaded.","");
        return;
}
/* EOF */
/* cat > src+obj/p15.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p15: p15 button - load background color		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p15()
{
        register int            c;
	reset_palette();
        strcpy(txt,panel_get    (pt[1],PANEL_VALUE,0));
        if (FALSE == my_isint(txt))
	   {strcat(txt," is not an integer");
	    bad_data(txt);
	    return;
	   }
        c       = atoi(txt);
        if (c < 0 || c > 255)
	   {bad_data("value < 0 or value > 255");
	    return;
	   }
        clear_color     = c;
info_msg("","Background color loaded and in effect for all future actions.","");
        return;
}
/* EOF */
/* cat > src+obj/p16.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p16: p16 button - done with the grid frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p16 ()
{
	if (1 == sw_grid || FALSE == confirm_grid ())
	{
		window_destroy (pa[2]);
		window_destroy (fr[2]);
		pa[2] = fr[2] = NULL;
		panel_set (pb[4], PANEL_SHOW_ITEM, TRUE, 0);
		info_msg ("", "Grid frame put away.", "");
		sw_grid = 0;
		return;
	}
	panel_set (pb[16], PANEL_LABEL_IMAGE,
		   panel_button_image (pa[2], "CONFIRM", 7, NULL), 0);
	sw_grid = 1;
	warn_msg ();
	return;
}
/* EOF */
/* cat > src+obj/p17.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p17: p17 button - grid...toggle the FinalPic switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p17()
{
	reset_grid();
        if (grid.sw == 1)
          {grid.sw = 0;
           panel_set(	pb[17],PANEL_LABEL_IMAGE,
			panel_button_image(pa[2],
			"FinalPic toggle (OFF)",21,NULL),
			0);
          }
        else
          {grid.sw = 1;
           panel_set(	pb[17],PANEL_LABEL_IMAGE,
			panel_button_image(pa[2],
			"FinalPic toggle (ON) ",21,NULL),
			0);
          }
	info_msg("","FinalPic switch toggled for grid.","");
        return;
}
/* EOF */
/* cat > src+obj/p18.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p18: p18 button - grid...store displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p18()
{
	reset_grid();
        if (FALSE == ok_grid(&tgrid)) return;
        grid.color      = tgrid.color;
        grid.xpix       = tgrid.xpix;
        grid.ypix       = tgrid.ypix;
	p19();
        return;
}
/* EOF */
/* cat > src+obj/p19.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p19: p19 button - grid...discard displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p19()
{
	reset_grid();
        if	(grid.color == 0)
		panel_set(	pt[2],PANEL_VALUE,"",0);
        else
		{my_itoa(grid.color,txt);
		 panel_set(	pt[2],PANEL_VALUE,txt,0);
		}
        if      (grid.xpix == 0)
		panel_set(	pt[3],PANEL_VALUE,"",0);
        else
		{my_itoa(grid.xpix,txt);
		 panel_set(	pt[3],PANEL_VALUE,txt,0);
		}
        if      (grid.ypix == 0)
		panel_set(	pt[4],PANEL_VALUE,"",0);
        else
		{my_itoa(grid.ypix,txt);
		 panel_set(	pt[4],PANEL_VALUE,txt,0);
		}
	info_msg("","Display now shows currently stored values for grid.","");
        return;
}
/* EOF */
/* cat > src+obj/p20.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p20: p20 button - draw the grid			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p20()
{
	reset_grid();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_grid(&tgrid)) return;
	if (grid_down)		/* already grid down - erase first */
	{
		lgrid.color = clear_color;
		draw_grid (&lgrid);
	}
        draw_grid(&tgrid);
	lgrid = tgrid;
	grid_down = TRUE;
	info_msg("","Grid drawn.","");
        return;
}
/* EOF */
/* cat > src+obj/p21.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p21: p21 button - erase the grid			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	p21()
{
	reset_grid();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_grid(&tgrid)) return;
        tgrid.color     = clear_color;
        draw_grid(&tgrid);
	grid_down = FALSE;
	info_msg("","Grid erased.","");
        return;
}
/* EOF */
/* cat > src+obj/p22.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p22: p22 button - done with colorbar frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p22 ()
{
	if (1 == sw_colorbar || FALSE == confirm_colorbar ())
	{
		reset_mcolorbar ();
		window_destroy (pa[3]);
		window_destroy (fr[3]);
		pa[3] = fr[3] = NULL;
		panel_set (pb[5], PANEL_SHOW_ITEM, TRUE, 0);
		info_msg ("", "ColorBar frame put away.", "");
		sw_colorbar = 0;
		return;
	}
	panel_set (pb[22], PANEL_LABEL_IMAGE,
		   panel_button_image (pa[3], "CONFIRM", 7, NULL), 0);
	sw_colorbar = 1;
	warn_msg ();
	return;
}
/* EOF */
/* cat > src+obj/p23.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p23: p23 button - colorbar...toggle the FinalPic	*/
/*	switch						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p23()
{
	reset_colorbar();
        if (cbar.sw == 1)
          {cbar.sw = 0;
           panel_set(	pb[23],PANEL_LABEL_IMAGE,
			panel_button_image(pa[3],
			"FinalPic toggle (OFF)",21,NULL),
			0);
          }
        else
          {cbar.sw = 1;
           panel_set(	pb[23],PANEL_LABEL_IMAGE,
			panel_button_image(pa[3],
			"FinalPic toggle (ON) ",21,NULL),
			0);
          }
	info_msg("","FinalPic switch toggled for colorbar.","");
        return;
}
/* EOF */
/* cat > src+obj/p24.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p24: p24 button - colorbar...store displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p24()
{
	reset_colorbar();
        if (FALSE == ok_colorbar(&tcbar)) return;
        cbar.xpts       = tcbar.xpts;
        cbar.ypts       = tcbar.ypts;
        cbar.xpos       = tcbar.xpos;
        cbar.ypos       = tcbar.ypos;
	p25();
        return;
}
/* EOF */
/* cat > src+obj/p25.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p25: p25 button:  colorbar...discard displayed	*/
/*	values						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p25()
{
	reset_colorbar();
	reset_mcolorbar();
        panel_set(      pt[5],PANEL_VALUE,"128",0);
        if      (cbar.xpts == 0)
		panel_set(	pt[6],PANEL_VALUE,"",0);
        else
		{my_itoa(cbar.xpts,txt);
		 panel_set(	pt[6],PANEL_VALUE,txt,0);
		}
        if      (cbar.ypts == 0)
		panel_set(	pt[7],PANEL_VALUE,"",0);
        else
		{my_itoa(cbar.ypts,txt);
		 panel_set(	pt[7],PANEL_VALUE,txt,0);
		}
        if      (cbar.xpos == 0)
		panel_set(	pt[8],PANEL_VALUE,"",0);
        else
		{my_itoa(cbar.xpos,txt);
		 panel_set(      pt[8],PANEL_VALUE,txt,0);
		}
        if      (cbar.ypos == 0)
		panel_set(	pt[9],PANEL_VALUE,"",0);
        else
		{my_itoa(cbar.ypos,txt);
		 panel_set(      pt[9],PANEL_VALUE,txt,0);
		}
	info_msg("","Display now shows currently stored values for colorbar.","");
        return;
}
/* EOF */
/* cat > src+obj/p26.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p26: p26 button - colorbar...draw it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p26()
{
	reset_colorbar();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_colorbar(&tcbar)) return;
        draw_colorbar(&tcbar);
	info_msg("","Colorbar drawn.","");
        return;
}
/* EOF */
/* cat > src+obj/p27.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p27: p27 button - colorbar...erase it		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int     p27()
{
	reset_colorbar();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_colorbar(&tcbar)) return;
        pw_rop(cpw,	tcbar.xpos,
                        tcbar.ypos,
                        tcbar.xpts,
                        tcbar.ypts,
                PIX_SRC | ((clear_color) << 5),NULL,0,0);
	info_msg("","Colorbar erased.","");
        return;
}
/* EOF */
/* cat > src+obj/p28.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p28: p28 button - colorbar...mouse draw 		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p28()
{
        reset_colorbar();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_colorbar == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_colorbar = TRUE;
	    sw_draw = TRUE;
	    panel_set(pb[28],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[3],"MS DRAW",8,NULL),0);
	    msg_draw("ColorBar frame:");
	    return;
	   }
	if (sw_draw == TRUE)
	   {sw_draw = FALSE;
	    csw_colorbar = FALSE;
	    panel_set(pb[28],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[3],"ms draw",8,NULL),0);
	    info_msg("","Draw ColorBar with mouse deactivated.","");
	    return;
	   }
	sw_move = FALSE;
	panel_set(pb[84],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[3],"mouse mv",9,NULL),0);
	sw_draw = TRUE;
	panel_set(pb[28],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[3],"MS DRAW",8,NULL),0);
	msg_draw("ColorBar frame:");
	return;
}
/* EOF */
/* cat > src+obj/p29.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p29: p29 button - colorbar...temporary show color	*/
/*	pos						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p29()
{
        int             c;
        float           f = 255.00001;
	reset_colorbar();
        if	(FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if	(FALSE == ok_colorbar(&tcbar)) return;
        strcpy( txt,panel_get(  pt[5],PANEL_VALUE,0));
        if	(FALSE == my_isint(txt))
		{strcat(txt," is not an integer, request ignored.");
		 bad_data(txt);
		 return;
		}
        c       = atoi(txt);
        if	(c < 0 || c > 255)
		{bad_data("Value < 0 or value > 255, request ignored.");
		 return;
		}
        c = c * (f / (0. + tcbar.ypts));
        pw_vector(cpw,	tcbar.xpos + tcbar.xpts,
        		tcbar.ypos + tcbar.ypts - 1 - c,
			tcbar.xpos + tcbar.xpts + 5,
			tcbar.ypos + tcbar.ypts - 1 - c + 5,
			PIX_SRC,255);
        pw_vector(cpw,	tcbar.xpos + tcbar.xpts,
			tcbar.ypos + tcbar.ypts - 1 - c,
			tcbar.xpos + tcbar.xpts + 5,
			tcbar.ypos + tcbar.ypts - 1 - c - 5,
			PIX_SRC,255);
	info_msg("","Specified color shown on colorbar.","");
        return;
}
/* EOF */
/* cat > src+obj/p30.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p30: p30 button - done with text frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p30 ()
{
	if (1 == sw_text || FALSE == confirm_text ())
	{
		reset_text ();
		reset_mtext ();
		window_destroy (pa[4]);
		window_destroy (fr[4]);
		panel_set (pb[6], PANEL_SHOW_ITEM, TRUE, 0);
		info_msg ("", "Text frame put away.", "");
		reset_text ();
		csw_text = FALSE;
		pa[4] = fr[4] = NULL;
		return;
	}
	reset_text ();
	panel_set (pb[30], PANEL_LABEL_IMAGE,
		   panel_button_image (pa[4], "CONFIRM", 7, NULL), 0);
	sw_text = 1;
	warn_msg ();
	return;
}
/* EOF */
/* cat > src+obj/p31.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p31: p31 button - text...toggle the FinalPic switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p31()
{
	reset_text();
        if (text[nt].sw == 1)
          {text[nt].sw = 0;
           panel_set(	pb[31],PANEL_LABEL_IMAGE,
			panel_button_image(pa[4],
			"FinalPic toggle (OFF)",21,NULL),
			0);
          }
        else
          {text[nt].sw = 1;
           panel_set(	pb[31],PANEL_LABEL_IMAGE,
			panel_button_image(pa[4],
			"FinalPic toggle (ON) ",21,NULL),
			0);
	  }
	*(rw_toggle + N_image + N_contour + N_vector + nt) = TRUE;
	info_msg("","FinalPic toggled for text.","");
        return;
}
/* EOF */
/* cat > src+obj/p32.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p32: p32 button - text...store displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p32()
{
	reset_text();
        if (FALSE == ok_text(&text[N_text])) return;
        text[nt].color  = text[N_text].color;
        text[nt].xpos   = text[N_text].xpos;
        text[nt].ypos   = text[N_text].ypos;
        strcpy(text[nt].body,text[N_text].body);
        strcpy(text[nt].prefont,text[N_text].prefont);
        strcpy(text[nt].postfont,text[N_text].postfont);
	reset_text();
	p33();
	*(rw_toggle + N_image + N_contour + N_vector + nt) = TRUE;
        return;
}
/* EOF */
/* cat > src+obj/p33.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p33: p33 button - text...discard displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p33()
{
        char            *s;
	reset_text();
	reset_mtext();
        strcpy(txt,window_get(fr[4],FRAME_LABEL,0));
        s = txt;
        while (*s) s++;
	while (*s != 't') s--;
	s++;
        my_itoa(nt,s);
        while (*s) s++;
        *s++ = '\'';
        *s++ = ')';
        *s   = '\0';
        window_set(     fr[4],FRAME_LABEL,txt,0);
        if      (text[nt].sw == 0)
        	panel_set(	pb[31],PANEL_LABEL_IMAGE,
				panel_button_image(pa[4],
				"FinalPic toggle (OFF)",21,NULL),
				0);
        else
        	panel_set(	pb[31],PANEL_LABEL_IMAGE,
				panel_button_image(pa[4],
				"FinalPic toggle (ON) ",21,NULL),
				0);
        if      (text[nt].color == 0)
		panel_set(      pt[11],PANEL_VALUE,"",0);
        else
		{my_itoa(text[nt].color,txt);
		 panel_set(pt[11],PANEL_VALUE,txt,0);
		}
        if      (text[nt].xpos == 0)
		panel_set(      pt[12],PANEL_VALUE,"",0);
        else
		{my_itoa(text[nt].xpos,txt);
		 panel_set(pt[12],PANEL_VALUE,txt,0);
		}
        if      (text[nt].ypos == 0)
		panel_set(      pt[13],PANEL_VALUE,"",0);
        else
		{my_itoa(text[nt].ypos,txt);
		 panel_set(pt[13],PANEL_VALUE,txt,0);
		}
        panel_set(      pt[14],PANEL_VALUE,text[nt].body,0);
        panel_set(      pt[15],PANEL_VALUE,text[nt].prefont,0);
        panel_set(      pt[16],PANEL_VALUE,text[nt].postfont,0);
        s = txt;
        *s++ = 't';
        if (nt == 0)    {*s++ = '0'; *s = '\0';}
        else            my_itoa(nt-1,s);
        panel_set(      pt[10],PANEL_VALUE,txt,0);
	info_msg("","Display now shows currently stored values for text.","");
        return;
}
/* EOF */
/* cat > src+obj/p34.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p34: p34 button - text...draw it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p34()
{
	reset_text();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_text(&text[N_text])) return;
        draw_text(&text[N_text]);
	info_msg("","Text drawn.","");
        return;
}
/* EOF */
/* cat > src+obj/p35.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p35: p35 button - text...erase it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p35()
{
	reset_text();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_text(&text[N_text])) return;
	text[N_text].color = clear_color;
        draw_text(&text[N_text]);
	info_msg("","Text erased.","");
        return;
}
/* EOF */
/* cat > src+obj/p36.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p36: p36 button - text...copy data from another tag	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p36()
{
        register int    n;
        char            *s;
        strcpy(txt,panel_get(   pt[10],PANEL_VALUE,0));
        s = txt;
        if (*s != 't' || *(s + 1) == '\0')
	  {strcat(txt," is not a valid text tag.");
	   reset_text();
	   bad_data(txt);
	   return;
	  }
        s++;
        if (FALSE == my_isint(s))
	  {strcat(txt," is not a valid text tag.");
	   reset_text();
	   bad_data(txt);
	   return;
	  }
        n = atoi(s);
        if (n < 0)
	  {strcat(txt," is not a valid text tag.");
	   reset_text();
	   bad_data(txt);
	   return;
	  }
        if (n >= N_text)
	  {strcat(txt," is valid, but there are not that many tags.");
	   reset_text();
	   bad_data(txt);
	   return;
	  }
	if (nt == n)
	   {reset_text();
	    info_msg("","This text tag already showing.","");
	    return;
	   }
	if (sw_t[0] == 0 && TRUE == confirm_text())
	   {reset_text();
	    panel_set(pb[36],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[4],"*",2,NULL),0);
	    sw_t[0] = 1;
	    warn_msgt();
	    return;
	   }
        if      (text[n].color == 0)
		panel_set(      pt[11],PANEL_VALUE,"",0);
        else
		{my_itoa(text[n].color,txt);
		 panel_set(pt[11],PANEL_VALUE,txt,0);
		}
        if      (text[n].xpos == 0)
		panel_set(      pt[12],PANEL_VALUE,"",0);
        else
		{my_itoa(text[n].xpos,txt);
		 panel_set(pt[12],PANEL_VALUE,txt,0);
		}
        if      (text[n].ypos == 0)
		panel_set(      pt[13],PANEL_VALUE,"",0);
        else
		{my_itoa(text[n].ypos,txt);
		 panel_set(pt[13],PANEL_VALUE,txt,0);
		}
        panel_set(      pt[14],PANEL_VALUE,text[n].body,0);
        panel_set(      pt[15],PANEL_VALUE,text[n].prefont,0);
        panel_set(      pt[16],PANEL_VALUE,text[n].postfont,0);
	reset_text();
	reset_mtext();
	info_msg("","Text displayed has been copied from",
		    "another tag but has not been stored.");
        return;
}
/* EOF */
/* cat > src+obj/p37.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p37: p37 button - text...decrement tag number by 5	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p37()
{
	if (nt == 0)
	   {reset_text();
	    info_msg("","This text tag is the first one.","");
	    return;
	   }
	if (sw_t[1] == 1 || FALSE == confirm_text())
           {nt -= 5;
            if (nt < 0) nt = 0;
            p33();
	    reset_text();
            return;
	   }
	reset_text();
	panel_set(pb[37],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"*",2,NULL),0);
	sw_t[1] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p38.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p38: p38 button - text...decrement tag number by 1	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p38()
{
	if (nt == 0)
	   {reset_text();
	    info_msg("","This text tag already displayed.","");
	    return;
	   }
	if (sw_t[2] == 1 || FALSE == confirm_text())
           {nt--;
            p33();
	    reset_text();
            return;
	   }
	reset_text();
	panel_set(pb[38],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"*",1,NULL),0);
	sw_t[2] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p39.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p39: p39 button - text...increment tag number by 1	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p39()
{
	if (nt == N_text - 1)
	   {reset_text();
	    info_msg("","This text tag already displayed.","");
	    return;
	   }
	if (sw_t[3] == 1 || FALSE == confirm_text())
           {nt++;
            p33();
	    reset_text();
            return;
	   }
	reset_text();
	panel_set(pb[39],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"*",1,NULL),0);
	sw_t[3] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p40.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p40: p40 button - text...increment tag number by 5	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p40()
{
	if (nt == N_text - 1)
	   {reset_text();
	    info_msg("","This text tag already displayed.","");
	    return;
	   }
	if (sw_t[4] == 1 || FALSE == confirm_text())
           {nt += 5;
	    if (nt > N_text - 1) nt = N_text - 1;
            p33();
	    reset_text();
            return;
	   }
	reset_text();
	panel_set(pb[40],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"*",2,NULL),0);
	sw_t[4] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p41.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p41: p41 button - done with fileutile frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p41 ()
{
	if (csw_dump == TRUE)
		sw_flash = FALSE;
	window_destroy (pa[5]);
	window_destroy (fr[5]);
	pa[5] = fr[5] = NULL;
	panel_set (pb[11], PANEL_SHOW_ITEM, TRUE, 0);
	csw_dump = FALSE;
	info_msg ("", "File utility frame put away.", "");
	return;
}
/* EOF */
/* cat > src+obj/p42.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p42: p42 button - fileutil...write settings to file	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int 
p42 ()
{
	register int    i, m;
	int             f, b;

	m = my_otod (644);
	strcpy (txt, panel_get (pt[17], PANEL_VALUE, 0));
	if (xstrlen (txt) == 0)	/* no filename */
	{
		bad_data ("No filename given, request ignored.");
		return;
	}
	if (-1 == (f = creat (txt, m)))
	{
		bad_data ("Cannot create file, request ignored.");
		return;
	}
	b = strlen (compat_hdr);
	if (b != write (f, compat_hdr, b))
	{
		bad_data ("Problem writing compatibility header, premature end.");
		close (f);
		return;
	}
	tag_to_string ("g", -1, msg);
	b = strlen (msg);
	if (b != write (f, msg, b))
	{
		bad_data ("Problem writing grid tag, premature end.");
		close (f);
		return;
	}
	tag_to_string ("p", -1, msg);
	b = strlen (msg);
	if (b != write (f, msg, b))
	{
		bad_data ("Problem writing palette tag, premature end.");
		close (f);
		return;
	}
	tag_to_string ("b", -1, msg);
	b = strlen (msg);
	if (b != write (f, msg, b))
	{
		bad_data ("Problem writing colorbar tag, premature end.");
		close (f);
		return;
	}
	for (i = 0; i < N_text; i++)
	{
		if (*(rw_toggle + N_image + N_contour + N_vector + i) == TRUE)
		{
			tag_to_string ("t", i, msg);
			b = strlen (msg);
			if (b != write (f, msg, b))
			{
				bad_data ("Problem writing text tag, premature end.");
				close (f);
				return;
			}
		}
	}
	for (i = 0; i < N_image; i++)
	{
		if (*(rw_toggle + i) == TRUE)
		{
			tag_to_string ("i", i, msg);
			b = strlen (msg);
			if (b != write (f, msg, b))
			{
				bad_data ("Problem writing image tag, premature end.");
				close (f);
				return;
			}
		}
	}
	for (i = 0; i < N_image + N_contour + N_vector; i++)
	{
		if (*(rw_toggle + i) == TRUE)
		{
			tag_to_string ("f", i, msg);
			b = strlen (msg);
			if (b != write (f, msg, b))
			{
				bad_data ("Problem writing feature tag, premature end.");
				close (f);
				return;
			}
		}
	}
	for (i = 0; i < N_vector; i++)
	{
		if (*(rw_toggle + N_image + N_contour + i) == TRUE)
		{
			tag_to_string ("v", i, msg);
			b = strlen (msg);
			if (b != write (f, msg, b))
			{
				bad_data ("Problem writing vector tag, premature end.");
				close (f);
				return;
			}
		}
	}
	for (i = 0; i < N_contour; i++)
	{
		if (*(rw_toggle + N_image + i) == TRUE)
		{
			tag_to_string ("c", i, msg);
			b = strlen (msg);
			if (b != write (f, msg, b))
			{
				bad_data ("Problem writing contour tag, premature end.");
				close (f);
				return;
			}
		}
	}
	strcpy (msg, "\\");
	write (f, msg, 1);
	close (f);
	info_msg ("", "Program settings written to file.", "");
	return;
}
/* EOF */
/* cat > src+obj/p43.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p43: p43 button - fileutil...read settings from file	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int 
p43 ()
{
	char           *s, t[8], my_eof = '\\', nd = '\0', td = '\n';
	int             f, n, done = FALSE;
	register int    i;

	strcpy (txt, panel_get (pt[17], PANEL_VALUE, 0));
	if (xstrlen (txt) == 0)
	{
		bad_data ("No filename given, request ignored.");
		return;
	}
	if (-1 == (f = open (txt, 0)))
	{
		bad_data ("Cannot open file, request ignored.");
		return;
	}

		/* get directory part of filename */

	(void) getdirname (txt, util_read_dir);

	n = strlen (compat_hdr);
	read (f, msg, n);
	*(msg + n) = '\0';
	if (strcmp (compat_hdr, msg) != 0)
	{
		bad_data ("File format for this tool has changed since file was written: unable to read.");
		close (f);
		return;
	}

	for (i = 0; i < N_image + N_contour + N_vector + N_text; i++)
		*(rw_toggle + i) = FALSE;
	for (i = 0; i < N_text; i++)
		null_text (&text[i]);
	for (i = 0; i < N_image; i++)
		null_image (&image[i]);
	for (i = 0; i < N_image + N_contour + N_vector; i++)
		null_feature (&feat[i]);
	for (i = 0; i < N_contour; i++)
		null_contour (&con[i]);
	for (i = 0; i < N_vector; i++)
		null_vector (&vec[i]);

	while (done == FALSE)
	{
		s = msg;
		read (f, s, 1);
		if (*s == my_eof)
			done = TRUE;
		else
		{
			s++;
			while (*(s - 1) != td)
			{
				read (f, s, 1);
				s++;
			}
			*s = nd;
			if (FALSE == string_to_tag (msg, util_read_dir))
			{
				close (f);
				return;
			}
		}
	}
	close (f);

	if (TRUE == (int) window_get (fr[9], WIN_SHOW, 0))
	{
		strcpy (t, panel_get (pm[3], PANEL_LABEL_STRING, 0));
		if (strcmp (t, "X-AXIS") == 0)
			p91 ();
		else if (strcmp (t, "Y-AXIS") == 0)
			p93 ();
		else if (strcmp (t, "X-GRID") == 0)
			p95 ();
		else if (strcmp (t, "Y-GRID") == 0)
			p97 ();
		else if (strcmp (t, "X-TIC1") == 0)
			p99 ();
		else if (strcmp (t, "Y-TIC1") == 0)
			p101 ();
		else if (strcmp (t, "X-TIC2") == 0)
			p103 ();
		else if (strcmp (t, "Y-TIC2") == 0)
			p105 ();
		else
		{
			bad_data ("It is not possible to get this feature error message, p43");
			return;
		}
	}

	info_msg ("", "Program settings read from file.", "");
	return;
}
/* EOF */
/* cat > src+obj/p44.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p44: p44 button - fileutil...dump screen to file	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int
p44 ()
{
	Pixrect        *p;
	struct mpr_data *s;
	int             f, nx, ny;

	if (FALSE == (int) window_get (c_frame, WIN_SHOW, 0))
	{
		info_msg ("", "Canvas is not up, request ignored.", "");
		return;
	}
	else if (FALSE == my_isint (panel_get (pt[18], PANEL_VALUE, 0)))
	{
		bad_data ("X-pix start is not an integer, request ignored.");
		return;
	}
	else if (FALSE == my_isint (panel_get (pt[20], PANEL_VALUE, 0)))
	{
		bad_data ("X-pix end is not an integer, request ignored.");
		return;
	}
	else if (FALSE == my_isint (panel_get (pt[19], PANEL_VALUE, 0)))
	{
		bad_data ("Y-pix start is not an integer, request ignored.");
		return;
	}
	else if (FALSE == my_isint (panel_get (pt[21], PANEL_VALUE, 0)))
	{
		bad_data ("Y-pix end is not an integer, request ignored.");
		return;
	}
	else if (atoi (panel_get (pt[18], PANEL_VALUE, 0)) < 0)
	{
		bad_data ("X-pix start is less than zero, request ignored.");
		return;
	}
	else if (atoi (panel_get (pt[18], PANEL_VALUE, 0)) >= N_hpix)
	{
		my_itoa (N_hpix - 1, txt);
		strcat (txt, " is largest X-pix start allowed, request ignored.");
		bad_data (txt);
		return;
	}
	else if (atoi (panel_get (pt[20], PANEL_VALUE, 0)) < 0)
	{
		bad_data ("X-pix end is less than zero, request ignored.");
		return;
	}
	else if (atoi (panel_get (pt[20], PANEL_VALUE, 0)) >= N_hpix)
	{
		my_itoa (N_hpix - 1, txt);
		strcat (txt, " is largest X-pix end allowed, request ignored.");
		bad_data (txt);
		return;
	}
	else if (atoi (panel_get (pt[20], PANEL_VALUE, 0)) <
		 atoi (panel_get (pt[18], PANEL_VALUE, 0)))
	{
		bad_data ("X-pix end < X-pix start, request ignored.");
		return;
	}
	else if (atoi (panel_get (pt[19], PANEL_VALUE, 0)) < 0)
	{
		bad_data ("Y-pix start is less than zero, request ignored.");
		return;
	}
	else if (atoi (panel_get (pt[19], PANEL_VALUE, 0)) >= N_vpix)
	{
		my_itoa (N_vpix - 1, txt);
		strcat (txt, " is largest Y-pix start allowed, request ignored.");
		bad_data (txt);
		return;
	}
	else if (atoi (panel_get (pt[21], PANEL_VALUE, 0)) < 0)
	{
		bad_data ("Y-pix end is less than zero, request ignored.");
		return;
	}
	else if (atoi (panel_get (pt[21], PANEL_VALUE, 0)) >= N_vpix)
	{
		my_itoa (N_vpix - 1, txt);
		strcat (txt, " is largest Y-pix end allowed, request ignored.");
		bad_data (txt);
		return;
	}
	else if (atoi (panel_get (pt[21], PANEL_VALUE, 0)) <
		 atoi (panel_get (pt[19], PANEL_VALUE, 0)))
	{
		bad_data ("Y-pix end < Y-pix start, request ignored.");
		return;
	}
	else if ((atoi (panel_get (pt[18], PANEL_VALUE, 0)) ==
		  atoi (panel_get (pt[20], PANEL_VALUE, 0)) &&
		  atoi (panel_get (pt[21], PANEL_VALUE, 0)) <
		  atoi (panel_get (pt[19], PANEL_VALUE, 0))) ||
		 (atoi (panel_get (pt[19], PANEL_VALUE, 0)) ==
		  atoi (panel_get (pt[21], PANEL_VALUE, 0)) &&
		  atoi (panel_get (pt[20], PANEL_VALUE, 0)) <
		  atoi (panel_get (pt[18], PANEL_VALUE, 0))))
	{
		bad_data ("A region of negative area defined, request ignored.");
		return;
	}
	else if (xstrlen (panel_get (pt[17], PANEL_VALUE, 0)) == 0)
	{
		bad_data ("No filename given, request ignored.");
		return;
	}
	else
	{
		sdump.xstart = atoi (panel_get (pt[18], PANEL_VALUE, 0));
		sdump.xend = atoi (panel_get (pt[20], PANEL_VALUE, 0));
		sdump.ystart = atoi (panel_get (pt[19], PANEL_VALUE, 0));
		sdump.yend = atoi (panel_get (pt[21], PANEL_VALUE, 0));
	}
	nx = sdump.xend - sdump.xstart + 1;
	ny = sdump.yend - sdump.ystart + 1;
	p = mem_create (nx, ny, 8);
	s = mpr_d (p);
	pw_read (p, 0, 0, nx, ny, PIX_SRC, cpw, sdump.xstart, sdump.ystart);
	s = mpr_d (p);

 /* unpad image before saving it */

	unpad_image (nx, ny, p);

	if (store_image (panel_get_value (pt[17]), nx, ny, (unsigned char *) s->md_image, (int) panel_get_value (util_pc_save)))
		return;
	info_msg ("", "Screen dumped to file.", "");
	return;
}
/* EOF */
/* cat > src+obj/p45.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p45: p45 button - fileutil...load dump parms via	*/
/*	mouse						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p45()
{
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
	if (csw_dump == TRUE)
	   {panel_set(pb[45],PANEL_LABEL_IMAGE, 
                      panel_button_image(pa[5],"now OFF",7,NULL),0);
	    info_msg("","File Utility:  mouse disabled for the canvas.","");
	    sw_flash = FALSE;
	    csw_dump = FALSE;
            return;
	   }
	if (FALSE == cpw_check())
	   {csw_dump = TRUE;
	    panel_set(pb[45],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[5],"now ON",7,NULL),0);
	   info_msg("          File Utility:  move the cursor into the canvas and then",
	   "press the left mouse to define your start point.  Hold the mouse down and drag",
	   "it to your end point, then release it. Use on/off button to disable mouse.");
            return;
	   }
	return;
}
/* EOF */
/* cat > src+obj/p46.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p46: p46 button - done with image frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p46 ()
{
	if (1 == sw_image || FALSE == confirm_image ())
	{
		reset_image ();
		reset_mimage ();
		window_destroy (pa[6]);
		window_destroy (fr[6]);
		panel_set (pb[7], PANEL_SHOW_ITEM, TRUE, 0);
		info_msg ("", "Image frame put away.", "");
		reset_image ();
		pa[6] = fr[6] = NULL;
		return;
	}
	reset_image ();
	panel_set (pb[46], PANEL_LABEL_IMAGE,
		   panel_button_image (pa[6], "CONFIRM", 7, NULL), 0);
	sw_image = 1;
	warn_msg ();
	return;
}
/* EOF */
/* cat > src+obj/p47.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p47: p47 button - image...toggle the FinalPic switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p47()
{
	reset_image();
        if (image[ni].sw == 1)
          {image[ni].sw = 0;
           panel_set(	pb[47],PANEL_LABEL_IMAGE,
			panel_button_image(pa[6],
			"FinalPic toggle (OFF)",21,NULL),
			0);
          }
        else
          {image[ni].sw = 1;
           panel_set(	pb[47],PANEL_LABEL_IMAGE,
			panel_button_image(pa[6],
			"FinalPic toggle (ON) ",21,NULL),
			0);
	  }
	*(rw_toggle + ni) = TRUE;
	info_msg("","FinalPic toggled for image.","");
        return;
}
/* EOF */
/* cat > src+obj/p48.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p48: p48 button - image...store displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p48()
{
	reset_image();
        if (FALSE == ok_image(&image[N_image], 1)) return;
        image[ni].xpts  = image[N_image].xpts;
        image[ni].ypts  = image[N_image].ypts;
        image[ni].xpos  = image[N_image].xpos;
        image[ni].ypos  = image[N_image].ypos;
        strcpy(image[ni].fname,image[N_image].fname);
	p49();
	*(rw_toggle + ni) = TRUE;
        return;
}
/* EOF */
/* cat > src+obj/p49.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p49: p49 button - image...discard displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p49()
{
        char            *s;
	reset_image();
	reset_mimage();
        strcpy(txt,window_get(fr[6],FRAME_LABEL,0));
        s = txt;
        while (*s) s++;
	while (*s != 'i') s--;
	s++;
        my_itoa(ni,s);
        while (*s) s++;
        *s++ = '\'';
        *s++ = ')';
        *s   = '\0';
        window_set(     fr[6],FRAME_LABEL,txt,0);
        if      (image[ni].sw == 0)
        	panel_set(	pb[47],PANEL_LABEL_IMAGE,
				panel_button_image(pa[6],
				"FinalPic toggle (OFF)",21,NULL),
				0);
        else
        	panel_set(	pb[47],PANEL_LABEL_IMAGE,
				panel_button_image(pa[6],
				"FinalPic toggle (ON) ",21,NULL),
				0);
        if      (image[ni].xpts == 0)
		panel_set(	pt[23],PANEL_VALUE,"",0);
        else
		{my_itoa(image[ni].xpts,txt);
		 panel_set(pt[23],PANEL_VALUE,txt,0);
		}
        if      (image[ni].ypts == 0)
		panel_set(      pt[24],PANEL_VALUE,"",0);
        else
		{my_itoa(image[ni].ypts,txt);
		 panel_set(pt[24],PANEL_VALUE,txt,0);
		}
        if      (image[ni].xpos == 0)
		panel_set(      pt[25],PANEL_VALUE,"",0);
        else
		{my_itoa(image[ni].xpos,txt);
		 panel_set( pt[25],PANEL_VALUE,txt,0);
		}
        if      (image[ni].ypos == 0)
		panel_set(      pt[26],PANEL_VALUE,"",0);
        else
		{my_itoa(image[ni].ypos,txt);
		 panel_set( pt[26],PANEL_VALUE,txt,0);
		}
        panel_set(      pt[27],PANEL_VALUE,image[ni].fname,0);
        s = txt;
        *s++ = 'i';
        if (ni == 0)    {*s++ = '0'; *s = '\0';}
        else            my_itoa(ni-1,s);
        panel_set(      pt[22],PANEL_VALUE,txt,0);
	info_msg("","Display now shows currently stored values for image.","");
        return;
}
/* EOF */
/* cat > src+obj/p50.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p50: p50 button - image...draw it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p50()
{
	reset_image();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_image(&image[N_image], 1)) return;
        draw_image(&image[N_image], 1);
	info_msg("","Image drawn.","");
        return;
}
/* EOF */
/* cat > src+obj/p51.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p51: p51 button - image...erase it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p51()
{
	reset_image();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_image(&image[N_image], 1)) return;
        pw_writebackground(cpw, image[N_image].xpos,    image[N_image].ypos,
                                image[N_image].xpts,    image[N_image].ypts,
                                PIX_SRC | (clear_color) << 5);
	info_msg("","Image erased.","");
        return;
}
/* EOF */
/* cat > src+obj/p52.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p52: p52 button - image...mouse draw			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p52()
{
        reset_image();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_image == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_image = TRUE;
	    sw_draw = TRUE;
	    panel_set(pb[52],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[6],"MS DRAW",8,NULL),0);
	    msg_draw("Image frame:");
	    return;
	   }
	if (sw_draw == TRUE)
	   {sw_draw = FALSE;
	    csw_image = FALSE;
	    panel_set(pb[52],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[6],"ms draw",8,NULL),0);
	    info_msg("","Draw Images with mouse deactivated.","");
	    return;
	   }
	sw_move = FALSE;
	panel_set(pb[85],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[6],"mouse mv",9,NULL),0);
	sw_draw = TRUE;
	panel_set(pb[52],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"MS DRAW",8,NULL),0);
	msg_draw("Image frame:");
	return;
}
/* EOF */
/* cat > src+obj/p53.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p53: p53 button - image...copy data from another tag	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p53()
{
        register int    n;
        char            *s;
        strcpy(txt,panel_get(   pt[22],PANEL_VALUE,0));
        s = txt;
        if (*s != 'i' || *(s + 1) == '\0')
	  {strcat(txt," is not a valid image tag.");
	   reset_image();
	   bad_data(txt);
	   return;
	  }
        s++;
        if (FALSE == my_isint(s))
	  {strcat(txt," is not a valid image tag.");
	   reset_image();
	   bad_data(txt);
	   return;
	  }
        n = atoi(s);
        if (n < 0)
	  {strcat(txt," is not a valid image tag.");
	   reset_image();
	   bad_data(txt);
	   return;
	  }
        if (n >= N_image)
	  {strcat(txt," is valid, but there are not that many tags.");
	   reset_image();
	   bad_data(txt);
	   return;
	  }
	if (ni == n)
	   {reset_image();
	    info_msg("", "This image tag already showing.","");
	    return;
	   }
	if (sw_i[0] == 0 && TRUE == confirm_image())
	   {reset_image();
	    panel_set(pb[53],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[6],"*",2,NULL),0);
	    sw_i[0] = 1;
	    warn_msgt();
	    return;
	   }
        if      (image[n].xpts == 0)
		panel_set(      pt[23],PANEL_VALUE,"",0);
        else
		{my_itoa(image[n].xpts,txt);
		 panel_set(pt[23],PANEL_VALUE,txt,0);
		}
        if      (image[n].ypts == 0)
		panel_set(      pt[24],PANEL_VALUE,"",0);
        else
		{my_itoa(image[n].ypts,txt);
		 panel_set(pt[24],PANEL_VALUE,txt,0);
		}
        if      (image[n].xpos == 0)
		panel_set(      pt[25],PANEL_VALUE,"",0);
        else
		{my_itoa(image[n].xpos,txt);
		 panel_set(pt[25],PANEL_VALUE,txt,0);
		}
        if      (image[n].ypos == 0)
		panel_set(      pt[26],PANEL_VALUE,"",0);
        else
		{my_itoa(image[n].ypos,txt);
		 panel_set(pt[26],PANEL_VALUE,txt,0);
		}
        panel_set(      pt[27],PANEL_VALUE,image[n].fname,0);
	reset_image();
	reset_mimage();
	info_msg("","Image displayed has been copied from",
		    "another tag but has not been stored.");
        return;
}
/* EOF */
/* cat > src+obj/p54.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p54: p54 button - image...decrement tag number by 5	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p54()
{
	if (ni == 0)
	   {reset_image();
	    info_msg("","This image tag already displayed.","");
	    return;
	   }
	if (sw_i[1] == 1 || FALSE == confirm_image())
           {ni -= 5;
	    if (ni < 0) ni = 0;
            p49();
	    reset_image();
            return;
	   }
	reset_image();
	panel_set(pb[54],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"*",2,NULL),0);
	sw_i[1] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p55.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p55: p55 button - image...decrement tag number by 1	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p55()
{
	if (ni == 0)
	   {reset_image();
	    info_msg("","This image tag already displayed.","");
	    return;
	   }
	if (sw_i[2] == 1 || FALSE == confirm_image())
           {ni --;
            p49();
	    reset_image();
            return;
	   }
	reset_image();
	panel_set(pb[55],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"*",1,NULL),0);
	sw_i[2] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p56.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p56: p56 button - image...increment tag number by 1	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p56()
{
	if (ni == N_image - 1)
	   {reset_image();
	    info_msg("","This image tag already displayed.","");
	    return;
	   }
	if (sw_i[3] == 1 || FALSE == confirm_image())
           {ni++;
            p49();
	    reset_image();
            return;
	   }
	reset_image();
	panel_set(pb[56],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"*",1,NULL),0);
	sw_i[3] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p57.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p57: p57 button - image...increment tag number by 5	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p57()
{
	if (ni == N_image - 1)
	   {reset_image();
	    info_msg("","This image tag already displayed.","");
	    return;
	   }
	if (sw_i[4] == 1 || FALSE == confirm_image())
           {ni += 5;
	    if (ni > N_image - 1) ni = N_image - 1;
            p49();
	    reset_image();
            return;
	   }
	reset_image();
	panel_set(pb[57],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"*",2,NULL),0);
	sw_i[4] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p58.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p58: p58 button - done with contour frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p58 ()
{
	if (1 == sw_contour || FALSE == confirm_contour ())
	{
		reset_mcontour ();
		reset_contour ();
		window_destroy (pa[7]);
		window_destroy (fr[7]);
		pa[7] = fr[7] = NULL;
		panel_set (pb[8], PANEL_SHOW_ITEM, TRUE, 0);
		info_msg ("", "Contour frame put away.", "");
		return;
	}
	reset_contour ();
	panel_set (pb[58], PANEL_LABEL_IMAGE,
		   panel_button_image (pa[7], "CONFIRM", 7, NULL), 0);
	sw_contour = 1;
	warn_msg ();
	return;
}
/* EOF */
/* cat > src+obj/p59.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p59: p59 button - contour...toggle the FinalPic	*/
/*	switch						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p59()
{
	reset_contour();
        if (con[nc].sw == 1)
          {con[nc].sw = 0;
           panel_set(	pb[59],PANEL_LABEL_IMAGE,
			panel_button_image(pa[7],
			"FinalPic toggle (OFF)",21,NULL),
			0);
          }
        else
          {con[nc].sw = 1;
           panel_set(	pb[59],PANEL_LABEL_IMAGE,
			panel_button_image(pa[7],
			"FinalPic toggle (ON) ",21,NULL),
			0);
	  }
	*(rw_toggle + N_image + nc) = TRUE;
	info_msg("","FinalPic toggled for contour.","");
        return;
}
/* EOF */
/* cat > src+obj/p60.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p60: p60 button - contour...store displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p60()
{
	reset_contour();
        if (FALSE == ok_contour(&con[N_contour], 1)) return;
        con[nc].xpts    = con[N_contour].xpts;
        con[nc].ypts    = con[N_contour].ypts;
        con[nc].xpos    = con[N_contour].xpos;
        con[nc].ypos    = con[N_contour].ypos;
        con[nc].first   = con[N_contour].first;
        con[nc].last    = con[N_contour].last;
        con[nc].interval = con[N_contour].interval;
        con[nc].color   = con[N_contour].color;
        con[nc].dis     = con[N_contour].dis;
        strcpy(con[nc].fname,con[N_contour].fname);
	p61();
	*(rw_toggle + N_image + nc) = TRUE;
        return;
}
/* EOF */
/* cat > src+obj/p61.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p61: p61 button - contour...discard displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p61()
{
        char            *s;
	reset_contour();
	reset_mcontour();
        strcpy(txt,window_get(fr[7],FRAME_LABEL,0));
        s = txt;
        while (*s) s++;
	while (*s != 'c') s--;
	s++;
        my_itoa(nc,s);
        while (*s) s++;
        *s++ = '\'';
        *s++ = ')';
        *s   = '\0';
        window_set(     fr[7],FRAME_LABEL,txt,0);
        if      (con[nc].sw == 0)
        	panel_set(	pb[59],PANEL_LABEL_IMAGE,
				panel_button_image(pa[7],
				"FinalPic toggle (OFF)",21,NULL),
				0);
        else
        	panel_set(	pb[59],PANEL_LABEL_IMAGE,
				panel_button_image(pa[7],
				"FinalPic toggle (ON) ",21,NULL),
				0);
        if      (con[nc].xpts == 0)
		panel_set(	pt[30],PANEL_VALUE,"",0);
        else
		{my_itoa(con[nc].xpts,txt);
		 panel_set(	pt[30],PANEL_VALUE,txt,0);
		}
        if      (con[nc].ypts == 0)
		panel_set(	pt[31],PANEL_VALUE,"",0);
        else
		{my_itoa(con[nc].ypts,txt);
		 panel_set(	pt[31],PANEL_VALUE,txt,0);
		}
        if      (con[nc].xpos == 0)
		panel_set(	pt[32],PANEL_VALUE,"",0);
        else
		{my_itoa(con[nc].xpos,txt);
		 panel_set(	pt[32],PANEL_VALUE,txt,0);
		}
        if      (con[nc].ypos == 0)
		panel_set(	pt[33],PANEL_VALUE,"",0);
        else
		{my_itoa(con[nc].ypos,txt);
		 panel_set(	pt[33],PANEL_VALUE,txt,0);
		}
        if      (con[nc].first == 0)
		panel_set(	pt[35],PANEL_VALUE,"",0);
        else
		{my_itoa(con[nc].first,txt);
		 panel_set(	pt[35],PANEL_VALUE,txt,0);
		}
        if      (con[nc].last == 0)
		panel_set(	pt[36],PANEL_VALUE,"",0);
        else
		{my_itoa(con[nc].last,txt);
		 panel_set(	pt[36],PANEL_VALUE,txt,0);
		}
        if      (con[nc].interval == 0)
		panel_set(	pt[37],PANEL_VALUE,"",0);
        else
		{my_itoa(con[nc].interval,txt);
		 panel_set(	pt[37],PANEL_VALUE,txt,0);
		}
        if      (con[nc].color == 0)
		panel_set(	pt[34],PANEL_VALUE,"",0);
        else
		{my_itoa(con[nc].color,txt);
		 panel_set(	pt[34],PANEL_VALUE,txt,0);
		}
        panel_set(	pt[29],PANEL_VALUE,con[nc].fname,0);
        s = txt;
        *s++ = 'c';
        if (nc == 0)    {*s++ = '0'; *s = '\0';}
        else            my_itoa(nc-1,s);
        panel_set(      pt[28],PANEL_VALUE,txt,0);
	info_msg("","Display now shows current stored values for contour.","");
        return;
}
/* EOF */
/* cat > src+obj/p62.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p62: p62 button - contour...draw it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p62()
{
	reset_contour();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_contour(&con[N_contour], 1)) return;
        draw_contour(&con[N_contour], 1);
	info_msg("","Contour drawn.","");
        return;
}
/* EOF */
/* cat > src+obj/p63.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p63: p63 button - contour...erase it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p63()
{
	reset_contour();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_contour(&con[N_contour], 1)) return;
        con[N_contour].color = clear_color;
        pw_writebackground(cpw, con[N_image].xpos,    con[N_image].ypos,
                                con[N_image].xpts,    con[N_image].ypts,
                                PIX_SRC | (clear_color) << 5);
	info_msg("","Contour erased.","");
        return;
}
/* EOF */
/* cat > src+obj/p64.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p64: p64 button - contour...mouse draw		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p64()
{
        reset_contour();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_contour == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_contour = TRUE;
	    sw_draw = TRUE;
	    panel_set(pb[64],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[7],"MS DRAW",8,NULL),0);
	    msg_draw("Contour frame:");
	    return;
	   }
	if (sw_draw == TRUE)
	   {sw_draw = FALSE;
	    csw_contour = FALSE;
	    panel_set(pb[64],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[7],"ms draw",8,NULL),0);
	    info_msg("","Draw Contours with mouse deactivated.","");
	    return;
	   }
	sw_move = FALSE;
	panel_set(pb[86],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[7],"mouse mv",9,NULL),0);
	sw_draw = TRUE;
	panel_set(pb[64],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"MS DRAW",8,NULL),0);
	msg_draw("Contour frame:");
	return;
}
/* EOF */
/* cat > src+obj/p65.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p65: p65 button - contour...copy data from another	*/
/*	tag						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p65()
{
        register int    n;
        char            *s;
        strcpy(txt,panel_get(   pt[28],PANEL_VALUE,0));
        s = txt;
        if (*s != 'c' || *(s + 1) == '\0')
	  {strcat(txt," is not a valid text tag.");
	   reset_contour();
	   bad_data(txt);
	   return;
	  }
        s++;
        if (FALSE == my_isint(s))
	  {strcat(txt," is not a valid text tag.");
	   reset_contour();
	   bad_data(txt);
	   return;
	  }
        n = atoi(s);
        if (n < 0)
	  {strcat(txt," is not a valid text tag.");
	   reset_contour();
	   bad_data(txt);
	   return;
	  }
        if (n >= N_contour)
	  {strcat(txt," is valid, but there are not that many tags.");
	   reset_contour();
	   bad_data(txt);
	   return;
	  }
	if (nc == n)
	   {reset_contour();
	    info_msg("","This contour tag already showing.","");
	    return;
	   }
	if (sw_c[0] == 0 && TRUE == confirm_contour())
	   {reset_contour();
	    panel_set(pb[65],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[7],"*",2,NULL),0);
	    sw_c[0] = 1;
	    warn_msgt();
	    return;
	   }
        if      (con[n].xpts == 0)
		panel_set(	pt[30],PANEL_VALUE,"",0);
        else
		{my_itoa(con[n].xpts,txt);
		 panel_set(	pt[30],PANEL_VALUE,txt,0);
		}
        if      (con[n].ypts == 0)
		panel_set(	pt[31],PANEL_VALUE,"",0);
        else
		{my_itoa(con[n].ypts,txt);
		 panel_set(	pt[31],PANEL_VALUE,txt,0);
		}
        if      (con[n].xpos == 0)
		panel_set(	pt[32],PANEL_VALUE,"",0);
        else
		{my_itoa(con[n].xpos,txt);
		 panel_set(	pt[32],PANEL_VALUE,txt,0);
		}
        if      (con[n].ypos == 0)
		panel_set(	pt[33],PANEL_VALUE,"",0);
        else
		{my_itoa(con[n].ypos,txt);
		 panel_set(	pt[33],PANEL_VALUE,txt,0);
		}
        if      (con[n].first == 0)
		panel_set(	pt[35],PANEL_VALUE,"",0);
        else
		{my_itoa(con[n].first,txt);
		 panel_set(	pt[35],PANEL_VALUE,txt,0);
		}
        if      (con[n].last == 0)
		panel_set(	pt[36],PANEL_VALUE,"",0);
        else
		{my_itoa(con[n].last,txt);
		 panel_set(	pt[36],PANEL_VALUE,txt,0);
		}
        if      (con[n].interval == 0)
		panel_set(	pt[37],PANEL_VALUE,"",0);
        else
		{my_itoa(con[n].interval,txt);
		 panel_set(	pt[37],PANEL_VALUE,txt,0);
		}
        if      (con[n].color == 0)
		panel_set(	pt[34],PANEL_VALUE,"",0);
        else
		{my_itoa(con[n].color,txt);
		 panel_set(	pt[34],PANEL_VALUE,txt,0);
		}
        panel_set(	pt[29],PANEL_VALUE,con[n].fname,0);
	reset_contour();
	reset_mcontour();
	info_msg("","Contour displayed has been copied from",
		    "another tag but has not been stored.");
        return;
}
/* EOF */
/* cat > src+obj/p66.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p66: p66 button - contour...decrement tag number by	*/
/*	5						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p66()
{
	if (nc == 0)
	   {reset_contour();
	    info_msg("","This contour tag already showing.","");
	    return;
	   }
	if (sw_c[1] == 1 || FALSE == confirm_contour())
           {nc -= 5;
	    if (nc < 0) nc = 0;
            p61();
	    reset_contour();
            return;
	   }
	reset_contour();
	panel_set(pb[66],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"*",2,NULL),0);
	sw_c[1] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p67.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p67: p67 button - contour...decrement tag number by	*/
/*	1						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p67()
{
	if (nc == 0)
	   {reset_contour();
	    info_msg("","This contour tag already showing.","");
	    return;
	   }
	if (sw_c[2] == 1 || FALSE == confirm_contour())
           {nc --;
            p61();
	    reset_contour();
            return;
	   }
	reset_contour();
	panel_set(pb[67],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"*",1,NULL),0);
	sw_c[2] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p68.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p68: p68 button - contour...increment tag number by	*/
/*	1						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p68()
{
	if (nc == N_contour - 1)
	   {reset_contour();
	    info_msg("","This contour tag already showing.","");
	    return;
	   }
	if (sw_c[3] == 1 || FALSE == confirm_contour())
           {nc ++;
            p61();
	    reset_contour();
            return;
	   }
	reset_contour();
	panel_set(pb[68],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"*",1,NULL),0);
	sw_c[3] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p69.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p69: p69 button - contour...increment tag number by	*/
/*	5						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p69()
{
	if (nc == N_contour - 1)
	   {reset_contour();
	    info_msg("","This contour tag already showing.","");
	    return;
	   }
	if (sw_c[4] == 1 || FALSE == confirm_contour())
           {nc += 5;
            if (nc > N_contour - 1) nc = N_contour - 1;
            p61();
	    reset_contour();
            return;
	   }
	reset_contour();
	panel_set(pb[69],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"*",2,NULL),0);
	sw_c[4] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p70.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p70: p70 button - done with vector frame		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p70 ()
{
	if (1 == sw_vector || FALSE == confirm_vector ())
	{
		reset_vector ();
		reset_mvector ();
		window_destroy (pa[8]);
		window_destroy (fr[8]);
		panel_set (pb[9], PANEL_SHOW_ITEM, TRUE, 0);
		info_msg ("", "Vector frame put away.", "");
		reset_vector ();
		pa[8] = fr[8] = NULL;
		return;
	}
	reset_vector ();
	panel_set (pb[70], PANEL_LABEL_IMAGE,
		   panel_button_image (pa[8], "CONFIRM", 7, NULL), 0);
	sw_vector = 1;
	warn_msg ();
	return;
}
/* EOF */
/* cat > src+obj/p71.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p71: p71 button - vector...toggle the FinalPic	*/
/*	switch						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p71()
{
	reset_vector();
        if (vec[nv].sw == 1)
          {vec[nv].sw = 0;
           panel_set(	pb[71],PANEL_LABEL_IMAGE,
			panel_button_image(pa[8],
			"FinalPic toggle (OFF)",21,NULL),
			0);
          }
        else
          {vec[nv].sw = 1;
           panel_set(	pb[71],PANEL_LABEL_IMAGE,
			panel_button_image(pa[8],
			"FinalPic toggle (ON) ",21,NULL),
			0);
	  }
	*(rw_toggle + N_image + N_contour + nv) = TRUE;
	info_msg("","FinalPic toggled for vector.","");
        return;
}
/* EOF */
/* cat > src+obj/p72.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p72: p72 button - vector...store displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p72()
{
	reset_vector();
        if (FALSE == ok_vector(&vec[N_vector], 1)) return;
        vec[nv].xpts    = vec[N_vector].xpts;
        vec[nv].ypts    = vec[N_vector].ypts;
        vec[nv].xpos    = vec[N_vector].xpos;
        vec[nv].ypos    = vec[N_vector].ypos;
        vec[nv].xstart  = vec[N_vector].xstart;
        vec[nv].xend    = vec[N_vector].xend;
        vec[nv].xinterval       = vec[N_vector].xinterval;
        vec[nv].ystart  = vec[N_vector].ystart;
        vec[nv].yend    = vec[N_vector].yend;
        vec[nv].yinterval       = vec[N_vector].yinterval;
        vec[nv].color   = vec[N_vector].color;
        vec[nv].maxlen  = vec[N_vector].maxlen;
        vec[nv].xzero   = vec[N_vector].xzero;
        vec[nv].yzero   = vec[N_vector].yzero;
        strcpy(vec[nv].xname,vec[N_vector].xname);
        strcpy(vec[nv].yname,vec[N_vector].yname);
        vec[nv].xscale  = vec[N_vector].xscale;
        vec[nv].yscale  = vec[N_vector].yscale;
	p73();
	*(rw_toggle + N_image + N_contour + nv) = TRUE;
        return;
}
/* EOF */
/* cat > src+obj/p73.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p73: p73 button - vector...discard displayed values	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p73()
{
        char            *s;
	int		n = nv;
	reset_vector();
	reset_mvector();
        strcpy(txt,window_get(fr[8],FRAME_LABEL,0));
        s = txt;
        while (*s) s++;
	while (*s != 'v') s--;
	s++;
        my_itoa(nv,s);
        while (*s) s++;
        *s++ = '\'';
        *s++ = ')';
        *s   = '\0';
        window_set(     fr[8],FRAME_LABEL,txt,0);
        if      (vec[n].sw == 0)
        	panel_set(	pb[71],PANEL_LABEL_IMAGE,
				panel_button_image(pa[8],
				"FinalPic toggle (OFF)",21,NULL),
				0);
        else
        	panel_set(	pb[71],PANEL_LABEL_IMAGE,
				panel_button_image(pa[8],
				"FinalPic toggle (ON) ",21,NULL),
				0);
        if      (vec[n].xpts == 0)
		panel_set(	pt[41],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xpts,txt);
		 panel_set(	pt[41],PANEL_VALUE,txt,0);
		}
        if      (vec[n].ypts == 0)
		panel_set(	pt[42],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].ypts,txt);
		 panel_set(	pt[42],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xpos == 0)
		panel_set(	pt[43],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xpos,txt);
		 panel_set(	pt[43],PANEL_VALUE,txt,0);
		}
        if      (vec[n].ypos == 0)
		panel_set(	pt[44],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].ypos,txt);
		 panel_set(	pt[44],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xstart == 0)
		panel_set(	pt[48],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xstart,txt);
		 panel_set(	pt[48],PANEL_VALUE,txt,0);
		}
        if      (vec[n].ystart == 0)
		panel_set(	pt[49],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].ystart,txt);
		 panel_set(	pt[49],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xend == 0)
		panel_set(	pt[50],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xend,txt);
		 panel_set(	pt[50],PANEL_VALUE,txt,0);
		}
        if      (vec[n].yend == 0)
		panel_set(	pt[51],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].yend,txt);
		 panel_set(	pt[51],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xinterval == 0)
		panel_set(	pt[52],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xinterval,txt);
		 panel_set(	pt[52],PANEL_VALUE,txt,0);
		}
        if      (vec[n].yinterval == 0)
		panel_set(	pt[53],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].yinterval,txt);
		 panel_set(	pt[53],PANEL_VALUE,txt,0);
		}
        if      (vec[n].color == 0)
		panel_set(	pt[54],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].color,txt);
		 panel_set(	pt[54],PANEL_VALUE,txt,0);
		}
        if      (vec[n].maxlen == 0)
		panel_set(	pt[55],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].maxlen,txt);
		 panel_set(	pt[55],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xzero == 0)
		panel_set(	pt[45],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xzero,txt);
		 panel_set(	pt[45],PANEL_VALUE,txt,0);
		}
        if      (vec[n].yzero == 0)
		panel_set(	pt[46],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].yzero,txt);
		 panel_set(	pt[46],PANEL_VALUE,txt,0);
		}
        my_ftoa(vec[n].xscale,4,txt);
        panel_set(	pt[47],PANEL_VALUE,txt,0);
        my_ftoa(vec[n].yscale,4,txt);
        panel_set(	pt[56],PANEL_VALUE,txt,0);
        panel_set(	pt[39],PANEL_VALUE,vec[n].xname,0);
        panel_set(	pt[40],PANEL_VALUE,vec[n].yname,0);
        s = txt;
        *s++ = 'v';
        if (nv == 0)    {*s++ = '0'; *s = '\0';}
        else            my_itoa(nv-1,s);
        panel_set(      pt[38],PANEL_VALUE,txt,0);
	info_msg("","Display shows currently stored values for vector.","");
        return;
}
/* EOF */
/* cat > src+obj/p74.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p74: p74 button - vector...draw it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p74()
{
	reset_vector();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_vector(&vec[N_vector], 1)) return;
        draw_vector(FALSE,&vec[N_vector], 1);
	info_msg("","Vector drawn.","");
        return;
}
/* EOF */
/* cat > src+obj/p75.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p75: p75 button - vector...erase it			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p75()
{
	reset_vector();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
	  {info_msg("","Canvas is not up, request ignored.","");
	   return;
	  }
        if (FALSE == ok_vector(&vec[N_vector], 1)) return;
        vec[N_vector].color = clear_color;
        draw_vector(FALSE,&vec[N_vector], 1);
	info_msg("","Vector erased.","");
        return;
}
/* EOF */
/* cat > src+obj/p76.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p76: p76 button - vector...mouse draw		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p76()
{
        reset_vector();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_vector == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_vector = TRUE;
	    sw_draw = TRUE;
	    panel_set(pb[76],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[8],"MS DRAW",8,NULL),0);
	    msg_draw("Vector frame:");
	    return;
	   }
	if (sw_draw == TRUE)
	   {sw_draw = FALSE;
	    csw_vector = FALSE;
	    panel_set(pb[76],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[8],"ms draw",8,NULL),0);
	    info_msg("","Draw Vectors with mouse deactivated.","");
	    return;
	   }
	sw_move = FALSE;
	panel_set(pb[87],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[8],"mouse mv",9,NULL),0);
	sw_draw = TRUE;
	panel_set(pb[76],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"MS DRAW",8,NULL),0);
	msg_draw("Vector frame:");
	return;
}
/* EOF */
/* cat > src+obj/p77.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p77: p77 button - vector...copy data from another	*/
/*	tag						*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p77()
{
        register int    n;
        char            *s;
        strcpy(txt,panel_get(   pt[38],PANEL_VALUE,0));
        s = txt;
        if (*s != 'v' || *(s + 1) == '\0')
	  {strcat(txt," is not a valid vector tag.");
	   reset_vector();
	   bad_data(txt);
	   return;
	  }
        s++;
        if (FALSE == my_isint(s))
	  {strcat(txt," is not a valid vector tag.");
	   reset_vector();
	   bad_data(txt);
	   return;
	  }
        n = atoi(s);
        if (n < 0)
	  {strcat(txt," is not a valid vector tag.");
	   reset_vector();
	   bad_data(txt);
	   return;
	  }
        if (n >= N_vector)
	  {strcat(txt," is valid, but there are not that many tags.");
	   reset_vector();
	   bad_data(txt);
	   return;
	  }
	if (nv == n)
	   {reset_vector();
	    info_msg("","This vector tag already showing.","");
	    return;
	   }
	if (sw_v[0] == 0 && TRUE == confirm_vector())
	   {reset_vector();
	    panel_set(pb[77],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[8],"*",2,NULL),0);
	    sw_v[0] = 1;
	    warn_msgt();
	    return;
	   }
        if      (vec[n].sw == 0)
        	panel_set(	pb[71],PANEL_LABEL_IMAGE,
				panel_button_image(pa[8],
				"FinalPic toggle (OFF)",21,NULL),
				0);
        else
        	panel_set(	pb[71],PANEL_LABEL_IMAGE,
				panel_button_image(pa[8],
				"FinalPic toggle (ON) ",21,NULL),
				0);
        if      (vec[n].xpts == 0)
		panel_set(	pt[41],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xpts,txt);
		 panel_set(	pt[41],PANEL_VALUE,txt,0);
		}
        if      (vec[n].ypts == 0)
		panel_set(	pt[42],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].ypts,txt);
		 panel_set(	pt[42],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xpos == 0)
		panel_set(	pt[43],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xpos,txt);
		 panel_set(	pt[43],PANEL_VALUE,txt,0);
		}
        if      (vec[n].ypos == 0)
		panel_set(	pt[44],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].ypos,txt);
		 panel_set(	pt[44],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xstart == 0)
		panel_set(	pt[48],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xstart,txt);
		 panel_set(	pt[48],PANEL_VALUE,txt,0);
		}
        if      (vec[n].ystart == 0)
		panel_set(	pt[49],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].ystart,txt);
		 panel_set(	pt[49],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xend == 0)
		panel_set(	pt[50],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xend,txt);
		 panel_set(	pt[50],PANEL_VALUE,txt,0);
		}
        if      (vec[n].yend == 0)
		panel_set(	pt[51],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].yend,txt);
		 panel_set(	pt[51],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xinterval == 0)
		panel_set(	pt[52],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xinterval,txt);
		 panel_set(	pt[52],PANEL_VALUE,txt,0);
		}
        if      (vec[n].yinterval == 0)
		panel_set(	pt[53],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].yinterval,txt);
		 panel_set(	pt[53],PANEL_VALUE,txt,0);
		}
        if      (vec[n].color == 0)
		panel_set(	pt[54],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].color,txt);
		 panel_set(	pt[54],PANEL_VALUE,txt,0);
		}
        if      (vec[n].maxlen == 0)
		panel_set(	pt[55],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].maxlen,txt);
		 panel_set(	pt[55],PANEL_VALUE,txt,0);
		}
        if      (vec[n].xzero == 0)
		panel_set(	pt[45],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].xzero,txt);
		 panel_set(	pt[45],PANEL_VALUE,txt,0);
		}
        if      (vec[n].yzero == 0)
		panel_set(	pt[46],PANEL_VALUE,"",0);
        else
		{my_itoa(vec[n].yzero,txt);
		 panel_set(	pt[46],PANEL_VALUE,txt,0);
		}
        my_ftoa(vec[n].xscale,4,txt);
        panel_set(	pt[47],PANEL_VALUE,txt,0);
        my_ftoa(vec[n].yscale,4,txt);
        panel_set(	pt[56],PANEL_VALUE,txt,0);
        panel_set(	pt[39],PANEL_VALUE,vec[n].xname,0);
        panel_set(	pt[40],PANEL_VALUE,vec[n].yname,0);
	reset_vector();
	reset_mvector();
	info_msg("","Vector displayed has been copied from",
		    "another tag but has not been stored.");
        return;
}
/* EOF */
/* cat > src+obj/p78.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p78: p78 button - vector...decrement tag number by 5	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p78()
{
	if (nv == 0)
	   {reset_vector();
	    info_msg("","This vector tag already displayed.","");
	    return;
	   }
	if (sw_v[1] == 1 || FALSE == confirm_vector())
           {nv -= 5;
            if (nv < 0) nv = 0;
            p73();
	    reset_vector();
            return;
	   }
	reset_vector();
	panel_set(pb[78],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"*",2,NULL),0);
	sw_v[1] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p79.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p79: p79 button - vector...decrement tag number by 1	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p79()
{
	if (nv == 0)
	   {reset_vector();
	    info_msg("","This vector tag already displayed.","");
	    return;
	   }
	if (sw_v[2] == 1 || FALSE == confirm_vector())
           {nv--;
            p73();
	    reset_vector();
            return;
	   }
	reset_vector();
	panel_set(pb[79],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"*",1,NULL),0);
	sw_v[2] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p80.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p80: p80 button - vector...increment tag number by 1	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p80()
{
	if (nv == N_vector - 1)
	   {reset_vector();
	    info_msg("","This vector tag already displayed.","");
	    return;
	   }
	if (sw_v[3] == 1 || FALSE == confirm_vector())
           {nv++;
            p73();
	    reset_vector();
            return;
	   }
	reset_vector();
	panel_set(pb[80],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"*",1,NULL),0);
	sw_v[3] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p81.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p81: p81 button - vector...increment tag number by 5	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p81()
{
	if (nv == N_vector - 1)
	   {reset_vector();
	    info_msg("","This vector tag already displayed.","");
	    return;
	   }
	if (sw_v[4] == 1 || FALSE == confirm_vector())
           {nv += 5;
            if (nv > N_vector - 1) nv = N_vector - 1;
            p73();
	    reset_vector();
            return;
	   }
	reset_vector();
	panel_set(pb[81],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"*",2,NULL),0);
	sw_v[4] = 1;
	warn_msgt();
	return;
}
/* EOF */
/* cat > src+obj/p82.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p82: p82 button - text...mouse draw			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p82()
{
        reset_text();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_text == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_text = TRUE;
	    sw_draw = TRUE;
	    panel_set(pb[82],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[4],"MS DRAW",8,NULL),0);
	    msg_draw("Text frame:");
	    return;
	   }
	if (sw_draw == TRUE)
	   {sw_draw = FALSE;
	    csw_text = FALSE;
	    panel_set(pb[82],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[4],"ms draw",8,NULL),0);
	    info_msg("","Draw Texts with mouse deactivated.","");
	    return;
	   }
	sw_move = FALSE;
	panel_set(pb[83],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[4],"mouse mv",9,NULL),0);
	sw_draw = TRUE;
	panel_set(pb[82],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"MS DRAW",8,NULL),0);
	msg_draw("Text frame:");
	return;
}
/* EOF */
/* cat > src+obj/p83.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p83: p83 button - text...mouse move			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p83()
{
        reset_text();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_text == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_text = TRUE;
	    sw_move = TRUE;
	    panel_set(pb[83],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[4],"MOUSE MV",9,NULL),0);
	    msg_move("Text frame:");
	    return;
	   }
	if (sw_move == TRUE)
	   {sw_move = FALSE;
	    csw_text = FALSE;
	    panel_set(pb[83],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[4],"mouse mv",9,NULL),0);
	    info_msg("","Move Texts with mouse deactivated.","");
	    return;
	   }
	sw_draw = FALSE;
	panel_set(pb[82],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[4],"ms draw",8,NULL),0);
	sw_move = TRUE;
	panel_set(pb[83],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"MOUSE MV",9,NULL),0);
	msg_move("Text frame:");
	return;
}
/* EOF */
/* cat > src+obj/p84.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p84: p84 button - colorbar...mouse move		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p84()
{
        reset_colorbar();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_colorbar == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_colorbar = TRUE;
	    sw_move = TRUE;
	    panel_set(pb[84],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[3],"MOUSE MV",9,NULL),0);
	    msg_move("ColorBar frame:");
	    return;
	   }
	if (sw_move == TRUE)
	   {sw_move = FALSE;
	    csw_colorbar = FALSE;
	    panel_set(pb[84],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[3],"mouse mv",9,NULL),0);
	    info_msg("","Move ColorBar with mouse deactivated.","");
	    return;
	   }
	sw_draw = FALSE;
	panel_set(pb[28],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[3],"ms draw",8,NULL),0);
	sw_move = TRUE;
	panel_set(pb[84],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[3],"MOUSE MV",9,NULL),0);
	msg_move("ColorBar frame:");
	return;
}
/* EOF */
/* cat > src+obj/p85.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p85: p85 button - image...mouse move			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p85()
{
        reset_image();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_image == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_image = TRUE;
	    sw_move = TRUE;
	    panel_set(pb[85],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[6],"MOUSE MV",9,NULL),0);
	    msg_move("Image frame:");
	    return;
	   }
	if (sw_move == TRUE)
	   {sw_move = FALSE;
	    csw_image = FALSE;
	    panel_set(pb[85],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[6],"mouse mv",9,NULL),0);
	    info_msg("","Move Images with mouse deactivated.","");
	    return;
	   }
	sw_draw = FALSE;
	panel_set(pb[52],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[6],"ms draw",8,NULL),0);
	sw_move = TRUE;
	panel_set(pb[85],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"MOUSE MV",9,NULL),0);
	msg_move("Image frame:");
	return;
}
/* EOF */
/* cat > src+obj/p86.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p86: p86 button - contour...mouse move		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p86()
{
        reset_contour();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_contour == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_contour = TRUE;
	    sw_move = TRUE;
	    panel_set(pb[86],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[7],"MOUSE MV",9,NULL),0);
	    msg_move("Contour frame:");
	    return;
	   }
	if (sw_move == TRUE)
	   {sw_move = FALSE;
	    csw_contour = FALSE;
	    panel_set(pb[86],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[7],"mouse mv",9,NULL),0);
	    info_msg("","Move Contours with mouse deactivated.","");
	    return;
	   }
	sw_draw = FALSE;
	panel_set(pb[64],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[7],"ms draw",8,NULL),0);
	sw_move = TRUE;
	panel_set(pb[86],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"MOUSE MV",9,NULL),0);
	msg_move("Contour frame:");
	return;
}
/* EOF */
/* cat > src+obj/p87.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p87: p87 button - vector...mouse move		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p87()
{
        reset_vector();
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (csw_vector == FALSE)
	   {if (cpw_check() == TRUE)
	       return;
	    csw_vector = TRUE;
	    sw_move = TRUE;
	    panel_set(pb[87],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[8],"MOUSE MV",9,NULL),0);
	    msg_move("Vector frame:");
	    return;
	   }
	if (sw_move == TRUE)
	   {sw_move = FALSE;
	    csw_vector = FALSE;
	    panel_set(pb[87],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[8],"mouse mv",9,NULL),0);
	    info_msg("","Move Vectors with mouse deactivated.","");
	    return;
	   }
	sw_draw = FALSE;
	panel_set(pb[76],PANEL_LABEL_IMAGE,
	 	  panel_button_image(pa[8],"ms draw",8,NULL),0);
	sw_move = TRUE;
	panel_set(pb[87],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"MOUSE MV",9,NULL),0);
	msg_move("Vector frame:");
	return;
}
/* EOF */
/* cat > src+obj/p88.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p88: p88 button - feature...done			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int 
p88 ()
{
	window_destroy (pa[9]);
	window_destroy (fr[9]);
	pa[9] = fr[9] = NULL;
	panel_set (pb[10], PANEL_SHOW_ITEM, TRUE, 0);
	info_msg ("", "Features frame put away.", "");
	return;
}
/* EOF */
/* cat > src+obj/p89.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p89: p89 button - feature...draw			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p89()
{
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (0 == draw_feature(&feat[nf],nf,TRUE))
	   info_msg("","Features drawn for this tag.","");
	return;
}
/* EOF */
/* cat > src+obj/p90.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p90: p90 button - feature...erase			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p90()
{
        if (FALSE == (int)window_get(c_frame,WIN_SHOW,0))
          {info_msg("","Canvas is not up, request ignored.","");
           return;
          }
	if (0 == draw_feature(&feat[nf],nf,FALSE))
	   info_msg("","Features erased for this tag.","");
	return;
}
/* EOF */
/* cat > src+obj/p91.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p91: p91 button  - feature...x-axis select		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p91()
{
	resetb_feature();
	panel_set(pb[91],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"X-AXIS",7,NULL),0);
	nosho_feature();
	panel_set(pm[4],PANEL_LABEL_STRING,"X-AXIS",0);
	panel_set(ps[0],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[1],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[107],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[108],PANEL_SHOW_ITEM,TRUE,0);
	if (feat[nf].xax_bot == TRUE)
	   panel_set(pb[107],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"bot side ON",14,NULL),0);
	else
	   panel_set(pb[107],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"bot side OFF",14,NULL),0);
	if (feat[nf].xax_top == TRUE)
	   panel_set(pb[108],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"top side ON",14,NULL),0);
	else
	   panel_set(pb[108],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"top side OFF",14,NULL),0);
	panel_set(ps[0],PANEL_VALUE,feat[nf].xax_thick,0);
	panel_set(ps[1],PANEL_VALUE,feat[nf].xax_color,0);
	return;
}
/* EOF */
/* cat > src+obj/p92.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p92: p92 button - feature...x-axis switch		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p92()
{
	if (feat[nf].xax_sw == TRUE)
	   {feat[nf].xax_sw = FALSE;
	    panel_set(pb[92],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"OFF",3,NULL),0);
	   }
	else
	   {feat[nf].xax_sw = TRUE;
	    panel_set(pb[92],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"ON",3,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/p93.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p93: p93 button - feature...y-axis select		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p93()
{
        resetb_feature();
        panel_set(pb[93],PANEL_LABEL_IMAGE,
                  panel_button_image(pa[9],"Y-AXIS",7,NULL),0);
        nosho_feature();
        panel_set(pm[4],PANEL_LABEL_STRING,"Y-AXIS",0);
        panel_set(ps[0],PANEL_SHOW_ITEM,TRUE,0);
        panel_set(ps[1],PANEL_SHOW_ITEM,TRUE,0);
        panel_set(pb[107],PANEL_SHOW_ITEM,TRUE,0);
        panel_set(pb[108],PANEL_SHOW_ITEM,TRUE,0);
        if (feat[nf].yax_left == TRUE)
           panel_set(pb[107],PANEL_LABEL_IMAGE,
                     panel_button_image(pa[9],"left side ON",14,NULL),0);
        else
           panel_set(pb[107],PANEL_LABEL_IMAGE,
                     panel_button_image(pa[9],"left side OFF",14,NULL),0);
        if (feat[nf].yax_right == TRUE)
           panel_set(pb[108],PANEL_LABEL_IMAGE,
                     panel_button_image(pa[9],"right side ON",14,NULL),0);
        else
           panel_set(pb[108],PANEL_LABEL_IMAGE,
                     panel_button_image(pa[9],"right side OFF",14,NULL),0);
        panel_set(ps[0],PANEL_VALUE,feat[nf].yax_thick,0);
        panel_set(ps[1],PANEL_VALUE,feat[nf].yax_color,0);
	return;
}
/* EOF */
/* cat > src+obj/p94.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p94: p94 button - feature...y-axis switch		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p94()
{
	if (feat[nf].yax_sw == TRUE)
	   {feat[nf].yax_sw = FALSE;
	    panel_set(pb[94],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"OFF",3,NULL),0);
	   }
	else
	   {feat[nf].yax_sw = TRUE;
	    panel_set(pb[94],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"ON",3,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/p95.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p95: p95 button - feature...x-grid select		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p95()
{
	resetb_feature();
	panel_set(pb[95],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"X-GRID",7,NULL),0);
	nosho_feature();
	panel_set(pm[4],PANEL_LABEL_STRING,"X-GRID",0);
	panel_set(ps[0],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[1],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[2],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[0],PANEL_VALUE,feat[nf].xgr_thick,0);
	panel_set(ps[1],PANEL_VALUE,feat[nf].xgr_color,0);
	panel_set(ps[2],PANEL_VALUE,feat[nf].xgr_space,0);
	return;
}
/* EOF */
/* cat > src+obj/p96.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p96: p96 button - feature...x-grid switch		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p96()
{
	if (feat[nf].xgr_sw == TRUE)
	   {feat[nf].xgr_sw = FALSE;
	    panel_set(pb[96],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"OFF",3,NULL),0);
	   }
	else
	   {feat[nf].xgr_sw = TRUE;
	    panel_set(pb[96],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"ON",3,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/p97.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p97: p97 button - feature...y-grid select		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p97()
{
	resetb_feature();
	panel_set(pb[97],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"Y-GRID",7,NULL),0);
	nosho_feature();
	panel_set(pm[4],PANEL_LABEL_STRING,"Y-GRID",0);
	panel_set(ps[0],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[1],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[2],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[0],PANEL_VALUE,feat[nf].ygr_thick,0);
	panel_set(ps[1],PANEL_VALUE,feat[nf].ygr_color,0);
	panel_set(ps[2],PANEL_VALUE,feat[nf].ygr_space,0);
	return;
}
/* EOF */
/* cat > src+obj/p98.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p98: p98 button - feature...y-grid switch		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p98()
{
	if (feat[nf].ygr_sw == TRUE)
	   {feat[nf].ygr_sw = FALSE;
	    panel_set(pb[98],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"OFF",3,NULL),0);
	   }
	else
	   {feat[nf].ygr_sw = TRUE;
	    panel_set(pb[98],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"ON",3,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/p99.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p99: p99 button - feature...x-ticks1 select		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p99()
{
	resetb_feature();
	panel_set(pb[99],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"X-TIC1",7,NULL),0);
	nosho_feature();
	panel_set(pm[4],PANEL_LABEL_STRING,"X-TIC1",0);
	panel_set(ps[0],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[1],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[2],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[3],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[110],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[111],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[112],PANEL_SHOW_ITEM,TRUE,0);
	if (feat[nf].xt1_bot == TRUE)
	   panel_set(pb[111],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"bot side ON",14,NULL),0);
	else
	   panel_set(pb[111],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"bot side OFF",14,NULL),0);
	if (feat[nf].xt1_top == TRUE)
	   panel_set(pb[112],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"top side ON",14,NULL),0);
	else
	   panel_set(pb[112],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"top side OFF",14,NULL),0);
	if (feat[nf].xt1_direc == TRUE)
	   panel_set(pb[110],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"now OUT",7,NULL),0);
	else
	   panel_set(pb[110],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"now IN",7,NULL),0);
	panel_set(ps[0],PANEL_VALUE,feat[nf].xt1_thick,0);
	panel_set(ps[1],PANEL_VALUE,feat[nf].xt1_color,0);
	panel_set(ps[2],PANEL_VALUE,feat[nf].xt1_space,0);
	panel_set(ps[3],PANEL_VALUE,feat[nf].xt1_len,0);
	return;
}
/* EOF */
/* cat > src+obj/p100.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p100: p100 button - feature...x-ticks1 switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p100()
{
	if (feat[nf].xt1_sw == TRUE)
	   {feat[nf].xt1_sw = FALSE;
	    panel_set(pb[100],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"OFF",3,NULL),0);
	   }
	else
	   {feat[nf].xt1_sw = TRUE;
	    panel_set(pb[100],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"ON",3,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/p101.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p101: p101 button - feature...y-ticks1 select	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p101()
{
	resetb_feature();
	panel_set(pb[101],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"Y-TIC1",7,NULL),0);
	nosho_feature();
	panel_set(pm[4],PANEL_LABEL_STRING,"Y-TIC1",0);
	panel_set(ps[0],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[1],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[2],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[3],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[110],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[111],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[112],PANEL_SHOW_ITEM,TRUE,0);
	if (feat[nf].yt1_left == TRUE)
	   panel_set(pb[111],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"left side ON",14,NULL),0);
	else
	   panel_set(pb[111],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"left side OFF",14,NULL),0);
	if (feat[nf].yt1_right == TRUE)
	   panel_set(pb[112],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"right side ON",14,NULL),0);
	else
	   panel_set(pb[112],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"right side OFF",14,NULL),0);
	if (feat[nf].yt1_direc == TRUE)
	   panel_set(pb[110],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"now OUT",7,NULL),0);
	else
	   panel_set(pb[110],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"now IN",7,NULL),0);
	panel_set(ps[0],PANEL_VALUE,feat[nf].yt1_thick,0);
	panel_set(ps[1],PANEL_VALUE,feat[nf].yt1_color,0);
	panel_set(ps[2],PANEL_VALUE,feat[nf].yt1_space,0);
	panel_set(ps[3],PANEL_VALUE,feat[nf].yt1_len,0);
	return;
}
/* EOF */
/* cat > src+obj/p102.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p102: p102 button - feature...y-ticks1 switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p102()
{
	if (feat[nf].yt1_sw == TRUE)
	   {feat[nf].yt1_sw = FALSE;
	    panel_set(pb[102],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"OFF",3,NULL),0);
	   }
	else
	   {feat[nf].yt1_sw = TRUE;
	    panel_set(pb[102],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"ON",3,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/p103.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p103: p103 button - feature...x-tick2 select		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p103()
{
	resetb_feature();
	panel_set(pb[103],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"X-TIC2",7,NULL),0);
	nosho_feature();
	panel_set(pm[4],PANEL_LABEL_STRING,"X-TIC2",0);
	panel_set(ps[0],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[1],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[2],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[3],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[110],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[111],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[112],PANEL_SHOW_ITEM,TRUE,0);
	if (feat[nf].xt2_bot == TRUE)
	   panel_set(pb[111],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"bot side ON",14,NULL),0);
	else
	   panel_set(pb[111],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"bot side OFF",14,NULL),0);
	if (feat[nf].xt2_top == TRUE)
	   panel_set(pb[112],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"top side ON",14,NULL),0);
	else
	   panel_set(pb[112],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"top side OFF",14,NULL),0);
	if (feat[nf].xt2_direc == TRUE)
	   panel_set(pb[110],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"now OUT",7,NULL),0);
	else
	   panel_set(pb[110],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"now IN",7,NULL),0);
	panel_set(ps[0],PANEL_VALUE,feat[nf].xt2_thick,0);
	panel_set(ps[1],PANEL_VALUE,feat[nf].xt2_color,0);
	panel_set(ps[2],PANEL_VALUE,feat[nf].xt2_space,0);
	panel_set(ps[3],PANEL_VALUE,feat[nf].xt2_len,0);
	return;
}
/* EOF */
/* cat > src+obj/p104.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p104: p104 button - feature...x-ticks2 switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p104()
{
	if (feat[nf].xt2_sw == TRUE)
	   {feat[nf].xt2_sw = FALSE;
	    panel_set(pb[104],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"OFF",3,NULL),0);
	   }
	else
	   {feat[nf].xt2_sw = TRUE;
	    panel_set(pb[104],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"ON",3,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/p105.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p105: p105 button - feature...y-ticks2 select	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p105()
{
	resetb_feature();
	panel_set(pb[105],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"Y-TIC2",7,NULL),0);
	nosho_feature();
	panel_set(pm[4],PANEL_LABEL_STRING,"Y-TIC2",0);
	panel_set(ps[0],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[1],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[2],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(ps[3],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[110],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[111],PANEL_SHOW_ITEM,TRUE,0);
	panel_set(pb[112],PANEL_SHOW_ITEM,TRUE,0);
	if (feat[nf].yt2_left == TRUE)
	   panel_set(pb[111],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"left side ON",14,NULL),0);
	else
	   panel_set(pb[111],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"left side OFF",14,NULL),0);
	if (feat[nf].yt2_right == TRUE)
	   panel_set(pb[112],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"right side ON",14,NULL),0);
	else
	   panel_set(pb[112],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"right side OFF",14,NULL),0);
	if (feat[nf].yt2_direc == TRUE)
	   panel_set(pb[110],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"now OUT",7,NULL),0);
	else
	   panel_set(pb[110],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"now IN",7,NULL),0);
	panel_set(ps[0],PANEL_VALUE,feat[nf].yt2_thick,0);
	panel_set(ps[1],PANEL_VALUE,feat[nf].yt2_color,0);
	panel_set(ps[2],PANEL_VALUE,feat[nf].yt2_space,0);
	panel_set(ps[3],PANEL_VALUE,feat[nf].yt2_len,0);
	return;
}
/* EOF */
/* cat > src+obj/p106.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p106: p106 button - feature...y-ticks2 switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p106()
{
	if (feat[nf].yt2_sw == TRUE)
	   {feat[nf].yt2_sw = FALSE;
	    panel_set(pb[106],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"OFF",3,NULL),0);
	   }
	else
	   {feat[nf].yt2_sw = TRUE;
	    panel_set(pb[106],PANEL_LABEL_IMAGE,
		      panel_button_image(pa[9],"ON",3,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/p107.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p107: p107 button - feature...axis left side switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p107()
{
	char		c[8];
	strcpy(c,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if (strcmp(c,"X-AXIS") == 0)
	   {if (feat[nf].xax_bot == FALSE)
	       {feat[nf].xax_bot = TRUE;
		panel_set(pb[107],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"bot side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].xax_bot = FALSE; 
                panel_set(pb[107],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"bot side OFF",14,NULL),0); 
               }
	   }
	else if (strcmp(c,"Y-AXIS") == 0)
	   {if (feat[nf].yax_left == FALSE)
	       {feat[nf].yax_left = TRUE;
		panel_set(pb[107],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"left side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].yax_left = FALSE; 
                panel_set(pb[107],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"left side OFF",14,NULL),0); 
               }
	   }
	else
	   bad_data("It is not possible to get this feature error message, p107");
	return;
}
/* EOF */
/* cat > src+obj/p108.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p108: p108 button - feature...axis right side switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p108()
{
	char		c[8];
	strcpy(c,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if (strcmp(c,"X-AXIS") == 0)
	   {if (feat[nf].xax_top == FALSE)
	       {feat[nf].xax_top = TRUE;
		panel_set(pb[108],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"top side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].xax_top = FALSE; 
                panel_set(pb[108],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"top side OFF",14,NULL),0); 
               }
	   }
	else if (strcmp(c,"Y-AXIS") == 0)
	   {if (feat[nf].yax_right == FALSE)
	       {feat[nf].yax_right = TRUE;
		panel_set(pb[108],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"right side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].yax_right = FALSE; 
                panel_set(pb[108],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"right side OFF",14,NULL),0); 
               }
	   }
	else
	   bad_data("It is not possible to get this feature error message, p108");
	return;
}
/* EOF */
/* cat > src+obj/p109.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p109: p109 button - feature...specify tag		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p109()
{
	char		c[10],
			*s,*t;
	register int	n;
	strcpy(c,panel_get(pt[57],PANEL_VALUE,0));
	s = c;
	if (*s == '\0')
	   {bad_data("No tag given, request ignored.");
	    return;
	   }
	if (*s != 'i' && *s != 'c' && *s != 'v')
	   {strcpy(txt,c);
	    strcat(txt,":  does not begin with i, c, or v, request ignored.");
	    bad_data(txt);
	    panel_set(pt[57],PANEL_VALUE,"",0);
	    return;
	   }
	s++;
	if (FALSE == my_isint(s))
	   {strcpy(txt,c);
	  strcat(txt,": first letter ok, but remainder not integer, request ignored.");
	    bad_data(txt);
	    panel_set(pt[57],PANEL_VALUE,"",0);
	    return;
	   }
	n = atoi(s);
	if (n < 0)
	   {strcpy(txt,c);
	    strcat(txt,": first letter ok, but remainder < 0, request ignored.");
	    bad_data(txt);
	    panel_set(pt[57],PANEL_VALUE,"",0);
	    return;
	   }
	if (*c == 'i' && n >= N_image)
	   {strcpy(txt,c);
	    strcat(txt,":  not that many image tags, request ignored.");
	    bad_data(txt);
	    panel_set(pt[57],PANEL_VALUE,"",0);
	    return;
	   }
	if (*c == 'c' && n >= N_contour)
	   {strcpy(txt,c);
	    strcat(txt,":  not that many contour tags, request ignored.");
	    bad_data(txt);
	    panel_set(pt[57],PANEL_VALUE,"",0);
	    return;
	   }
	if (*c == 'v' && n >= N_vector)
	   {strcpy(txt,c);
	    strcat(txt,":  not that many vector tags, request ignored.");
	    bad_data(txt);
	    panel_set(pt[57],PANEL_VALUE,"",0);
	    return;
	   }
	if	(*c == 'i')	nf = n;
	else if (*c == 'c')	nf = N_image + n;
	else			nf = N_image + N_contour + n;
	strcpy(txt,window_get(fr[9],FRAME_LABEL,0));
	t = txt;
	while (*t) t++;
	while (*t != '\'') t--;
	t--;
	while (*t != '\'') t--;
	t++;
	s = c;
	while (*s) *t++ = *s++;
	*t++ = '\'';
	*t++ = ')';
	*t = '\0';
	window_set(fr[9],FRAME_LABEL,txt,0);
	panel_set(pt[57],PANEL_VALUE,"",0);
	p91();
	info_msg("","Feature tag selected.","");
	return;
}
/* EOF */
/* cat > src+obj/p110.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p110: p110 button - feature...ticks in or out	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p110()
{
	char		c[8];
	strcpy(c,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if (strcmp(c,"X-TIC1") == 0)
	   {if (feat[nf].xt1_direc == FALSE)
	       {feat[nf].xt1_direc = TRUE;
		panel_set(pb[110],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"now OUT",7,NULL),0);
	       }
	    else
	       {feat[nf].xt1_direc = FALSE; 
                panel_set(pb[110],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"now IN",7,NULL),0); 
               }
	   }
	else if (strcmp(c,"Y-TIC1") == 0)
	   {if (feat[nf].yt1_direc == FALSE)
	       {feat[nf].yt1_direc = TRUE;
		panel_set(pb[110],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"now OUT",7,NULL),0);
	       }
	    else
	       {feat[nf].yt1_direc = FALSE; 
                panel_set(pb[110],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"now IN",7,NULL),0); 
               }
	   }
	else if (strcmp(c,"X-TIC2") == 0)
	   {if (feat[nf].xt2_direc == FALSE)
	       {feat[nf].xt2_direc = TRUE;
		panel_set(pb[110],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"now OUT",7,NULL),0);
	       }
	    else
	       {feat[nf].xt2_direc = FALSE; 
                panel_set(pb[110],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"now IN",7,NULL),0); 
               }
	   }
	else if (strcmp(c,"Y-TIC2") == 0)
	   {if (feat[nf].yt2_direc == FALSE)
	       {feat[nf].yt2_direc = TRUE;
		panel_set(pb[110],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"now OUT",7,NULL),0);
	       }
	    else
	       {feat[nf].yt2_direc = FALSE; 
                panel_set(pb[110],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"now IN",7,NULL),0); 
               }
	   }
	else
	   bad_data("It is not possible to get this feature error message, p110");
	return;
}
/* EOF */
/* cat > src+obj/p111.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p111: p111 button - feature...ticks on left/bot	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p111()
{
	char		c[8];
	strcpy(c,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if (strcmp(c,"X-TIC1") == 0)
	   {if (feat[nf].xt1_bot == FALSE)
	       {feat[nf].xt1_bot = TRUE;
		panel_set(pb[111],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"bot side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].xt1_bot = FALSE; 
                panel_set(pb[111],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"bot side OFF",14,NULL),0); 
               }
	   }
	else if (strcmp(c,"Y-TIC1") == 0)
	   {if (feat[nf].yt1_left == FALSE)
	       {feat[nf].yt1_left = TRUE;
		panel_set(pb[111],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"left side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].yt1_left = FALSE; 
                panel_set(pb[111],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"left side OFF",14,NULL),0); 
               }
	   }
	else if (strcmp(c,"X-TIC2") == 0)
	   {if (feat[nf].xt2_bot == FALSE)
	       {feat[nf].xt2_bot = TRUE;
		panel_set(pb[111],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"bot side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].xt2_bot = FALSE; 
                panel_set(pb[111],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"bot side OFF",14,NULL),0); 
               }
	   }
	else if (strcmp(c,"Y-TIC2") == 0)
	   {if (feat[nf].yt2_left == FALSE)
	       {feat[nf].yt2_left = TRUE;
		panel_set(pb[111],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"left side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].yt2_left = FALSE; 
                panel_set(pb[111],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"left side OFF",14,NULL),0); 
               }
	   }
	else
	   bad_data("It is not possible to get this feature error message, p111");
	return;
}
/* EOF */
/* cat > src+obj/p112.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p112: p112 button - feature...ticks on right/top	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p112()
{
	char		c[8];
	strcpy(c,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if (strcmp(c,"X-TIC1") == 0)
	   {if (feat[nf].xt1_top == FALSE)
	       {feat[nf].xt1_top = TRUE;
		panel_set(pb[112],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"top side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].xt1_top = FALSE; 
                panel_set(pb[112],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"top side OFF",14,NULL),0); 
               }
	   }
	else if (strcmp(c,"Y-TIC1") == 0)
	   {if (feat[nf].yt1_right == FALSE)
	       {feat[nf].yt1_right = TRUE;
		panel_set(pb[112],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"right side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].yt1_right = FALSE; 
                panel_set(pb[112],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"right side OFF",14,NULL),0); 
               }
	   }
	else if (strcmp(c,"X-TIC2") == 0)
	   {if (feat[nf].xt2_top == FALSE)
	       {feat[nf].xt2_top = TRUE;
		panel_set(pb[112],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"top side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].xt2_top = FALSE; 
                panel_set(pb[112],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"top side OFF",14,NULL),0); 
               }
	   }
	else if (strcmp(c,"Y-TIC2") == 0)
	   {if (feat[nf].yt2_right == FALSE)
	       {feat[nf].yt2_right = TRUE;
		panel_set(pb[112],PANEL_LABEL_IMAGE,
			  panel_button_image(pa[9],"right side ON",14,NULL),0);
	       }
	    else
	       {feat[nf].yt2_right = FALSE; 
                panel_set(pb[112],PANEL_LABEL_IMAGE, 
                          panel_button_image(pa[9],"right side OFF",14,NULL),0); 
               }
	   }
	else
	   bad_data("It is not possible to get this feature error message, p112");
	return;
}
/* EOF */
/* cat > src+obj/p113.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p113: p113 button - feature...copy from another tag	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p113()
{
        char            c[8],
			d[8],
                        *s;
        register int    n;
        strcpy(c,panel_get(pt[58],PANEL_VALUE,0));
	strcpy(d,panel_get(pm[3],PANEL_LABEL_STRING,0));
        s = c;
	if (*s == '\0')
	   {bad_data("No tag given, request ignored.");
	    return;
	   }
        if (*s != 'i' && *s != 'c' && *s != 'v')
           {strcpy(txt,c);
            strcat(txt,":  does not begin with i, c, or v, copy request ignored.");
            bad_data(txt);
            panel_set(pt[58],PANEL_VALUE,"",0);
            return;
           }
        s++;
        if (FALSE == my_isint(s))
           {strcpy(txt,c);
          strcat(txt,": first letter ok, but remainder not integer, copy request ignored.");
            bad_data(txt);
            panel_set(pt[58],PANEL_VALUE,"",0);
            return;
           }
        n = atoi(s);
        if (n < 0)
           {strcpy(txt,c);
            strcat(txt,": first letter ok, but remainder < 0, copy request ignored.");
            bad_data(txt);
            panel_set(pt[58],PANEL_VALUE,"",0);
            return;
           }
        if (*c == 'i' && n >= N_image)
           {strcpy(txt,c);
            strcat(txt,":  not that many image tags, copy request ignored.");
            bad_data(txt);
            panel_set(pt[58],PANEL_VALUE,"",0);
            return;
           }
        if (*c == 'c' && n >= N_contour)
           {strcpy(txt,c);
            strcat(txt,":  not that many contour tags, copy request ignored.");
            bad_data(txt);
            panel_set(pt[58],PANEL_VALUE,"",0);
            return;
           }
        if (*c == 'v' && n >= N_vector)
           {strcpy(txt,c);
            strcat(txt,":  not that many vector tags, copy request ignored.");
            bad_data(txt);
            panel_set(pt[58],PANEL_VALUE,"",0);
            return;
           }
        if	(*c == 'c')     n = N_image + n;
        else if	(*c == 'v')	n = N_image + N_contour + n;
	else;

	feat[nf].xax_sw		= feat[n].xax_sw;
	feat[nf].xax_thick	= feat[n].xax_thick;
	feat[nf].xax_color	= feat[n].xax_color;
	feat[nf].xax_bot	= feat[n].xax_bot;
	feat[nf].xax_top	= feat[n].xax_top;
	feat[nf].yax_sw		= feat[n].yax_sw;
	feat[nf].yax_thick	= feat[n].yax_thick;
	feat[nf].yax_color	= feat[n].yax_color;
	feat[nf].yax_left	= feat[n].yax_left;
	feat[nf].yax_right	= feat[n].yax_right;

	feat[nf].xgr_sw		= feat[n].xgr_sw;
	feat[nf].xgr_thick	= feat[n].xgr_thick;
	feat[nf].xgr_color	= feat[n].xgr_color;
	feat[nf].xgr_space	= feat[n].xgr_space;
	feat[nf].ygr_sw		= feat[n].ygr_sw;
	feat[nf].ygr_thick	= feat[n].ygr_thick;
	feat[nf].ygr_color	= feat[n].ygr_color;
	feat[nf].ygr_space	= feat[n].ygr_space;

	feat[nf].xt1_sw		= feat[n].xt1_sw;
	feat[nf].xt1_thick	= feat[n].xt1_thick;
	feat[nf].xt1_color	= feat[n].xt1_color;
	feat[nf].xt1_bot	= feat[n].xt1_bot;
	feat[nf].xt1_top	= feat[n].xt1_top;
	feat[nf].xt1_space	= feat[n].xt1_space;
	feat[nf].xt1_direc	= feat[n].xt1_direc;
	feat[nf].yt1_sw		= feat[n].yt1_sw;
	feat[nf].yt1_thick	= feat[n].yt1_thick;
	feat[nf].yt1_color	= feat[n].yt1_color;
	feat[nf].yt1_left	= feat[n].yt1_left;
	feat[nf].yt1_right	= feat[n].yt1_right;
	feat[nf].yt1_space	= feat[n].yt1_space;
	feat[nf].yt1_direc	= feat[n].yt1_direc;

	feat[nf].xt2_sw		= feat[n].xt2_sw;
	feat[nf].xt2_thick	= feat[n].xt2_thick;
	feat[nf].xt2_color	= feat[n].xt2_color;
	feat[nf].xt2_bot	= feat[n].xt2_bot;
	feat[nf].xt2_top	= feat[n].xt2_top;
	feat[nf].xt2_space	= feat[n].xt2_space;
	feat[nf].xt2_direc	= feat[n].xt2_direc;
	feat[nf].yt2_sw		= feat[n].yt2_sw;
	feat[nf].yt2_thick	= feat[n].yt2_thick;
	feat[nf].yt2_color	= feat[n].yt2_color;
	feat[nf].yt2_left	= feat[n].yt2_left;
	feat[nf].yt2_right	= feat[n].yt2_right;
	feat[nf].yt2_space	= feat[n].yt2_space;
	feat[nf].yt2_direc	= feat[n].yt2_direc;

	if	(strcmp(d,"X-AXIS") == 0) p91();
	else if	(strcmp(d,"Y-AXIS") == 0) p93();
	else if	(strcmp(d,"X-GRID") == 0) p95();
	else if	(strcmp(d,"Y-GRID") == 0) p97();
	else if	(strcmp(d,"X-TIC1") == 0) p99();
	else if	(strcmp(d,"Y-TIC1") == 0) p101();
	else if	(strcmp(d,"X-TIC2") == 0) p103();
	else if	(strcmp(d,"Y-TIC2") == 0) p105();
	else
	   {bad_data("It is not possible to get this feature error message, p113");
	    return;
	   }

        panel_set(pt[58],PANEL_VALUE,"",0);
	strcpy(txt,"Current feature tag data copied from feature tag ");
	strcat(txt,c);
        info_msg("",txt,"");
	return;
}
/* EOF */
/* cat > src+obj/p114.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p114: p114 button - feature...all features on	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p114()
{
	feat[nf].xax_sw = TRUE;
	feat[nf].yax_sw = TRUE;
	feat[nf].xgr_sw = TRUE;
	feat[nf].ygr_sw = TRUE;
	feat[nf].xt1_sw = TRUE;
	feat[nf].yt1_sw = TRUE;
	feat[nf].xt2_sw = TRUE;
	feat[nf].yt2_sw = TRUE;
	panel_set(pb[92],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"ON",3,NULL),0);
	panel_set(pb[94],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"ON",3,NULL),0);
	panel_set(pb[96],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"ON",3,NULL),0);
	panel_set(pb[98],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"ON",3,NULL),0);
	panel_set(pb[100],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"ON",3,NULL),0);
	panel_set(pb[102],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"ON",3,NULL),0);
	panel_set(pb[104],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"ON",3,NULL),0);
	panel_set(pb[106],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"ON",3,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/p115.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* p115: p115 button - feature...all features off	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	p115()
{
	feat[nf].xax_sw = FALSE;
	feat[nf].yax_sw = FALSE;
	feat[nf].xgr_sw = FALSE;
	feat[nf].ygr_sw = FALSE;
	feat[nf].xt1_sw = FALSE;
	feat[nf].yt1_sw = FALSE;
	feat[nf].xt2_sw = FALSE;
	feat[nf].yt2_sw = FALSE;
	panel_set(pb[92],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"OFF",3,NULL),0);
	panel_set(pb[94],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"OFF",3,NULL),0);
	panel_set(pb[96],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"OFF",3,NULL),0);
	panel_set(pb[98],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"OFF",3,NULL),0);
	panel_set(pb[100],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"OFF",3,NULL),0);
	panel_set(pb[102],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"OFF",3,NULL),0);
	panel_set(pb[104],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"OFF",3,NULL),0);
	panel_set(pb[106],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"OFF",3,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/reset_colorbar.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_colorbar: reset the colorbar "Done" button and	*/
/*		   switch				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_colorbar()
{
	sw_colorbar = 0;
	panel_set(pb[22],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[3],"Done",7,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/reset_contour.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_contour: reset the change contour buttons and	*/
/*		  switches				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_contour()
{
	sw_contour = 0;
	panel_set(pb[58],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"Done",7,NULL),0);
	sw_c[0] = sw_c[1] = sw_c[2] = sw_c[3] = sw_c[4] = 0;
	panel_set(pb[66],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"-5",2,NULL),0);
	panel_set(pb[67],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"-",1,NULL),0);
	panel_set(pb[68],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"+",1,NULL),0);
	panel_set(pb[69],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"+5",2,NULL),0);
	panel_set(pb[65],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7]," ",2,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/reset_grid.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_grid: reset the grid "Done" button and switch	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_grid()
{
	sw_grid = 0;
	panel_set(pb[16],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[2],"Done",7,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/reset_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_image: reset the change image buttons and	*/
/*		switches				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_image()
{
	sw_image = 0;
	panel_set(pb[46],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"Done",7,NULL),0);
	sw_i[0] = sw_i[1] = sw_i[2] = sw_i[3] = sw_i[4] = 0;
	panel_set(pb[54],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"-5",2,NULL),0);
	panel_set(pb[55],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"-",1,NULL),0);
	panel_set(pb[56],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"+",1,NULL),0);
	panel_set(pb[57],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"+5",2,NULL),0);
	panel_set(pb[53],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6]," ",2,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/reset_mcolorbar.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_mcolorbar: reset the colorbar draw & move	*/
/*		    buttons and switches		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_mcolorbar()
{
	if (csw_colorbar == TRUE)
	   {csw_colorbar = FALSE;
	    sw_draw	 = FALSE;
	    sw_move	 = FALSE;
	   }
	if (TRUE == (int)window_get(fr[3],WIN_SHOW,TRUE,0))
	   {panel_set(pb[28],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[3],"ms draw",8,NULL),0);
	    panel_set(pb[84],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[3],"mouse mv",9,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/reset_mcontour.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_mcontour: reset the contour draw & move	*/
/*		   buttons and switches			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_mcontour()
{
	if (csw_contour == TRUE)
	   {csw_contour = FALSE;
	    sw_draw	= FALSE;
	    sw_move	= FALSE;
	   }
	if (TRUE == (int)window_get(fr[7],WIN_SHOW,TRUE,0))
	   {panel_set(pb[64],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"ms draw",8,NULL),0);
	    panel_set(pb[86],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[7],"mouse mv",9,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/reset_mimage.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_mimage: reset the image draw & move buttons	*/
/*		 and switches				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_mimage()
{
	if (csw_image  == TRUE)
	   {csw_image	= FALSE;
	    sw_draw	= FALSE;
	    sw_move	= FALSE;
	   }
	if (TRUE == (int)window_get(fr[6],WIN_SHOW,TRUE,0))
	   {panel_set(pb[52],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"ms draw",8,NULL),0);
	    panel_set(pb[85],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[6],"mouse mv",9,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/reset_mtext.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_mtext: reset the text draw & move buttons and	*/
/*		switches				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_mtext()
{
	if (csw_text   == TRUE)
	   {csw_text	= FALSE;
	    sw_draw	= FALSE;
	    sw_move	= FALSE;
	   }
	if (TRUE == (int)window_get(fr[4],WIN_SHOW,TRUE,0))
	   {panel_set(pb[82],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"ms draw",8,NULL),0);
	    panel_set(pb[83],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"mouse mv",9,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/reset_mvector.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_mvector: reset the vector draw & move buttons	*/
/*		  and switches				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_mvector()
{
	if (csw_vector == TRUE)
	   {csw_vector	= FALSE;
	    sw_draw	= FALSE;
	    sw_move	= FALSE;
	   }
	if (TRUE == (int)window_get(fr[8],WIN_SHOW,TRUE,0))
	   {panel_set(pb[76],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"ms draw",8,NULL),0);
	    panel_set(pb[87],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"mouse mv",9,NULL),0);
	   }
	return;
}
/* EOF */
/* cat > src+obj/reset_palette.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_palette: reset the palette "Done" button and	*/
/*		  switch				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_palette()
{
	sw_palette = 0;
	panel_set(pb[13],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[1],"Done",7,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/reset_text.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_text: reset the change text buttons and	*/
/*	       switches					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_text()
{
	sw_text = 0;
	panel_set(pb[30],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"Done",7,NULL),0);
	sw_t[0] = sw_t[1] = sw_t[2] = sw_t[3] = sw_t[4] = 0;
	panel_set(pb[37],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"-5",2,NULL),0);
	panel_set(pb[38],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"-",1,NULL),0);
	panel_set(pb[39],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"+",1,NULL),0);
	panel_set(pb[40],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4],"+5",2,NULL),0);
	panel_set(pb[36],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[4]," ",2,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/reset_vector.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_vector: reset the change vector buttons and	*/
/*		 switches				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	reset_vector()
{
	sw_vector = 0;
	panel_set(pb[70],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"Done",7,NULL),0);
	sw_v[0] = sw_v[1] = sw_v[2] = sw_v[3] = sw_v[4] = 0;
	panel_set(pb[78],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"-5",2,NULL),0);
	panel_set(pb[79],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"-",1,NULL),0);
	panel_set(pb[80],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"+",1,NULL),0);
	panel_set(pb[81],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8],"+5",2,NULL),0);
	panel_set(pb[77],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[8]," ",2,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/resetb_feature.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* resetb_feature: reset the feature buttons		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	resetb_feature()
{
	panel_set(pb[91],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"x-axis",7,NULL),0);
	panel_set(pb[93],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"y-axis",7,NULL),0);
	panel_set(pb[95],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"x-grid",7,NULL),0);
	panel_set(pb[97],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"y-grid",7,NULL),0);
	panel_set(pb[99],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"x-tic1",7,NULL),0);
	panel_set(pb[101],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"y-tic1",7,NULL),0);
	panel_set(pb[103],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"x-tic2",7,NULL),0);
	panel_set(pb[105],PANEL_LABEL_IMAGE,
		  panel_button_image(pa[9],"y-tic2",7,NULL),0);
	if (feat[nf].xax_sw == FALSE)
	   panel_set(pb[92],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"OFF",3,NULL),0);
	else
	   panel_set(pb[92],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"ON",3,NULL),0);
	if (feat[nf].yax_sw == FALSE)
	   panel_set(pb[94],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"OFF",3,NULL),0);
	else
	   panel_set(pb[94],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"ON",3,NULL),0);
	if (feat[nf].xgr_sw == FALSE)
	   panel_set(pb[96],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"OFF",3,NULL),0);
	else
	   panel_set(pb[96],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"ON",3,NULL),0);
	if (feat[nf].ygr_sw == FALSE)
	   panel_set(pb[98],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"OFF",3,NULL),0);
	else
	   panel_set(pb[98],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"ON",3,NULL),0);
	if (feat[nf].xt1_sw == FALSE)
	   panel_set(pb[100],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"OFF",3,NULL),0);
	else
	   panel_set(pb[100],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"ON",3,NULL),0);
	if (feat[nf].yt1_sw == FALSE)
	   panel_set(pb[102],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"OFF",3,NULL),0);
	else
	   panel_set(pb[102],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"ON",3,NULL),0);
	if (feat[nf].xt2_sw == FALSE)
	   panel_set(pb[104],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"OFF",3,NULL),0);
	else
	   panel_set(pb[104],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"ON",3,NULL),0);
	if (feat[nf].yt2_sw == FALSE)
	   panel_set(pb[106],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"OFF",3,NULL),0);
	else
	   panel_set(pb[106],PANEL_LABEL_IMAGE,
		     panel_button_image(pa[9],"ON",3,NULL),0);
	return;
}
/* EOF */
/* cat > src+obj/s0.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* s0: s0 slider - feature...specify thickness		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	s0()
{
	strcpy(txt,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if	(strcmp(txt,"X-AXIS") == 0)
	   feat[nf].xax_thick = (int)panel_get(ps[0],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-AXIS") == 0)
	   feat[nf].yax_thick = (int)panel_get(ps[0],PANEL_VALUE,0);
	else if (strcmp(txt,"X-GRID") == 0)
	   feat[nf].xgr_thick = (int)panel_get(ps[0],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-GRID") == 0)
	   feat[nf].ygr_thick = (int)panel_get(ps[0],PANEL_VALUE,0);
	else if (strcmp(txt,"X-TIC1") == 0)
	   feat[nf].xt1_thick = (int)panel_get(ps[0],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-TIC1") == 0)
	   feat[nf].yt1_thick = (int)panel_get(ps[0],PANEL_VALUE,0);
	else if (strcmp(txt,"X-TIC2") == 0)
	   feat[nf].xt2_thick = (int)panel_get(ps[0],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-TIC2") == 0)
	   feat[nf].yt2_thick = (int)panel_get(ps[0],PANEL_VALUE,0);
	else
	   bad_data("This feature error message for thickness is not possible.");
	return;
}
/* EOF */
/* cat > src+obj/s1.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* s1: s1 slider - feature...specify color		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	s1()
{
	strcpy(txt,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if	(strcmp(txt,"X-AXIS") == 0)
	   feat[nf].xax_color = (int)panel_get(ps[1],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-AXIS") == 0)
	   feat[nf].yax_color = (int)panel_get(ps[1],PANEL_VALUE,0);
	else if (strcmp(txt,"X-GRID") == 0)
	   feat[nf].xgr_color = (int)panel_get(ps[1],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-GRID") == 0)
	   feat[nf].ygr_color = (int)panel_get(ps[1],PANEL_VALUE,0);
	else if (strcmp(txt,"X-TIC1") == 0)
	   feat[nf].xt1_color = (int)panel_get(ps[1],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-TIC1") == 0)
	   feat[nf].yt1_color = (int)panel_get(ps[1],PANEL_VALUE,0);
	else if (strcmp(txt,"X-TIC2") == 0)
	   feat[nf].xt2_color = (int)panel_get(ps[1],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-TIC2") == 0)
	   feat[nf].yt2_color = (int)panel_get(ps[1],PANEL_VALUE,0);
	else
	   bad_data("This feature error message for color is not possible.");
	return;
}
/* EOF */
/* cat > src+obj/s2.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* s2: s2 slider - feature...specify spacing		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	s2()
{
	strcpy(txt,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if 	(strcmp(txt,"X-GRID") == 0)
	   feat[nf].xgr_space = (int)panel_get(ps[2],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-GRID") == 0)
	   feat[nf].ygr_space = (int)panel_get(ps[2],PANEL_VALUE,0);
	else if (strcmp(txt,"X-TIC1") == 0)
	   feat[nf].xt1_space = (int)panel_get(ps[2],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-TIC1") == 0)
	   feat[nf].yt1_space = (int)panel_get(ps[2],PANEL_VALUE,0);
	else if (strcmp(txt,"X-TIC2") == 0)
	   feat[nf].xt2_space = (int)panel_get(ps[2],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-TIC2") == 0)
	   feat[nf].yt2_space = (int)panel_get(ps[2],PANEL_VALUE,0);
	else
	   bad_data("This feature error message for spacing is not possible.");
	return;
}
/* EOF */
/* cat > src+obj/s3.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* s3: s3 slider - feature...specify tick length	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	s3()
{
	strcpy(txt,panel_get(pm[4],PANEL_LABEL_STRING,0));
	if	(strcmp(txt,"X-TIC1") == 0)
	   feat[nf].xt1_len = (int)panel_get(ps[3],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-TIC1") == 0)
	   feat[nf].yt1_len = (int)panel_get(ps[3],PANEL_VALUE,0);
	else if (strcmp(txt,"X-TIC2") == 0)
	   feat[nf].xt2_len = (int)panel_get(ps[3],PANEL_VALUE,0);
	else if (strcmp(txt,"Y-TIC2") == 0)
	   feat[nf].yt2_len = (int)panel_get(ps[3],PANEL_VALUE,0);
	else
	   bad_data("This feature error message for tic length is not possible.");
	return;
}
/* EOF */
/* cat > src+obj/string_to_tag.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* string_to_tag: create a program tag from a file char	*/
/*		  string				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int 
string_to_tag (s, dir)
	char           *s;
	char	       *dir;	/* file directory path */
{
	struct pixfont *a;
	char           *q, c, fd = '\t', td = '\n', nd = '\0';
	int             z, nxpts, nypts, w, x, y;
	register int    n;
	float           f;
	int             filetype;
	char		tmpfn[MAXNAMELEN + 1];
	char		msg1[MAXNAMELEN + 1];

	q = s;
	if (*s == 'p')
	{
		while (*q)
		{
			if (*q == fd)
				*q = nd;
			q++;
		}
		s++;
		s++;

		strcpy (pfntmp, s);

		z = check_palette (pfntmp, 1);
		if (z == 1)
		{
			(void) swapdirnames (pfntmp, dir, tmpfn);
			z = check_palette (tmpfn, 1);
			if (z == 1)
			{
				sprintf (msg1, "File = %s", s);
				bad_data2 ("Cannot open palette file. Tried program settings directory also! Request ignored.", msg1);
				return (FALSE);
			}
			else if (load_rgb (tmpfn, 1))
				return (FALSE);
			else
				strcpy (pfn, tmpfn);
		}
		else if (load_rgb (pfntmp, 1))
			return (FALSE);
		else
			strcpy (pfn, s);
		
		reset_colormap ();
/*
		pw_putcolormap (bpw, 0, 256 - 2, red, green, blue);
		pw_putcolormap (cpw, 0, 256, red, green, blue);
*/

		while (*s)
			s++;
		s++;
		clear_color = atoi (s);
	}
	else if (*s == 't')
	{
		while (*q)
		{
			if (*q == fd)
				*q = nd;
			q++;
		}
		s++;
		n = atoi (s);
		while (*s)
			s++;
		s++;
		strcpy (text[n].body, s);
		while (*s)
			s++;
		s++;
		strcpy (text[n].prefont, s);
		while (*s)
			s++;
		s++;
		strcpy (text[n].postfont, s);
		while (*s)
			s++;
		s++;
		text[n].sw = atoi (s);
		while (*s)
			s++;
		s++;
		text[n].color = atoi (s);
		while (*s)
			s++;
		s++;
		text[n].xpos = atoi (s);
		while (*s)
			s++;
		s++;
		text[n].ypos = atoi (s);
		strcpy (txt, text[n].prefont);
		strcat (txt, "/");
		strcat (txt, text[n].postfont);
		if (NULL == (a = pf_open (txt)))
		{
			sprintf (msg1, "Font = %s, text[%d]", txt, n);
			bad_data2 ("Text string font could not be read, request ignored.", msg1);
			pf_close (a);
			null_text (&text[n]);
			return (FALSE);
		}
		else
			*(rw_toggle + N_image + N_contour + N_vector + n) = TRUE;
	}
	else if (*s == 'i')
	{
		while (*q)
		{
			if (*q == fd)
				*q = nd;
			q++;
		}
		s++;
		n = atoi (s);
		while (*s)
			s++;
		s++;
		strcpy (image[n].fname, s);
		while (*s)
			s++;
		s++;
		image[n].sw = atoi (s);
		while (*s)
			s++;
		s++;
		image[n].xpts = atoi (s);
		while (*s)
			s++;
		s++;
		image[n].ypts = atoi (s);
		while (*s)
			s++;
		s++;
		image[n].xpos = atoi (s);
		while (*s)
			s++;
		s++;
		image[n].ypos = atoi (s);
		z = check_image (image[n].fname, &image[n].xpts, &image[n].ypts, &nxpts, &nypts, 1, &filetype);
		if (z == 1)
		{
			(void) swapdirnames (image[n].fname, dir, tmpfn);
			z = check_image (tmpfn, &image[n].xpts, &image[n].ypts, &nxpts, &nypts, 1, &filetype);
			if (z != 1)
				strcpy (image[n].fname, tmpfn);
		}
		if (z == 1)
		{
			sprintf (msg1, "File = %s, image[%d]", image[n].fname, n);
			bad_data2 ("Cannot open image file. Tried program settings directory also! Request ignored.", msg1);
		}
		else if (z == 2)
		{
			sprintf (msg1, "File = %s, image[%d]", image[n].fname, n);
			bad_data2 ("X-pts * Y-pts != image filesize, request ignored.", msg1);
		}
		else if (z == 3)
		{
			sprintf (msg1, "File = %s, image[%d]", image[n].fname, n);
			bad_data2 ("Not enough images in HDF file, request ignored.", msg1);
		}
		else if (z < 0)	/* HDF error */
		{
			sprintf (msg1, "HDF file error (DFerror = %d), request ignored.", z);
			sprintf (msg2, "File = %s, image[%d]", image[n].fname, n);
			bad_data2 (msg1, msg2);
		}
		else if (z == 4)/* HDF - different size */
		{
			sprintf (msg1, "File = %s, image[%d], old(x=%d,y=%d) != new(x=%d,y=%d)", image[n].fname, n, image[n].xpts, image[n].ypts, nxpts, nypts);
			bad_data2 ("Image dimensions do not agree with those in HDF file - request ignored.", msg1);
		}
		if (z != 0)
		{
			null_image (&image[n]);
			return (FALSE);
		}
		else
			*(rw_toggle + n) = TRUE;
	}
	else if (*s == 'c')
	{
		while (*q)
		{
			if (*q == fd)
				*q = nd;
			q++;
		}
		s++;
		n = atoi (s);
		while (*s)
			s++;
		s++;
		strcpy (con[n].fname, s);
		while (*s)
			s++;
		s++;
		con[n].sw = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].color = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].first = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].last = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].interval = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].dis = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].xpts = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].ypts = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].xpos = atoi (s);
		while (*s)
			s++;
		s++;
		con[n].ypos = atoi (s);
		z = check_image (con[n].fname, &con[n].xpts, &con[n].ypts, &nxpts, &nypts, 1, &filetype);
		if (z == 1)
		{
			(void) swapdirnames (con[n].fname, dir, tmpfn);
			z = check_image (tmpfn, &con[n].xpts, &con[n].ypts, &nxpts, &nypts, 1, &filetype);
			if (z != 1)
				strcpy (con[n].fname, tmpfn);
		}
		if (z == 1)
		{
			sprintf (msg1, "File = %s, con[%d]", con[n].fname, n);
			bad_data2 ("Cannot open contour image file. Tried program settings directory also! Request ignored.", msg1);
		}
		else if (z == 2)
		{
			sprintf (msg1, "File = %s, con[%d]", con[n].fname, n);
			bad_data2 ("X-pts * Y-pts != contour image filesize, request ignored.", msg1);
		}
		else if (z == 3)
		{
			sprintf (msg1, "File = %s, con[%d]", con[n].fname, n);
			bad_data2 ("Not enough images in HDF file, request ignored.", msg1);
		}
		else if (z < 0)	/* HDF error */
		{
			sprintf (msg1, "HDF file error (DFerror = %d), request ignored.", z);
			sprintf (msg2, "File = %s, con[%d]", con[n].fname, n);
			bad_data2 (msg1, msg2);
		}
		else if (z == 4)/* HDF - different size */
		{
			sprintf (msg1, "File = %s, con[%d], old(x=%d,y=%d) != new(x=%d,y=%d)", con[n].fname, n, con[n].xpts, con[n].ypts, nxpts, nypts);
			bad_data2 ("Contour image dimensions do not agree with those in HDF file - request ignored.", msg1);
		}
		if (z != 0)
		{
			null_contour (&con[n]);
			return (FALSE);
		}
		else
			*(rw_toggle + N_image + n) = TRUE;
	}
	else if (*s == 'v')
	{
		while (*q)
		{
			if (*q == fd)
				*q = nd;
			q++;
		}
		s++;
		n = atoi (s);
		while (*s)
			s++;
		s++;
		strcpy (vec[n].xname, s);
		while (*s)
			s++;
		s++;
		strcpy (vec[n].yname, s);
		while (*s)
			s++;
		s++;
		vec[n].sw = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].color = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].maxlen = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].xstart = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].xend = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].xinterval = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].xdis = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].ystart = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].yend = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].yinterval = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].xzero = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].yzero = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].ydis = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].xpts = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].ypts = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].xpos = atoi (s);
		while (*s)
			s++;
		s++;
		vec[n].ypos = atoi (s);
		while (*s)
			s++;
		s++;
		sscanf (s, "%f", &f);
		vec[n].xscale = f;
		while (*s)
			s++;
		s++;
		sscanf (s, "%f", &f);
		vec[n].yscale = f;
		z = check_image (vec[n].xname, &vec[n].xpts, &vec[n].ypts, &nxpts, &nypts, 1, &filetype);
		if (z == 1)
		{
			(void) swapdirnames (vec[n].xname, dir, tmpfn);
			z = check_image (tmpfn, &vec[n].xpts, &vec[n].ypts, &nxpts, &nypts, 1, &filetype);
			if (z != 1)
				strcpy (vec[n].xname, tmpfn);
		}
		if (z == 1)
		{
			sprintf (msg1, "File = %s, vec[%d]", vec[n].xname, n);
			bad_data2 ("Cannot open x-image file. Tried program settings directory also! Request ignored.", msg1);
		}
		else if (z == 2)
		{
			sprintf (msg1, "File = %s, vec[%d]", vec[n].xname, n);
			bad_data2 ("X-pts * Y-pts != x-image filesize, request ignored.", msg1);
		}
		else if (z == 3)
		{
			sprintf (msg1, "File = %s, vec[%d]", vec[n].xname, n);
			bad_data2 ("Not enough images in HDF file, request ignored.", msg1);
		}
		else if (z < 0)	/* HDF error */
		{
			sprintf (msg1, "HDF file error (DFerror = %d), request ignored.", z);
			sprintf (msg2, "File = %s, vec[%d]", vec[n].xname, n);
			bad_data2 (msg1, msg2);
		}
		else if (z == 4)/* HDF - different size */
		{
			sprintf (msg1, "File = %s, vec[%d], old(x=%d,y=%d) != new(x=%d,y=%d)", vec[n].xname, n, vec[n].xpts, vec[n].ypts, nxpts, nypts);
			bad_data2 ("X-image dimensions do not agree with those in HDF file - request ignored.", msg1);
		}
		if (z != 0)
		{
			null_vector (&vec[n]);
			return (FALSE);
		}
		z = check_image (vec[n].yname, &vec[n].xpts, &vec[n].ypts, &nxpts, &nypts, (!strcmp (vec[n].xname, vec[n].yname)) ? 2 : 1, &filetype);
		if (z == 1)
		{
			(void) swapdirnames (vec[n].yname, dir, tmpfn);
			z = check_image (tmpfn, &vec[n].xpts, &vec[n].ypts, &nxpts, &nypts, (!strcmp (vec[n].xname, tmpfn)) ? 2 : 1, &filetype);
			if (z != 1)
				strcpy (vec[n].yname, tmpfn);
		}
		if (z == 1)
		{
			sprintf (msg1, "File = %s, vec[%d]", vec[n].yname, n);
			bad_data2 ("Cannot open y-image file. Tried program settings directory also! Request ignored.", msg1);
		}
		else if (z == 2)
		{
			sprintf (msg1, "File = %s, vec[%d]", vec[n].yname, n);
			bad_data2 ("X-pts * Y-pts != y-image filesize, request ignored.", msg1);
		}
		else if (z == 3)
		{
			sprintf (msg1, "File = %s, vec[%d]", vec[n].yname, n);
			bad_data2 ("Not enough images in HDF file, request ignored.");
		}
		else if (z < 0)	/* HDF error */
		{
			sprintf (msg1, "HDF file error (DFerror = %d), request ignored.", z);
			sprintf (msg2, "File = %s, vec[%d]", vec[n].yname, n);
			bad_data2 (msg1, msg2);
		}
		else if (z == 4)/* HDF - different size */
		{
			sprintf (msg1, "File = %s, vec[%d], old(x=%d,y=%d) != new(x=%d,y=%d)", vec[n].yname, n, vec[n].xpts, vec[n].ypts, nxpts, nypts);
			bad_data2 ("Y-image dimensions do not agree with those in HDF file - request ignored.", msg1);
		}
		if (z != 0)
		{
			null_vector (&vec[n]);
			return (FALSE);
		}
		else
			*(rw_toggle + N_image + N_contour + n) = TRUE;
	}
	else if (*s == 'f')
	{
		while (*q)
		{
			if (*q == fd)
				*q = nd;
			q++;
		}
		s++;
		c = *s++;
		n = atoi (s);
		if (c == 'c')
			n = n + N_image;
		else if (c == 'v')
			n = n + N_image + N_contour;
		else;
		while (*s)
			s++;
		s++;
		feat[n].xax_sw = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xax_thick = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xax_color = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xax_bot = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xax_top = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yax_sw = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yax_thick = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yax_color = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yax_left = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yax_right = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xgr_sw = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xgr_thick = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xgr_color = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xgr_space = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].ygr_sw = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].ygr_thick = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].ygr_color = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].ygr_space = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt1_sw = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt1_thick = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt1_color = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt1_bot = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt1_top = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt1_space = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt1_len = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt1_direc = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt1_sw = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt1_thick = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt1_color = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt1_left = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt1_right = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt1_space = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt1_len = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt1_direc = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt2_sw = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt2_thick = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt2_color = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt2_bot = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt2_top = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt2_space = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt2_len = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].xt2_direc = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt2_sw = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt2_thick = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt2_color = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt2_left = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt2_right = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt2_space = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt2_len = atoi (s);
		while (*s)
			s++;
		s++;
		feat[n].yt2_direc = atoi (s);
	}
	else if (*s == 'b')
	{
		while (*q)
		{
			if (*q == fd)
				*q = nd;
			q++;
		}
		while (*s)
			s++;
		s++;
		cbar.sw = atoi (s);
		while (*s)
			s++;
		s++;
		cbar.xpts = atoi (s);
		while (*s)
			s++;
		s++;
		cbar.ypts = atoi (s);
		while (*s)
			s++;
		s++;
		cbar.xpos = atoi (s);
		while (*s)
			s++;
		s++;
		cbar.ypos = atoi (s);
	}
	else if (*s == 'g')
	{
		while (*q)
		{
			if (*q == fd)
				*q = nd;
			q++;
		}
		while (*s)
			s++;
		s++;
		grid.sw = atoi (s);
		while (*s)
			s++;
		s++;
		grid.xpix = atoi (s);
		while (*s)
			s++;
		s++;
		grid.ypix = atoi (s);
		while (*s)
			s++;
		s++;
		grid.color = atoi (s);
	}
	else;
	return (TRUE);
}
/* EOF */
/* cat > src+obj/tag_to_string.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* tag_to_string: create a char string from a program	*/
/*		  tag					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	tag_to_string(t,n,s) char *t,*s; int n;
{
        char            *q,
                        fd = '\t',
                        td = '\n',
                        nd = '\0',
                        t_string[16];
	register int	m;
        *s++    = *t;
	if (*t == 'f')
	   {if		(n >= N_image + N_contour)
	       {*s++ = 'v';
		m = n - N_image - N_contour;
		my_itoa(m,s);
		while(*s) s++;
	       }
	    else if	(n >= N_image)
	       {*s++ = 'c';
		m = n - N_image;
		my_itoa(m,s);
		while(*s) s++;
	       }
	    else
	       {*s++ = 'i';
		my_itoa(n,s);
		while(*s) s++;
	       }
	   }
	else
	   {if (n > -1)
	       {my_itoa(n,s); while(*s) s++;}
	    else;
	   }
        *s++    = fd;
        if (*t == 'p')
          {q    = pfn;                          while (*q) *s++ = *q++; *s++ = fd;
           my_itoa(clear_color,s);              while (*s) s++;         *s++ = fd;
           *s++ = td;                           *s   = nd;
          }
        else if (*t == 't')
          {q    = text[n].body;                 while (*q) *s++ = *q++; *s++ = fd;
           q    = text[n].prefont;              while (*q) *s++ = *q++; *s++ = fd;
           q    = text[n].postfont;             while (*q) *s++ = *q++; *s++ = fd;
           my_itoa(text[n].sw,s);               while (*s) s++;         *s++ = fd;
           my_itoa(text[n].color,s);            while (*s) s++;         *s++ = fd;
           my_itoa(text[n].xpos,s);             while (*s) s++;         *s++ = fd;
           my_itoa(text[n].ypos,s);             while (*s) s++;         *s++ = fd;
           *s++ = td;                           *s   = nd;
          }
        else if (*t == 'v')
          {q    = vec[n].xname;                 while (*q) *s++ = *q++; *s++ = fd;
           q    = vec[n].yname;                 while (*q) *s++ = *q++; *s++ = fd;
           my_itoa(vec[n].sw,s);                while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].color,s);             while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].maxlen,s);            while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].xstart,s);            while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].xend,s);              while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].xinterval,s);         while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].xdis,s);              while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].ystart,s);            while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].yend,s);              while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].yinterval,s);         while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].xzero,s);             while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].yzero,s);             while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].ydis,s);              while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].xpts,s);              while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].ypts,s);              while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].xpos,s);              while (*s) s++;         *s++ = fd;
           my_itoa(vec[n].ypos,s);              while (*s) s++;         *s++ = fd;
           sprintf(t_string,"%f",vec[n].xscale);
           *s-- = nd;
           strcat(s,t_string);                  while (*s) s++;         *s++ = fd;
           sprintf(t_string,"%f",vec[n].yscale);
           *s-- = nd;
           strcat(s,t_string);                  while (*s) s++;         *s++ = fd;
           *s++ = td;                           *s   = nd;
          }
        else if (*t == 'c')
          {q    = con[n].fname;                 while (*q) *s++ = *q++; *s++ = fd;
           my_itoa(con[n].sw,s);                while (*s) s++;         *s++ = fd;
           my_itoa(con[n].color,s);             while (*s) s++;         *s++ = fd;
           my_itoa(con[n].first,s);             while (*s) s++;         *s++ = fd;
           my_itoa(con[n].last,s);              while (*s) s++;         *s++ = fd;
           my_itoa(con[n].interval,s);          while (*s) s++;         *s++ = fd;
           my_itoa(con[n].dis,s);               while (*s) s++;         *s++ = fd;
           my_itoa(con[n].xpts,s);              while (*s) s++;         *s++ = fd;
           my_itoa(con[n].ypts,s);              while (*s) s++;         *s++ = fd;
           my_itoa(con[n].xpos,s);              while (*s) s++;         *s++ = fd;
           my_itoa(con[n].ypos,s);              while (*s) s++;         *s++ = fd;
           *s++ = td;                           *s   = nd;
          }
        else if (*t == 'i')
          {q    = image[n].fname;               while (*q) *s++ = *q++; *s++ = fd;
           my_itoa(image[n].sw,s);              while (*s) s++;         *s++ = fd;
           my_itoa(image[n].xpts,s);            while (*s) s++;         *s++ = fd;
           my_itoa(image[n].ypts,s);            while (*s) s++;         *s++ = fd;
           my_itoa(image[n].xpos,s);            while (*s) s++;         *s++ = fd;
           my_itoa(image[n].ypos,s);            while (*s) s++;         *s++ = fd;
           *s++ = td;                           *s   = nd;
          }
        else if (*t == 'f')
          {my_itoa(feat[n].xax_sw,s);           while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xax_thick,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xax_color,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xax_bot,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xax_top,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yax_sw,s);           while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yax_thick,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yax_color,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yax_left,s);         while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yax_right,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xgr_sw,s);           while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xgr_thick,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xgr_color,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xgr_space,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].ygr_sw,s);           while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].ygr_thick,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].ygr_color,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].ygr_space,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt1_sw,s);           while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt1_thick,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt1_color,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt1_bot,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt1_top,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt1_space,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt1_len,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt1_direc,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt1_sw,s);           while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt1_thick,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt1_color,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt1_left,s);         while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt1_right,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt1_space,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt1_len,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt1_direc,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt2_sw,s);           while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt2_thick,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt2_color,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt2_bot,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt2_top,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt2_space,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt2_len,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].xt2_direc,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt2_sw,s);           while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt2_thick,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt2_color,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt2_left,s);         while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt2_right,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt2_space,s);        while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt2_len,s);          while (*s) s++;         *s++ = fd;
           my_itoa(feat[n].yt2_direc,s);        while (*s) s++;         *s++ = fd;
           *s++ = td;                           *s   = nd;
          }
        else if (*t == 'b')
          {my_itoa(cbar.sw,s);                  while (*s) s++;         *s++ = fd;
           my_itoa(cbar.xpts,s);                while (*s) s++;         *s++ = fd;
           my_itoa(cbar.ypts,s);                while (*s) s++;         *s++ = fd;
           my_itoa(cbar.xpos,s);                while (*s) s++;         *s++ = fd;
           my_itoa(cbar.ypos,s);                while (*s) s++;         *s++ = fd;
           *s++ = td;                           *s   = nd;
          }
        else if (*t == 'g')
          {my_itoa(grid.sw,s);                  while (*s) s++;         *s++ = fd;
           my_itoa(grid.xpix,s);                while (*s) s++;         *s++ = fd;
           my_itoa(grid.ypix,s);                while (*s) s++;         *s++ = fd;
           my_itoa(grid.color,s);               while (*s) s++;         *s++ = fd;
           *s++ = td;                           *s   = nd;
          }
	else;
        return;
}
/* EOF */
/* cat > src+obj/warn_msg.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* warn_msg: warn user that displayed data will be	*/
/*	     lost on "Done"				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	warn_msg()
{
	info_msg("          ** WARNING ** The data displayed has not been stored",
		 "and will be lost if you put away this frame.  Press CONFIRM to",
		 "put away the frame anyway.");
	return;
}
/* EOF */
/* cat > src+obj/warn_msgt.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* warn_msgt: tag chg - warn user that displayed data	*/
/*	      will be lost				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	warn_msgt()
{
	info_msg("          ** WARNING ** The data displayed has not been stored",
		 "and will be lost if you change tags now.  Press the same button",
		 "again to change tags anyway.");
	return;
}
/* EOF */
/* cat > src+obj/bad_data2.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* bad_data2: two-line error message on stderr before	*/
/*	      the base frame comes up or on the base	*/
/*	      frame after it comes up.			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

void bad_data2 (s1, s2) char *s1, *s2;
{

	if (base_frame_up)
		info_msg2 ("           ----- ERROR MESSAGE -----",
			   s1, s2,
			   "           ----- ERROR MESSAGE -----");
	else
		fprintf (stderr, "%s\n%s\n%s\n%s\n",
			 "           ----- ERROR MESSAGE -----",
			 s1, s2,
			 "           ----- ERROR MESSAGE -----");
	return;
}
/* EOF */
/* cat > src+obj/check_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* check_image: return 0 if ok, 1 if file not openable,	*/
/*	        2 if badpts for non-HDF files, 3 if not */
/*		enough images in a HDF file, 4 if HDF	*/
/*		file with new values, DFerror if HDF	*/
/*		error. Returns the filetype.		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	check_image (s, w1, h1, w2, h2, n, filetype)

		   char	*s;
		   int	*w1, *h1, *w2, *h2;
		   int	n;	 /* sequence number of image in HDF file */
		   int *filetype;	/* VALUE RETURNED -
					    0 - regular file
					    1 - HDF file
					   -1 - undefined */
{
	int		f, size, i, dummy;
	DF		*file;

	*filetype = -1;
	if (DFR8getdims (s, w2, h2, &dummy))
	{
		DFR8restart ();
		if (DFerror == DFE_FNF)		/* file not found error */
			return (1);
		else if (DFerror == DFE_NOTDFFILE)	/* regular file */
		{
			stat(s,&my_stat);
			if (w1 == NULL || h1 == NULL)	/* should have values */
				return (2);
			size = (*w1) * (*h1);
			*filetype = 0;
			if (my_stat.st_size != size) return(2);
			return (0);
		}
		else if (DFerror == DFE_NOMATCH)	/* no image */
			return (3);
		else
			return (DFerror);	/* other HDF error */
	}
	for (i = 1; i < n; i++)
		if (DFR8getdims (s, w2, h2, &dummy)) 
		{
			DFR8restart ();
			if (DFerror == DFE_NOMATCH)
				return (3);
			else
				return (DFerror);	/* other HDF error */
		}
	DFR8restart();
	*filetype = 1;
	if (w1 == NULL || h1 == NULL)	/* at least one has no value yet */
		return (4);
	if ((*w1) != (*w2) || (*h1) != (*h2))
		return (4);			/* new size */
	else
		return (0);
}
/* EOF */
/* cat > src+obj/check_palette.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* check_file: return 0 if ok, 1 if file not openable,	*/
/*	       2 if badpts for non-HDF files, 3 if not	*/
/*	       enough palettes in HDF file, DFerror if  */
/*	       HDF error.				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

#define	PALLETE_SIZE	768

int	check_palette (s, n)

		   char	*s;
		   int	n;	 /* sequence number of palette in HDF file */
{
	int		npals, size; 

	if ((npals = DFPnpals (s)) == -1)
	{
		DFPrestart ();
		if (DFerror == DFE_FNF)		/* file not found error */
			return (1);
		else if (DFerror == DFE_NOTDFFILE)	/* regular file */
		{
			stat(s,&my_stat);
			size = PALLETE_SIZE;
			if (my_stat.st_size != size) return(2);
			return (0);
		}
		else
			return (DFerror);	/* other HDF error */
	}
	else if (npals < n)
	{
		DFPrestart();
		return (3);
	}
	else
	{
		DFPrestart();
		return (0);
	}
}
/* EOF */
/* cat > src+obj/get_defaults.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* get_defaults: get value of entry in defaults		*/
/* 		 database				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* implementation note(s):
	1. The default value will be "".
	2. IMPORTANT NOTE: The Sun Defaults software seems to read
	   the value of DEFAULTS_FILE only ONCE on the first call
	   to one of their interface routines.
	3. In order to get around the problem of having user defaults
	   files with
		/Defaults/Read_Defaults_DataBase
	   being "False" the following must be done. On the first call
	   a copy of the user's $HOME/.defaults file (if there is one)
	   is copied to a temporary file. If there isn't one a two
	   line file is created.  This temporary file becomes
	   the value of DEFAULTS_FILE in the environment. If a "False"
	   value is detected in the file then another version is created
	   with the value being "True" and then "moved" to the original
	   version.
	4. IMPORTANT NOTE: The Sun Defaults Software must read the "True"
	   value above from the user's default file. Now the Sun Defaults
	   Software was used to create the scratch version before copying
	   to the original version. The original version may have had
	   a "False" value for the attribute above. After the scratch
	   version is "moved" to the original version the attribute above
	   MUST BE REREAD! Then everything is good!
*/

/* #include "all.h" */
/* #include "newext.h" */

char           *
get_defaults (s)
	char           *s;
{
	static int      startup = 1;
	static Bool     value_false = 0;
	static char     fn_tmp_defaults[36];
	static char     env_fn_new_defaults[64];
	static char    *header_line = "SunDefaults_Version 2\n";
	static char    *read_line = "/Defaults/Read_Defaults_Database	\"True\"\n";
	static char    *read_attribute = "/Defaults/Read_Defaults_Database";
	FILE           *fd_new_defaults, *fd_old_defaults, *fd_tmp_defaults;
	Bool            value_r;
	char           *home, *fn_old_defaults;
	char           *value_s;
	int             status;

	char           *getenv ();

	int             i, c;

	if (startup)
	{
		startup = 0;
		sprintf (fn_new_defaults, "/tmp/.defaults.%d", getpid ());
		if ((fd_new_defaults = fopen (fn_new_defaults, "w")) == NULL)
		{
			sprintf (msg, "File = %s", fn_new_defaults);
			bad_data2 ("Internal Error: Could not create temporary private database, CompositeTool terminated.", msg);
			exit (-1);
		}
		sprintf (env_fn_new_defaults, "DEFAULTS_FILE=%s", fn_new_defaults);
		if ((status = putenv (env_fn_new_defaults)) != 0)
		{
			bad_data2 ("Internal Error: Could not save DEFAULTS_FILE environment variable, CompositeTool terminated.", "");
			exit (-1);
		}
		if ((home = getenv ("HOME")) == NULL)
		{
			bad_data2 ("Internal Error: Could not get the value of $HOME from the environment, CompositeTool terminated.", "");
			exit (-1);
		}
		if ((fn_old_defaults = (char *) malloc (strlen (home) + 11)) == NULL)
		{
			bad_data2 ("Internal Error: Could not create storage for $HOME/.defaults string, CompositeTool terminated.", "");
			exit (-1);
		}
		sprintf (fn_old_defaults, "%s/.defaults", home);
		if ((fd_old_defaults = fopen (fn_old_defaults, "r")) == NULL)
		{
			(void) fputs (header_line, fd_new_defaults);
			(void) fputs (read_line, fd_new_defaults);
			(void) fclose (fd_new_defaults);
		}
		else
		{		/* copy users private default to temporary
				   private defaults */
			while ((c = getc (fd_old_defaults)) != EOF)
				(void) putc (c, fd_new_defaults);
			(void) fflush (fd_new_defaults);
			(void) fclose (fd_old_defaults);
			(void) fclose (fd_new_defaults);
		}
		free (fn_old_defaults);
		value_r = defaults_get_boolean ("/Defaults/Read_Defaults_Database", value_false, 0);
		if (!value_r)
		{
			sprintf (fn_tmp_defaults, "/tmp/.defaults.tmp.%d", getpid ());
			if ((fd_tmp_defaults = fopen (fn_tmp_defaults, "w+")) == NULL)
			{
				sprintf (msg, "File = %s", fn_tmp_defaults);
				bad_data2 ("Internal Error: Could not create scratch private database, CompositeTool terminated.", msg);
				exit (-1);
			}
			(void) fputs (header_line, fd_tmp_defaults);
			(void) fputs (read_line, fd_tmp_defaults);
			move_defaults ("/", fd_tmp_defaults);
			(void) fflush (fd_tmp_defaults);
			rewind (fd_tmp_defaults);
			if ((fd_new_defaults = fopen (fn_new_defaults, "w")) == NULL)
			{
				sprintf (msg, "File = %s", fn_tmp_defaults);
				bad_data2 ("Internal Error: Could not open temporary private database, CompositeTool terminated.", msg);
				exit (-1);
			}
			while ((c = getc (fd_tmp_defaults)) != EOF)
				putc (c, fd_new_defaults);
			(void) fflush (fd_new_defaults);
			(void) fclose (fd_new_defaults);
			(void) fclose (fd_tmp_defaults);
			(void) unlink (fn_tmp_defaults);
				/* the most important line in the
				   whole module */
			defaults_reread (read_attribute, NULL);
		}
	}

	value_s = defaults_get_string (s, "", 0);
	return ((*value_s == NULL) ? NULL : value_s);
}
/* EOF */
/* cat > src+obj/info_msg2.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* info_msg2: put four messages on the main panel	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int	info_msg2 (p,q,r,u) char *p,*q,*r,*u;
{
	char	m[10],*s,*t;
	msg_no++;
	my_itoa(msg_no,m);
	if (strlen(p) <= strlen(m))
	   panel_set(pm[0],PANEL_LABEL_STRING,m,0);
	else
	   {s = m;
	    t = p;
	    while (*s) *t++ = *s++;
	    panel_set(pm[0],PANEL_LABEL_STRING,p,0);
	   }
	panel_set(pm[1],PANEL_LABEL_STRING,q,0);
	panel_set(pm[2],PANEL_LABEL_STRING,r,0);
	panel_set(pm[3],PANEL_LABEL_STRING,u,0);
	return;
}
/* EOF */
/* cat > src+obj/itoa.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* itoa: Convert n to characters in s.			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

char *itoa (n, s)
	int n;
	char s[];
{
	int i, sign;

	if ((sign = n) < 0)	/* record sign */
		n = -n;		/* make n positive */
	i = 0;
	do			/* generate digits in reverse order */
	{
		s[i++] = n % 10 + '0';		/* get next digit */
	}
	while ((n /= 10) > 0);	/* delete it */
	if (sign < 0)
		s[i++] = '-';
	s[i] = '\0';
	reverse (s);
	return (s);
}
/* EOF */
/* cat > src+obj/load_contour_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* load_contour_image: loads an image from a file - 	*/
/*		       used by draw_contour.		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	load_contour_image (s, xpts, ypts, image, n)
		   char *s; int xpts, ypts;
		   unsigned char *image;
		   int n;	/* sequence number of image in HDF file */
{
	int xdim, ydim, ispalette;
	int f;
	register int i, j;
	register unsigned char *p0, *p1;

	if (DFR8getdims (s, &xdim, &ydim, &ispalette))
	{
		DFR8restart ();
		if (DFerror == DFE_NOTDFFILE)	/* regular file */
		{
			f = open (s, O_RDONLY);
			read (f, image, xpts * ypts); 
			close (f);
			return (0);
		}
		else
		{	
			sprintf (msg, "HDF error while getting dimensions (DFerror = %d) for contour image.", DFerror);
			sprintf (msg2, "File = %s, INTERNAL ERROR!", s);
			bad_data2 (msg, msg2);
			return (-1);
		}
	}
	for (i = 1; i < n; i++)	/* skip over the rest of the images */
		if (DFR8getdims (s, &xdim, &ydim, &ispalette))
		{
			DFR8restart ();
			sprintf (msg, "HDF error while getting dimensions (DFerror = %d) for contour image.", DFerror);
			sprintf (msg2, "File = %s, INTERNAL ERROR!", s);
			bad_data2 (msg, msg2);
			return (-1);
		}
	if (xpts != xdim || ypts != ydim)
	{
		DFR8restart ();
		sprintf (msg, "Unexpected dimensions from HDF file while loading contour image.");
		sprintf (msg2, "File = %s, old(x=%d,y=%d), new(x=%d,y=%d) - INTERNAL ERROR!", s, xpts, ypts, xdim, ydim);
		bad_data2 (msg, msg2);
		return (-1);
	}
	if (DFR8getimage (s, image, xdim, ydim, NULL))
	{
		DFR8restart ();
		sprintf (msg, "Did not load contour image from HDF file (DFerror = %d), request halted", DFerror);
		sprintf (msg2, "File = %s", s);
		bad_data2 (msg, msg2);
		return (-1);
	}
	DFR8restart ();
	return (0);
}
/* EOF */
/* cat > src+obj/load_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* load_image: loads an image from a file - used by	*/
/*	       draw_image. Padding is done by 		*/
/*	       pad_image.				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int 
load_image (s, xpts, ypts, xpos, ypos, mpr, n)
	char           *s;
	int             xpts, ypts, xpos, ypos;
	struct pixrect *mpr;
	int             n;	/* sequence number of image in HDF file */
{
	int             xdim, ydim, ispalette;
	int             f;
	register int    i, j;
	register unsigned char *p0, *p1;
	struct mpr_data *d;

	d = mpr_d (mpr);
	if (DFR8getdims (s, &xdim, &ydim, &ispalette))
	{
		DFR8restart ();
		if (DFerror == DFE_NOTDFFILE)	/* regular file */
		{
			f = open (s, O_RDONLY);
			read (f, (char *) d->md_image, xpts * ypts);
			pad_image (xpts, ypts, xpos, ypos, mpr);
			close (f);
			return (0);
		}
		else
		{
			if (base_frame_up)
			{
				sprintf (msg, "HDF error while getting dimensions (DFerror = %d) - INTERNAL ERROR!", DFerror);
				sprintf (msg2, "File = %s", s);
				bad_data2 (msg, msg2);
				return (-1);
			}
			else
			{
				sprintf (msg, "HDF error while getting dimensions (DFerror = %d), CompositeTool Terminated", DFerror);
				sprintf (msg2, "File = %s - INTERNAL ERROR! ", s);
				bad_data2 (msg, msg2);
				return (-1);
			}
		}
	}
	for (i = 1; i < n; i++)	/* skip over the rest of the images */
		if (DFR8getdims (s, &xdim, &ydim, &ispalette))
		{
			DFR8restart ();
			if (base_frame_up)
			{
				sprintf (msg, "HDF error while getting dimensions (DFerror = %d) - INTERNAL ERROR!", DFerror);
				sprintf (msg2, "File = %s", s);
				bad_data2 (msg, msg2);
				return (-1);
			}
			else
			{
				sprintf (msg, "HDF error while getting dimensions (DFerror = %d), CompositeTool Terminated", DFerror);
				sprintf (msg2, "File = %s - INTERNAL ERROR! ", s);
				bad_data2 (msg, msg2);
				return (-1);
			}
		}
	if (xpts != xdim || ypts != ydim)
	{
		DFR8restart ();
		if (base_frame_up)
		{
			sprintf (msg, "Unexpected dimensions from HDF file while loading - INTERNAL ERROR!", s);
			sprintf (msg2, "File = %s, old(x=%d,y=%d), new(x=%d,y=%d)", s, xpts, ypts, xdim, ydim);
			bad_data2 (msg, msg2);
			return (-1);
		}
		else
		{
			sprintf (msg, "Unexpected dimensions from HDF file while loading, CompositeTool Terminated");
			sprintf (msg2, "File = %s - INTERNAL ERROR!", s);
			bad_data2 (msg, msg2);
			return (-1);
		}
	}
	if (DFR8getimage (s, (char *) d->md_image, xdim, ydim, NULL))
	{
		DFR8restart ();
		if (base_frame_up)
		{
			sprintf (msg, "Did not load image from HDF file (DFerror = %d), request halted", DFerror);
			sprintf (msg2, "File = %s", s);
			bad_data2 (msg, msg2);
			return (-1);
		}
		else
		{
			sprintf (msg, "Did not load image from HDF file (DFerror = %d), CompositeTool Terminated", DFerror);
			sprintf (msg2, "File = %s, check defaults database with defaultsedit.", s);
			bad_data2 (msg, msg2);
			return (-1);
		}
	}
	DFR8restart ();
	pad_image (xpts, ypts, xpos, ypos, mpr);
	return (0);
}
/* EOF */
/* cat > src+obj/load_vector_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* load_vector_image: loads either x-image or y-image	*/
/*		      from a file - used by draw_vector	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int	load_vector_image (s, xpts, ypts, image, n, type)
		   char *s; int xpts, ypts;
		   unsigned char *image;
		   int n;	/* sequence number of image in HDF file */
		   int type;	/* 0 = x-image, 1 = y-image */
{
	int xdim, ydim, ispalette;
	int f;
	register int i, j;
	register unsigned char *p0, *p1;

	if (DFR8getdims (s, &xdim, &ydim, &ispalette))
	{
		DFR8restart ();
		if (DFerror == DFE_NOTDFFILE)	/* regular file */
		{
			f = open (s, O_RDONLY);
			read (f, image, xpts * ypts); 
			close (f);
			return (0);
		}
		else
		{	
			if (! type)
			{
				sprintf (msg, "HDF error while getting dimensions (DFerror = %d) for vector x-image", DFerror);
				sprintf (msg2, "file = %s - INTERNAL ERROR!", s);
			}
			else
			{
				sprintf (msg, "HDF error while getting dimensions (DFerror = %d) for vector y-image", DFerror);
				sprintf (msg2, "file = %s - INTERNAL ERROR!", s);
			}
			bad_data2 (msg, msg2);
			return (-1);
		}
	}
	for (i = 1; i < n; i++)	/* skip over the rest of the images */
		if (DFR8getdims (s, &xdim, &ydim, &ispalette))
		{
			DFR8restart ();
			if (! type)
			{
				sprintf (msg, "HDF error while getting dimensions (DFerror = %d) for vector x-image", DFerror);
				sprintf (msg2, "file = %s - INTERNAL ERROR!", s);
			}
			else
			{
				sprintf (msg, "HDF error while getting dimensions (DFerror = %d) for vector y-image", DFerror);
				sprintf (msg2, "file = %s - INTERNAL ERROR!", s);
			}
			bad_data2 (msg, msg2);
			return (-1);
		}
	if (xpts != xdim || ypts != ydim)
	{
		DFR8restart ();
		if (! type)
		{
			sprintf (msg, "Unexpected dimensions from HDF file while loading vector x-image.");
			sprintf (msg2, "File = %s, old(x=%d,y=%d), new(x=%d,y=%d) - INTERNAL ERROR!", s, xpts, ypts, xdim, ydim);
		}
		else
		{
			sprintf (msg, "Unexpected dimensions from HDF file while loading vector y-image.");
			sprintf (msg2, "File = %s, old(x=%d,y=%d), new(x=%d,y=%d) - INTERNAL ERROR!", s, xpts, ypts, xdim, ydim);
		}
		bad_data2 (msg, msg2);
		return (-1);
	}
	if (DFR8getimage (s, image, xdim, ydim, NULL))
	{
		DFR8restart ();
		if (! type)
		{
			sprintf (msg, "Did not load vector x-image from HDF file (DFerror = %d), request halted", DFerror);
			sprintf (msg2, "File = %s", s);
		}
		else
		{
			sprintf (msg, "Did not load vector y-image from HDF file (DFerror = %d), request halted", DFerror);
			sprintf (msg2, "File = %s", s);
		}
		bad_data2 (msg, msg2);
		return (-1);
	}
	DFR8restart ();
	return (0);
}
/* EOF */
/* cat > src+obj/main_destroy_interposer.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* main_destroy_interposer: destroy the base frame	*/
/*			    frame			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

Notify_value 
main_destroy_interposer (frame, status)
	Frame frame;
	Destroy_status status;
{
	if (status != DESTROY_CHECKING)
	{
		(void) unlink (fn_new_defaults);
	}
	return (notify_next_destroy_func (frame, status));
}
/* EOF */
/* cat > src+obj/make_p.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* make_p: makes a panel				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

Panel make_p (f) Frame f;
{
	Panel panel;
        panel = window_create ( f, PANEL,
				WIN_FONT, font_panel,
				0);
	set_panel_colormap (panel, b_cmsn);
	return (panel);
}
/* EOF */
/* cat > src+obj/move_defaults.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* move_defaults: move defaults from users .defaults	*/
/*		  file to temporary .defaults file	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

void
move_defaults (path_name, fd)
	char           *path_name;
	FILE           *fd;
{
	static char    *read_attribute = "/Defaults/Read_Defaults_Database";
	char           *child, *sibling, *value;
	char            tmp[1024];
	int		i, c, len;

	if ((child = defaults_get_child (path_name, NULL)) == NULL)
	{
		if (strcmp (path_name, read_attribute))
		{
			(void) fputs (path_name, fd);
			(void) fputs ("\t\"", fd);
			value = defaults_get_string (path_name, "", 0);
			len = strlen (value);
				/* special: double quotes in the string */
			for (i = 0; i < len; i++)
				if ((c = (int) *value++) == '"')
					(void) fputs ("\\\"", fd);
				else
					(void) fputc (c, fd);
			(void) fputs ("\"\n", fd);
		}
		return;
	}

	if (path_name[1] == NULL)	/* only / */
		sprintf (tmp, "%s%s", path_name, child);
	else
		sprintf (tmp, "%s/%s", path_name, child);
	move_defaults (tmp, fd);
	while ((sibling = defaults_get_sibling (tmp, NULL)) != NULL)
	{
		if (path_name[1] == NULL)	/* only / */
			sprintf (tmp, "%s%s", path_name, sibling);
		else
			sprintf (tmp, "%s/%s", path_name, sibling);
		move_defaults (tmp, fd);
	}
}
/* EOF */
/* cat > src+obj/pad_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* pad_image: expand and pad a memory pixrect with 	*/
/*	      clear_color.				*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

void
pad_image (xpts, ypts, xpos, ypos, mpr)
	int             xpts, ypts;	/* x and y dimensions of pixrect */
	int             xpos, ypos;	/* not used currently */
	Pixrect        *mpr;
{
	struct mpr_data *d;
	char           *image;
	register int    i, j, npad;
	register char  *p0;	/* character from pointer */
	register char  *p1;	/* character to pointer */

	d = mpr_d (mpr);
	image = (char *) d->md_image;
	p0 = image + xpts * ypts - 1;
/*
   BUG: mpr_linebytes () is wrong on Sun-3 and Sun-4. It computes padding
        to 16 bits not 32 bits which mem_create uses. Decided not to use it.
	Can't tell when it works!
*/
#if sun == sparc || sun == mc68020 || sun == mc68030
	npad = (xpts % 4 == 0) ? 0 : 4 - xpts % 4;
	p1 = image + (xpts + npad) * ypts - 1;
#else
	npad = (xpts % 2 == 0) ? 0 : 2 - xpts % 2;
	p1 = image + (xpts + npad) * ypts - 1;
#endif
/*
	printf ("xpts, npad = %d %d\n", xpts, npad);
*/
	if (npad == 0)		/* no padding required */
		return;
 /* make space and pad with NULL's */
	for (i = 0; i < npad; i++)
		*p1-- = clear_color;
	for (i = 0; i < ypts - 1; i++)	/* do all rows except first */
	{
		for (j = 0; j < xpts; j++)
			*p1-- = *p0--;
		for (j = 0; j < npad; j++)
			*p1-- = clear_color;
	}
	return;
}
/* EOF */
/* cat > src+obj/reverse.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reverse: reverse string s in place			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

void reverse (s)
	char s[];
{
	int c, i, j;

	for (i = 0, j = strlen(s) - 1; i < j; i++, j--)
	{
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}
/* EOF */
/* cat > src+obj/store_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* store_image: stores image alone in raw raster file	*/
/*		or dimensions, image, and palette as a	*/
/*		HDF 8-bit Raster Image set.		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int
store_image (fn, nx, ny, s, mode)
	char           *fn;	/* filename */
	int             nx, ny;	/* dimensions of image */
	unsigned char  *s;	/* image */
	int             mode;	/** 0 - HDF 8-bit Raster Image set
					(uncompressed)
				    1 - HDF 8-bit Raster Image set
					(compressed)
				    2 - image only in raw raster */
{
	int             f, i, nw;
	unsigned char  *p_palette;

	if ((f = creat (fn, my_otod (644))) == -1)
	{
		sprintf (msg, "Unix errno = %d, access or pwd problem?", errno);
		bad_data2 ("File creation failed, request ignored.", msg);
		return (-1);
	}
	if (mode == 0 || mode == 1)	/* HDF 8-bit Raster Image set */
	{
		close (f);
		p_palette = palette;
		for (i = 0; i < 256; i++)
		{
			*p_palette++ = red[i];
			*p_palette++ = green[i];
			*p_palette++ = blue[i];
		}
		if (DFR8setpalette (palette))
		{
			sprintf (msg, "HDF setpalette call failed (DFerror = %d), request ignored.", DFerror);
			bad_data (msg);
			return (-1);
		}
		if (DFR8putimage (fn, s, nx, ny, mode))
		{
			sprintf (msg, "HDF putimage call failed (DFerror = %d), request ignored.", DFerror);
			bad_data (msg);
			return (-1);
		}
	}
	else if (mode == 2)	/* raw raster */
	{
		if (nx * ny != (nw = write (f, image, nx * ny)))
		{
			if (nw == -1)
			{
				close (f);
				sprintf (msg, "UNIX errno = %d", errno);
				bad_data2 ("Raw raster write to file failed, request ignored.", msg);
				return (-1);
			}
			else
			{
				close (f);
				sprintf (msg, "Only %d of %d bytes written to raw raster file, request failed.", nw, nx * ny);
				bad_data (msg);
				return (-1);
			}
		}
		close (f);
	}
	else
	{
		sprintf (msg, "Mode = %d - INTERNAL ERROR!", mode);
		bad_data2 ("Bad mode value, request ignored.", msg);
		return (-1);
	}
	return (0);
}
/* EOF */
/* cat > src+obj/unpad_image.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* unpad_image: compress out padding in memory pixrect	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

void 
unpad_image (xpts, ypts, mpr)
	int             xpts, ypts;	/* x and y dimensions of pixrect */
	Pixrect *mpr;
{
	struct mpr_data *d;
	char           *image;
	register int    i, j, npad;
	register char  *p0;	/* character from pointer */
	register char  *p1;	/* character to pointer */

	d = mpr_d (mpr);
	image = (char *) d->md_image;
	p1 = image + xpts;
/*
   BUG: mpr_linebytes () is wrong on Sun-3 and Sun-4. It computes padding
        to 16 bits not 32 bits which mem_create uses. Decided not to use it.
	Can't tell when it works!
*/
#if sun == sparc || sun == mc68020 || sun == mc68030
	npad = (xpts % 4 == 0) ? 0 : 4 - xpts % 4;
	p0 = image + (xpts + npad);
#else
	npad = (xpts % 2 == 0) ? 0 : 2 - xpts % 2;
	p0 = image + (xpts + npad);
#endif
/*
	printf ("xpts, npad = %d %d\n", xpts, npad);
*/
	if (npad == 0)		/* no unpadding required */
		return;

 /* remove padding */

	for (i = 0; i < ypts - 1; i++)	/* do all rows except first */
	{
		for (j = 0; j < xpts; j++)
			*p1++ = *p0++;
		for (j = 0; j < npad; j++)
			p0++;
	}
	return;
}
/* EOF */
/* cat > src+obj/xstrcmp.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* xstrcmp: compare two strings without leading or	*/
/*	    trailing white space.			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int xstrcmp (s, t)
	char *s, *t;
{
	msg[0] = '\0';
	msg2[0] = '\0';
	sscanf (s, "%s", msg);
	sscanf (t, "%s", msg2);
	return (strcmp(msg, msg2));
}
/* EOF */
/* cat > src+obj/xstrlen.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* xstrlen: length of string with leading and trailing	*/
/*	    white space stripped off.			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int xstrlen (s)
	char *s;
{
	msg[0] = '\0';
	sscanf (s, "%s", msg);
	return (strlen(msg));
}
/* EOF */
/* cat > src+obj/getdirname.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* getdirname: determines the full directory part of	*/
/*	       a path. If the path is relative it is	*/
/*	       taken relative to the current directory. */
/*	       It is assumed that the path is valid!	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int getdirname (path, dir)
	char *path;
	char *dir;
{
	int i;
	char current_dir[MAXNAMELEN + 1];

	(void) getwd (current_dir);
	for (i = strlen (path) - 1; i >= 0; i--)
		if (path[i] == '/')
			break;
	strncpy (dir, path, ++i);
	dir[i] = '\0';
	if (strlen (dir) == 0)
	{
		dir[0] = '.';
		dir[1] = '\0';
	}
	(void) chdir (dir);
	(void) getwd (dir);
	(void) chdir (current_dir);

	return (0);
}
/* EOF */
/* cat > src+obj/getbasename.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* getbasename: determines the last level of path.	*/
/*		It is assumed that the path is valid!	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int getbasename (path, base)
	char *path;
	char *base;
{
	int i;

	for (i = strlen (path) - 1; i >= 0; i--)
		if (path[i] == '/')
			break;
	strcpy (base, &path[i + 1]);

	return (0);
}
/* EOF */
/* cat > src+obj/swapdirnames.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* swapdirnames: returns a new path built by replacing	*/
/*		 the directory part by another		*/
/*		 directory part. It is assumed that the	*/
/*		 that all paths and directories are	*/
/*		 valid!					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int swapdirnames (pathin, dir, pathout)
	char *pathin;
	char *dir;
	char *pathout;
{
	int lpath;

	strcpy (pathout, dir);
	lpath = strlen (pathout);
	if (pathout[lpath - 1] != '/')
	{
		pathout[lpath++] = '/';
		pathout[lpath] = '\0';
	}
	(void) getbasename (pathin, &pathout[lpath]);

	return (0);
}
/* EOF */
/* cat > src+obj/set_frame_label.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* set_frame_label: set the frame label			*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int
set_frame_label (frame)
	Frame frame;
{
	char msg1[MAXNAMELEN + 1];
	char current_dir[MAXNAMELEN + 1];
	
/*
			    FRAME_LABEL, "CompositeTool 1.1 Base Panel",
*/
	(void) getwd (current_dir);
	sprintf (msg1, "CompositeTool 1.1 - Dir: %s", current_dir);
	window_set (frame, FRAME_LABEL, msg1, 0);
}
/* EOF */
/* cat > src+obj/strip_wspace.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* strip_wspace: strip off leading and trailing white	*/
/*		 space.					*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

int
strip_wspace (s)
		/* returns the length */
	char *s;
		/* input: string to strip
		   returns: stripped string with s[0] the first non-whitespace
			    character */
{
/* Implementation note(s):
	1. Assumes that s is not NULL and the string is NULL 
	   terminated.
*/

	register int i, j, k;

		/* strip off trailing white space */
	if ((i = strlen (s)) == 0)
		return(0);
	while (--i >= 0 && (s[i] == ' ' || s[i] == '\t'));
	s[++i] = '\0';
	if (i == 0)
		return (0);

		/* strip off leading white space */
	if (s[0] != ' ' && s[0] != '\t')
		return (i);
	for (j = 0; s[j] == ' ' || s[j] == '\t'; j++);
	for (k = 0; k < i - j; k++)
		s[k] = s[k+j];
	s[i-j] = '\0';
	return ((i - j)); 
}
/* EOF */
/* cat > src+obj/util_proc_saveall.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* util_proc_saveall: save all screen to file.		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

int
util_proc_saveall ()
{
	Pixrect        *p;
	struct mpr_data *s;
	int             nx, ny;

        if (FALSE == (int) window_get (c_frame, WIN_SHOW, 0))
        {
                info_msg ("", "Canvas is not up, request ignored.", "");
                return;
        }
        else if (xstrlen (panel_get (pt[17], PANEL_VALUE, 0)) == 0)
        {
                bad_data ("No filename given, request ignored.");
                return;
        }

	sdump.xstart = 0;
	sdump.xend = N_hpix - 1;
	sdump.ystart =  0;
	sdump.yend = N_vpix - 1;

	nx = sdump.xend - sdump.xstart + 1;
	ny = sdump.yend - sdump.ystart + 1;
	p = mem_create (nx, ny, 8);
	s = mpr_d (p);
	pw_read (p, 0, 0, nx, ny, PIX_SRC, cpw, sdump.xstart, sdump.ystart);
	s = mpr_d (p);

 /* unpad image before saving it */

	unpad_image (nx, ny, p);

	if (store_image (panel_get_value (pt[17]), nx, ny, (unsigned char *) s->md_image, (int) panel_get_value (util_pc_save)))
		return;
	info_msg ("", "All of screen dumped to file.", "");
	return;
}
/* EOF */
/* cat > src+obj/adjust_colormap.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* adjust_colormap: adjust the palette entries.		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

void
adjust_colormap ()
{
        *red         = *green         = *blue         = 255;
        *(red + 255) = *(green + 255) = *(blue + 255) = 0;
        *(red + 254) = *(green + 254) = *(blue + 254) = 255;
        *(red + 253) = *(green + 253) = *(blue + 253) = 0;
}
/* EOF */
/* cat > src+obj/set_colormap.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* set_colormap: initializes the Sun colormap.		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */
/* #include "newext.h" */

void
set_colormap ()
{
	set_frame_colormap (fr[0], b_cmsn);
	set_frame_colormap (c_frame, c_cmsn);
	set_canvas_colormap (canvas, c_cmsn);
}
/* EOF */
/* cat > src+obj/reset_colormap.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* reset_colormap: reset the palette in all windows.	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

void
reset_colormap ()
{
	int i;

	set_frame_colormap (fr[0], b_cmsn);
	set_panel_colormap (pa[0], b_cmsn);
	set_frame_colormap (c_frame, c_cmsn);
	set_canvas_colormap (canvas, c_cmsn);

/* reset all the open windows */

	for (i = 1; i <= 9; i++)
		if (fr[i] != NULL)
		{
			set_frame_colormap (fr[i], b_cmsn);
			set_panel_colormap (pa[i], b_cmsn);
		}
}
/* cat > src+obj/set_frame_colormap.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* set_frame_colormap: load a frame with colormap.	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

void
set_frame_colormap (frame, cmsn)
	Frame frame;
			/* input: frame to load colormap */
	char	*cmsn;
			/* input: colormap name */
{
	Pixwin	*pixw;

	pixw = (Pixwin *) window_get (frame, WIN_PIXWIN);
	pw_setcmsname (pixw, cmsn);
	if (! strcmp (cmsn, b_cmsn))	/* partial palette */
		pw_putcolormap (pixw, 0, 256 - 2, red, green, blue);
	else				/* full palette */
		pw_putcolormap (pixw, 0, 256, red, green, blue);
}
/* EOF */
/* cat > src+obj/set_panel_colormap.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* set_panel_colormap: load a panel with colormap.	*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

void
set_panel_colormap (panel, cmsn)
	Panel panel;
			/* input: panel to load colormap */
	char	*cmsn;
			/* input: colormap name */
{
	Pixwin	*pixw;

	pixw = (Pixwin *) window_get (panel, WIN_PIXWIN);
	pw_setcmsname (pixw, cmsn);
	if (! strcmp (cmsn, b_cmsn))	/* partial palette */
		pw_putcolormap (pixw, 0, 256 - 2, red, green, blue);
	else				/* full palette */
		pw_putcolormap (pixw, 0, 256, red, green, blue);
}
/* EOF */
/* cat > src+obj/set_canvas_colormap.c << "EOF" */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* set_canvas_colormap: load a canvas subwindow		*/
/*			with a colormap.		*/
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* SCCS information: %W%	%G% - NCSA */

/* #include "all.h" */

void
set_canvas_colormap (canvas, cmsn)
	Canvas canvas;
			/* input: canvas to load colormap */
	char	*cmsn;
			/* input: colormap name */
{
	Pixwin	*pixw;

	pixw = canvas_pixwin (canvas);
	pw_setcmsname (pixw, cmsn);
	if (! strcmp (cmsn, b_cmsn))	/* partial palette */
		pw_putcolormap (pixw, 0, 256 - 2, red, green, blue);
	else				/* full palette */
		pw_putcolormap (pixw, 0, 256, red, green, blue);
}
/* EOF */
