/*** analhea2.h; header file for analog version 1.9beta5 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/ */

/*** These things are not intended to be user definable; user definable headers
     are in analhead.h ***/

#ifndef ANALHEAD2
#define ANALHEAD2

/*** First some #define's and #include's ***/

#define VERSION "1.9beta5"    /* the version number of this program */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <ctype.h>

#ifdef TRUE  /* I suppose everyone else defines TRUE = 1, but I won't */
#undef TRUE  /* risk it by doing an #ifndef! */
#endif
#define TRUE (1)
#ifdef FALSE
#undef FALSE
#endif
#define FALSE (0)
#ifdef ON
#undef ON
#endif
#define ON (TRUE)
#ifdef OFF
#undef OFF
#endif
#define OFF (FALSE)
#ifdef OK
#undef OK
#endif
#define OK (0)
#ifdef ERR
#undef ERR
#endif
#define ERR (-1)
#ifdef UNSET
#undef UNSET
#endif
#define UNSET (-1)
#define BYREQUESTS (0)       /* ways of sorting */
#define BYBYTES (1)
#define ALPHABETICAL (2)
#define RANDOMLY (3)
#define APPROX (2)       /* for hostname counting */
#define ALL (2)          /* see PAGELINKS and REQTYPE in analhead.h */
#define PAGES (1)
#define COMMON (2)       /* three types of input lines */
#define NCSAOLD (1)
#define CORRUPT (0)
#define CACHE (2)        /* output types */
#define ASCII (1)
#define HTML (0)
#ifdef MAX
#undef MAX
#endif
#define MAX(a,b) (((a)>(b))?(a):(b))
#ifdef MIN
#undef MIN
#endif
#define MIN(a,b) (((a)<(b))?(a):(b))
#ifdef ROUND
#undef ROUND
#endif            /* round double to nearest integer (as double) */
#define ROUND(x) (((x)-(floor(x)))>=0.5?ceil(x):floor(x))
#define STREQ(a,b) (strcmp(a,b)==0)
#ifdef INFINITY
#undef INFINITY
#endif            /* something very big (but that will fit in a long) */
#define INFINITY (2000000000)
#define SUNDAY (0)
#define MONDAY (1)
#define TUESDAY (2)
#define WEDNESDAY (3)
#define THURSDAY (4)
#define FRIDAY (5)
#define SATURDAY (6)
#define ISLEAPFEB(m,y) (((m)==1)&&(((y)%4)==0))  /* Feb in leap year */
#define ISLEAPJF(m,y) (((m)<=1)&&(((y)%4)==0))  /* Jan or Feb in leap year */
/* NB Every 4th year from 1901 to 2099 is a leap year */

#define DOMHASHSIZE (1354)
/* = 2 * 26^2 + 2 by description of domain algorithm */
#define NO_ERRS (29)   /* how many error types there are (in init.c) */
#define MAXERRLENGTH (40)  /* the longest one */
#define NO_STATUS (22) /* how many status codes are defined */
#define MAXSTATUSLENGTH (35)

/*** Now include the user-definable header things ***/

#include "analhead.h"

/*** Next some global structures ***/

typedef int flag;

struct timestruct {        /* some things we might want to know about a
			      particular time */
  int date;                /* the day of the month */
  int monthno;             /* 0 for Jan, ... , 11 for Dec */
  int year;                /* 4 digits */
  int hr;                  /* 0 to 23 */
  int min;                 /* 0 to 59 */
  long code;               /* an increasing (though not necessarily linear)
			      function of time, for quick comparisons.
			      Defined in timecode() */
};

struct monthly {           /* a structure for a year's worth of monthly data */
  int reqs[12];            /* the number of requests on each month */
  double bytes[12];        /* and bytes ditto */
  struct monthly *next;    /* where the next year's data is */
};

struct daily {             /* similarly, for a month's worth of daily data */
  int reqs[31];            /* NB Day n is stored in location (n - 1) */
  double bytes[31];
  struct daily *next;
};

struct hourly {            /* and for a day's worth of hourly data */
  int reqs[24];
  double bytes[24];
  struct hourly *next;
};

struct weekly {             /* a structure for weekly data */
  int reqs;
  double bytes;
  struct timestruct start;  /* the start of the week */
  struct weekly *next;
};

struct genstruct {           /* relevant information about an object */
  char *name;                /* its name */
  int reqs;                  /* its number of requests */
  double bytes;              /* the number of bytes transferred due to it */
  flag pre7;                 /* has been used before last 7 days (host only) */
  flag last7;                /* has been used in the last 7 days? */
  flag aliasdone;            /* have we done an alias on it? (URLs only) */
  struct genstruct *next;    /* the next object in the list */
};

struct domain {              /* and domains */
  char *id;                  /* can be as long as host for subdomains */
  char *revid;               /* same reversed */
  char *name;                /* the geographical location of the domain */
  int reqs;
  double bytes;
  int nexti;                 /* the index of the next domain alphabetically */
  struct domain *next;       /* the next subdomain of the current domain */
};

struct alias {      /* aliases from the configuration file */
  char from[MAXSTRINGLENGTH];
  char to[MAXSTRINGLENGTH];
  struct alias *next;
};

struct include {   /* a list of included/excluded things */
  char name[MAXSTRINGLENGTH];
  int in;           /* TRUE, FALSE or UNSET */
  struct include *next;
};

struct loglist {   /* a list of logfiles */
  char name[MAXSTRINGLENGTH];
  char prefix[MAXSTRINGLENGTH];
  struct loglist *next;
};

struct stringlist {   /* a simple list of strings */
  char name[MAXSTRINGLENGTH];
  struct stringlist *next;
};

#endif  /* not previously included */
