#!/usr/local/bin/perl
# -----------------------------------------------------------------
# bdhome.pl
# 
# Author: Mic Bowman and Satya Venneti
#
# Create the initial page for the description file maintenance
# scripts.
# -----------------------------------------------------------------
$ENV{"HARVEST_HOME"} = "/usr/local/harvest" 
	if (!defined($ENV{"HARVEST_HOME"}));
$ENV{"HSR_HOME"} = "$ENV{'HARVEST_HOME'}/gatherers/HSR";
push(@INC,$ENV{"HSR_HOME"} . "/lib");
require 'cgi.pl';
require 'hsrlibrary.pl';
require 'bdlibrary.pl';

# -----------------------------------------------------------------
# BD_BuildList
# -----------------------------------------------------------------
sub BD_BuildList {
    local($toolurl);
    local(%dlist);
    local($key,$type,$home);
    local($url,$output);

    $toolurl = &HSR_FileName("CGI","BDTool");
    %dlist = &BD_ReadDescriptions();

    $output = "";
    foreach $key (sort keys %dlist) {
	($type, $home) = split('&',$dlist{$key},2);
	$url = "<a href=\"$toolurl?TYPE=$type&HOME=$home&FILE=$key\">$key</A>";
	$output = $output . "<LI> $url\n";
    }

    return($output);
}

# -----------------------------------------------------------------
# Main
# -----------------------------------------------------------------
sub Main
{
    local($filename,$newurl);

    &HSR_Initialize;

    &CGIHeader;

    $descriptions = &BD_BuildList();
    $applyurl = &HSR_FileName("CGI","BDApply");
    $filename = &HSR_FileName("Library","BDHome.Skel");

    open(SKEL,"<$filename") ||
	&CGIError("Unable to generate update form, check configuration.");

    while (<SKEL>) {
	$_ =~ s/@APPLYURL@/$applyurl/;
	$_ =~ s/@DESCRIPTIONS@/$descriptions/;
	print $_;
    }

    close(SKEL);

}

# -----------------------------------------------------------------
&Main;
exit(0);
