#!/bin/sh
# (c) 1996 - Alexandre FENYO - fenyo@enst.fr

echo '*** Building Network-To-AS index'

echo 'Cleaning the DB/ directory'
rm -f DB/*

echo
echo 'Fetching the databases'
mirror -d -d radb.pkg
ls -l DB

echo
echo 'Uncompressing the databases'
find DB -name \*.Z  -print | xargs uncompress
find DB -name \*.gz -print | xargs gunzip
ls -l DB

echo
PWD=`pwd`
echo "Building the index, result will be : ${PWD}/net2as.*"
rm -f net2as*
for i in DB/*.db
do
  echo Indexing $i
  cat $i | ./makeindex.pl net2as
done
ls -l net2as*
