/* 
 *  $Id: disk.h,v 1.2.6.4 1996/01/30 20:00:02 duane Exp $
 **********************************************************************
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 *  
 */
#ifndef DISK_H
#define DISK_H

#include "ansihelp.h"

#define DISK_OK                   (0)
#define DISK_ERROR               (-1)
#define DISK_EOF                 (-2)
#define DISK_WRT_LOCK_FAIL       (-3)
#define DISK_WRT_WRONG_CODE      (-4)
#define DISK_FILE_NOT_FOUND      (-5)
#define DISK_NO_SPACE_LEFT       (-6)

typedef int (*FILE_READ_HD) _PARAMS((int fd, char *buf, int size, int errflag,
	caddr_t data, int offset));

typedef int (*FILE_WALK_HD) _PARAMS((int fd, int errflag, caddr_t data));

typedef int (*FILE_WALK_LHD) _PARAMS((int fd, char *buf, int size, caddr_t line_data));



extern int file_open _PARAMS((char *path, int (*handler) (), int mode));
extern int file_close _PARAMS((int fd));
extern int file_write _PARAMS((int fd, caddr_t buf, int len, int access_code,
	void       (*handle) (), void *handle_data));
extern int file_write_unlock _PARAMS((int fd, int access_code));
extern int file_read _PARAMS((int fd, caddr_t buf, int req_len, int offset,
	int       (*handler) (int fd, char *buf, int size,
	    int errflag, caddr_t data, int offset),
	caddr_t client_data));
extern int file_walk _PARAMS((int fd,
	int       (*handler) (int fd, int errflag, caddr_t data),
	caddr_t client_data,
	int       (*line_handler)
	          (int fd, char *buf, int size, caddr_t line_data),
	caddr_t line_data));
extern int file_get_fd _PARAMS((char *filename));
extern int file_update_open _PARAMS((int fd, char *path));

#endif /* DISK_H */
