/*
 * Copied from ~devet/WWW/Teletekst/wwwgate/network.c
 *
 * Author: Arjan de Vet (devet@win.tue.nl)
 * Modified by: Reinier Post (reinpost@win.tue.nl)
 */

static char rcsid[] = "$Id: network.c,v 0.6 1994/02/17 21:26:04 reinpost Exp $";

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>

#include "system.h"

#include "network.h"

#define BUFLEN 2048

void
get_hostname(int sockfd, char *host_name, char *ipnum)
{
    struct sockaddr_in      sa;
    int                     length;
    struct hostent          *hp;

    length = sizeof(sa);
    getpeername(sockfd, (struct sockaddr *) &sa, &length);
    strcpy(ipnum, inet_ntoa(sa.sin_addr));
    strcpy(host_name, inet_ntoa(sa.sin_addr));

    hp = gethostbyaddr((char *) &sa.sin_addr,
                       sizeof (sa.sin_addr.s_addr), AF_INET);

    if (hp != NULL)
        (void) strcpy(host_name, hp->h_name);
}

int
open_connection (char *them, char *port)
{
    struct sockaddr_in sin;
    struct hostent *hp;
    struct servent *sp;
    int s;

    /* Connect to specified server on specified host. */

    if ((hp = gethostbyname(them)) == 0) {
	return(TCP_UNKNOWN_HOST);
    }
    bzero((char *) &sin, sizeof(sin));
    bcopy(hp->h_addr, (char *) &sin.sin_addr, hp->h_length);
    sin.sin_family = hp->h_addrtype;
    if ((sp = getservbyname(port, "tcp"))) {
	sin.sin_port = sp->s_port;
    } else if ((sin.sin_port = htons((unsigned) atoi(port))) <= 0) {
	return(TCP_UNKNOWN_SERVICE);
    }
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	return(TCP_COULDNT_CREATE_SOCKET);
    }
    if (connect(s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
	return(TCP_COULDNT_CONNECT);
    }

    return(s);  /* RP: assume > 0 */
}
