/* error.h - header file for error messages (die() routine) */
/* relied upon by Mosaic fish search */

#define DIE_USAGE 600
#define DIE_CONFIG 601
#define DIE_BADFILE 602
#define DIE_BADSOCKET 604
#define DIE_NO_HTTP_URL 605
#define DIE_RDCACHE 606
#define DIE_WRCACHE 607
#define DIE_BROKEN_PIPE 608
#define DIE_WRONG_INTERFACE 609
#define DIE_BUG 610
#define DIE_WRONG_REQUEST 611
#define DIE_CONV 612
#define DIE_LOGFILE 613
#define DIE_DB 614
#define DIE_MIME 615
#define DIE_CAS 616
#define DIE_TIME 617
#define DIE_DIR 618
#define DIE_FILE 619
#define DIE_BAD_URL 620
#define DIE_WROUT 621
#define DIE_RDIN 622

extern void die(int err,char *reason);

extern int add_warning(char *w1, char *w2, int badness);
/*
 * adds a warning to the list of warnings
 * reports its badness (0 none, -1 non-fatal, -2 fatal)
 * returns the current overall badness
 * add_warning() can only worsen the overall badness, never reset it
 */

extern void log_warnings();
/*
 * logs the warnings in the list created with add_warning()
 * and resets both the list and the badness
 */

extern int current_badness();
/* 0 if no problems, -1 if some warnings occurred, -2 on fatal error */
