/* error.c - print errors to output as a HTML stream */

/*
 * $Log: error.c,v $
 * Revision 0.14  1994/05/17  13:39:27  reinpost
 * some superficial changes in error messages and codes
 *
 * Revision 0.14  1994/05/17  13:39:27  reinpost
 * some superficial changes in error messages and codes
 *
 * Revision 0.12  1994/04/01  15:07:22  reinpost
 * spelling changes
 *
 * Revision 0.12  1994/04/01  15:07:22  reinpost
 * spelling changes
 *
 * Revision 0.11  1994/03/25  20:44:56  reinpost
 * new error: WROUT
 *
 * Revision 0.10  1994/03/11  13:39:12  reinpost
 * freing static memory is not appreciated on Solaris - fixed it
 *
 * Revision 0.8  1994/02/25  20:25:42  reinpost
 * added storage of warnings before they can be printed (add_warning() etc.)
 * changes in error mesage codes and contents
 *
 * Revision 0.5  1994/02/17  10:21:59  reinpost
 * some changes in the message content, and renamings
 *
 * Revision 0.4  1994/02/10  12:48:42  reinpost
 * a new case DIE_was added (filename generation in database.c)
 * and the layout was slightly modified
 *
 * Revision 0.3  1994/02/01  19:47:34  reinpost
 * some new errors were added from various sources
 *
 * Revision 0.2  1994/01/25  16:08:28  reinpost
 * print_error() was moved here from cache.c and one more entry was added
 *
 */

static char rcsid[] =
  "$Id: error.c,v 0.14 1994/05/17 13:39:27 reinpost Exp $";

#include <stdio.h>
#include <malloc.h>

#include "system.h"

#include "constants.h"
#include "error.h"
#include "log.h"
#include "config.h"
#include "util.h"
#include "mime.h"

void die(int err,char *reason)
{
  char logerror[1024];
  /* open_logs(); must have been issued before */
  sprintf(logerror,"exiting writing the error rc=%d, argument: %s",err,reason);
  log_error(logerror);
  quit_logging();

  set_content_type("text/html");
  set_content_length(-1);		/* for unknown */
  set_http_status(200);			/* this is */
  set_http_reason("Cache Error");	/* provisional */
  send_http_header(stdout);
  printf("<TITLE>%d Cache Error</TITLE>%c",err,LF);
  switch(err)
  {
    case DIE_USAGE:
      printf("<H1>Call error</H1>%c",LF);
      printf("This script has been incorrectly accessed. The %c",LF);
      printf("request for a cached document has been made incorrectly.%c",LF);
      /* printf("<CODE>%s</CODE>%c",reason,LF); */
      break;
    case DIE_CONFIG:
      printf("<H1>Configuration error</H1>%c",LF);
      printf("This script probably is not set up properly on%c",LF);
      printf("this server. The problem: %s.%c",reason,LF);
      break;
    case DIE_BADFILE:
      printf("<H1>Missing document</H1>%c",LF);
      printf("The file %s is not a mirrored remote file, nor could it be found on this server.%c",reason,LF);
      break;
    case DIE_BADSOCKET:
      printf("<H1>Communication error</H1>%c",LF);
      printf("Communication to the remote site failed: %s.%c",reason,LF);
      printf("The remote host or its HTTP document server may not exist ");
      printf("or may be temporarily unavailable.%c",LF);
      break;
    case DIE_NO_HTTP_URL:
      printf("<H1>Protocol error</H1>%c",LF);
      printf("The URL %s is not a http: type URL, and cannot be cached.<P>%c",
        reason,LF);
      break;
    case DIE_BAD_URL:
      printf("<H1>Protocol error</H1>%c",LF);
      printf("The URL %s is malformed, and cannot be cached.<P>%c",
        reason,LF);
      break;
    case DIE_WRCACHE:
      printf("<H1>Write error</H1>%c",LF);
      printf("You asked for a cached version of a document.%c",LF);
      printf("For some reason, it was impossible to write this document ");
      printf("to the cache.  The file %s could not be written.<P>%c",
	reason,LF);
      break;
    case DIE_WROUT:
      printf("<H1>Write error</H1>%c",LF);
      printf("For some reason, it was impossible to write the document; ");
      printf("%s.<P>%c", reason,LF);
      break;
    case DIE_RDIN:
      printf("<H1>Read error</H1>%c",LF);
      printf("For some reason, it was impossible to read the document; ");
      printf("%s.<P>%c", reason,LF);
      break;
    case DIE_RDCACHE:
      printf("<H1>Document could not be read from cache</H1>%c",LF);
      printf("The cached document (stored in %s) could not be accessed to be sent.<P>%c",
	reason,LF);
      break;
    case DIE_CONV:
      printf("<H1>Conversion error</H1>%c",LF);
      printf("The document could not be converted in the cache; %s.<P>%c",
	reason,LF);
      break;
    case DIE_BUG:
      printf("<H1>Internal error</H1>%c",LF);
      printf("The cache routine contains a bug (%s).<P>%c", reason,LF);
      break;
    case DIE_WRONG_REQUEST:
      printf("<H1>Invalid request</H1>%c",LF);
      printf("Sorry, your client program sent a request (%s) that ",reason);
      printf("this caching mechanism is unable to handle.%c",LF);
      /* in next version, send a REDIRECT instead */
      break;
    case DIE_WRONG_INTERFACE:
      printf("<H1>Caching Incompatible Server Error</H1>%c",LF);
      printf("Sorry, the caching function is incompatible with the ");
      printf("server it has been installed with.  (In detail: it is a ");
      printf("'CGI/1.0' script, and the server wants a '%s' script.)%c",
	reason,LF);
      break;
    case DIE_LOGFILE:
      printf("<H1>Couldn't log request</H1>%c",LF);
      printf("An error occurred trying to log info on your request.%c",LF);
      printf("%s%c",reason,LF);
      printf("This has caused the request to be aborted.%c",LF);
      /*admittedly, a silly reason to abort the request */
      break;
    case DIE_DB:
      printf("<H1>Problems with internal database</H1>%c",LF);
      printf("When trying to look up info on your request, the following error occurred:%c",LF);
      printf("%s%c",reason,LF);
      break;
    case DIE_MIME:
      printf("<H1>Problems with MIME headers</H1>%c",LF);
      printf("In relation to parsing or processing of MIME headers in the ");
      printf("document, the following error occurred:%c",LF);
      printf("%s%c",reason,LF);
      break;
    case DIE_CAS:
      printf("<H1>Problems generating a new filename</H1>%c",LF);
      printf("In managing the filenames for the cached document, ");
      printf("the following error occurred:%c",LF);
      printf("%s%c",reason,LF);
      break;
    case DIE_TIME:
      printf("<H1>Timeout</H1>%c",LF);
      printf("Something took longer than we are prepared to wait:%c",LF);
      printf("%s%c",reason,LF);
      break;
    case DIE_DIR:
      printf("<H1>File management problem</H1>%c",LF);
      printf("A vital directory for the cache, %s, is inaccessible.%c",
	reason,LF);
      break;
    case DIE_FILE:
      printf("<H1>File management problem</H1>%c",LF);
      printf("Problems reading or writing the auxiliary file %s.%c",
	reason,LF);
      break;
  }

  /* if it was, append a message that the configuration file was missing */
  if (!config_file_found())
  {
    printf("<P>%cMaybe the error is due to the fact that the cache ",LF);
    printf("configuration file, <CODE>%s</CODE>, is missing.%c",CACHE_CONF,LF);
  }
  printf("<P>If you think there is a problem with the cache mechanism, ");
  printf("please contact the cache server maintainer, %s, ",server_maintainer);
  printf("and report this error.%c",LF);

  fclose(stdout);
  exit(1);
}

static int cb = 0;
static char *ws = (char *)NULL;

int current_badness()
{
  return(cb);
}

int add_warning(char *w1, char *w2, int badness)
{
  char *old_ws = ws;
  if (!w1) w1 = ""; if (!w2) w2 = "";
  if (!old_ws) old_ws = strdup("");

  ws = (char *)malloc(strlen(old_ws)+strlen(w1)+strlen(w2)+3);
  sprintf(ws,"%s%s %s\n", old_ws, w1, w2);
  free(old_ws);
  if (badness < cb) cb = badness;
  return(cb);
}

void log_warnings()
/* erases the warnings from memory, too */
{
  int next_separator;
  char *w = ws;
  if (!w) return;

  while (*w && ((next_separator = ind(w,'\n')) != -1))
  {
    w[next_separator] = '\0';
    log_error(w);
    w[next_separator] = '\n';
    w = &w[next_separator+1];
    next_separator = ind(w,'\n');
  }

  if (*w) die(DIE_BUG,"log_warnings() found a strange list of warnings");

  free(ws);
  ws = (char *)NULL;
  cb = 0;
}
