/*
 * cleanout - clean out the cache according to the criteria given
 * in the configuration file
 *
 * $Log: cleanout.c,v $
 * Revision 0.15  1994/05/18  07:56:03  reinpost
 * *** empty log message ***
 *
 * Revision 0.13  1994/05/03  19:29:01  reinpost
 * *** empty log message ***
 *
 * Revision 0.13  1994/05/03  19:29:01  reinpost
 * *** empty log message ***
 *
 * Revision 0.11  1994/03/25  20:39:15  reinpost
 * *** empty log message ***
 *
 * Revision 0.11  1994/03/25  20:39:15  reinpost
 * *** empty log message ***
 *
 * Revision 0.9  1994/03/02  21:21:02  reinpost
 * this is now a working program
 *
 * Revision 0.9  1994/03/02  21:21:02  reinpost
 * this is now a working program
 *
 * Revision 0.8  1994/02/25  20:13:06  reinpost
 * initial version - no dedicated config file which is a pain in the ass
 *
 */

static char rcsid[] =
  "$Id";

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "system.h"

#include "constants.h"
#include "error.h"
#include "database.h"
#include "cleanup.h"
#include "config.h"
/* to get the variables expire_confname and cache_root */

static int cleanout_cache()
/* preliminary version */
/* cannot fail, but I think it can die */
/* error checking is virtually nonexistent */
{
  char file[MAX_STRING_LEN+1];

  if (!set_first_cached_file(file))
  {
    /* no files are cached */
    return(1);
  }

  if (cached_file_status(file,CF_CLEANUP) == CF_OLD)
    fprintf(stderr,"removing cached file %s\n",file);

  while (set_next_cached_file(file))
  {
    if (cached_file_status(file,CF_CLEANUP) == CF_OLD)
    {
      fprintf(stderr,"removing outdated cached file %s\n",file);
      remove_cached_file(file);
    }
    else
    {
      fprintf(stderr,"cached file %s is up to date\n",file);
    }
  }
  return(1);
}

static bark(char *program_name)
{
  fprintf(stderr,"Usage: %s -d cache_directory -f configuration_file\n",
    program_name);
  exit(-1);
}

static void parse_cleanout_cmdline(int argc, char *argv[])
/* fills two global variables; dies on error in command line */
{
  struct stat finfo;

  cache_root = (char *)NULL;
  expire_confname = (char *)NULL;

  if (argc != 5) bark(argv[0]);
  if (!strcmp(argv[1],"-f")) expire_confname = strdup(argv[2]);
  else if (!strcmp(argv[1],"-d")) cache_root = strdup(argv[2]);
  else bark(argv[0]);
  if (!strcmp(argv[3],"-f")) expire_confname = strdup(argv[4]);
  else if (!strcmp(argv[3],"-d")) cache_root = strdup(argv[4]);
  else bark(argv[0]);

  if (!cache_root || !expire_confname) bark(argv[0]);

  if ((stat(expire_confname,&finfo) == -1) || !S_ISREG(finfo.st_mode))
  {
    fprintf(stderr,"configuration file %s is missing or is not a regular file\n",expire_confname);
    exit(-2);
  }

  if ((stat(cache_root,&finfo) == -1) || !S_ISDIR(finfo.st_mode))
  {
    fprintf(stderr,"cache directory %s is missing or is not a directory\n",cache_root);
    exit(-2);
  }
}

int main(int argc, char *argv[])
{
  parse_cleanout_cmdline(argc,argv);

  if (!cleanout_cache())
  {
    fprintf(stderr,"something went wrong in trying to cleanoout the cache\n");
    /* hm, currently, cleanout_cache() always succeeds */
    exit (-3);
  }
  exit(0);
}
