#include "defs.h"
#include <ctype.h>
	
void refinehightext(char *text, int len);
/*
 * refinehightext strips control codes off the end of some of the 
 * lines of text that are input from pc database files.  Most notably
 * the hytelnet files contain some stange codes at the end of each line
 * that cause lynx to behave funny.  It also strips of extra spaces at
 * the end of the line which makes lynx look prettier.
 *
 */

void refinehightext(char *text, int len)
{
    char *x;

    /* this basicly finds the first non printable character or space
       and terminates it by putting a \0 there */
    for(x=text+len; !isgraph(*x); x--)
	; /* null body */

    *(x+1) = '\0';
}
