//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx : public TApplication
//	Include File:	TDosLynx.h
//	Purpose:	Implement our application object.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-09-93	created
//		02-09-04	Split all members to seperate files to enhance
//				overlay support.
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TKeys
#include"tdoslynx.h"
#include"globals.h"

TMenuBar *TDosLynx::initMenuBar(TRect TR_r)	{
//	Purpose:	Initialize the menu bar.
//	Arguments:	TR_r	Dimensions of the menu.
//	Return Value:	TMenuBar *	the new menu created.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-10-93	created

	//	Set bottom line one below from top
	TR_r.b.y = TR_r.a.y + 1;
	TSubMenu& TSM_File =
		*new TSubMenu("~F~ile", kbAltF, hcNoContext) +
		*new TMenuItem("~O~pen URL...", cmOpenURL, kbF3, hcNoContext,
			"F3") +
		*new TMenuItem("Open ~L~ocal...", cmOpenLocal, kbNoKey,
			hcNoContext) +
		*new TMenuItem("~C~lose", cmClose, kbAltF3, hcNoContext,
			"Alt-F3") +
		newLine() +
		*new TMenuItem("~S~ave Rendering...", cmSaveDLX, kbF2,
			hcNoContext, "F2") +
		*new TMenuItem("~P~rint Rendering...", cmPrint, kbNoKey,
			hcNoContext, NULL) +
		newLine() +
		*new TMenuItem("~D~os Shell", cmDosShell, kbNoKey,
			hcNoContext) +
		*new TMenuItem("E~x~it", cmQuit, kbAltX, hcNoContext,
			"Alt-X");
	TSubMenu& TSM_Navigate =
		*new TSubMenu("~N~avigate", kbAltN, hcNoContext) +
		*new TMenuItem("~F~ind...", cmSearch, kbNoKey, hcNoContext,
			NULL) +
		*new TMenuItem("Find ~A~gain", cmSearchAgainDLX, kbF4,
			hcNoContext, "F4") +
		newLine() +
		*new TMenuItem("~N~ext Anchor", cmNextAnchor, kbNoKey,
			hcNoContext, "J, 2") +
		*new TMenuItem("~P~revious Anchor", cmPreviousAnchor,
			kbNoKey, hcNoContext, "K, 8") +
		newLine() +
		*new TMenuItem("~A~ctivate Anchor", cmSelectAnchor, kbNoKey,
			hcNoContext, "L, 6") +
		*new TMenuItem("Prior ~D~ocument", cmPreviousDocument,
			kbNoKey, hcNoContext, "H, 4") +
		newLine() +
		*new TMenuItem("Search ~I~ndex...", cmSearchIndex, kbF7,
			hcNoContext, "F7") +
		newLine() +
		*new TMenuItem("Show Destination ~U~RL", cmShowDestination,
			kbNoKey, NULL);
	TSubMenu& TSM_Options =
		*new TSubMenu("~O~ptions", kbAltO, hcNoContext) +
		*new TMenuItem("~T~oggle Low/High Text Mode", cmVideoMode, kbNoKey,
			hcNoContext)
#ifndef RELEASE
		+
		newLine() +
		*new TMenuItem("Trace DOSLYNX", cmTraceDOSLYNX, kbNoKey,
			hcNoContext) +
		*new TMenuItem("Trace WWW", cmTraceWWW, kbNoKey,
			hcNoContext) +
		*new TMenuItem("Trace WATTCP", cmTraceWATTCP, kbNoKey,
			hcNoContext)
#endif // RELEASE
		;
	TSubMenu& TSM_Window =
		*new TSubMenu("~W~indow", kbAltW, hcNoContext) +
		*new TMenuItem("~M~essages", cmUnHideMessage, kbNoKey,
			hcNoContext) +
		newLine() +
		*new TMenuItem("C~l~one Window", cmCloneWindow, kbNoKey,
			hcNoContext, NULL) +
		newLine() +
		*new TMenuItem("~Z~oom", cmZoom, kbF5, hcNoContext, "F5") +
		*new TMenuItem("~R~esize", cmResize, kbAltF5, hcNoContext,
			"Alt-F5") +
		*new TMenuItem("~C~ascade", cmCascade, kbNoKey, hcNoContext) +
		*new TMenuItem("~T~ile", cmTile, kbNoKey, hcNoContext);
	TSubMenu& TSM_HotList =
		*new TSubMenu("~H~otlist", kbAltH, hcNoContext) +
		*new TMenuItem("~V~iew...", cmHotList, kbF1, hcNoContext,
			"F1")	+
		*new TMenuItem("~A~dd Current To Hotlist", cmAddToHotList,
			kbNoKey, hcNoContext, NULL) +
		newLine() +
		*new TMenuItem("Home ~P~age", cmHomePage, kbF9,
			hcNoContext, "F9");
	TSubMenu& TSM_Help =
		*new TSubMenu("Help", kbNoKey, hcNoContext) +
		*new TMenuItem("~A~bout DosLynx", cmAboutDosLynx, kbNoKey,
			hcNoContext) +
		*new TMenuItem("~M~ail Developer", cmMailDeveloper, kbNoKey,
			hcNoContext);
	return(new TMenuBar(TR_r, TSM_File + TSM_Navigate + TSM_Options +
		TSM_Window + TSM_HotList + TSM_Help));
}
