//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TCapture
//	Include File:	tcapture.h
//	Purpose:	Captures c streams stdout and sterr to a window.
//	Remarks/Portability/Dependencies/Restrictions:
//		Works in conjuction with the c source file capstdio.c and
//		two global variables capstdout and capstderr in globals.c
//	Revision History:
//		01-08-94	created
//		02-09-94	Split all members into seperate files.
#define Uses_otstream
#include"tcapture.h"

TCapture::TCapture(TRect TR, const char *cp_title, unsigned short int
	usi_bufsize) :
	TWindowInit(TCapture::initFrame),
	TWindow(TR, cp_title, 0)	{
//	Purpose:	Constructor of the TCapture object.
//	Arguments:	TR		The rectangle to occupy.
//			cp_title	The title of the window.
//			usi_bufsize	The size of the buffer for the dumb
//					terminal.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-08-94	created
//		08-09-94	Modified to send output to NUL if not needed.

	//	Set out palette to that of a message window.
	palette = wpCyanWindow;

	//	Get the size of the window.
	//	Create the terminal.
	TR = getExtent();
	TR.grow(-1, -1);

	if(B_noInfo == FALSE)	{
		TT = new TTerminal(TR, NULL, standardScrollBar(sbVertical |
			sbHandleKeyboard), usi_bufsize);
		insert(TT);

		otstream ot(TT);
		DumbStream = ot;
	}
	else	{
		//	Warning, serious DOS/C++ hack coming!!!
		//	We are not sending the output anywhere if they don't
		//	want to see it set by the B_noInfo global, so to
		//	avoid making two different binary versions, we hack
		//	below to assign the same functionality but output
		//	is going absolutely nowhere.

		//	Open up the NUL device.
		filebuf *fb = new filebuf();
		fb->open("NUL", ios::out);

		//	Assign the stream.
		ostream os(fb);
		DumbStream = os;
	}
}