#!/usr/local/bin/perl
#                              -*- Mode: Perl -*- 
# query.pl -- 
# ITIID           : $ITI$ $Header $__Header$
# Author          : Ulrich Pfeifer
# Created On      : Thu Mar 31 13:48:36 1994
# Last Modified By: Ulrich Pfeifer
# Last Modified On: Fri Jun 24 19:38:40 1994
# Update Count    : 86
# Status          : Unknown, Use with caution!
# 

$deffld_field   = 'text';                                    # default field name
$plain_field    = 'text';
$database_field = 'database';                                # fieldname

sub error {
    local($msg) = @_;
    
    $perror .= "$msg\n";
    $errno++;
}

sub decode {
    local($_) = @_;
    
    s/%([0-9A-F]{2})/pack('C',hex($1))/eig; 
    s/\+/ /g;
    $_;
}

sub encode {
    local($_) = @_;
    s/([^\w-.:])/sprintf("%%%02x",ord($1))/eg; 
    $_;
}

sub sloppy_encode {
    local($_) = @_;
    s/([^\w\/:\-\.\=\&\;])/sprintf("%%%02x",ord($1))/eg; 
    $_;
}

sub detex {
    local($_) = @_;
  s/\"a/\344/g;
  s/\"A/\304/g;
  s/\"o/\366/g;
  s/\"O/\334/g;
  s/\"u/\374/g;
  s/\"U/\326/g;
  s/\"s/\337/g;
  $_;
}

# ignore begin
sub deiso {
    local($_) = @_;

    s#\304#Ae#g;  #196
    s#\344#ae#g;  #228
    s#\334#Oe#g;  #220
    s#\366#oe#g;  #246
    s#\326#Ue#g;  #214
    s#\374#ue#g;  #252
    s#\337#sz#g;  #219
    $_;
}

sub eniso {
    local($_) = @_;

    s#Ae#\304#g;
    s#ae#\344#g;
    s#Oe#\334#g;
    s#oe#\366#g;
    s#Ue#\326#g;
    s#ue#\374#g;
    s#sz#\337#g;
    $_;
}
# ignore end

sub parse_query_string {
    local($url) = @_;
    local($_,$name,$value,%table);

    for (split(/&/,$url)) {
        if ( /=/) {                                 
            ($name,$value) = split(/=/,$_,2);
        } else {
            $name = $deffld_field;
            $value = $_;
        }
        next unless $value;
        $value = &detex(&decode($value)); # unless $name eq $database_field;
        if ($table{$name}) {
            $table{$name} .= " ".$value;
        } else {
            $table{$name} = $value;
        }
    }

    %table;
}

# ignore begin
sub translate_query {
    local($query_string) = @_;
    &parse_query_string($query_string);
}
# ignore end

sub retranslate_query {
    local(%table) = @_;
    local($_,$result);

    for (keys %table) {
        $result .= &sloppy_encode($_)."=".&sloppy_encode($table{$_})."&";
    }
    chop($result);
    $result;
}

sub translate_query1 {
    local(%table) = @_;
    local($_,%pred,%index,$index,@databases,@words,
          @iwords,$words,$query,$fld,$type,$term);
    
    if ($table{$database_field}) {
        @databases = split(/ /,$table{$database_field});
        delete($table{$database_field});
    }

    # extract the special fields
    for (grep(/_[pi]$/, keys %table)) {
        if (/^(.*)_p$/) {                              # predicates
            $pred{$1}  = $table{$_} || "==";
        } elsif (/^(.*)_i$/) {                         # index types
            $fld = $1;
            if ($table{$_} =~ /plain|strikt|genau/i) {
                $index{$fld} .= "$plain_field,";
            } 
            if ($table{$_} =~ /soundex|\344hnlich/i) {
                $index{$fld} .= 'soundex,';
            }
            chop($index{$fld}) if $index{$fld};
        }
        delete ($table{$_});
    }

#    # ok, lets build the query string
#    # Let's get the plain text words
#    if ($table{$deffld_field} ) {                             # text may be omitted
#        $query = $table{$deffld_field}.' ';                  # in query
#        delete($table{$deffld_field});
#    }
    # now the other fields
    for (keys %table) {
        next unless $table{$_} =~ /./;
        @words = split(' ',$table{$_});
        # sanity checks
        if ($index{$_} && $pred{$_}) {
            &error("Nummeric and soundex together are of no use!");
            next;
        }
        if ($pred{$_} && ($#words > $[)) {
            &error("Nummeric comparrision only for one argument!");
        }
            
        if ($index{$_}) {                              # prepend each word
                                                       # with the index type
            for $word (@words) {
                if ($word =~ /^(und|oder|and|or|not|nicht)$/) { # not for boolean ops
                    push(@iwords, $word);
                } else {
                    $term = '';
                    for $type (split(/,/,$index{$_})) {
                        if ($type eq $plain_field) {
                            $term .= "$word ";
                        } else {
                            $term .= "$type $word";
                        }
                    }
                    push(@iwords, "($term)");          # brace each term
                }
            }
            @words = @iwords;
        }
        $words = join(' ',@words);
        
        if ($pred{$_}) {                               # we have a nummeric 
                                                       # predicate
            if ($_ eq $deffld_field) {
                &error("Nummeric in default field not supported!");
                next;
            }
            $query .= "$_$pred{$_}$words ";
        } else {
            # text may be omitted
            if ($_ eq $deffld_field) {
                if ($words =~ /\W/) {
                    $query .= "($words ) $tie ";
                } else {
                    $query .= "$words $tie ";
                }
            } else {
                if ($words =~ /\W/) {
                    $query .= "$_=($words) $tie ";
                } else {
                    $query .= "$_=($words) $tie ";
                }
                
            }
        }
    }
    # now let's fix the boolean operators (use german also)
    $query =~ s/ $tie $//;
    $query =~ s/(\W)und(\W)/\1and\2/g;
    $query =~ s/(\W)nicht(\W)/\1not\2/g;
    $query =~ s/(\W)oder(\W)/\1\2/g;
    # trimm spaces
    $query =~ s/\s{2,}/ /g;
    $query =~ s/^\s+//;
    $query =~ s/\s+$//;
    $query =~ tr/A-Z\304\334\326/a-z\344\366\374/;      # wais downcases all
    $query =~ s/^\(([^()]*)\)$/$1/;
    return($query, @databases);
}

1;
