//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx : public TApplication
//	Include File:	TDosLynx.h
//	Purpose:	Implement our application object.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-09-93	created
//		02-09-04	Split all members to seperate files to enhance
//				overlay support.
#define Uses_TDeskTop
#include"tdoslynx.h"
#include"turlwind.h"
#include"tcapture.h"
#include"globals.h"
#include"trace.h"
#include"urltodos.h"
#include<ctype.h>
#include<string.h>
#include<stdlib.h>

void TDosLynx::EvalOption(int i_sequence, char *cp_argument)	{
//	Purpose:	Determine the implications of a command line argument
//	Arguments:	i_sequence	A number corellating to the array in
//					the list the argument was on the
//					command line.
//			cp_argument	The argument to evaluate.
//	Return Value:   void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-13-93	created

	if(i_sequence == 0)	{
		//	This is the actual command issued to execute doslynx.
		//	Parse only if need be.
	}
	else	{
		//	Here, we take care of options.

		//	If there is no leading slash, we assume a url.
		if(*cp_argument != '/')	{
			//	Check if this is a dos path.  If so,
			//	convert it to a URL.
			//	We check by attempt to recognize any possible
			//	url access types, and if not, then assume a
			//	dos path.
			auto char urlbuff[usi_TILURLSize];
			if(strncmpi("wais:", cp_argument, 5))	{
			if(strncmpi("news:", cp_argument, 5))	{
			if(strncmpi("ftp:", cp_argument, 4))	{
			if(strncmpi("gopher:", cp_argument, 7))	{
			if(strncmpi("http:", cp_argument, 5))	{
			if(strncmpi("rlogin:", cp_argument, 7))	{
			if(strncmpi("file:", cp_argument, 5))	{
			if(strncmpi("telnet:", cp_argument, 7))	{
			if(strncmpi("nntp:", cp_argument, 5))	{
			if(strncmpi("mailto:", cp_argument, 7))	{
				//	assume a dos path.
				//	Put the dos path in the open local
				//	history.
				historyAdd(usi_OpenLocalHist, cp_argument);

				//	Convert to a URL that WWW will take.
				dostourl(urlbuff, cp_argument);
				cp_argument = urlbuff;
			}
			}
			}
			}
			}
			}
			}
			}
			}
			}

			//	Create our new valid window.
			TView *TV_new = validView((TView *)new
				TURLWindow(cp_argument));

			//	If not created, don't insert onto the desktop.
			//	Assume WWW produced appropriate error message.
			if(TV_new != NULL)	{
				//	Insert onto the desktop.
				deskTop->insert(TV_new);
				//	Here we insert the url into the open
				//	url history list.
				historyAdd(usi_OpenURLHist, cp_argument);
				//	Don't load home if URL on command
				//	line.
				B_loadHome = False;
			}
		}
		else	{
			//	Move argument past the '/'
			cp_argument++;

			if(*cp_argument == '?')	{
				//	Command line help for switches
				doslynxmessage("Command line help not yet "
					"implemented.");
#ifdef TODO
#error Implement command line help.
#endif	//	TODO
			}
			else if(toupper(*cp_argument) == 'P')	{
				//	This will set the path of the ini file
				cp_argument++;

				//	Free if previously encountered.
				if(cp_inipath != NULL)	{
					delete(cp_inipath);
				}

				//	Construct the global path variable.
				cp_inipath = new char[strlen(cp_argument) +
					1];
				strcpy(cp_inipath, cp_argument);
#ifndef RELEASE
				trace("Configuration files in " <<
					cp_inipath);
#endif // RELEASE
			}
			else if(toupper(*cp_argument) == 'T')	{
				//	This will set the temporary directory
				//	in which to write temporary files.
				cp_argument++;

				if(cp_TempDir != NULL)	{
					delete(cp_TempDir);
				}

				//	Construct the global temp dir name.
				cp_TempDir = new char[strlen(cp_argument) +
					1];
				strcpy(cp_TempDir, cp_argument);
#ifndef RELEASE
				trace("Temporary file directory is " <<
					cp_TempDir);
#endif // RELEASE
			}
			else if(toupper(*cp_argument) == 'L')	{
				//	This will set the maximum number of
				//	loaded HTexts.
				cp_argument++;

				//	Make sure that we can covert the
				//	string, if unable, keep the default
				//	maximum.
				usi_MaxLoadedHTexts = atoi(cp_argument) == 0
					? usi_MaxLoadedHTexts : atoi(
					cp_argument);
#ifndef RELEASE
				trace("Maximum loaded HTexts set to " <<
					usi_MaxLoadedHTexts);
#endif // RELEASE
			}
#ifndef RELEASE
			else if(strcmpi(cp_argument, "debug") == 0)	{
				//	Enable debugging mode.
				c_trace = 1;
				trace("Debug mode enabled at argument " <<
					i_sequence);
			}
#endif // RELEASE
			else if(toupper(*cp_argument) == 'V')	{
				//	This will set what text mode the
				//	user hopes to set to.
				cp_argument++;

				//	Check for high or low.
				if(stricmp("HIGH", cp_argument))	{
				if(stricmp("LOW", cp_argument))	{
					//	bad value.
				}
				else	{
					//	low
					if(B_isLow != True)	{
						switchVideo();
					}
				}
				}
				else	{
					//	high
					if(B_isLow != False)	{
						switchVideo();
					}
				}
			}
			else if(toupper(*cp_argument) == 'H')	{
				//	This will set wether or now DosLynx
				//	will load up the home page once
				//	started.
				cp_argument++;

				//	Check for on or off.
				if(stricmp("OFF", cp_argument))	{
				if(stricmp("ON", cp_argument))	{
					//	bad value.
				}
				else	{
					//	on
					B_loadHome = True;
				}
				}
				else	{
					//	off
					B_loadHome = False;
				}
			}
			else if(toupper(*cp_argument) == 'N')	{
				//	This will set wether or not DosLynx
				//	will allow network access
				cp_argument++;

				//	Check for yes or no.
				if(stricmp("YES", cp_argument))	{
				if(stricmp("NO", cp_argument))	{
					//	bad value.
				}
				else	{
					//	no
					i_networked = 0;
				}
				}
				else	{
					//	yes
					i_networked = 1;
				}
			}
			else	{
				//	Print an error if argument not found.
				doslynxmessage("Unknown command line option "
					<< (cp_argument - 1));
			}
		}
	}
}
