/*  
 *  Usage:
 *  
 *    wwrtest ...
 *  
 *  Not all possible error checking is done.
 */    

#include <stdio.h>
#include <string.h>
#include "whois.h"


#define CONS 0
#define SRCH 1


extern const char *tail proto_((const char *path));
extern void usage proto_((void));
  

const char *prog;


int main(ac, av)
  int ac;
  char **av;
{
  WItem *l;
  WItem *lst;
  char *s;
  int state;
  
  prog = tail(av[0]);

  wSetDebug(2);

  /*  
   *  Test routines to create a search query.
   */    

  fprintf(stderr, "\nCreate search query from command line.\n");
  fprintf(stderr,   "--------------------------------------\n\n");

  lst = l = wCreateSearch();
  while (av++, --ac)
  {
    if (av[0][0] == '-')
    {
      switch (av[0][1])
      {
      case 'c': state = CONS; break;
      case 's': state = SRCH; break;
      default: usage();
      }
    }
    else
    {
      char *e = strchr(*av, '=');

      if ( ! e)
      {
        wFreeList(lst);
        exit(1);
      }
      *e = '\0';

      switch (state)
      {
      case CONS:
        wAppendConstraint(l, *av, e+1);
        break;

      case SRCH:
        l = wAppendTerm(lst, F_ATTR_VAL, *av, e+1);
        break;

      default:
        fprintf(stderr, "%s: bad state value, `%d'.\n", prog, state);
        exit(1);
        break;
      }
    }
  }

  fprintf(stderr, "\nConstructed query is:\n\n");
  wPrintList(stderr, lst);

  /*  
   *  Test commands to extract values
   */  

  fprintf(stderr, "\nAgain, query is:\n\n");
  l = lst;
  do
  {
    WItem *c;

    fprintf(stderr, "Type: %d, Format: %d, LHS: `%s', RHS: `%s'.\n", (int)wGetType(l),
            (int)wGetFormat(l), wGetLHS(l) ? wGetLHS(l) : "", wGetRHS(l) ? wGetRHS(l) : "");
    c = wFirstConstraint(l);
    if (c)
    {
      fprintf(stderr, "Constraints:\n");
      do
      {
        fprintf(stderr, "\tType: %d, Format: %d, LHS: `%s', RHS: `%s'.\n", (int)wGetType(c),
                (int)wGetFormat(c), wGetLHS(c) ? wGetLHS(c) : "", wGetRHS(c) ? wGetRHS(c) : "");
      }
      while ((c = wNextItem(c)));
    }
  }
  while ((l = wNextItem(l)));

  /*  
   *  Test wQueryStr() and wQueryParse().
   */  

  fprintf(stderr, "\nCreate search string with wQueryStr(); parse with wQueryParse().\n");
  fprintf(stderr,   "----------------------------------------------------------------\n\n");

  if ( ! (s = wQueryStr(lst)))
  {
    fprintf(stderr, "%s: wQueryStr() failed on search string!\n", prog);
  }
  else
  {
    WItem *lst2;

    fprintf(stderr, "wQueryStr() produced [%s].\n\n", s);
    lst2 = wQueryParse(s);
    if ( ! lst2)
    {
      fprintf(stderr, "%s: wQueryParse() failed on search string generated by wQueryStr()!.\n",
              prog);
    }
    else
    {
      fprintf(stderr, "wQueryParse produced:\n\n");
      wPrintList(stderr, lst2);
      wFreeList(lst2);
    }
  }

  wFreeList(lst);

  /*  
   *  Test wCreateCommand() and other functions on commands.
   */  

  fprintf(stderr, "\nCreate command query.\n");
  fprintf(stderr,   "---------------------\n\n");

  lst = wCreateCommand("help", "foobar");
  wAppendConstraint(lst, "hold", "true");

  fprintf(stderr, "\n\nCommand is:\n\n");
  wPrintList(stderr, lst);

  if ( ! (s = wQueryStr(lst)))
  {
    fprintf(stderr, "%s: wQueryStr() failed on command list!\n", prog);
  }
  else
  {
    WItem *lst2 = wQueryParse(s);

    if ( ! lst2)
    {
      fprintf(stderr, "%s: wQueryParse() failed on command string generated by wQueryStr()!.\n",
              prog);
    }
    else
    {
      fprintf(stderr, "wQueryParse produced:\n\n");
      wPrintList(stderr, lst2);
      wFreeList(lst2);
    }
  }

  wFreeList(lst);

  /*  
   *  Failed command
   */  

  fprintf(stderr, "\nFail while creating a command query.\n");
  fprintf(stderr,   "------------------------------------\n\n");

  lst = wCreateCommand("help", "foobar");
  wAppendConstraint(lst, "hold", "true");
  if ( ! wAppendTerm(lst, F_ATTR, "foo", "bar")) /* should cause an error */
  {
    fprintf(stderr, "\n%s: error appending to command (as it should be).\n", prog);
  }

  fprintf(stderr, "\n\nFailed command is:\n\n");
  wPrintList(stderr, lst);
  wFreeList(lst);

  /*  
   *  Test commands for creating replies.
   */  

  fprintf(stderr, "\nCreate a reply.\n");
  fprintf(stderr,   "---------------\n\n");

  lst = wCreateReply(R_FULL, 2);
  wAppendTerm(lst, R_FULL_FMT, "user", "DE13");
  wAppendTerm(lst, R_FULL, "first-name", "Dwayne");
  wAppendTerm(lst, R_FULL, "last-name", "Esper");

  wAppendTerm(lst, R_FULL_FMT, "user", "BG2");
  wAppendTerm(lst, R_FULL, "first-name", "Bert");
  wAppendTerm(lst, R_FULL, "last-name", "Gordon");

  fprintf(stderr, "\nReply is:\n\n");
  wPrintList(stderr, lst);

  fprintf(stderr, "\nwReply() produces:\n\n");
  if ( ! wReply(lst, stderr))
  {
    fprintf(stderr, "%s: wReply() failed.\n", prog);
  }
  wFreeList(lst);

  exit(0);
}


const char *tail(path)
  const char *path;
{
  char *p = strrchr(path, '/');
  return p ? p+1 : path;
}


void usage()
{
  fprintf(stderr, "Usage: %s ([-c <con-name> <con-val> ...] | [-s <attr-name> <attr-val> ...])*\n",
          prog);
  exit(1);
}
