/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
 *
 * $Log:	qdisplay.c,v $
 * Revision 1.10  92/04/28  15:29:31  jonathan
 * Cleaned up ANSI specs on most function calls.
 * 
 * Revision 1.9  92/03/23  16:11:59  jonathan
 * added save requester.
 * 
 * Revision 1.8  92/03/17  14:16:40  jonathan
 * Added cursor support.
 * 
*/

#ifndef lint
static char *RCSid = "$Header: /tmp_mnt/net/quake/proj/wais/wais-8-b5/x/RCS/qdisplay.c,v 1.10 92/04/28 15:29:31 jonathan Exp $";
#endif

#include "xwais.h"
#include "cursor.h"
#include "xwaisq.bit"
#include "xwaist.bit"

void SetqIcon(parent)
Widget parent;
{
  Arg args[1];
  Pixmap icon_pixmap = None;

  XtSetArg (args[0], XtNiconPixmap, &icon_pixmap);
  XtGetValues(parent, args, ONE);
  if (icon_pixmap == None) {
    XtSetArg(args[0], XtNiconPixmap, 
	     XCreateBitmapFromData(XtDisplay(parent),
				   XtScreen(parent)->root,
				   xwaisq_bits, xwaisq_width, xwaisq_height));
    XtSetValues (parent, args, ONE);
  }
}

void SettIcon(parent)
Widget parent;
{
  Arg args[1];
  Pixmap icon_pixmap = None;

  XtSetArg (args[0], XtNiconPixmap, &icon_pixmap);
  XtGetValues(parent, args, ONE);
  if (icon_pixmap == None) {
    XtSetArg(args[0], XtNiconPixmap, 
	     XCreateBitmapFromData(XtDisplay(parent),
				   XtScreen(parent)->root,
				   xwaist_bits, xwaist_width, xwaist_height));
    XtSetValues (parent, args, ONE);
  }
}

Widget
MakeQuestionPane(parent, question)
Widget parent;
XQuestion question;
{
  Widget frame, stringlabelwid, button, view;
  static String
    name = "";
  Arg arglist[10];
  Cardinal num_args;
  static String items[] = {NULL};
  Question q = question->q;

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, q->name); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, q->name); num_args++;
  question->window->shell = parent;
  frame =
    XtCreateManagedWidget("questionpopupform", formWidgetClass,
			  question->window->shell, NULL, ZERO);

  SetqIcon(question->window->shell);

  stringlabelwid =
    MakeLabel(frame, "keywordlabel", "Tell me about:", NULL, NULL);
  question->window->keywordwid =
    MakeStringBox(frame, "keywords", "", stringlabelwid, NULL);

  searchButton = MakeCommandButton(frame, "wsearch", DoSearch,
			     stringlabelwid, question->window->keywordwid, NULL);
  stringlabelwid =
    MakeLabel(frame, "qsourcelabel", "In Sources:",
	      NULL, NULL);

  num_args = 0;
/*  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++; */
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("sview", viewportWidgetClass,
				frame, arglist, num_args);

  question->window->Sources =
    MakeScrollList(view, "questionsource", question->Source_Items,
		   EditQuestionSource, NULL, NULL);

  stringlabelwid =
    MakeLabel(frame, "qdoclabel", "Similar to:",
	      question->window->keywordwid, NULL);

  num_args = 0;
/*  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++;*/
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("dview", viewportWidgetClass,
				frame, arglist, num_args);

  question->window->RelevantDocuments = 
    MakeScrollList(view, "questiondoc", question->Relevant_Items,
		   ViewRelevant, NULL, NULL);

  addSourceButton = button =
    MakeCommandButton(frame, "qaddsource", PopupSourceMenu,
		      view, NULL, NULL);
  delSourceButton = button =
    MakeCommandButton(frame, "qdeletesource", DeleteQuestionSource,
		      view, button, NULL);
  addDocButton = button =
    MakeCommandButton(frame, "qadddoc", AddResponseToQuestion,
		      view, NULL, NULL);
  delDocButton = button =
    MakeCommandButton(frame, "qdeletedoc", DeleteQuestionDoc,
		      view, button, NULL);

  stringlabelwid =
    MakeLabel(frame, "qreslabel", "Resulting\ndocuments:",
	      NULL, NULL);

  viewbutton = button = 
    MakeCommandButton(frame, "view", ViewResponse,
		      stringlabelwid, NULL, NULL);

  saveAsButton = button =
    MakeCommandButton(frame, "qsave", ViewResponse,
		      button, NULL, NULL);

  abortButton = button =
    MakeCommandButton(frame, "Abort", Abort,
		      button, NULL, NULL);

  helpButton = button =
    MakeCommandButton(frame, "help", XwaisHelp,
		      button, NULL, NULL);
  doneButton = button =
    MakeCommandButton(frame, "qdone", CloseQuestionEdit,
		      button, NULL, NULL);

  num_args = 0;
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("rview", viewportWidgetClass,
				frame, arglist, num_args);

  question->window->ResultDocuments = 
    MakeScrollList(view, "questionresults", question->Result_Items,
		   ViewResponse, NULL, NULL);

  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextEdit); num_args++;
  XtSetArg(arglist[num_args], XtNsensitive, False); num_args++;

  stringlabelwid =
    MakeLabel(frame, "statuslabel", "Status:",
	      NULL, NULL);

  question->window->StatusWindow =
    XtCreateManagedWidget("statusWindow", asciiTextWidgetClass,
			  frame, arglist, num_args);
  return(question->window->shell);
}

Widget
MakeTextPopup(parent, t, name)
Widget parent;
Textbuff t;
char *name;
{
  Widget frame, button;
  Arg arglist[10];
  Cardinal num_args;
  static String items[] = {NULL};

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, name); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, name); num_args++;
  t->shell = XtCreatePopupShell("textpopup", applicationShellWidgetClass,
				parent, arglist, num_args);
  frame =
    XtCreateManagedWidget("questionpopupform", formWidgetClass,
			  t->shell, NULL, ZERO);

  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextRead); num_args++;
  t->textwindow =
    XtCreateManagedWidget("textWindow", asciiTextWidgetClass, frame, arglist, num_args);

  button = MakeCommandButton(frame, "addSection",addSection,
			     t->textwindow, NULL, NULL);
  button = MakeCommandButton(frame, "findKey", showKeyword,
			     t->textwindow, button, NULL);
  button = MakeCommandButton(frame, "showNext", showNext,
			     t->textwindow, button, (XtPointer)t);
  button = MakeCommandButton(frame, "showPrevious", showPrevious,
			     t->textwindow, button, (XtPointer)t);
  button = MakeCommandButton(frame, "filesave", SaveText,
			     t->textwindow, button, NULL);
  button = MakeCommandButton(frame, "tdone", EndText,
			     t->textwindow, button, (XtPointer)t);

  MakeLabel(frame, "textstatuslabel", "Status:", button, NULL);
  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextEdit); num_args++;
  XtSetArg(arglist[num_args], XtNsensitive, False); num_args++;

  t->status =
    XtCreateManagedWidget("textStatus", asciiTextWidgetClass, frame, arglist, num_args);

  SettIcon(t->shell);

  XtPopup(t->shell, XtGrabNone);

  return t->textwindow;
}


QuestionWindow
MakeQuestionForm(question)
XQuestion question;
{
  Widget frame, labelwid, stringlabelwid, button;
  WidgetClass wclass;
  static String
    name = "";
  Arg arglist[10];
  Cardinal num_args;
  static String items[] = {NULL};
  int n;
  float shown;
  QuestionWindow result;
  Question q = question->q;

  if((result = (QuestionWindow) s_malloc(sizeof(_QuestionWindow))) == NULL) {
    XwaisPrintf("Unable to allocate space for new window.\n");
    return(NULL);
  }

  question->window = result;
  q->CurrentSource = NO_ITEM_SELECTED;
  q->CurrentRelDoc = NO_ITEM_SELECTED;
  q->CurrentResDoc = NO_ITEM_SELECTED;

  result->shell = (Widget)MakeQuestionPane(top, question);

  ReplaceText(result->keywordwid, q->keywords);

  return(result);
}

Widget
MakeSourcePopup(parent)
Widget parent;
{
  Widget shell, frame, labelwid, stringlabelwid, button;
  WidgetClass wclass;
  static String
    namestring,
  serverstring,
  servicestring,
  dbstring,
  cost, units,
  maintainer,
  description;
  int CurrentSource;

  namestring = "default";
  serverstring = "localhost";
  servicestring = "8000";
  dbstring = "";
  cost = "";
  units = "";
  maintainer = "";
  description = "";

  shell = XtCreatePopupShell("sourcepopup", applicationShellWidgetClass,
			     parent, NULL, ZERO);
  frame = XtCreateManagedWidget("sourcepopupform", formWidgetClass,
				shell, NULL, ZERO);

  labelwid = MakeLabel(frame, "sourceditlabel", "Source Edit", NULL, NULL);

  stringlabelwid = MakeLabel(frame, "sourcenamelabel", "       Name:", labelwid, NULL);
  snamewid = MakeStringBox(frame, "sourcename", namestring, labelwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "serverlabel",     "     Server:", snamewid, NULL);
  serverwid = MakeStringBox(frame, "server", serverstring, snamewid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "servicelabel", "    Service:", serverwid, NULL);
  servicewid = MakeStringBox(frame, "service", serverstring, serverwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "dblabel",      "   Database:", stringlabelwid, NULL);
  dbwid = MakeStringBox(frame, "database", dbstring, servicewid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "costlabel",    "       Cost:", stringlabelwid, NULL);
  costwid = MakeStringBox(frame, "cost", cost, dbwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "unitlabel",    "      Units:", stringlabelwid, NULL);
  unitwid = MakeStringBox(frame, "costunit", units, costwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "maintlabel",   " Maintainer:", stringlabelwid, NULL);
  maintainerwid = MakeStringBox(frame, "maintainer", maintainer, unitwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "desclabel",    "Description:", stringlabelwid, NULL);
  descwid = MakeStringBox(frame, "description", description, stringlabelwid, NULL);

  button = MakeCommandButton(frame, "sdone", DoSSave, descwid, NULL, NULL);
  MakeCommandButton(frame, "cancel", DontSSave, descwid, button, NULL);

  return shell;
}

ScrollList
MakeSourceFrame(parent)
Widget parent;
{
  Widget frame, labelwid, button, view;
  ScrollList result;
  Arg arglist[10];
  Cardinal num_args;

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, "Sources"); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, "Sources"); num_args++;
  sshell = XtCreatePopupShell("sourcepane", transientShellWidgetClass, 
			      parent, arglist, num_args);
  frame = XtCreateManagedWidget("sources", formWidgetClass, sshell, NULL, ZERO);

  num_args = 0;
/*  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++;*/
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("ssview", viewportWidgetClass,
				frame, arglist, num_args);

  result =
    MakeScrollList(view, "sourceWindow", Source_items, 
		   AddSourceToQuestion, NULL, NULL);

  button = MakeCommandButton(frame, "qsadd", AddSourceToQuestion,
			     view, NULL, NULL);
  return result;
}

ScrollList
MakeTypeFrame(parent)
Widget parent;
{
  Widget frame, labelwid, button, view;
  ScrollList result;
  Arg arglist[10];
  Cardinal num_args;

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, "Types"); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, "Types"); num_args++;
  typeshell = XtCreatePopupShell("typepane", transientShellWidgetClass, 
			      parent, arglist, num_args);
  frame = XtCreateManagedWidget("types", formWidgetClass, typeshell, NULL, ZERO);

  num_args = 0;
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("typeview", viewportWidgetClass,
				frame, arglist, num_args);

  result =
    MakeScrollList(view, "typeWindow", Type_items, doType, NULL, NULL);

  button = MakeCommandButton(frame, "None", doType,
			     view, NULL, NULL);
  return result;
}

void
MakeWaisCursors()
{
  int i;
  XColor fore, back;
  Pixmap cursor_pixmap, mask;

  back.red = 65535;
  back.green = 65535;
  back.blue = 65535;

  fore.red = 0;
  fore.green = 0;
  fore.blue = 0;

  mask = XCreateBitmapFromData(XtDisplay(top),
					XtScreen(top)->root,
					cursor_mask, cursor_width, cursor_height);
  cursor_pixmap = XCreateBitmapFromData(XtDisplay(top),
					XtScreen(top)->root,
					cursor0_bits, cursor_width, cursor_height);
  wais_cursors[0] = XCreatePixmapCursor(CurDpy, cursor_pixmap, mask, &fore, &back, 0, 0);

  cursor_pixmap = XCreateBitmapFromData(XtDisplay(top),
					XtScreen(top)->root,
					cursor1_bits, cursor_width, cursor_height);
  wais_cursors[1] = XCreatePixmapCursor(CurDpy, cursor_pixmap, mask, &fore, &back, 0, 0);
  cursor_pixmap = XCreateBitmapFromData(XtDisplay(top),
					XtScreen(top)->root,
					cursor2_bits, cursor_width, cursor_height);
  wais_cursors[2] = XCreatePixmapCursor(CurDpy, cursor_pixmap, mask, &fore, &back, 0, 0);
  cursor_pixmap = XCreateBitmapFromData(XtDisplay(top),
					XtScreen(top)->root,
					cursor3_bits, cursor_width, cursor_height);
  wais_cursors[3] = XCreatePixmapCursor(CurDpy, cursor_pixmap, mask, &fore, &back, 0, 0);
  cursor_pixmap = XCreateBitmapFromData(XtDisplay(top),
					XtScreen(top)->root,
					cursor4_bits, cursor_width, cursor_height);
  wais_cursors[4] = XCreatePixmapCursor(CurDpy, cursor_pixmap, mask, &fore, &back, 0, 0);
  cursor_pixmap = XCreateBitmapFromData(XtDisplay(top),
					XtScreen(top)->root,
					cursor5_bits, cursor_width, cursor_height);
  wais_cursors[5] = XCreatePixmapCursor(CurDpy, cursor_pixmap, mask, &fore, &back, 0, 0);
  cursor_pixmap = XCreateBitmapFromData(XtDisplay(top),
					XtScreen(top)->root,
					cursor6_bits, cursor_width, cursor_height);
  wais_cursors[6] = XCreatePixmapCursor(CurDpy, cursor_pixmap, mask, &fore, &back, 0, 0);
}

