/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
 *
 * $Log:	filereq.c,v $
 * Revision 1.2  92/04/30  12:21:34  jonathan
 * Added "quit no save" button, and changed the meaning of cancel.
 * 
 * Revision 1.1  92/03/25  18:51:30  jonathan
 * Initial revision
 * 
 */

#ifndef lint
static char *RCSid = "$Header: /tmp_mnt/net/quake/proj/wais/wais-8-b5/x/RCS/filereq.c,v 1.2 92/04/30 12:21:34 jonathan Exp $";
#endif

#define FILEREQ_C
#include "xwais.h"

static Boolean
isdir(name)
char* name;
{
  struct stat stats;

  if(stat(name, &stats) < 0) return FALSE;

  if(S_ISDIR(stats.st_mode)) return TRUE;
  else return FALSE;
}

static int last_file = NO_ITEM_SELECTED;

void
SetFileName(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  XawListReturnStruct *l = (XawListReturnStruct*)call_data;
  char dirname[MAX_FILENAME_LEN+1], filename[MAX_FILENAME_LEN+1];

  if(!(strcmp(l->string, "."))) return;
  if(!(strcmp(l->string, ".."))) {
    char *slash;
    sprintf(dirname, "%s", GetString(dirnamewidget));
    if(dirname[strlen(dirname)-1] == '/')
      dirname[strlen(dirname)-1] = 0;
    slash = strrchr(dirname, '/');
    if (slash != NULL) *(slash+1) = 0;
    ReplaceText(dirnamewidget, dirname);
    last_file = NO_ITEM_SELECTED;
    SetDir(NULL, NULL, NULL);
    ReplaceText(filenamewidget, "");
    return;
  }
  
  sprintf(dirname, "%s", GetString(dirnamewidget));
  if(dirname[strlen(dirname)-1] != '/')
    strcat(dirname, "/");

  sprintf(filename, "%s%s", dirname, l->string);

  if(isdir(filename)) {
    strcat(filename, "/");
    ReplaceText(dirnamewidget, filename);
    last_file = NO_ITEM_SELECTED;
    SetDir(NULL, NULL, NULL);
    ReplaceText(filenamewidget, "");
  }
  else {
    if(last_file == l->list_index) {
      last_file = NO_ITEM_SELECTED;
      DoSave(NULL, NULL, NULL);
    }
    else {
      last_file = l->list_index;
      ReplaceText(filenamewidget, l->string);
    }
  }
}

void SetDir(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  static char **files = NULL;
  char dirname[MAX_FILENAME_LEN+2];

  last_file = NO_ITEM_SELECTED;

  if(files != NULL) {
    int i;
    for(i =0; files[i] != NULL; i++) s_free(files[i]);
    free(files);
  }

  strncpy(dirname, GetString(dirnamewidget), MAX_FILENAME_LEN);
  if((files = GetDirNames(dirname)) == NULL) {
    pathname_directory(dirname, dirname);
    files = GetDirNames(dirname);
  }

  if(dirname[strlen(dirname)-1] != '/')
    strcat(dirname, "/");
  ReplaceText(dirnamewidget, dirname);

  RebuildListWidget(savelist, files);
}

static void
cancelFile(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  Arg args[1];
  XtPopdown(savereq);
  XtSetArg(args[0], XtNsensitive, False);
  XtSetValues(quitbutton, args, ONE);
}

void clearReqButtons()
{
  Arg args[1];

  XtSetArg(args[0], XtNlabel, "   Save  ");
  XtSetValues(savebutton, args, ONE);
  XtSetArg(args[0], XtNsensitive, False);
  XtSetValues(quitbutton, args, ONE);
}

ScrollList
MakeSaveRequester(parent)
Widget parent;
{
  Widget frame, labelwid, button, view;
  ScrollList result;
  Arg arglist[10];
  Arg args[1];
  Cardinal num_args;

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, "Save As"); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, "Save As"); num_args++;
  savereq = XtCreatePopupShell("savereqpopup", applicationShellWidgetClass, 
			      parent, arglist, num_args);
  frame = XtCreateManagedWidget("savereq", formWidgetClass, savereq, NULL, ZERO);

  labelwid = MakeLabel(frame, "dirlabel", "Directory", NULL, NULL);
  dirnamewidget = MakeStringBox(frame, "dirbox", "", NULL, NULL);

  num_args = 0;
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("fileview", viewportWidgetClass,
				frame, arglist, num_args);

  result = 
    MakeScrollList(view, "fileWindow", NULL, SetFileName, NULL, NULL);

  labelwid = MakeLabel(frame, "filelabel", "File Name", NULL, NULL);
  filenamewidget = MakeStringBox(frame, "filebox", "", NULL, NULL);

  savebutton = MakeCommandButton(frame, "fileset", setFile,
				 NULL, NULL, NULL);
  cancelbutton = MakeCommandButton(frame, "filecancel", cancelFile,
				   NULL, NULL, NULL);
  quitbutton = MakeCommandButton(frame, "filequit", quitFile,
				   NULL, NULL, NULL);

  clearReqButtons();
  return result;
}
