/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/

/* this file contains X specific code - it is an integral part of XWAIS */

#define _C_TCOMMANDS

#include "xwais.h"

static Boolean editting_new_question;
static int CurrentQuestion = NO_ITEM_SELECTED;

int get_selected_question()
{
  int result;

  if ((result = get_selected_item(questionwindow->ListWidget))
      != NO_ITEM_SELECTED)
    result+=questionwindow->offset;
  return result;
}

/* ARGSUSED */
void
EditQuestion(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  char msg[STRINGSIZE];
  static last_question = -1;

  double_click = FALSE;
  LastClicked = w;
  
  if((CurrentQuestion = get_selected_question())
     != NO_ITEM_SELECTED) {
    if (CurrentQuestion == last_question) {
      sprintf(msg, "Opening question: %s\n", Question_items[CurrentQuestion]);
      XwaisPrintf(msg);
      sprintf(msg, "xwaisq \"%s\" &", Question_items[CurrentQuestion]);
      system(msg);
    }
    else last_question = CurrentQuestion;
  }
  else {
    last_question = -1;
    if (NumQuestions > 0)
      XwaisPrintf("No question selected.\nPlease select one and try again.\n");
    else {
      XwaisPrintf("Opening new question\n");
      system("xwaisq &");
    }
  }
}

/* ARGSUSED */
void
AddQuestion(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  Question new;

  double_click = FALSE;
  LastClicked = w;

  XwaisPrintf("Opening new question\n");
  system("xwaisq &");
}

void
DeleteQuestion(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  char msg[STRINGSIZE];

  double_click = FALSE;
  LastClicked = w;

  if((CurrentQuestion = get_selected_question())
     != NO_ITEM_SELECTED) {
    sprintf(msg, "%s%s",
	    app_resources.questionDirectory,
	    Question_items[CurrentQuestion]);
    if(unlink(msg) != 0)
      XwaisPrintf("Error delete Question.\n");

    CurrentQuestion = NO_ITEM_SELECTED;
    ScanDirs(NULL, NULL);
  }
  else
    XwaisPrintf("No question selected.\nPlease select one and try again.\n");
}

void
DeleteSource(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  char msg[STRINGSIZE];

  double_click = FALSE;
  LastClicked = w;

  if(get_selected_source() != NO_ITEM_SELECTED) {
    sprintf(msg, "%s%s",
	    app_resources.userSourceDirectory,
	    Source_items[get_selected_source()]);

    if (unlink(msg) != 0)
      XwaisPrintf("Error deleting source.\n");
    else
      XawListUnhighlight(sourcewindow->ListWidget);

    /* ScanDirs(NULL, NULL); */
  }
  else
    XwaisPrintf("No source selected.\nPlease select one and try again.\n");
}


static Widget helpwindow = NULL;

void EndHelp(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  XtPopdown(helpwindow);
}

void XwaisHelp(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  Widget textwindow, frame, button;
  Arg arglist[10];
  Cardinal num_args;
  static String items[] = {NULL};

  if (helpwindow == NULL) {
    num_args = 0;
    XtSetArg(arglist[num_args], XtNtitle, "X WAIS Help"); num_args++;
    XtSetArg(arglist[num_args], XtNiconName, "X WAIS Help"); num_args++;
    helpwindow = XtCreatePopupShell("textpopup", applicationShellWidgetClass,
				    XtParent(w), arglist, num_args);
    frame =
      XtCreateManagedWidget("helppopupform", formWidgetClass,
			    helpwindow, NULL, ZERO);
    num_args = 0;
    XtSetArg(arglist[num_args], XtNtype, XawAsciiFile); num_args++;
    XtSetArg(arglist[num_args], XtNstring, app_resources.helpFile); num_args++;
    XtSetArg(arglist[num_args], XtNeditType, XawtextRead); num_args++;
    textwindow =
      XtCreateManagedWidget("textWindow", asciiTextWidgetClass, frame, arglist, num_args);
    button = MakeCommandButton(frame, "tdone", EndHelp,
			       textwindow, NULL);
    SetIcon(helpwindow);
  }
  XtPopup(helpwindow, XtGrabNone);
}
