/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/

#define _C_SCOMMANDS

#include "xwais.h"

static Boolean editting_new_source;
static int CurrentSource = NO_ITEM_SELECTED;

Source edit_source = NULL;

int get_selected_source()
{
  int result;

  if ((result = get_selected_item(sourcewindow->ListWidget))
      != NO_ITEM_SELECTED)
    result+=sourcewindow->offset;
  return result;
}

/* widget commands */

/* ARGSUSED */
void
EditSource(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  SList s;
  static last_source = -1;
  char msg[1000];

  double_click = FALSE;
  LastClicked = w;

  if ((CurrentSource = get_selected_source())
      != NO_ITEM_SELECTED) {
    if (last_source == CurrentSource) {
      edit_source = findSource(CurrentSource);
      sprintf(msg, "Opening source: %s\n", edit_source->name);
      XwaisPrintf(msg);
      PopupSource(edit_source);
    }
    else last_source = CurrentSource;
  } 
  else {
    last_source = -1;
    XwaisPrintf("No source selected.\nPlease selected one and try again.\n");
  }
}

/* ARGSUSED */
void
AddSource(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  static Source new = NULL;

  double_click = FALSE;
  LastClicked = w;

  if(new == NULL) {
    if((new = (Source) s_malloc(sizeof(_Source))) == NULL) {
      fprintf(stderr, "Unable to allocate new source structure.\n");
      exit(1);
    }
  }
  editting_new_source = TRUE;
  new->name = s_strdup("new.src");
  new->directory = s_strdup(app_resources.userSourceDirectory);
  strncpy(new->server, "localhost", STRINGSIZE);
  strncpy(new->service, "8000", STRINGSIZE);
  strncpy(new->database, "database_name", STRINGSIZE);
  new->maintainer = s_strdup("");
  new->description = s_strdup("");
  edit_source = new;
  XwaisPrintf("Opening new source\n");
  PopupSource(new);
}

void PopupSource(s)
Source s;
{
  Arg arglist[10];
  Cardinal num_args;

  if (s != NULL) {
    num_args = 0;
    XtSetArg(arglist[num_args], XtNtitle, s->name); num_args++;
    XtSetValues(sourcepopup, arglist, num_args);
    ReplaceText(snamewid, s->name);
    ReplaceText(serverwid, s->server);
    ReplaceText(servicewid, s->service);
    ReplaceText(dbwid, s->database);
    ReplaceText(costwid, s->cost);
    ReplaceText(unitwid, s->units);
    ReplaceText(maintainerwid, s->maintainer);
    ReplaceText(descwid, s->description);
    XtPopup(sourcepopup, XtGrabNone);
  }
}

/* ARGSUSED */
void CloseSourceEdit(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  char name[STRINGSIZE];
  Source source;

  double_click = FALSE;
  LastClicked = w;

  if (editting_new_source == TRUE) {
    editting_new_source = FALSE;
  } 
  source = edit_source;
  if (source != NULL) {
    strcpy(name, GetString(snamewid));

    if(!((strlen(name) > 4) && 
	 strstr(name, ".src") &&
	 (!strcmp(".src", strstr(name, ".src")))))
      strcat(name, ".src");

    if(source->name != NULL) s_free(source->name);
    source->name = s_strdup(name);

    if (source->maintainer != NULL) s_free(source->maintainer);
    source->maintainer = s_strdup(GetString(maintainerwid));

    if (source->description != NULL) s_free(source->description);
    source->description = s_strdup(GetString(descwid));

    strncpy(source->server, GetString(serverwid), STRINGSIZE);
    strncpy(source->service, GetString(servicewid), STRINGSIZE);
    strncpy(source->database, GetString(dbwid), STRINGSIZE);
    strncpy(source->cost, GetString(costwid), STRINGSIZE);
    strncpy(source->units, GetString(unitwid), STRINGSIZE);

    WriteSource(app_resources.userSourceDirectory, source, TRUE);

    /* ScanDirs(NULL, NULL);*/
  }
  else XwaisPrintf("No currently selected source.  This shouldn't happen.\n");
  edit_source = NULL;
  XtPopdown(sourcepopup);
}

/* ARGSUSED */
void CancelSourceEdit(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  SList s;

  double_click = FALSE;
  LastClicked = w;

  if (editting_new_source == TRUE) {
    s = Sources;
    editting_new_source = FALSE;
    FreeSource(Sources->thisSource);
    Sources = Sources->nextSource;
    s_free(s);
  }
  CurrentSource = NO_ITEM_SELECTED;
  /*XawListUnhighlight(sourcewindow->ListWidget);*/
  XtPopdown(sourcepopup);
  edit_source = NULL;
}
