# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
#ifndef lint
static char	rcsid[] = "$Header: /usr/src/local/bin/detex/RCS/detex.l,v 2.14 1992/09/02 15:35:44 trinkle Exp $";
#endif

/*
 * detex [-e environment-list] [-c] [-l] [-n] [-s] [-t] [-w] [file[.tex]]
 *
 *	This program is used to remove TeX or LaTeX constructs from a text
 *	file.
 *
 * Written by:
 *	Daniel Trinkle
 *	Department of Computer Science
 *	Purdue University
 *
 */

#include "detex.h"
#ifdef USG
#include <string.h>
#define	index	strchr
#define	rindex	strrchr
#else
#include <strings.h>
#endif
#ifndef MAXPATHLEN
#include <sys/param.h>
#endif

#define	LaBEGIN		if (fLatex) BEGIN
#define	CITEBEGIN	if (fLatex && !fCite) BEGIN
#define	IGNORE		if (fSpace && !fWord) putchar(' ')
#define	SPACE		if (!fWord) putchar(' ')
#define	NEWLINE		if (!fWord) putchar('\n')

#ifndef NO_MALLOC_DECL
char	*malloc();
#endif

char	*rgsbEnvIgnore[MAXENVS];	/* list of environments ignored */
char	*rgsbIncList[MAXINCLIST];	/* list of includeonly files */
char	*rgsbSMPaths[MAXINPUTPATHS];	/* list of input paths in order */
char	sbCurrentEnv[CCHMAXENV];	/* current environment being ignored */
char	*sbProgName;			/* name we were invoked with */
FILE	*rgfp[NOFILE+1];		/* stack of input/include files */
int	cfp = 0;			/* count of files in stack */
int	cOpenBrace = 0;			/* count of `{' in <SG> */
int	csbEnvIgnore;			/* count of environments ignored */
int	csbIncList = 0;			/* count of includeonly files */
int	csbSMPaths;			/* count of input paths */
int	fLatex = 0;			/* flag to indicated delatex */
int	fWord = 0;			/* flag for -w option */
int	fFollow = 1;			/* flag to follow input/include */
int	fCite = 0;			/* flag to echo \cite and \ref args */
int	fSpace = 0;			/* flag to replace \cs with space */
int	fForcetex = 0;			/* flag to inhibit latex mode */
# define SJ 2
# define SK 4
# define SL 6
# define SM 8
# define SN 10
# define SO 12
# define SP 14
# define SA 16
# define SB 18
# define SC 20
# define SD 22
# define SE 24
# define SF 26
# define SH 28
# define SG 30
# define SI 32
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	/* ignore comments */	;
break;
case 2:
{fLatex = !fForcetex; IGNORE;}
break;
case 3:
    /* environment start */	{LaBEGIN SA; IGNORE;}
break;
case 4:
	{   if (BeginEnv("verbatim"))
							BEGIN SD;
						    else
							BEGIN SI;
						    IGNORE;
						}
break;
case 5:
/* verbatim mode */	{BEGIN 
SO; IGNORE;}
break;
case 6:
				ECHO;
break;
case 7:
				{   if (BeginEnv(yytext))
							BEGIN SD;
						    else
							BEGIN SH;
						    IGNORE;
						}
break;
case 8:
				NEWLINE;
break;
case 9:
				;
break;
case 10:
 /* absorb some environments */	{LaBEGIN SC; IGNORE;}
break;
case 11:
				NEWLINE;
break;
case 12:
				;
break;
case 13:
	 /* end environment */	{   if (EndEnv(yytext))
							BEGIN SO;
						    IGNORE;
						}
break;
case 14:
				{BEGIN SD; IGNORE;}
break;
case 15:
				NEWLINE;
break;
case 16:
				;
break;
case 17:
    /* ignore args  */	{LaBEGIN SG; IGNORE;}
break;
case 18:
   /* of these \cs */	{LaBEGIN SH; IGNORE;}
break;
case 19:
			{LaBEGIN SH; IGNORE;}
break;
case 20:
			{CITEBEGIN SG; IGNORE;}
break;
case 21:
		{LaBEGIN SH; IGNORE;}
break;
case 22:
				{LaBEGIN SH; IGNORE;}
break;
case 23:
			{LaBEGIN SG; SPACE;}
break;
case 24:
			{LaBEGIN SH; IGNORE;}
break;
case 25:
			{CITEBEGIN SH; IGNORE;}
break;
case 26:
			{LaBEGIN SH; IGNORE;}
break;
case 27:
				{CITEBEGIN SH; IGNORE;}
break;
case 28:
			{LaBEGIN SH; IGNORE;}
break;
case 29:
/* ignore \verb<char>...<char> */ {   if (fLatex) {
						 	char verbchar, c;
						 	verbchar = input();
						 	while ((c = input()) !=
 verbchar)
							    if (c == '\n')
								NEWLINE;
						    }
						    IGNORE;
						}
break;
case 30:
				BEGIN SO;
break;
case 31:
				NEWLINE;
break;
case 32:
				;
break;
case 33:
				{   cOpenBrace++; }
break;
case 34:
				{   cOpenBrace--;
						    if (cOpenBrace == 0)
							BEGIN SO;
						}
break;
case 35:
				NEWLINE;
break;
case 36:
				;
break;
case 37:
	/* ignore def begin */	{BEGIN SJ; IGNORE;}
break;
case 38:
				BEGIN SO;
break;
case 39:
				NEWLINE;
break;
case 40:
				;
break;
case 41:
	/* formula mode */	{LaBEGIN SE; IGNORE;}
break;
case 42:
			BEGIN SO;
break;
case 43:
				NEWLINE;
break;
case 44:
				;
break;
case 45:
	/* display mode */	{LaBEGIN SB; IGNORE;}
break;
case 46:
			BEGIN SO;
break;
case 47:
				NEWLINE;
break;
case 48:
				;
break;
case 49:
	/* display mode */	{BEGIN SK; IGNORE;}
break;
case 50:
				BEGIN SO;
break;
case 51:
				NEWLINE;
break;
case 52:
				;
break;
case 53:
	/* math mode */		{BEGIN SN; IGNORE;}
break;
case 54:
				BEGIN SO;
break;
case 55:
				NEWLINE;
break;
case 56:
				;
break;
case 57:
					;
break;
case 58:
/* process files */	{LaBEGIN SF; IGNORE;}
break;
case 59:
			{   IncludeFile(yytext);
						    BEGIN SO;
						}
break;
case 60:
				NEWLINE;
break;
case 61:
				;
break;
case 62:
			{BEGIN SL; IGNORE;}
break;
case 63:
		AddInclude(yytext);
break;
case 64:
			{   if (csbIncList == 0)
							rgsbIncList[csbIncList++] = '\0';
						    BEGIN SO;
						}
break;
case 65:
			NEWLINE;
break;
case 66:
				;
break;
case 67:
			{BEGIN SM; IGNORE;}
break;
case 68:
			{   SMFile(yytext);
						    BEGIN SO;
						}
break;
case 69:
				NEWLINE;
break;
case 70:
				;
break;
case 71:
/* handle ligatures */ {printf("%.2s", yytext+1);}
break;
case 72:
			{printf("%.1s", yytext+1);}
break;
case 73:
/* ignore other \cs */	{BEGIN SP; IGNORE;}
break;
case 74:
				SPACE;
break;
case 75:
				IGNORE;
break;
case 76:
			IGNORE;
break;
case 77:
	IGNORE;
break;
case 78:
				{BEGIN SO; NEWLINE;}
break;
case 79:
			{BEGIN SO; IGNORE;}
break;
case 80:
				{yyless(0);BEGIN SO;}
break;
case 81:
/* special characters */	IGNORE;
break;
case 82:
				IGNORE;
break;
case 83:
				SPACE;
break;
case 84:
			{   if (fWord)
							printf("%s\n", yytext);
						    else
							ECHO;
						}
break;
case 85:
				if (!fWord) ECHO;
break;
case 86:
				if (!fWord) ECHO;
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
/******
** main --
**	Set sbProgName to the base of arg 0.
**	Set the input paths.
**	Check for options
**		-c		echo LaTeX \cite, \ref, and \pageref values
**		-e <env-list>	list of LaTeX environments to ignore
**		-l		force latex mode
**		-n		do not follow \input and \include
**		-s		replace control sequences with space
**		-t		force tex mode
**		-w		word only output
**	Set the list of LaTeX environments to ignore.
**	Process each input file.
**	If no input files are specified on the command line, process stdin.
******/

main(cArgs,rgsbArgs)
int	cArgs;
char	*rgsbArgs[];
{
	char	*pch, *sbEnvList = DEFAULTENV, sbBadOpt[2];
	FILE	*TexOpen();
	int	fSawFile = 0, iArgs = 1;
	
	/* get base name and decide what we are doing, detex or delatex */
	if ((sbProgName = rindex(rgsbArgs[0], '/')) != NULL)
	    sbProgName++;
	else
	    sbProgName = rgsbArgs[0];
	if (strcmp("delatex",sbProgName) == 0)
	    fLatex = 1;
	
	/* set rgsbSMPaths for use with TexOpen() */
	SetSMPaths();

	/* process command line options */
	while (iArgs < cArgs && *(pch = rgsbArgs[iArgs]) == CHOPT) {
		while (*++pch)
		    switch (*pch) {
		    case CHCITEOPT:
			fCite = 1;
			break;
		    case CHENVOPT:
			sbEnvList = rgsbArgs[++iArgs];
			break;
		    case CHLATEXOPT:
			fLatex = 1;
			break;
		    case CHNOFOLLOWOPT:
			fFollow = 0;
			break;
		    case CHSPACEOPT:
			fSpace = 1;
			break;
		    case CHTEXOPT:
			fForcetex = 1;
			break;
		    case CHWORDOPT:
			fWord = 1;
			break;
		    default:
			sbBadOpt[0] = *pch;
			sbBadOpt[1] = '\0';
			Warning("unknown option ignored -", sbBadOpt);
		    }
		iArgs++;
	}
	SetEnvIgnore(sbEnvList);

	/* process input files */
	for (; iArgs < cArgs; iArgs++) {
	    fSawFile++;
	    if ((yyin = TexOpen(rgsbArgs[iArgs])) == NULL) {
		Warning("can't open file", rgsbArgs[iArgs]);
		continue;;
	    }
	    BEGIN SO;
	    (void)yylex();
	}

	/* if there were no input files, assume stdin */
	if (!fSawFile) {
	    yyin = stdin;
	    BEGIN SO;
	    (void)yylex();
	}
#ifndef FLEX_SCANNER
	if (YYSTATE != SO)
	    ErrorExit("input contains an unterminated mode or environment");
#endif
	exit(0);
}

#ifdef FLEX_SCANNER
#undef yywrap
#endif

/******
** yywrap -- handles EOF for lex.  Check to see if the stack of open files
**	has anything on it.  If it does, set yyin to the to value.  If not
**	return the termination signal for lex.
******/

yywrap()
{
	(void)fclose(yyin);
	if (cfp > 0) {
	    yyin = rgfp[--cfp];
	    return(0);
	}
	return(1);
}

/******
** SetEnvIgnore -- sets rgsbEnvIgnore to the values indicated by the
**	sbEnvList.
******/

SetEnvIgnore(sbEnvList)
char	*sbEnvList;
{
	csbEnvIgnore = SeparateList(sbEnvList, rgsbEnvIgnore, CHENVSEP, MAXENVS
);
	if (csbEnvIgnore == ERROR)
	    ErrorExit("The environtment list contains too many environments");
}

/******
** BeginEnv -- checks to see if sbEnv is in the list rgsbEnvIgnore.  If it
**	is, sbCurrentEnv is set to sbEnv.
******/

BeginEnv(sbEnv)
char	*sbEnv;
{
	int	i;

	if (!fLatex) return(0);
	for (i = 0; i < csbEnvIgnore; i++)
	    if (strcmp(sbEnv, rgsbEnvIgnore[i]) == 0) {
		(void)strcpy(sbCurrentEnv, sbEnv);
		return(1);
	    }
	return(0);
}

/******
** EndEnv -- checks to see if sbEnv is the current environment being ignored.
******/

EndEnv(sbEnv)
char	*sbEnv;
{
	if (!fLatex) return(0);
	if (strcmp(sbEnv, sbCurrentEnv) == 0)
	    return(1);
	return(0);
}

/******
** SMFile -- push the current yyin and open sbFile.  If the open fails,
**	the sbFile is ignored.
******/

SMFile(sbFile)
char	*sbFile;
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\input file", sbFile);
	    yyin = rgfp[--cfp];
	}
}

/******
** IncludeFile -- if sbFile is not in the rgsbIncList, push current yyin
**	and open sbFile.  If the open fails, the sbFile is ignored.
******/

IncludeFile(sbFile)
char	*sbFile;
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	if (!InList(sbFile))
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\include file", sbFile);
	    yyin = rgfp[--cfp];
	}
}

/******
** AddInclude -- adds sbFile to the rgsbIncList and increments csbIncList.
**	If the include list is too long, sbFile is ignored.
******/

AddInclude(sbFile)
char	*sbFile;
{
	if (!fFollow)
	    return;
	if (csbIncList >= MAXINCLIST)
	    Warning("\\includeonly list is too long, ignoring", sbFile);
	rgsbIncList[csbIncList] = malloc((unsigned)(strlen(sbFile) + 1));
	(void)strcpy(rgsbIncList[csbIncList++], sbFile);
}

/******
** InList -- checks to see if sbFile is in the rgsbIncList.  If there is
**	no list, all files are assumed to be "in the list".
******/

InList(sbFile)
char	*sbFile;
{
	char	*pch, sbBase[MAXPATHLEN];
	int	i;

	if (csbIncList == 0)	/* no list */
	    return(1);
	(void)strcpy(sbBase, sbFile);
	if ((pch = rindex(sbBase, '.')) != NULL)
	    *pch = '\0';
	i = 0;
	while ((i < csbIncList) && rgsbIncList[i])
	    if (strcmp(rgsbIncList[i++], sbBase) == 0)
	        return(1);
	return(0);
}

/******
** SetSMPaths -- sets rgsbSMPaths to the values indicated by the
**	TEXINPUTS environment variable if set or else DEFAULTINPUTS.
******/

SetSMPaths()
{
    char *sb, *sbPaths, *getenv();

    if ((sb = getenv("TEXINPUTS")) == NULL)
	sbPaths = DEFAULTINPUTS;
    else {
	sbPaths = malloc((unsigned)(strlen(sb) + 1));
	(void)strcpy(sbPaths, sb);
    }

    csbSMPaths = SeparateList(sbPaths, rgsbSMPaths, CHPATHSEP, MAXINPUTPATHS);
    if (csbSMPaths == ERROR)
	ErrorExit("TEXINPUTS environment variable has too many paths");
}

/******
** SeparateList -- takes a chSep separated list sbList, replaces the
**	chSep's with NULLs and sets rgsbList[i] to the beginning of
**	the ith word in sbList.  The number of words is returned.  A
**	ERROR is returned if there are more than csbMax words.
******/

SeparateList(sbList, rgsbList, chSep, csbMax)
char	*sbList, *rgsbList[], chSep;
int	csbMax;
{
	int	csbList = 0;

	while (sbList && *sbList && csbList < csbMax) {
	    rgsbList[csbList++] = sbList;
	    if (sbList = index(sbList, chSep))
		*sbList++ = '\0';
	}
	return(sbList && *sbList ? ERROR : csbList);
}

/******
** TexOpen -- tries to open sbFile in each of the rgsbSMPaths in turn.
**	For each input path the following order is used:
**		file.tex - must be as named, if not there go to the next path
**		file.ext - random extension, try it
**		file     - base name, add .tex and try it
**		file     - try it as is
**	Notice that if file exists in the first path and file.tex exists in
**	one of the other paths, file in the first path is what is opened.
**	If the sbFile begins with a '/', no paths are searched.
******/

FILE *
TexOpen(sbFile)
char	*sbFile;
{
	char	*pch, *sbNew;
	FILE	*fp;
	int	iPath;
	static char	sbFullPath[MAXPATHLEN];

	for (iPath = 0; iPath < csbSMPaths; iPath++) {
	    if (*sbFile == '/') {	/* absolute path */
		(void)sprintf(sbFullPath, "%s", sbFile);
		iPath = csbSMPaths;	/* only check once */
	    } else
		(void)sprintf(sbFullPath, "%s/%s", rgsbSMPaths[iPath], sbFile);

	    /* If sbFile ends in .tex then it must be there */
	    if ((pch = rindex(sbFullPath, '.')) != NULL
			&& (strcmp(pch, ".tex") == 0))
		if ((fp = fopen(sbFullPath, "r")) != NULL)
		    return(fp);
		else
		    continue;

	    /* if .<ext> then try to open it.  the '.' represents   */
	    /* the beginning of an extension if it is not the first */
	    /* character and it does not follow a '.' or a '/'      */
	    if (pch != NULL && pch > &(sbFullPath[0])
                    && *(pch - 1) != '.' && *(pch - 1) != '/'
		    && (fp = fopen(sbFullPath, "r")) != NULL)
		return(fp);

	    /* just base name, add .tex to the name */
	    sbNew = malloc((unsigned)(strlen(sbFullPath) + 5));
	    (void)strcpy(sbNew, sbFullPath);
	    (void)strcat(sbNew, ".tex");
	    if ((fp = fopen(sbNew, "r")) != NULL)
		return(fp);

	    /* try sbFile regardless */
	    if ((fp = fopen(sbFullPath, "r")) != NULL)
		return(fp);
	}
	return((FILE *)NULL);
}

/******
** Warning -- print a warning message preceded by the program name.
******/

Warning(sb1, sb2)
char	*sb1, *sb2;
{
	fprintf(stderr, "%s: warning: %s %s\n", sbProgName, sb1, sb2);
}

/******
** ErrorExit -- print an error message preceded by the program name.
**	Stdout is flushed and detex exits.
******/

ErrorExit(sb1)
char	*sb1;
{
	(void)fflush(stdout);
	fprintf(stderr, "%s: error: %s\n", sbProgName, sb1);
	exit(1);
}
int yyvstop[] = {
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

40,
0,

39,
0,

38,
40,
0,

52,
0,

51,
0,

52,
0,

63,
66,
0,

66,
0,

65,
0,

64,
66,
0,

68,
70,
0,

70,
0,

69,
0,

57,
0,

55,
0,

54,
57,
0,

57,
0,

86,
0,

86,
0,

53,
86,
0,

1,
86,
0,

85,
86,
0,

86,
0,

81,
86,
0,

81,
86,
0,

83,
86,
0,

80,
0,

79,
80,
0,

78,
0,

77,
80,
0,

80,
0,

80,
0,

9,
0,

9,
0,

8,
0,

7,
9,
0,

9,
0,

48,
0,

47,
0,

48,
0,

16,
0,

15,
0,

13,
16,
0,

14,
16,
0,

12,
0,

11,
0,

12,
0,

44,
0,

43,
0,

44,
0,

59,
61,
0,

61,
0,

60,
0,

32,
0,

31,
0,

30,
32,
0,

36,
0,

35,
0,

33,
36,
0,

34,
36,
0,

6,
0,

6,
0,

50,
0,

63,
0,

68,
0,

56,
0,

82,
0,

49,
0,

1,
0,

85,
0,

84,
0,

75,
0,

74,
75,
0,

41,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

45,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

79,
0,

77,
0,

76,
0,

7,
0,

46,
0,

13,
0,

42,
0,

59,
0,

84,
0,

73,
0,

73,
0,

72,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

71,
0,

73,
0,

73,
0,

73,
0,

37,
73,
0,

73,
0,

22,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

27,
73,
0,

73,
0,

73,
0,

10,
0,

73,
0,

73,
0,

73,
0,

73,
0,

20,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

29,
73,
0,

3,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

23,
73,
0,

67,
73,
0,

24,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

17,
73,
0,

73,
0,

73,
0,

73,
0,

58,
73,
0,

25,
73,
0,

73,
0,

73,
0,

73,
0,

19,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

26,
73,
0,

73,
0,

4,
0,

73,
0,

73,
0,

73,
0,

28,
73,
0,

73,
0,

73,
0,

62,
73,
0,

18,
73,
0,

73,
0,

21,
73,
0,

5,
0,

2,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	3,35,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	5,38,	3,35,	3,36,	
0,0,	0,0,	0,0,	0,0,	
7,41,	5,38,	5,39,	0,0,	
103,0,	0,0,	34,0,	0,0,	
7,42,	7,43,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	3,35,	0,0,	
0,0,	6,40,	62,127,	0,0,	
3,35,	5,38,	12,50,	112,144,	
5,40,	3,35,	3,35,	5,38,	
7,41,	3,35,	40,97,	51,100,	
5,38,	5,38,	7,41,	54,102,	
5,38,	14,54,	14,55,	7,42,	
7,41,	62,127,	84,138,	7,41,	
113,144,	3,35,	3,35,	71,132,	
71,132,	143,160,	120,144,	0,0,	
5,38,	5,38,	68,131,	68,131,	
0,0,	3,35,	9,45,	7,41,	
7,41,	111,143,	98,0,	98,0,	
5,38,	111,143,	9,46,	9,47,	
0,0,	122,144,	71,132,	7,41,	
0,0,	3,35,	121,144,	0,0,	
0,0,	68,131,	0,0,	0,0,	
5,38,	113,143,	0,0,	74,135,	
0,0,	98,0,	53,101,	7,41,	
123,153,	115,143,	9,45,	81,137,	
96,140,	115,143,	116,145,	117,147,	
9,45,	98,0,	116,146,	11,48,	
119,150,	9,45,	9,45,	124,154,	
3,37,	9,45,	3,35,	11,48,	
11,49,	16,61,	12,48,	5,38,	
20,72,	5,38,	24,79,	26,82,	
34,95,	126,156,	7,42,	118,148,	
7,44,	9,45,	9,45,	134,157,	
137,158,	14,59,	125,155,	14,60,	
120,151,	118,149,	140,159,	11,48,	
62,127,	9,45,	11,50,	145,161,	
146,162,	11,48,	122,143,	121,152,	
125,143,	147,163,	11,48,	11,48,	
99,0,	99,0,	11,48,	148,164,	
149,165,	9,45,	150,166,	13,52,	
151,167,	151,168,	128,0,	128,0,	
71,134,	152,170,	153,171,	13,52,	
13,52,	15,61,	11,48,	11,48,	
154,172,	151,169,	155,173,	99,0,	
68,132,	15,62,	15,63,	156,174,	
157,175,	158,176,	11,48,	159,177,	
98,0,	128,0,	98,0,	161,178,	
9,46,	163,182,	9,46,	13,53,	
139,0,	139,0,	13,54,	13,55,	
165,183,	13,52,	11,51,	167,184,	
168,185,	15,61,	13,52,	13,52,	
169,186,	170,187,	13,56,	15,64,	
171,188,	173,189,	17,67,	162,179,	
15,61,	15,64,	162,180,	139,0,	
15,65,	174,190,	17,68,	17,69,	
175,191,	162,181,	13,52,	13,57,	
177,177,	177,177,	178,193,	179,194,	
180,195,	11,48,	11,48,	11,48,	
15,65,	15,65,	13,57,	181,196,	
183,197,	184,198,	185,199,	186,200,	
187,201,	189,204,	17,67,	191,205,	
15,65,	188,202,	188,203,	177,177,	
17,67,	194,209,	13,58,	195,210,	
196,211,	17,67,	17,67,	197,212,	
19,72,	17,67,	198,213,	202,214,	
15,66,	203,215,	204,216,	205,217,	
19,72,	19,73,	99,0,	206,218,	
99,0,	209,220,	210,221,	211,222,	
212,223,	17,67,	17,70,	213,224,	
128,0,	214,225,	21,75,	192,192,	
192,192,	13,59,	13,59,	13,59,	
13,60,	17,70,	21,75,	21,76,	
19,72,	215,226,	216,227,	15,62,	
15,61,	15,61,	19,72,	217,228,	
218,229,	219,230,	221,231,	19,72,	
19,72,	17,67,	192,192,	19,72,	
222,232,	223,233,	139,0,	224,234,	
139,0,	226,235,	21,75,	227,236,	
193,207,	193,207,	228,237,	229,238,	
21,75,	230,239,	23,79,	19,72,	
19,72,	21,75,	21,75,	208,208,	
208,208,	21,75,	23,79,	23,80,	
25,82,	207,207,	207,207,	19,72,	
17,71,	231,240,	17,67,	193,207,	
25,82,	25,83,	177,192,	233,241,	
234,242,	21,75,	21,77,	235,243,	
236,244,	238,246,	208,208,	19,74,	
239,247,	240,248,	23,79,	241,249,	
207,207,	21,77,	237,237,	237,237,	
23,79,	242,250,	244,251,	246,252,	
25,82,	23,79,	23,79,	247,253,	
248,254,	23,79,	25,82,	249,255,	
250,256,	21,75,	252,257,	25,82,	
25,82,	253,258,	254,259,	25,82,	
255,260,	237,237,	19,72,	19,72,	
19,72,	23,79,	23,79,	257,261,	
258,262,	260,263,	262,265,	0,0,	
192,206,	0,0,	27,85,	25,82,	
25,82,	23,79,	261,261,	261,261,	
0,0,	0,0,	27,86,	27,87,	
21,75,	0,0,	21,78,	25,82,	
265,265,	265,265,	0,0,	0,0,	
0,0,	23,81,	0,0,	0,0,	
0,0,	0,0,	208,219,	0,0,	
0,0,	261,261,	0,0,	25,84,	
0,0,	0,0,	27,85,	0,0,	
0,0,	0,0,	193,208,	265,265,	
27,85,	0,0,	29,88,	0,0,	
0,0,	27,85,	27,85,	0,0,	
0,0,	27,85,	29,88,	29,89,	
23,79,	23,79,	23,79,	207,208,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	25,82,	25,82,	
25,82,	27,85,	27,85,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	29,88,	0,0,	
0,0,	27,85,	0,0,	0,0,	
29,88,	0,0,	237,245,	0,0,	
0,0,	29,88,	29,88,	31,91,	
0,0,	29,88,	0,0,	0,0,	
0,0,	27,85,	0,0,	31,91,	
31,92,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	29,88,	29,88,	56,104,	
56,104,	56,104,	56,104,	56,104,	
56,104,	56,104,	56,104,	56,104,	
56,104,	29,88,	0,0,	31,91,	
0,0,	0,0,	261,264,	0,0,	
27,86,	31,91,	27,86,	33,95,	
0,0,	0,0,	31,91,	31,91,	
265,266,	29,88,	31,91,	33,95,	
33,0,	41,98,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	41,0,	41,0,	0,0,	
0,0,	0,0,	31,91,	31,91,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	33,95,	
0,0,	0,0,	31,91,	0,0,	
29,88,	33,95,	29,90,	0,0,	
41,0,	41,98,	33,95,	33,95,	
0,0,	0,0,	33,95,	41,98,	
0,0,	0,0,	31,91,	0,0,	
41,0,	41,98,	0,0,	0,0,	
41,98,	0,0,	0,0,	0,0,	
0,0,	45,99,	33,95,	33,95,	
0,0,	0,0,	0,0,	0,0,	
0,0,	45,0,	45,0,	55,103,	
41,98,	41,98,	33,95,	0,0,	
0,0,	0,0,	0,0,	55,103,	
55,0,	31,93,	0,0,	31,94,	
41,98,	0,0,	0,0,	0,0,	
0,0,	0,0,	33,96,	0,0,	
45,0,	45,99,	0,0,	0,0,	
0,0,	0,0,	0,0,	45,99,	
41,98,	0,0,	0,0,	55,103,	
45,99,	45,99,	0,0,	0,0,	
45,99,	55,103,	0,0,	0,0,	
0,0,	0,0,	55,103,	55,103,	
0,0,	0,0,	55,103,	0,0,	
0,0,	33,95,	33,95,	33,95,	
45,99,	45,99,	0,0,	0,0,	
0,0,	0,0,	0,0,	41,0,	
0,0,	41,0,	55,103,	55,103,	
45,99,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	55,103,	0,0,	
0,0,	0,0,	0,0,	0,0,	
45,99,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	55,103,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	57,105,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	45,0,	
0,0,	45,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	55,103,	0,0,	55,103,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	57,106,	57,106,	
57,106,	57,106,	58,107,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	58,107,	58,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	58,108,	58,107,	0,0,	
0,0,	0,0,	0,0,	0,0,	
58,107,	58,109,	0,0,	0,0,	
0,0,	58,107,	58,107,	0,0,	
0,0,	58,107,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	58,110,	58,111,	58,110,	
58,110,	58,110,	58,110,	58,110,	
58,110,	58,110,	58,110,	58,110,	
58,110,	58,112,	58,110,	58,110,	
58,113,	58,110,	58,110,	58,110,	
58,110,	58,110,	58,110,	58,110,	
58,110,	58,110,	58,110,	58,110,	
58,114,	58,107,	0,0,	0,0,	
0,0,	0,0,	58,115,	58,116,	
58,117,	58,118,	58,119,	58,110,	
58,110,	58,110,	58,120,	0,0,	
58,110,	58,121,	58,110,	58,110,	
58,122,	58,123,	58,110,	58,124,	
58,125,	58,110,	58,110,	58,126,	
58,110,	58,110,	58,110,	58,110,	
58,107,	64,128,	58,107,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	64,0,	64,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,0,	64,128,	0,0,	0,0,	
0,0,	0,0,	0,0,	64,128,	
0,0,	0,0,	0,0,	0,0,	
64,128,	64,128,	0,0,	0,0,	
64,128,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,128,	64,128,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,128,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,128,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	64,0,	
0,0,	64,128,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,128,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,128,	65,0,	
65,0,	65,129,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	65,0,	
65,0,	65,0,	0,0,	65,0,	
65,0,	65,129,	65,129,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	65,129,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
65,0,	65,0,	65,0,	65,0,	
65,0,	0,0,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
66,130,	66,130,	66,130,	66,130,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	70,133,	70,133,	
70,133,	70,133,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
77,136,	77,136,	77,136,	77,136,	
85,139,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
85,0,	85,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	85,0,	
85,139,	0,0,	0,0,	0,0,	
0,0,	0,0,	85,139,	0,0,	
0,0,	0,0,	0,0,	85,139,	
85,139,	0,0,	0,0,	85,139,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	85,139,	
85,139,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	85,139,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	85,139,	
0,0,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	0,0,	
0,0,	0,0,	85,0,	0,0,	
85,0,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	105,141,	
105,141,	105,141,	105,141,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	110,142,	110,142,	
110,142,	110,142,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
0,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	0,0,	129,0,	
129,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	129,0,	
129,0,	129,0,	0,0,	129,0,	
129,0,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	0,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	141,141,	
141,141,	141,141,	141,141,	0,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+-1,	0,		yyvstop+5,
yycrank+0,	yysvec+3,	yyvstop+7,
yycrank+-8,	0,		yyvstop+9,
yycrank+-1,	yysvec+5,	yyvstop+11,
yycrank+-15,	0,		yyvstop+13,
yycrank+0,	yysvec+7,	yyvstop+15,
yycrank+-77,	0,		yyvstop+17,
yycrank+0,	yysvec+9,	yyvstop+19,
yycrank+-118,	0,		yyvstop+21,
yycrank+-6,	yysvec+11,	yyvstop+23,
yycrank+-170,	0,		yyvstop+25,
yycrank+-21,	yysvec+13,	yyvstop+27,
yycrank+-180,	0,		yyvstop+29,
yycrank+-5,	yysvec+15,	yyvstop+31,
yycrank+-221,	0,		yyvstop+33,
yycrank+0,	yysvec+17,	yyvstop+35,
yycrank+-267,	0,		yyvstop+37,
yycrank+-8,	yysvec+19,	yyvstop+39,
yycrank+-289,	0,		yyvstop+41,
yycrank+0,	yysvec+21,	yyvstop+43,
yycrank+-329,	0,		yyvstop+45,
yycrank+-10,	yysvec+23,	yyvstop+47,
yycrank+-339,	0,		yyvstop+49,
yycrank+-11,	yysvec+25,	yyvstop+51,
yycrank+-401,	0,		yyvstop+53,
yycrank+0,	yysvec+27,	yyvstop+55,
yycrank+-441,	0,		yyvstop+57,
yycrank+0,	yysvec+29,	yyvstop+59,
yycrank+-486,	0,		yyvstop+61,
yycrank+0,	yysvec+31,	yyvstop+63,
yycrank+-526,	0,		yyvstop+65,
yycrank+-12,	yysvec+33,	yyvstop+67,
yycrank+0,	0,		yyvstop+69,
yycrank+0,	0,		yyvstop+71,
yycrank+0,	0,		yyvstop+73,
yycrank+0,	0,		yyvstop+76,
yycrank+0,	0,		yyvstop+78,
yycrank+14,	0,		yyvstop+80,
yycrank+-536,	0,		yyvstop+82,
yycrank+0,	0,		yyvstop+85,
yycrank+0,	0,		yyvstop+87,
yycrank+0,	0,		yyvstop+89,
yycrank+-588,	0,		yyvstop+92,
yycrank+0,	0,		yyvstop+95,
yycrank+0,	0,		yyvstop+97,
yycrank+0,	0,		yyvstop+99,
yycrank+0,	0,		yyvstop+101,
yycrank+0,	0,		yyvstop+103,
yycrank+15,	0,		yyvstop+106,
yycrank+0,	0,		yyvstop+108,
yycrank+10,	0,		yyvstop+110,
yycrank+19,	0,		yyvstop+112,
yycrank+-598,	0,		yyvstop+115,
yycrank+459,	0,		yyvstop+118,
yycrank+659,	0,		yyvstop+121,
yycrank+-781,	0,		yyvstop+123,
yycrank+0,	0,		yyvstop+126,
yycrank+0,	0,		yyvstop+129,
yycrank+0,	0,		yyvstop+132,
yycrank+29,	0,		yyvstop+134,
yycrank+0,	0,		yyvstop+137,
yycrank+-904,	0,		yyvstop+139,
yycrank+-1029,	0,		yyvstop+142,
yycrank+1061,	0,		yyvstop+144,
yycrank+0,	0,		yyvstop+146,
yycrank+65,	0,		yyvstop+148,
yycrank+0,	yysvec+68,	yyvstop+150,
yycrank+1119,	0,		yyvstop+152,
yycrank+58,	0,		yyvstop+155,
yycrank+0,	0,		yyvstop+157,
yycrank+0,	0,		yyvstop+159,
yycrank+10,	0,		yyvstop+161,
yycrank+0,	0,		yyvstop+163,
yycrank+0,	0,		yyvstop+165,
yycrank+1177,	0,		yyvstop+167,
yycrank+0,	0,		yyvstop+170,
yycrank+0,	0,		yyvstop+173,
yycrank+0,	0,		yyvstop+175,
yycrank+10,	0,		yyvstop+177,
yycrank+0,	0,		yyvstop+179,
yycrank+0,	0,		yyvstop+181,
yycrank+21,	0,		yyvstop+183,
yycrank+-1299,	0,		yyvstop+185,
yycrank+0,	0,		yyvstop+188,
yycrank+0,	0,		yyvstop+190,
yycrank+0,	0,		yyvstop+192,
yycrank+0,	0,		yyvstop+194,
yycrank+0,	0,		yyvstop+196,
yycrank+0,	0,		yyvstop+199,
yycrank+0,	0,		yyvstop+201,
yycrank+0,	0,		yyvstop+203,
yycrank+0,	0,		yyvstop+206,
yycrank+0,	0,		yyvstop+209,
yycrank+11,	0,		yyvstop+211,
yycrank+0,	0,		yyvstop+213,
yycrank+-73,	yysvec+41,	yyvstop+215,
yycrank+-155,	yysvec+45,	yyvstop+217,
yycrank+0,	0,		yyvstop+219,
yycrank+0,	0,		yyvstop+221,
yycrank+0,	0,		yyvstop+223,
yycrank+-10,	yysvec+55,	yyvstop+225,
yycrank+0,	yysvec+56,	yyvstop+227,
yycrank+1328,	yysvec+57,	0,	
yycrank+0,	yysvec+57,	yyvstop+229,
yycrank+0,	0,		yyvstop+231,
yycrank+0,	0,		yyvstop+233,
yycrank+0,	0,		yyvstop+236,
yycrank+1387,	0,		yyvstop+239,
yycrank+16,	yysvec+110,	yyvstop+242,
yycrank+11,	yysvec+110,	yyvstop+245,
yycrank+32,	yysvec+110,	yyvstop+248,
yycrank+0,	0,		yyvstop+251,
yycrank+12,	yysvec+110,	yyvstop+254,
yycrank+13,	yysvec+110,	yyvstop+257,
yycrank+10,	yysvec+110,	yyvstop+260,
yycrank+38,	yysvec+110,	yyvstop+263,
yycrank+10,	yysvec+110,	yyvstop+266,
yycrank+38,	yysvec+110,	yyvstop+269,
yycrank+62,	yysvec+110,	yyvstop+272,
yycrank+57,	yysvec+110,	yyvstop+275,
yycrank+11,	yysvec+110,	yyvstop+278,
yycrank+22,	yysvec+110,	yyvstop+281,
yycrank+45,	yysvec+110,	yyvstop+284,
yycrank+36,	yysvec+110,	yyvstop+287,
yycrank+0,	yysvec+62,	yyvstop+290,
yycrank+-165,	yysvec+64,	yyvstop+292,
yycrank+-1509,	yysvec+65,	0,	
yycrank+0,	yysvec+66,	yyvstop+294,
yycrank+0,	yysvec+68,	0,	
yycrank+0,	yysvec+71,	0,	
yycrank+0,	yysvec+70,	yyvstop+296,
yycrank+42,	0,		0,	
yycrank+0,	0,		yyvstop+298,
yycrank+0,	yysvec+77,	yyvstop+300,
yycrank+34,	0,		0,	
yycrank+0,	0,		yyvstop+302,
yycrank+-195,	yysvec+85,	yyvstop+304,
yycrank+40,	0,		0,	
yycrank+1508,	0,		yyvstop+306,
yycrank+0,	yysvec+110,	yyvstop+308,
yycrank+37,	yysvec+110,	yyvstop+310,
yycrank+0,	0,		yyvstop+312,
yycrank+52,	yysvec+110,	yyvstop+314,
yycrank+58,	yysvec+110,	yyvstop+316,
yycrank+45,	yysvec+110,	yyvstop+318,
yycrank+65,	yysvec+110,	yyvstop+320,
yycrank+69,	yysvec+110,	yyvstop+322,
yycrank+70,	yysvec+110,	yyvstop+324,
yycrank+73,	yysvec+110,	yyvstop+326,
yycrank+79,	yysvec+110,	yyvstop+328,
yycrank+75,	yysvec+110,	yyvstop+330,
yycrank+82,	yysvec+110,	yyvstop+332,
yycrank+70,	yysvec+110,	yyvstop+334,
yycrank+77,	yysvec+110,	yyvstop+336,
yycrank+78,	0,		0,	
yycrank+93,	0,		0,	
yycrank+95,	0,		0,	
yycrank+0,	0,		yyvstop+338,
yycrank+94,	yysvec+110,	yyvstop+340,
yycrank+118,	yysvec+110,	yyvstop+342,
yycrank+100,	yysvec+110,	yyvstop+344,
yycrank+0,	yysvec+110,	yyvstop+346,
yycrank+91,	yysvec+110,	yyvstop+349,
yycrank+0,	yysvec+110,	yyvstop+351,
yycrank+103,	yysvec+110,	yyvstop+354,
yycrank+111,	yysvec+110,	yyvstop+356,
yycrank+99,	yysvec+110,	yyvstop+358,
yycrank+116,	yysvec+110,	yyvstop+360,
yycrank+119,	yysvec+110,	yyvstop+362,
yycrank+0,	yysvec+110,	yyvstop+364,
yycrank+122,	yysvec+110,	yyvstop+367,
yycrank+131,	yysvec+110,	yyvstop+369,
yycrank+134,	0,		0,	
yycrank+0,	0,		yyvstop+371,
yycrank+227,	0,		0,	
yycrank+128,	yysvec+110,	yyvstop+373,
yycrank+123,	yysvec+110,	yyvstop+375,
yycrank+135,	yysvec+110,	yyvstop+377,
yycrank+131,	yysvec+110,	yyvstop+379,
yycrank+0,	yysvec+110,	yyvstop+381,
yycrank+139,	yysvec+110,	yyvstop+384,
yycrank+132,	yysvec+110,	yyvstop+386,
yycrank+130,	yysvec+110,	yyvstop+388,
yycrank+135,	yysvec+110,	yyvstop+390,
yycrank+144,	yysvec+110,	yyvstop+392,
yycrank+143,	yysvec+110,	yyvstop+394,
yycrank+142,	yysvec+110,	yyvstop+396,
yycrank+0,	yysvec+110,	yyvstop+398,
yycrank+158,	0,		0,	
yycrank+282,	0,		0,	
yycrank+315,	yysvec+110,	yyvstop+401,
yycrank+160,	yysvec+110,	yyvstop+404,
yycrank+152,	yysvec+110,	yyvstop+406,
yycrank+143,	yysvec+110,	yyvstop+408,
yycrank+166,	yysvec+110,	yyvstop+410,
yycrank+170,	yysvec+110,	yyvstop+412,
yycrank+0,	yysvec+110,	yyvstop+414,
yycrank+0,	yysvec+110,	yyvstop+417,
yycrank+0,	yysvec+110,	yyvstop+420,
yycrank+170,	yysvec+110,	yyvstop+423,
yycrank+157,	yysvec+110,	yyvstop+425,
yycrank+157,	yysvec+110,	yyvstop+427,
yycrank+159,	0,		0,	
yycrank+178,	0,		0,	
yycrank+332,	0,		0,	
yycrank+326,	0,		0,	
yycrank+172,	yysvec+110,	yyvstop+429,
yycrank+179,	yysvec+110,	yyvstop+431,
yycrank+175,	yysvec+110,	yyvstop+433,
yycrank+174,	yysvec+110,	yyvstop+435,
yycrank+186,	yysvec+110,	yyvstop+437,
yycrank+187,	yysvec+110,	yyvstop+439,
yycrank+180,	yysvec+110,	yyvstop+441,
yycrank+192,	yysvec+110,	yyvstop+443,
yycrank+202,	0,		0,	
yycrank+194,	0,		0,	
yycrank+198,	0,		0,	
yycrank+0,	yysvec+110,	yyvstop+445,
yycrank+196,	yysvec+110,	yyvstop+448,
yycrank+215,	yysvec+110,	yyvstop+450,
yycrank+201,	yysvec+110,	yyvstop+452,
yycrank+208,	yysvec+110,	yyvstop+454,
yycrank+0,	yysvec+110,	yyvstop+457,
yycrank+213,	yysvec+110,	yyvstop+460,
yycrank+207,	yysvec+110,	yyvstop+462,
yycrank+217,	0,		0,	
yycrank+229,	0,		0,	
yycrank+230,	0,		0,	
yycrank+248,	yysvec+110,	yyvstop+464,
yycrank+0,	yysvec+110,	yyvstop+466,
yycrank+236,	yysvec+110,	yyvstop+469,
yycrank+242,	yysvec+110,	yyvstop+471,
yycrank+254,	yysvec+110,	yyvstop+473,
yycrank+255,	yysvec+110,	yyvstop+475,
yycrank+357,	0,		0,	
yycrank+260,	0,		0,	
yycrank+243,	0,		0,	
yycrank+249,	yysvec+110,	yyvstop+477,
yycrank+247,	yysvec+110,	yyvstop+479,
yycrank+261,	yysvec+110,	yyvstop+481,
yycrank+0,	yysvec+110,	yyvstop+483,
yycrank+256,	yysvec+110,	yyvstop+486,
yycrank+0,	0,		yyvstop+488,
yycrank+255,	0,		0,	
yycrank+266,	0,		0,	
yycrank+272,	yysvec+110,	yyvstop+490,
yycrank+258,	yysvec+110,	yyvstop+492,
yycrank+259,	yysvec+110,	yyvstop+494,
yycrank+0,	yysvec+110,	yyvstop+496,
yycrank+277,	0,		0,	
yycrank+284,	0,		0,	
yycrank+265,	yysvec+110,	yyvstop+499,
yycrank+280,	yysvec+110,	yyvstop+501,
yycrank+0,	yysvec+110,	yyvstop+503,
yycrank+286,	0,		0,	
yycrank+286,	0,		0,	
yycrank+0,	yysvec+110,	yyvstop+506,
yycrank+296,	yysvec+110,	yyvstop+509,
yycrank+397,	0,		0,	
yycrank+282,	0,		0,	
yycrank+0,	yysvec+110,	yyvstop+511,
yycrank+0,	0,		yyvstop+514,
yycrank+407,	0,		0,	
yycrank+0,	0,		yyvstop+516,
0,	0,	0};
struct yywork *yytop = yycrank+1636;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,'!' ,01  ,01  ,01  ,01  ,01  ,047 ,
01  ,01  ,01  ,01  ,',' ,'-' ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,'-' ,01  ,'!' ,
'@' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'L' ,'A' ,'A' ,'L' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,0134,01  ,01  ,01  ,
'-' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'L' ,'L' ,'A' ,'L' ,'A' ,'A' ,'L' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'{' ,0134,'}' ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
