// WaisSource.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
// Incorporating:
/* 
   WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the [NeXTstep] user-interface for the WAIS software.
   Do with it as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/
//
// NOTE: In some of the WAIS software there is a distinction between sources 
// and source-id's.  This distinction is eliminated here, with sources having a 
// ":filename" info field so they can be act as their own source-id's.  This 
// info field is kept consistent with the source's object-lookup key.
//

#import "Wais.h"

extern _WaisDecoder waisSourceDecoder[];

@interface WaisSource : Wais
{
    FILE *connection;
    BOOL isConnected;
    long bufferLength;
    id dataFileList;
    int listCounter;
}

// Access by string keys.
- setKey:(const char *)aKey;
+ folderList;
+ setFolderList:aList;
+ (const char *)defaultHomeFolder;

// Creating and destroying sources.
- initKey:(const char *)aKey;
- free;

// Managing connections.
- setConnected:(BOOL)yn;
- (BOOL)isConnected;
- (FILE *)connection;
- (long)bufferLength;
+ registerUser:(const char *)userInfoString;

// Managing list of files and folders to be indexed in local source.
- dataFileList;
- addDataFile:data;
- removeDataFile:data;
- clearDataFiles;

// Routing error messages.
+ (const char *)errorTitle;

// Reading/writing WAIS files.
- readWaisFile;
- writeWaisFile;
- (short)readWaisStruct:(const char *)structName
    forElement:(const char *)elementName
    fromFile:(FILE *)file
    withDecoder:(WaisDecoder)theDecoder;
- (short)writeWaisStruct:(const char *)structName
    forElement:(const char *)elementName
    toFile:(FILE *)file
    withDecoder:(WaisDecoder)theDecoder;
+ (const char *)fileStructName;
+ (WaisDecoder)fileStructDecoder;
+ (BOOL)checkFileName:(const char *)fileName;

@end


@interface WaisDataFile : Wais
{
}

+ (const char *)fileStructName;
+ (WaisDecoder)fileStructDecoder;

@end


