/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   Morris@think.com
*/

/* Change log:
 * $Log:	panic.c,v $
 * Revision 1.10  92/03/07  19:42:30  jonathan
 * ANSIfied arguments.
 * 
 * Revision 1.9  92/02/20  13:58:10  jonathan
 * Removed redundant include of varargs.h.  Removed fprintf for BSD, since
 * we've not got a vprintf.
 * 
 * Revision 1.8  92/02/12  13:38:05  jonathan
 * Added "$Log" so RCS will put the log message in the header
 * 
*/

/* panic is an error system interface.  On the Mac, it will pop
 * up a little window to explain the problem.
 * On a unix box, it will print out the error and call perror()
 */
 
#include "panic.h"
#include "futil.h"

#include <ctype.h>

#ifndef EXIT_FAILURE  /* should be in stdlib */
#define EXIT_FAILURE (-1)
#endif /* ndef EXIT_FAILURE */

/*----------------------------------------------------------------------*/

static void exitAction _AP((long error));

static void
exitAction(error)
long error;
{
  long i;
#ifdef THINK_C
  Debugger();
#else
  for (i = 0; i < 100000; i++)
    ;
#endif
  abort();
}

/*----------------------------------------------------------------------*/

#define PANIC_HEADER "Fatal Error:  "
#define BELL "\007"

#ifdef ANSI_LIKE /* use ansi varargs */

#ifdef THINK_C /* pop up a dialog box */
#include "CDynamicError.h"
#endif

extern char* log_file_name;
extern FILE* logfile;

void
panic(char* format, ...)
{
  va_list ap;			/* the variable arguments */

#ifdef THINK_C			/* pop up a dialog box */

  char buffer[1000];		/* hope this is enough space! */
  long i;
  strncpy(buffer,PANIC_HEADER,1000);
  SysBeep(5);
  va_start(ap, format);		/* init ap */
  vsprintf(buffer + strlen(PANIC_HEADER),format,ap);
  va_end(ap);			/* free ap */
  for (i = 0L; buffer[i] != '\0'; i++)
    { if (buffer[i] == '\n' || buffer[i] == '\r')
	buffer[i] = ' ';
      }
  gError->PostAlertMessage(buffer);

#else				/* print in the shell window */

  if(logfile == NULL && log_file_name != NULL)
    logfile = fopen(log_file_name, "a");

  if(logfile == NULL) logfile = stderr;
  fprintf(logfile, "%d: 999999: %s: -1: %s  ", 
	  getpid(), printable_time(),PANIC_HEADER);
  /* fprintf(stderr,BELL); taken out by brewster 7/91 */
  va_start(ap, format);	/* init ap */
  vfprintf(logfile,format,ap); /* print the contents */
  va_end(ap);			/* free ap */
  fprintf(logfile, "\n");
  fflush(logfile);
#endif
  
  if(logfile != stderr) {
    fclose(logfile);
    logfile = NULL;
  }

  exitAction(0);
}

#else /* use k&r varargs */

extern char* log_file_name;
extern FILE* logfile;

void
panic(va_alist)
va_dcl
{
  va_list ap;			/* the variable arguments */
  char* format;
  
  if(logfile == NULL && log_file_name != NULL)
    logfile = fopen(log_file_name, "a");

  if(logfile == NULL) logfile = stderr;
  fprintf(logfile, "%d: 999999: %s: -1: %s  ", 
	  getpid(), printable_time(),PANIC_HEADER);
  /* fprintf(stderr,BELL); taken out by brewster 7/91 */
  
  va_start(ap);			/* init ap */

  format = va_arg(ap,char*);	/* get the format */
  
  vfprintf(logfile ,format,ap); /* print the contents */

  va_end(ap);			/* free ap */

  fprintf(logfile,"\n");
  fflush(logfile);

  if(logfile != stderr) {
    fclose(logfile);
    logfile = NULL;
  }

  exitAction(0);
}
  
#endif

/*----------------------------------------------------------------------*/
