// BarChartCell.m
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.

#import "BarChartCell.h"
#import <appkit/appkit.h>

@implementation BarChartCell

- initTextCell:(const char *)aString
{
    [super initTextCell:aString];
    barValue = 0.00;
    barSize = 0.20;
    padding = 0.45;
    barGray = NX_DKGRAY;
    return self;
}

- drawInside:(const NXRect *)cellFrame inView:controlView
{
    NXRect barRect, barFrame, textRect;
    float x, y, h, w;
    id rtn;
    
    // Compute subcell rects.
    x = NX_X(cellFrame); y = NX_Y(cellFrame);
    w = NX_WIDTH(cellFrame); h = NX_HEIGHT(cellFrame);
    NX_X(&barRect) = x + (1-barValue)*barSize*w;
    NX_Y(&barRect) = y + padding*h/2;
    NX_WIDTH(&barRect) = barValue*barSize*w;
    NX_HEIGHT(&barRect) = (1-padding)*h;
    NX_X(&barFrame) = x;		NX_Y(&barFrame) = y;
    NX_WIDTH(&barFrame) = barSize*w;	NX_HEIGHT(&barFrame) = h;
    NX_X(&textRect) = x + barSize*w;	NX_Y(&textRect) = y;
    NX_WIDTH(&textRect) = (1-barSize)*w;NX_HEIGHT(&textRect) = h;
    
    // Draw subcells.
    rtn = [super drawInside:&textRect inView:controlView];
    PSsetgray(backgroundGray);
    PSsetalpha(backgroundGray);
    PScompositerect(NX_X(&barFrame), NX_Y(&barFrame),
    	NX_WIDTH(&barFrame), NX_HEIGHT(&barFrame), NX_SOVER);
    PSsetalpha(1.0);
    if([self isHighlighted]) PScompositerect(NX_X(&barFrame), NX_Y(&barFrame),
    	NX_WIDTH(&barFrame), NX_HEIGHT(&barFrame), NX_HIGHLIGHT);
    PSsetgray(barGray);
    PSrectfill(NX_X(&barRect), NX_Y(&barRect),
    	NX_WIDTH(&barRect), NX_HEIGHT(&barRect));
    return rtn;
}

- setBarValue:(float)aValue
{
    barValue = aValue;
    if(barValue > 1.0) barValue = 1.0;
    if(barValue < 0.0) barValue = 0.0;
    return self;
}

- (float)barValue
{
    return barValue;
}

- setBarSize:(float)aValue
{
    barSize = aValue;
    if(barSize > 1.0) barSize = 1.0;
    if(barSize < 0.0) barSize = 0.0;
    return self;
}

- (float)barSize
{
    return barSize;
}

- setPadding:(float)aValue
{
    padding = aValue;
    if(padding > 1.0) padding = 1.0;
    if(padding < 0.0) padding = 0.0;
    return self;
}

- (float)padding
{
    return padding;
}

- setBarGray:(float)aValue
{
    barGray = aValue;
    if(barGray > 1.0) barGray = 1.0;
    if(barGray < 0.0) barGray = 0.0;
    return self;
}

- (float)barGray
{
    return barGray;
}

@end
