/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */
#ifndef FIELD_H
#define FIELD_H
#include "conf.h"
#define MAX_LINE 4096		/* maximum length of config file line */
#define MAX_HELP 240		/* maximum length of config file help */
#define MAX_LEN 4096		/* maximum length for any field */
#define F_LEADER 15		/* width of field used to print field names */

/*
 * Field descriptor.  describes the attributes of a field
 */
struct fielddesc
{
	short	fdId;		/* id # of the field */
	short	fdMax;		/* maximum length of the field */
	int	fdIndexed;	/* do we index this field? */
	int	fdLookup;	/* do we let just anyone do lookups with this? */
	int	fdPublic;	/* is field publicly viewable? */
	int	fdLocalPub;	/* is field publicly viewable off-campus? */
	int	fdDefault;	/* print the field by default? */
	int	fdAlways;	/* print the always fields ? */
	int	fdAny;		/* the search field/property any */
	int	fdTurn;		/* can the user turn off display of this field? */
	int	fdChange;	/* is field changeable by the user? */
	int	fdSacred;	/* field requires great holiness of changer */
	int	fdEncrypt;	/* field requires encryption when it passes the net */
	int	fdNoPeople;	/* field may not be changed for "people"
				 * entries, but can for others */
	int	fdForcePub;	/* field is public, no matter what F_SUPPRESS is */
	char	*fdName;	/* name of the field */
	char	*fdHelp;	/* help for this field */
	char	*fdMerge;	/* merge instructions for this field */
};
typedef struct fielddesc FDESC;

/*
 * predefined fields.  these correspond to the ``don't touch'' fields
 * in fields.config
 */
#define F_ADDRESS	0
#define F_PHONE		1
#define F_EMAIL		2
#define F_NAME		3
#define F_TYPE		4
#define F_UNIVID	5
#define F_ALIAS		6
#define F_PASSWORD	7
#define F_PROXY		8
#define F_DEPARTMENT	9
#define F_TITLE		10
#define F_CURRICULUM	11
#define F_CLASSCO	12
#define F_SOUND		13
#define F_MAILCODE	18
#define F_NICKNAME	23
#define F_HERO		30
#define F_HIGH		35
#define F_HOMEADDR	20
#define F_PERMADDR	21
#define F_HOMEPHONE	33
#define F_PAPER		38
#define F_SUPPRESS	43

/*
 * merge flags
 */
#define OLD_FIELD	'O'
#define STUDENT_FIELD	'S'
#define STAFF_FIELD	'F'
#define CONDITIONAL	'C'

static int F_TempValue;

#define FIELDVALUE(dir,select)	(index(dir[select],':')+1)
#define FINDVALUE(dir,f)	\
    (((F_TempValue=FindField(dir,f))>=0)?FIELDVALUE(dir,F_TempValue):"")

extern FDESC **FieldDescriptors;

#endif
