#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

/*
 * These routines provide a reasonably efficient way of building up a
 * string of unknown length.  The string is kept in a buffer, and the end
 * of the current string is remembered so that it can be easily added on
 * to.  If the buffer runs out of space it is reallocated at twice its 
 * needed size.  Once the string has been built it should be copied, since
 * it will be destroyed by the next call to init_string().
 */

#define INITIAL_SIZE 128

static char *StrBuf;
static unsigned StrBufSize;
static unsigned StrBufUsed;

/*
 * Initialize the buffer to start building a new string.
 */
void 
init_string()
{
	if (StrBuf)
		free(StrBuf);
	StrBufSize = INITIAL_SIZE;
	StrBuf = malloc(StrBufSize);
	StrBuf[0] = '\0';
	StrBufUsed = 1;
}

/*
 * Add a new string onto the current buffer.	A pointer to the beginning *
 * of the buffer is returned.
 */
char *
add_string(str)
	char *str;
{
	int	strlength;

	/* Nothing to do */
	if (!str || !str[0])
		return StrBuf;

	/* Just so we don't have to count it twice */
	strlength = strlen(str);

	/* Make sure we have enough space in the buffer */
	if (StrBufUsed + strlength > StrBufSize)
	{
		StrBufSize += strlength;
		free(StrBuf);
		StrBuf = realloc(StrBuf, StrBufSize *= 2);
	}

	/* Add on the new string */
	(void) strcat(&StrBuf[StrBufUsed - 1], str);
	StrBufUsed += strlength;

	/* Return a pointer to the whole thing */
	return StrBuf;
}
