/*
** This software is Copyright (c) 1989, 1990, 1991 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
*/
#if !defined(lint) && !defined(SABER)
static char SID[] = "@(#)zfopen.c	2.3 5/9/91";
#endif

#include <sys/types.h>
#include <stdio.h>
#include "rkive.h"
#include "suffix.h"

extern FILE *errfp;

static char cmdline[512] = "";

FILE *zfopen(file,mode)       
char *file, *mode;
{
    int strlen();
    int strcmp();
    char *strcat();
    FILE *fopen();
    FILE *popen();

    char *ss;
    FILE *fp;
    struct compress_tab *ct;

    /*
    ** First, need to compare the filename passed in to the
    ** compression suffix table in order to determine if the
    ** file has a recognized, compression suffix attached. 
    **
    ** If it does, execute the command specified in the table.
    ** 
    ** If no suffix found to be attached, try to open the file 
    ** name passed to this function. 
    ** 
    ** If that fails, brute force it to see if the file name 
    ** passed in did not contain the suffix but the file on
    ** disk the user is trying to open does. Do this by appending
    ** each compression suffix to the filename passed in and
    ** try to open the file. If the open does not fail, execute
    ** the command specified in the table.
    */
    
    cmdline[0] = '\0';
    ss = file + (strlen(file)-2);

    ct = &cprgs[0];
    while ((ct->com_name) != NULL) {
        if (strcmp(ss, ct->com_suffix) == 0) {
            *ss = '\0';
            (void) sprintf(cmdline, "%s %s", ct->uncom_name, file);
            break;
        }
        ct++;
    }

    if (cmdline[0] != '\0') {
        /*
        ** Found an attached suffix, execute the specified command.
        */
        if ((fp = popen(cmdline, "r")) == NULL) {
            (void) fprintf(errfp, "Can't execute command: %s\n", cmdline);
            exit(1);
        }
    }
    else if ((fp = fopen (file, mode)) == NULL) {
        /*
        **  OK, no suffix found to be attached, opening the file
        **  directly failed. Time to brute force it to see if a file
        **  name was passed in that did not contain the suffix but
        **  the file on disk that the user is trying to open does...
        */
        ss = file+strlen(file);
        ct = &cprgs[0];
        while ((ct->com_name) != NULL) {
            (void) strcat(file, ct->com_suffix);
            if ((fp = fopen (file, mode)) != NULL) {
                *ss = '\0';
                (void) sprintf(cmdline, "%s %s", ct->uncom_name, file);
                if (cmdline[0] != '\0') {
                    if ((fp = popen(cmdline, "r")) == NULL) {
                        (void) fprintf(errfp, "Can't execute command: %s\n", 
                                       cmdline);
                        exit(1);
                    }
                }
            }
            ct++;
            *ss = '\0';
        }
        (void) fprintf (errfp, "Can't open file %s\n", file);
        exit(1);
     }
     return (fp);
}

int   zfclose(fp)
FILE  *fp;
{
    int fclose();
    int pclose();

    return (cmdline[0] == '\0' ? fclose(fp) : pclose(fp));
}
