/*
** This software is Copyright (c) 1989, 1990, 1991 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
*/

#if !defined(lint) && !defined(SABER)
static char SID[] = "@(#)suffix.c	2.2 5/9/91";
#endif

#include <stdio.h>
#include <sys/types.h>
#include "rkive.h"
#include "suffix.h"

int strcmp();
char *strcpy();

extern char compress[];

char *suffix(compression)
    char *compression;
{
   char *strchr();

    char *ccp;
    char sccmd[BUFSIZ];
    struct compress_tab *ct;
    
    /*
    ** Need to remove any compression command
    ** options if they exist. (compress -f)
    */

    (void) strcpy(sccmd, compression);
    if ((ccp = strchr(sccmd,' ')) != NULL)
         *ccp = '\0';

    ct = &cprgs[0];
    while ((ct->com_name) != NULL) {
        if (strcmp(sccmd, ct->com_name) == 0) 
            return(ct->com_suffix);
        ct++;
    }
    return("");
}

int remove_suffix(path_str)
char *path_str;
 {
    int strlen();

    char *ss;
    struct compress_tab *ct;

    /*
    ** need to compare the filename passed in to 
    ** the compression suffix table in order to
    ** determine if the file has a recognized,
    ** compression suffix attached.
    */
    
    ss = path_str + (strlen(path_str) -2);

    ct = &cprgs[0];
    while ((ct->com_name) != NULL) {
        if (strcmp(ss, ct->com_suffix) == 0) {
            *ss = '\0';
            return(TRUE);
        }
        ct++;
    }
    return(FALSE);
}

char *expand_name(filename,ng)
char *filename;
struct group_archive *ng;
{
    char *oops;
    char *comp_cmd;
    char *strcat();
    char *basename();

    static char compress_path[MAXNAMLEN];

    (void) strcpy(compress_path, filename);

    /*
    ** Check to see if a group specific compress was specified.      
    ** If so, then attach the suffix and return.                    
    ** Else check to see if a global compress was specified. If so,
    ** then attach the suffix and return.                         
    ** If both are NULL, return filename.                        
    */

    if (*(ng->compress)) {
        comp_cmd = basename(ng->compress);
        oops = suffix(comp_cmd);
        (void) strcat(compress_path, oops);
    }
    else if (*compress) {
        comp_cmd = basename(compress);
        (void) strcat(compress_path, suffix(comp_cmd));
    }
    return(compress_path);
}
