BEGIN {
	# Lines not in the header will go to this temporary file to be
	#   included in the message body.
	"echo $tempfile" | getline message_file;
	close("echo $tempfile");

	# We start out in the header.
	in_header = 1;

	# These are not required by AWK, but...
	to_parms = "";
	command_line = "";

	# Kluge alert!
	"hostname" | getline hostname;
	close("hostname");
	if (hostname == "alpha.eecs.nwu.edu") {
		special_options = "-n";
	} else {
		special_options = "";
	}
}

in_header == 0 {
	print $0 > message_file;
	next;
}

# Everything below this line is executed only if (in_header == 1)

{
	# Set up "rest" to be everything in the line except the field name
        pos = index($1,":");
        if (pos == 0) {
        	# This line is not in the header.  We assume that it is
		#    the beginning of the message body.
		in_header = 0;
		print $0 > message_file;
		next;
	} else {
		field = substr($1,1,pos-1);
		# Take the rest of the line
		rest = $0;
		sub("^[^:]*:[ \t]+", "", rest);
		# It will be put in single-quotes, so single-quotes that are in
		# it already (if any) will have to be replaced with this, of 
		# all things: '"'"'
		#
		# For example:  'don't do this'  -->  'don'"'"'t do this'
		#
		# If sh and csh had any brains, they would allow us to use 
		#    'don\'t do this'
		# but...
        	gsub("'", "'\"'\"'", rest);
	}
}

field == "To" {
	to_parms = sprintf("%s '%s'", to_parms, rest);
	next;
}

field == "Subject" {
	command_line = sprintf("%s -s '%s'", command_line, rest);
 	next;
}

field ~ /^C[Cc]$/ {
 	command_line = sprintf("%s -c '%s'", command_line, rest);
 	next;
}

field ~ /^B[Cc][Cc]$/ {
 	command_line = sprintf("%s -b '%s'", command_line, rest);
 	next;
}

{
 	# This is still a header field, but we do not know what it is.
	#     Just write put it in the header, as is.
	#
  	command_line = sprintf("%s -a %s:'%s'", command_line, field, rest);
 	next;
}

END {
 	# "send" is happier with the "To" parameters in front
	# printf("send %s %s -c \"\" -f %s", \
	#	 to_parms, command_line, message_file);
	# Kluge alert!
	printf("send %s %s %s -c \"\" -f %s", \
		to_parms, special_options, command_line, message_file);
}
