#define		MAINLINE
#include	"parms.h"
#include	"structs.h"
#include "acl.h"

#ifdef	RCSIDENT
static char rcsid[] = "$Header: /g1/users/staff/gore/exp/notes/src/obsolete/nfaccess.c,v 2.0 89/04/16 01:13:09 gore Exp $";
#endif	RCSIDENT

/*
 *	This program works sort of chmod by adding/deleting
 *	permissions to the specified access lists.
 *
 *	Any normal user can run this program. It only allows changes
 *	to notesfiles the user is a director in.
 *
 *	Ray Essick		February 1984
 *
 *	Walter Underwood	June 1987 -- transplanted to Notes 2.7
 */



#define		MAXADD		1			/* simultaneous adds */
struct perm_f   Newmodes[MAXADD];			/* inserted modes */
static int  nmodes = 0;					/* active slots */

#include	<pwd.h>
#include	<grp.h>
extern struct passwd   *getpwnam ();
extern struct group *getgrnam ();


main (argc, argv)
int     argc;
char  **argv;
{
    struct io_f io;
    int     argn;
    struct nfile *nfptr;

    initenv();						/* common init code */

    if (parsemode (argv[1], &Newmodes[nmodes++], 1, 1))	/* grab a mode */
    {
	usage (argv[0]);				/* incorrect */
    }

    for (argn = 2; argn < argc; argn++)
    {
	expand (argv[argn]);				/* load it */
    }

    for (nfptr = nfile; nfptr; nfptr = nfptr->n_next)
    {
	if (init (&io, nfptr -> n_name) < 0)		/* open */
	{
	    printf ("%s:	couldn't open\n", nfptr -> n_name);
	    continue;
	}
	if (!allow (&io, DRCTOK))			/* a director? */
	{
	    printf ("%s:	Not a director\n", nfptr -> n_name);
	    closenf (&io);
	    continue;
	}

	addmodes (&io, nmodes, Newmodes, 1);		/* add permissions */
	closenf (&io);
    }
    exit (0);						/* all done */
}

usage (name)						/* how to invoke */
char   *name;
{
    fprintf (stderr,
	    "Usage: %s <permission> <notesfile> [<notesfile>...]\n",
	    name);
    exit (1);
}
