#!/bin/sh
#@(#)binary.sh	29.5a

# the following change from site to site, and must be set up
# before running this script.  There are sanity checks below.
# Also, before running, you must have set up a notes user in
# /etc/passwd, whose home directory is the same as LIBDIR.

SPOOLDIR=/usr/spool/notes		# Where to put the notes data itself
ARCHDIR=/usr/spool/oldnotes		# Where archives go (near above!)
LIBDIR=/usr/contrib/lib/notes		# Where support commands go
BINDIR=/usr/contrib/bin			# Where user commands go
MANDIR=/usr/contrib/man			# Where manuals go

NOTESUSR=notes				# The user name of notes
NOTESGRP=daemon				# And it's group name (it does matter)

DOMAIN=".HP.COM"			# What networking domain you are in

# safety check; comment out the following two lines when editing completed.

echo "If you have not set up the script for your site, do so and rerun."
exit 1

# Check that /etc/passwd is minimally right: the notes user (NOTESUSR)
# must exist, it's home directory must be LIBDIR, and the group number
# in /etc/passwd must yeild the group name NOTESGRP.  This is vital to
# the proper operation of notes.

if egrep "^$NOTESUSR:" /etc/passwd >/dev/null; then
	if [ `awk -F: "/^$NOTESUSR:/ {print \\$6;exit}" /etc/passwd` != $LIBDIR ] ; then
		echo "Notes user home directory in /etc/passwd is wrong."
		exit 1
	fi
	notesgid=`awk -F: "/^$NOTESGRP:/ {print \\$3;exit}" /etc/group`
	if [ `awk -F: "/^$NOTESUSR:/ {print \\$4;exit}" /etc/passwd` != $notesgid ] ; then
		echo "Notes group in /etc/passwd doesn't match /etc/group"
		exit 1
	fi

else
	echo "Notes user is not set up."
fi

# This just won't work reliably if not root.  (Updates are possible as
# non-root, but the first time requires root.)

if [ `whoami` != root ]; then
	echo "Not running as root"
	exit 1
fi

# BINDIR could not yet be set up, particularly if this is the first
# contriubted software.

if [ ! -d ${BINDIR} ]; then
	echo ${BINDIR} does not exist
	exit 1
fi

# Ditto for MANDIR

if [ ! -d ${MANDIR}/man1 ]; then
	echo ${MANDIR}/man1 does not exist
	exit 1
fi

if [ ! -d ${MANDIR}/man8 ]; then
	echo ${MANDIR}/man8 does not exist.  Create it and try again.
	exit 1
fi

echo "The initial setup was correct."

# The following probably don't need to be modified
LOCKS=${LIBDIR}/locks
RMTDIR=${LIBDIR}/sys
HLPDIR=${LIBDIR}/help
UNIQID=${LIBDIR}/SEQ
INVALID=${LIBDIR}/invalid
SYSBIN=/usr/bin
RNEWS=rnews
NFRCV=nfrcv

# make master directories
mkdir ${SPOOLDIR} ${ARCHDIR} ${LIBDIR}
chown ${NOTESUSR} ${SPOOLDIR} ${ARCHDIR} ${LIBDIR}
chgrp ${NOTESGRP} ${SPOOLDIR} ${ARCHDIR} ${LIBDIR}
chmod 775 ${SPOOLDIR} ${ARCHDIR} ${LIBDIR}

# setup library directory

# make subdirectories
mkdir ${RMTDIR} ${LOCKS} ${HLPDIR}
chown ${NOTESUSR} ${RMTDIR} ${LOCKS} ${HLPDIR}
chgrp ${NOTESGRP} ${RMTDIR} ${LOCKS} ${HLPDIR}
chmod 775 ${RMTDIR} ${LOCKS} ${HLPDIR}

echo "All new directories made."
# create invalid file, sequencer
if [ ! -f ${INVALID} ]; then
	echo general >${INVALID}
fi
if [ ! -f ${UNIQID} ]; then
	echo 1 > ${UNIQID}
fi
chown ${NOTESUSR} ${UNIQID} ${INVALID}
chgrp ${NOTESGRP} ${UNIQID} ${INVALID}
chmod 660 ${UNIQID}
chmod 644 ${INVALID}

# copy help files
cp help/*.help ${HLPDIR}
chown ${NOTESUSR} ${HLPDIR}/*.help
chgrp ${NOTESGRP} ${HLPDIR}/*.help
chmod 644 ${HLPDIR}/*.help

# make config file
#    Only make the file if it doesn't already exist
#
if test -f ${LIBDIR}/config; then
        echo "File ${LIBDIR}/config already exists, so I'm not making a new one."
else
	echo "# Configuration file for the Notesfiles system" >> ${LIBDIR}/config
	echo "#  This file is read by each program or utility at startup." >> ${LIBDIR}/config
	echo "Archive-Directory:$ARCHDIR"	>> ${LIBDIR}/config
	echo "Spool-Directory:	$SPOOLDIR"	>> ${LIBDIR}/config
	echo "Archive-Days:	14"		>> ${LIBDIR}/config
	echo "Junk-Days:	14"		>> ${LIBDIR}/config
	echo "Allow-Old:	 No"		>> ${LIBDIR}/config
	echo "Domain:		$DOMAIN"	>> ${LIBDIR}/config
	echo "Organization:	Hunga Dunga U." >> ${LIBDIR}/config
	#Since we're guessing, tell the user so.
	if [ ! -f /usr/lib/sendmail ]; then
		echo "It appears you have only UUCP mail; if you have a mailer"
		echo "that accepts user@site type names, you will want to"
		echo "remove the UUCP-mailer line in ${LIBDIR}/config."

		echo "UUCP-mailer:	yes"	>> ${LIBDIR}/config
	else
		echo "It appears you have a mailer that accepts name of the"
		echo "form user@site.  Add"
		echo "UUCP-mailer:	yes"
		echo "to ${LIBDIR}/config if that's not right."

	fi
fi
chown ${NOTESUSR} ${LIBDIR}/config
chgrp ${NOTESGRP} ${LIBDIR}/config
chmod 644 ${LIBDIR}/config

# put in support commands

LIBCMDS="mknf rmnf newsinput newsoutput nfaccess nfarchive nfrcv inotes recnotes seqset"

for i in ${LIBCMDS}; do 
    cp $i ${LIBDIR};
    chown ${NOTESUSR} ${LIBDIR}/$i
    chgrp ${NOTESGRP} ${LIBDIR}/$i
    chmod 6711 ${LIBDIR}/$i
done

# install various scripts
# nfxmitsh is temporary.

# the cronrun.* scripts are samples to be edited.  They also need some
# environmental data.  The others inherit it from these if needed.
# (In particular, cron does not set TZ right; we'll assume it's right for
# the installer).

SCRIPTS="cronrun.hr cronrun.day cronrun.wk"

for i in ${SCRIPTS}; do 
	echo LIBDIR=${LIBDIR}      > ${LIBDIR}/$i
	echo SPOOLDIR=${SPOOLDIR} >> ${LIBDIR}/$i
	echo TZ=${TZ}             >> ${LIBDIR}/$i
	cat samples/$i            >> ${LIBDIR}/$i
	chown ${NOTESUSR} ${LIBDIR}/$i
	chgrp ${NOTESGRP} ${LIBDIR}/$i
	chmod 0775 ${LIBDIR}/$i
done

SCRIPTS="mkactive nfxmitsh notesmail sendbatch newbatch fetchnotes spoolnotes arbitron"

for i in ${SCRIPTS}; do 
	cp $i.sh  ${LIBDIR}/$i
	chown ${NOTESUSR} ${LIBDIR}/$i
	chgrp ${NOTESGRP} ${LIBDIR}/$i
	chmod 0775 ${LIBDIR}/$i
done

# Install a sample crontab file; it seems a poor idea to actually install
# it until it's edited.
cp samples/crontab ${LIBDIR}/crontab
chown ${NOTESUSR} ${LIBDIR}/crontab
chgrp ${NOTESGRP} ${LIBDIR}/crontab
chmod 0664 ${LIBDIR}/crontab

echo "${LIBDIR} is prepared"

# Set up mail forwarding to root, if possible.  (Don't step on existing
# mailboxes).
if [ -s /usr/mail/${NOTESUSR} ]; then
	echo "Notes has a mailbox; left it alone"
else
	echo "Forward to root" > /usr/mail/${NOTESUSR}
	echo "Notes mail is now forwarded to root"
fi


# Make sure Active file exists, so that mknf will succeed
#   (nuking the Active file is OK, since mknf rebuilds it from scratch)
#
cat /dev/null > ${LIBDIR}/Active

# make gripe, maintenence, junk files.
#  first three use Quick flag, to skip remaking ~notes/Active.
#  the last one makes the active file.
#
${LIBDIR}/mknf -aoq nfgripes
${LIBDIR}/mknf -oq  nfmaint
${LIBDIR}/mknf -onq junk
${LIBDIR}/mknf -on  control

echo "The support newsgroups were created"

# put in user commands

BINCMDS="notes nfsearch nfstats nfprint checknotes"

for i in ${BINCMDS}; do
    cp $i ${BINDIR}
    chown ${NOTESUSR} ${BINDIR}/$i
    chgrp ${NOTESGRP} ${BINDIR}/$i
    chmod 2711 ${BINDIR}/$i
done

rm -f ${BINDIR}/autoseq
ln ${BINDIR}/notes ${BINDIR}/autoseq

echo "The user commands have been installed in ${BINDIR}"

# Install the uucp commands.
if [ -f ${SYSBIN}/${RNEWS} ]; then
	echo "${SYSBIN}/${RNEWS} exists; you will have to replace it."
else
	echo "exec ${LIBDIR}/newsinput \$*" >${SYSBIN}/${RNEWS}
fi
chown ${NOTESUSR} ${SYSBIN}/${RNEWS}
chgrp ${NOTESGRP} ${SYSBIN}/${RNEWS}
chmod 755 ${SYSBIN}/${RNEWS}

# This is temporary; and unnecessary if you have no "old" notes neighbors
if [ -f ${SYSBIN}/${NFRCV} ]; then
	echo "${SYSBIN}/${NFRCV} exists; you will have to replace it."
else
	echo "exec ${LIBDIR}/nfrcv $*" >${SYSBIN}/${NFRCV}
fi
chown ${NOTESUSR} ${SYSBIN}/${NFRCV}
chgrp ${NOTESGRP} ${SYSBIN}/${NFRCV}
chmod 711 ${SYSBIN}/${NFRCV}

# Put the commands in L.cmds (if not already there)
if grep ${RNEWS} /usr/lib/uucp/L.cmds; then
	:
else
	echo ${RNEWS} >>/usr/lib/uucp/L.cmds
fi

if grep ${NFRCV} /usr/lib/uucp/L.cmds; then
	:
else
	echo ${NFRCV} >>/usr/lib/uucp/L.cmds
fi

echo "Uucp is now prepared for notes"

for i in `cd man; ls *.1`
do
	cp man/$i ${MANDIR}/man1
	chown ${NOTESUSR} ${MANDIR}/man1/$i
	chgrp ${NOTESGRP} ${MANDIR}/man1/$i
	chmod 644 ${MANDIR}/man1/$i
done
ln ${MANDIR}/man1/notes.1 ${MANDIR}/man1/autoseq.1

for i in `cd man; ls *.8`
do
	cp man/$i ${MANDIR}/man8
	chown ${NOTESUSR} ${MANDIR}/man8/$i
	chgrp ${NOTESGRP} ${MANDIR}/man8/$i
	chmod 644 ${MANDIR}/man8/$i
done

echo "Manual pages have been installed"

echo
echo "Notesfiles installed; Now it's your turn:  you must do two things"
echo "right now:"
echo
echo "1) Edit ${LIBDIR}/cronrun.hr and ${LIBDIR}/cronrun.day to start"
echo "   transmitting to your news feed.  There are helpful comments."
echo "2) Edit ${LIBDIR}/crontab to reflect the best times for you to"
echo "   execute the scripts above, and install it, as ${NOTESUSR},"
echo "   into crontab.  ** Caution ** be ${NOTESUSR} to install it,"
echo "   not root."
echo
echo "It would be a good idea to read the notes documents, and you"
echo "will want to monitor net.log for proper traffic.  Please also"
echo "take a moment to read the netiquette article, and share it with"
echo "your users.  It's a good idea to watch the net for a while before"
echo "posting your first note."
echo
echo "All the pieces from this directory have been copied elsewhere except"
echo "the contents of doc/* and some of samples/*.  doc/* is the detailed"
echo "documentation, and you should print off a few copies for both yourself"
echo "and general users.  samples/* contains some additional scripts that"
echo "my be useful.  In particular if you use compress or some other"
echo "compression utility, you might want to look at cunbatch."

echo "Good luck, and see you on the net."
