/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/rfopen.c,v 2.0 89/04/16 01:09:17 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include <errno.h>

#ifdef BSD42ACCESS
#  define access(file,mode) bsd_access(file,mode)
#endif BSD42ACCESS

/*
 * open a file for writing, creating it if it
 * doesn't exist.  The call only succeeds if
 * the user has the appropriate permissions;
 * this should be safe since all the notes directories
 * are appropriately protected.
 *
 * NB:  on non 4.2 BSD or SYS V systems, a newly created file
 * will be in the notes group.  This should not cause
 * any problems.  If we wanted to avoid this, though,
 * we would have to fork off a process to create the
 * file, which is gross.
 */
FILE *
rfopen(file, val)
	char *file;
	int *val;
{
	extern int errno;
	FILE *f;
	int ret;

	if (file==NULL || file[0] == '\0') {
	    /*
	     * file=="" will either make access() fail (AT&T's "improvement"),
	     * or means that we are asked to open the current directory for
	     * writing.  Notes should not be writing directories, so fail.
	     */
	    return NULL;
	}

	if ((ret = access(file, 2)) < 0) {
	    if (errno != ENOENT) {

		/* Just can't access */
		return(NULL);

	    } else {

		/*
		 * File does not exist yet.  Check if the directory it will
		 * be in is writable.
		 */
		extern char* rindex();
		char dir[WDLEN];
		char *end_dir;

		safecpy(dir, file, WDLEN);
		end_dir = rindex(dir, '/');
		if (end_dir != NULL) {
		    *end_dir = '\0';
		} else {
		    /* just a filename -- use "." */
		    dir[0] = '.'; dir[1] = '\0';
		}
		if (access(dir, 2) < 0) {
		    /* Will not be able to create the file */
		    return NULL;
		}
	    }
	}

	if ((f = fopen(file, "a")) == NULL)
		return(NULL);
#ifdef	SYSV
	/* do a chown here on sys V systems, give the file away */
	if (ret < 0)
		chown(file, globuid, globgid);
#endif
	*val = ret;
	return(f);
}
