/* $Header: pattern.c,v 1.5 86/06/11 12:21:03 notes Exp $ */

#define dprintf if (0) printf

/*
 * Expand patterns.
 * Entry points are dopat and checkpat.
 *
 *	Lou Salkind
 *	New York University
 */

#include "parms.h"
#include "structs.h"
#include <sys/stat.h>

#include <stdio.h>

static char **basep;
static int nitems = 0;

char *malloc();
char *index();
#ifdef __STDC__
int initdir(char*,char*);
int match(char*,char*);
#else
int initdir();
int match();
#endif

dopat(s, what)
	char *s;
	int (*what)();
{
	char *ip;
	int i;
	static int inited;

	if (inited == 0) {
    		x(initdir(spooldir, "") < 0, "initdir");
		inited++;
	}
	for (i = 0; i < nitems; i++) {
		ip = basep[i];
		if (match(s, ip))
			(*what)(ip);
	}
}

/*
 * patcheck - look for a pattern character.
 * These are the shell meta-characters ?, [, and *.
 * Return 0 if none exist in the string.
 */
patcheck(p)
char *p;
{
	register char *q;

	q = p;
	while (*q && (*q != '?') && (*q != '[') && (*q != '*'))
		q++;
	return(*q != '\0');
}

int
initdir(s, prefix)
	char *s;
	char *prefix;
{
	FILE *active;
	char filetemp[1024];
	int i,j;
	char **item_p;

retry:	/* sorry 'bout that, but... */
	sprintf(filetemp, "%s/%s", libdir, ACTIVE);
	if ((active=fopen(filetemp,"r")) == NULL) {
		if (badactive("An active file is not present; please wait.\n"))
			goto retry;
		else 
			return -1;
	}
	if (fscanf(active, "!!Active files: %d\n", &nitems) != 1) {
		fclose(active);
		if (badactive("An ill-formed active file is present; please wait.\n"))
			goto retry;
		else
			return -1;

	}
	/* a good active file exists, I hope */
	basep = (char **)malloc(nitems * sizeof(char *));
	if (basep == 0)
	    return(-1);
	item_p = basep;
	for (i = 0; i < nitems; i++) {
		if (fgets(filetemp, 1024, active) == NULL) {
			fclose(active);
			if (badactive("A truncated active file is present; please wait.\n"))
				goto retry;
			else
				return -1;
		}
			
		j = strlen(filetemp);
		*item_p = (char *)malloc(j);
		filetemp[j-1] = '\0';  /* the pesky newline */
		strcpy(*item_p, filetemp);
		item_p++;
	}

	fclose(active);
	return(0);
}

badactive(msg)
char *msg;
{
	char filetemp[1024];

	fputs(msg, stderr);
	sprintf(filetemp, "%s/%s", libdir, MAKEACTIVE);
	return dosystem(filetemp, spooldir, NOSTR) == 0;
}

/*
	Public domain filename pattern matching routine.  Adapted from:

char	sccsTag[] = "@(#) match.c	1.3	last edit 1/16/85 at 21:18:57";

	Author:		Gary S. Moss
			U. S. Army Ballistic Research Laboratory
			Aberdeen Proving Ground
			Maryland 21005-5066
			(301)278-6647 or AV-283-6647
 */

/*	 m a t c h ( )
	if string matches pattern, return 1, else return 0
	special characters:
		*	Matches any string including the null string.
		?	Matches any single character.
		[...]	Matches any one of the characters enclosed.
		[!..]	Matchea any character NOT enclosed.
		-	May be used inside brackets to specify range
			(i.e. str[1-58] matches str1, str2, ... str5, str8)
		\	Escapes special characters.
 */

#define	NUL	'\000'

int match(pattern, string)
	register char *pattern, *string;
{
	do {
		switch (pattern[0]) {
		case '*':
			/* Match any string including null string. */
			if (pattern[1] == NUL || string[0] == NUL)
				return 1;
			while (string[0] != NUL) {
				if (match(&pattern[1], string))
					return 1;
				++string;
			}
			return 0;
		case '?':
			/* Match any character. */
			break;
		case '[':
			/* Match one of the characters in brackets
				unless first is a '!', then match
				any character not inside brackets. */
		{ 
			register char *rgtBracket;
			static int negation;

			++pattern; 	/* Skip over left bracket. */
			/* Find matching right bracket. */
			if ((rgtBracket = index(pattern, ']')) == NULL) {
				/* prnt1Err( "Unmatched '['." ); */
				return 0;
			}
			/* Check for negation operator. */
			if (pattern[0] == '!') {
				++pattern;
				negation = 1;
			} else {
				negation = 0;
			}
			/* Traverse pattern inside brackets. */
			for( ; pattern < rgtBracket &&
			    pattern[0] != string[0]; ++pattern) {
				if (pattern[0] == '-' && pattern[-1] != '\\') {
					if (pattern[-1] <= string[0]
					    && pattern[-1] != '['
					    && pattern[1] >= string[0]
					    && pattern[1] != ']')
						break;
				}
			}
			if (pattern == rgtBracket) {
				if (!negation)
					return 0;
			} else {
				if (negation)
					return 0;
			}
			pattern = rgtBracket; /* Skip to right bracket. */
			break;
		}
		case '\\':
			/* Escape special character. */
			++pattern;
			/* WARNING: falls through to default case. */
		default:
			/* Compare characters. */
			if (pattern[0] != string[0])
				return 0;
		}
		++pattern;
		++string;
	} while (pattern[0] != NUL && string[0] != NUL);
	if ((pattern[0] == NUL || pattern[0] == '*') && string[0] == NUL)
		return 1;
	return 0;
}
