/* $Header: note.c,v 1.2 86/06/17 15:45:39 notes Exp $ */

#include "parms.h"
#include "structs.h"

/*
 *	Putnote
 *
 *	Take the given text, and make put it into the note file.
 *	following algorithm:
 *	reserve space for text
 *	write the text
 *	make the note header record
 *	lock the index file
 *	write the note header info
 *	unlock the index file
 *	rewrite the correct text header info
 *
 *
 *	Delnote(io, noteno):  marks the status word as deleted.
 *
 *	Original authors:	Rob Kolstad and Ray Essick	Winter 1980
 *	modified;	Ray Essick	December 1981
 */

putnote(io, note, policy, addtime)
struct io_f *io;
struct note_f  *note;
/* policy = true if this is the policy note */
/* addtime = false if we already have a time for the note */
{
    int notenum;

    note->n_nresp = 0;			/* no responses yet */
    if (addtime)			/* dont if compressing... */
	time(&note->n_lmod);
    note->n_rindx = -1;			/* no place for responses yet */

    getdscr(io, &io->descr);			/* grab notesfile header */
    if (io->descr.d_stat & NFINVALID) {
	closenf(io);
	opennf(io, io->nf);				/* get new links */
	return(-1);
    }
    if (policy) {
	io->descr.d_plcy = 1;		/* mark as having a policy note */
	notenum = 0;
    } else {
	notenum = ++io->descr.d_nnote;		/* this note's number */
    }
    if (addtime)				/* see if want timestamp */
	io->descr.d_lastm = note->n_lmod;	/* last time file modified */
    putnrec(io, notenum, note);			/* write note info */
    putdscr(io, &io->descr);			/* rewrite header info */
#ifdef MSGID_INDEX
    putmsgid(io, notenum, 0, &note->n_msg);
#endif /* MSGID_INDEX */
    io->nnotwrit++;				/* bump count of writes */
    return(io->descr.d_nnote);			/* tell which slot it is in */
}


delnote(io, noteno, lockit)
struct io_f *io;
{
    struct note_f   note;

    if (lockit) {
	lock(io, 'n');				/* CRITICAL */
    }
    getnrec(io, noteno, &note);			/* get the note */
    note.n_stat |= DELETED;			/* deleted */
    putnrec(io, noteno, &note);
    if (lockit) {
	unlock(io, 'n');			/* CRITICAL */
    }
}
