/* $Header: filexp.c,v 1.1 85/12/20 16:48:36 notes Exp $ */

#include "parms.h"
#include "structs.h"
#include <ctype.h>
#include <pwd.h>

/* adapted from lwall@sdcrdcf's rn for notes */

/* expand filename via %, ~, and $ interpretation */
/* returns pointer to static area */

extern char *myhome;

char *
filexp(s)
register char *s;
{
	static char filename[WDLEN];
	char scrbuf[WDLEN];
	register char *d;

	interp(filename,s);			/* interpret any % escapes */
	s = filename;
	if (*s == '~') {	/* does destination start with ~? */
		if (!*(++s) || *s == '/') {
			sprintf(scrbuf, "%s%s", myhome, s);
			/* swap $HOME for it */
			strcpy(filename, scrbuf);
		} else {
			struct passwd *getpwnam();
			struct passwd *pwd;

			for (d=scrbuf; isalnum(*s); s++,d++)
				*d = *s;
			*d = '\0';
			pwd = getpwnam(scrbuf);
			if (pwd) {
				sprintf(scrbuf, "%s%s", pwd->pw_dir, s);
				strcpy(filename, scrbuf);
			}
			endpwent();
		}
	} else if (*s == '$') {	/* starts with some env variable? */
		d = scrbuf;
		*d++ = '%';
		if (s[1] == '{')
			strcpy(d,s+2);
		else {
			*d++ = '{';
			for (s++; isalnum(*s); s++) *d++ = *s;
			/* skip over token */
			*d++ = '}';
			strcpy(d,s);
		}
		interp(filename,scrbuf);
		/* this might do some extra '%'s but */
		/* that is how the Mercedes Benz */
	}
	return filename;
}

/* TODO: add all the baroque escapes */
interp(p, q)
	char *p, *q;
{
	strcpy(p, q);
}
