/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/expand.c,v 2.0 89/04/16 00:49:57 gore Exp $ */

/*
 *	Routines to expand notesgroups specifications
 *
 *	Lou Salkind, New York University
 *	Rick L Spickelmier, UC Berkeley
 */

#include <ctype.h>
#include "structs.h"
#include "parms.h"
#include <sys/dir.h>
#include "dumpmsg.h"

#define	NHASH	809

#ifdef __STDC__
static int hashval(char*);
#else
static int hashval();
#endif

/*
 * Hash notesfiles names on hlink chain for fast access.
 * Per file information is kept on the nfile chain.
 */
struct hlink {
	struct nfile *h_nfile;
	struct hlink *h_next;
};

static struct hlink *hlink[NHASH];
static struct nfile *curnf;
static int seqtyp = 0;
static int terseflag = 0;
struct nfile *nfile;
static int first_time = 0;
static int tmp_jump_over_xposts = 0;
static int tmp_concise_quotes = 0;
static dumpfmt_t tmp_dump_format;

char pending = '\0';

/*
 * set the sequencer type (external interface)
 */
setseq(i)
{
	seqtyp = i;
}

/*
 * Return a pointer to notesfile information
 * Entries with lookat set false are permanently invisible
 */
struct nfile *
getnfile(name)
	char *name;
{
	register struct hlink *hp;
	register struct nfile *np;
	int hval;

	hval = hashval(name);
	for (hp = hlink[hval]; hp; hp = hp->h_next) {
		np = hp->h_nfile;
		if (strcmp(np->n_name, name) == 0 && np->n_lookat)
			return(np);
	}
	return(0);
}

/*
 * add a notesfile to the active list
 */
addgrp(string)
char *string;
{
	int hval;
	register struct hlink *hp;
	register struct nfile *np;
	char *malloc();

	/* see if it already exists */
	/* getnfile() will not match any entries where n_lookat is false */
	/* This allows us to maintain order-dependencies */
	if (np = getnfile(string))
		return;

	hp = (struct hlink *)malloc(sizeof (struct hlink));
	np = (struct nfile *)malloc(sizeof (struct nfile));
	if (hp == 0 || np == 0) {
		printf("addgrp: ignoring %s, can't malloc\n", string);
		return;
	}
	np->n_lookat = 1;
	np->n_concise = tmp_concise_quotes;
	np->n_jumpxpost = tmp_jump_over_xposts;
	np->n_dumpfmt = tmp_dump_format;
	np->n_seqtyp = seqtyp;
	np->n_name = strsave(string);
	np->n_next = 0;
	np->n_when = 0;
	/* update nfile chain */
	if (curnf)
		curnf->n_next = np;
	else
		nfile = np;
	curnf = np;
	/* update hlink chain */
	hval = hashval(string);
	hp->h_next = hlink[hval];
	hp->h_nfile = np;
	hlink[hval] = hp;
}

/*
 * delete the notesfile from the active list
 */
delete(string)
char *string;
{
	register struct nfile *np;

	if (np = getnfile(string)) {
		np->n_lookat = 0;	/* no garbage collection! */
		return;
	}
}

static int
hashval(s)
	register char *s;
{
	register int i = 0;
	register int c;

	while (c = *s++)
		i += c & 0377;
	return(i%NHASH);
}

/*
 * given a command line argument, expand it into
 * the appropriate sequence command or notesfile
 * specification
 */
expand(argp)
char *argp;
{
	char *endp;
	if (first_time) {
	    first_time = 0;
	    tmp_dump_format = default_dump_format;
	}

again:
	while (isspace(*argp))
		argp++;
	if (*argp == '\0')
		return;
	endp = argp;
	while (*endp) {
		if (isspace(*endp) || *endp == ',') {
			*endp++ = '\0';
			break;
		}
		endp++;
	}
	if (pending) {
	    /* This is an operand for the preceding option */
	    switch (pending) {
	      case 'd':				/* format for saving to disk */
		tmp_dump_format = dump_format(argp);
		if (tmp_dump_format == DMP_INVALID) {
		    fprintf(stderr, "-d needs a save format:\n");
		    explain_dump_formats(stderr);
		    exit(BAD);
		}
		break;

	      case 'r':					/* Reply-To: address */
		replyto_address = strsave(argp);
		break;

	      case 'T': 			      /* overriding tty type */
		myterm = strsave(argp);
		break;
	    }
	    pending = '\0';
	} else if (argp[0] == '-') {
		/* sequencing options */
		switch (argp[1]) {
		case 's': 		/* -S-equencer */
			seqtyp = NORMSEQ | terseflag;
			break;
		case 'x': 		/* e-X-tended sequencer */
			seqtyp = EXTSEQ | terseflag;
			break;
		case 'i': 		/* indexing sequencer */
			seqtyp = INDXSEQ | terseflag;
			break;
		case 'n': 		/* -N-o sequencer */
			seqtyp = NOSEQ | terseflag;
			break;
		case 't':
			terseflag ^= TERSE;
			seqtyp ^= TERSE;
			break;
		case 'c':
			tmp_concise_quotes ^= 1;
			break;
		case 'j':
			tmp_jump_over_xposts ^= 1;
			break;
		case 'd':
		case 'r':
		case 'T':
			pending = argp[1];
			argp = endp;
			goto again;
		}
	} else {
		/* newsgroup specification */
		if (argp[0] == '!') {
			/* handle not's */
			if (patcheck(&argp[1]))
				/* wildcard */
				dopat(&argp[1], delete);
			else 
				delete(&argp[1]);
		} else {
			if (patcheck(argp))
				dopat(argp, addgrp);
			else
				addgrp(argp);
		}
	}
	argp = endp;
	goto again;
	/*NOT REACHED*/
}
