/* $Header: compat.c,v 1.6 87/06/10 20:18:34 notes Exp $ */

/*
 * Miscellaneous collection of local routines -
 * for compatability between UNIX versions
 */

#include "parms.h"
#include "structs.h"

/* This is to get MAXPATHLEN */
#ifdef BSD4_2
#  include <sys/param.h>
#endif

#ifndef	BSD4_2
/* emulate 4.2 BSD rename call */
rename(a, b)
char *a, *b;
{
	unlink(b);
	if (link(a, b) < 0)
		return(-1);
	return(unlink(a));
}

#include <sys/utsname.h>

/* emulate 4.2 BSD gethostname call */
gethostname(s, n)
	char *s;
{
	struct utsname ubuf;

	uname(&ubuf);
	strcpy(s, ubuf.nodename);
}

/*
 * emulate 4.2 BSD bzero library call
 *   move n bytes from a to b
 */
bcopy(a, b, n)
register char *a, *b;
register n;
{
	while (--n >= 0)
		*b++ = *a++;
}

/* emulate 4.2 BSD bzero library call */
bzero(p, n)
	register char *p;
	register int n;
{
	while (--n >= 0)
		*p++ = 0;
}

/* emulate 4.2 BSD bcmp library call */
bcmp(a, b, n)
     register char *a, *b;
     register int n;
{
  while (--n >= 0)
    if (*a++ != *b++)
      return 1;
  return 0;
}
#endif	BSD4_2

#ifndef	SYSV
/*
 * Use getwd() to emulate getcwd() from Sys V.
 *  Why can't these idiots agree on something this simple?
 *  W. Underwood, May 1986
 */
char *
getcwd(buf, size)
     char *buf;
     int size;
{
  extern char *getwd();
  char wdbuf[MAXPATHLEN];
  char *result;

  result = getwd(wdbuf);
  if( result == NULL )
    return NULL;		/* At least the error returns are the same */

  if( buf == NULL )			/* Yes, getcwd() really does this */
    buf = malloc(size);
  
  size = (size<MAXPATHLEN) ? size : MAXPATHLEN ; /* Keep the minimum */

  safecpy(buf, wdbuf, size);
  return buf;
}

/*
 * (stupid) public domain implementation of strtok()
 * added by lks - for sites without sys v source.
 */
char *
strtok(s1, s2)
	register char *s1, *s2;
{
	register char *p;
	static char *save;
	static char ochar;
	extern char *index();		/* SHOULD BE DONE INLINE */

	if (s1 == 0) {
		s1 = save;
		if (ochar)
			s1++;
	}
	while (*s1 && index(s2, *s1))
		s1++;
	if (*s1 == '\0')
		return((char *)0);
	p = s1++;
	while (*s1 && index(s2, *s1) == 0)
		s1++;
	ochar = *s1;
	*s1 = '\0';
	save = s1;
	return(p);
}
#endif

#ifdef	SYSV
/*
 * Return the ptr in sp at which the character c appears;
 * NULL if not found
 *
 * These are the v7 index and rindex routines, stolen for portability.
 * (Some Unix systems call them strchr and strrchr, notably PWB 2.0
 * and its derivitives such as Unix/TS 2.0, Unix 3.0, etc.)  Others,
 * like v6, don't have them at all.
 */

char *
index(sp, c)
register char *sp, c;
{
	do {
		if (*sp == c)
			return(sp);
	} while (*sp++);
	return(NULL);
}

/*
 * Return the ptr in sp at which the character c last
 * appears; NULL if not found
 */

char *
rindex(sp, c)
register char *sp, c;
{
	register char *r;

	r = NULL;
	do {
		if (*sp == c)
			r = sp;
	} while (*sp++);
	return(r);
}
#endif	SYSV

#ifdef FAKE_FTIME
/*
 *	This performs the "ftime" call for systems which no longer
 *	support that system call.  Ftime(2) is from Seventh Edition Unix.
 *
 *	Currently, this is only the USG systems: System III, System V,
 *	UNIX 4.0 (btl-internal), and HP-UX for the HP9000/s500 (Rel. 5.0).
 *	This code is only compiled for these systems.
 *
 *	This code taken from news 2.11
 */

#include "timeb.h"		/* Note -- local version of this file */

extern long timezone;
extern int  daylight;

ftime (tp)
struct timeb   *tp;
{
    long    t;

    time (&t);
    tp -> time = t;
    tp -> millitm = 0;
    tp -> timezone = timezone / 60;
    tp -> dstflag = daylight;
}
#endif	FAKE_FTIME
