/* $Header: cgtdate.c,v 1.3 87/10/02 15:50:19 notes Exp $ */

#include <sys/types.h>
#include <time.h>

/*
 *  cgtdate() -- like getdate(), except that it checks for ctime format
 *    first.  getdate munges ctime horribly, interpreting the year as
 *    a timezone offset.  cgtdate() does not seem to munge ARPA format
 *    dates, but it is possible that it could mistake an ARPA date for
 *    a ctime date.  If you have something that really is in ARPA format
 *    (i.e., conforming to RFC-822), use getdate directly.
 *
 *    This used to check for ctime format after running getdate, but the
 *    News 2.11 getdate added the numeric timezone (like "-0700") and
 *    that will accept 1987 as a timezone.
 *
 *    updated -- 28 sep 1987  w. underwood
 */

time_t
cgtdate(datestr)
char *datestr;
{
	time_t i;
	char bfr[200], junk[40],month[40];
	int  day, hh, mm, ss, year;
	int  num;

	num = sscanf(datestr, "%s %s %d %d:%d:%d %d",
		     junk, month, &day, &hh, &mm, &ss, &year);

	if (num == 7)		/* Probably ctime format, rewrite to ARPA */
	  {
	    sprintf(bfr, "%s %d, %d %d:%d:%d", month, day, year, hh, mm, ss);
	    return getdate(bfr, (struct timeb *)0);
	  }
	else
	  return getdate(datestr, (struct timeb *)0);
}
