/* $Header: checknotes.c,v 1.2 87/06/10 20:09:13 notes Exp $ */

/*
 *	checknotes
 *
 *	A program which prints the notesfiles modified since the
 *	user's last entry. The output is a list of the modified
 *	notesfiles. 
 *	
 *	The program exits with a zero status if there ARE modified
 *	notesfiles, and non-zero if there are not. This is to
 *	correspond with the "true" and "false" programs and 
 *	to permit use of the program in shell scripts.
 *
 *	The optional "-q" parameter disables the printing of the
 *	names of the notesfiles, the exit code is the only method
 *	of determining the existence of new notes.
 *
 *	Original Coding:	Ray Essick	June 12, 1982
 */

#include "parms.h"
#include "structs.h"

#define	VERBQ	0
#define	VERBN	1
#define	VERBV	2
#define	VERBS	3

int     verbosity = VERBQ;				/* be verbose */
int     ncount = 0;			/* number of modified notesfiles */
char    *strsave();

checknf(nfname, wdate)
	char *nfname;
	time_t wdate;
{
    struct io_f io;
    int     retcode;

    /* extra test to avoid opening files */
    if (nfmod_before(nfname, wdate))
	return(0);
    if ((opennf (&io, nfname) < 0) || !allow(&io,READOK))
	return(0);					/* ignore this one */
    getdscr(&io, &io.descr);
    io.stime = wdate;
    if (io.stime < io.descr.d_lastm) {
	ncount++;			/* bump count of touched notesfiles */
	if (verbosity == VERBV) {
	    printf ("%s\n", nfname);
	}
	if (verbosity == VERBQ || verbosity == VERBS) {
	    retcode = QUITFAST;
	} else {
	    retcode = 1;
	}
    } else {
	retcode = 0;
    }
    closenf (&io);				/* close the notesfile */
    return(retcode);
}

main(argc, argv)
char  **argv;
{
    int     i;					/* hold characters */
    char    cmdline[CMDLEN];			/* buffer names */
    int notesargs = 0;
    struct nfile *np;
    char *home;

	initenv();

    for (i = 1; i < argc; i++)
	if (argv[i][0] == '-') {			/* see if options */
	    switch (argv[i][1]) {
		case 'q': 				/* "are new notes" */
		    verbosity = VERBQ;
		    break;

		case 'n': 			/* spit "no new notes" */
		    verbosity = VERBN;
		    break;

		case 'v': 				/* tell everything */
		    verbosity = VERBV;
		    break;

		case 's': 				/* silent */
		    verbosity = VERBS;
		    break;

		case 'f':
		    notesrc = argv[++i];
		    break;

		default: 
		    fprintf (stderr, "Usage: %s [-qvns] [-f file]\n", argv[0]);
		    exit(BAD);
	    }

	} else {
	    expand(argv[i]);
	    notesargs++;
	}

    if (notesrc) {
	if (readrc(notesrc) < 0) {
		perror(notesrc);
		exit(BAD);
	}
    } else if (notesargs == 0) {
	sprintf(cmdline, "%s/%s", myhome, NOTESRC);
	readrc(cmdline);		/* ignore return status */
    }
    sprintf(cmdline, "%s/%s", myhome, NOTESEQ);
    readseq(cmdline, 1);
    for (np = nfile; np; np = np->n_next) {
	if (np->n_lookat == 1) {
	    if (checknf(np->n_name, np->n_when) == QUITFAST)
		break;
	}
    }
    switch (verbosity) {
	case VERBQ: 					/* "there are new" */
	    if (ncount) {
		printf ("There are new notes\n");
	    }
	    break;

	case VERBN: 					/* there are no new */
	    if (ncount == 0) {
		printf ("There are no new notes\n");
	    }
	    break;

	case VERBV: 					/* told elsewhere */
	case VERBS: 					/* silent */
	default: 
	    break;
    }
    if (ncount) {
	exit(GOOD);			/* TRUE/success for the shell */
    } else {
	exit(BAD);			/* FALSE/failure to the shell */
    }
}
