
/*
 * Routine to handle the processing of newsgroups
 */

 /*
  * Newsclip(TM) Library Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip library for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed.
  * Use of this code for a short term evaluation of the product, as defined
  * in the associated file, 'Licence', is permitted.
  */


#include "nl.h"

dbptr ng_base;		/* the database of known newsgroup names */

int group_count;	/* count of newsgroups in database */

ngrec **ngarray;		/* newsgroup array */
ngrec **ngarray_base;		/* alloced address for newsgroup array */
ngrec *extra_g_mem;		/* memory for extra groups */

/* Initialize the newsgroup database.  This may just involve the use
   of the predefined newsgroup names in the user program, or we may read
   in a pile of groups from the .newsrc, .nglas and active files. */

initngs(rcmode)
bool rcmode;		/* true if reading newsrc */
{
	extern int user_gcount;	/* count of user referenced groups */
	ngrec *group;	/* group record */
	extern char *user_groupnames[];	/* groups referenced in user code */
	int i;

	group_count = 1;

	ng_base = init_db( rcmode ? 400 : user_gcount, sizeof(ngrec) );

	/* now add the newsgroup names from the user's program */

	for( i = 0; user_groupnames[i]; i++ ) {
		group = (ngrec *)add_rec(ng_base, user_groupnames[i],	
						AR_CREATE|AR_NOALLOC);
		if( group->ngnumber == 0 )
			group->ngnumber = group_count++;
		}

	/* read in data needed to process a .newsrc file */
	if( rcmode ) {
		read_las();
		read_newsrc();
		read_active();
		}
	/* read in and set distributions */
	handle_distrs();

	/* now build the newsgroup array */
	ngarray_base = (ngrec **)perm_alloc( (group_count+NG_EXTRAS) *
					sizeof(ngrec *) );
	ngarray = ngarray_base + NG_EXTRAS;
	/* mem for temporary newsgroups */
	extra_g_mem = (ngrec *)perm_alloc( NG_EXTRAS * sizeof(ngrec) );

	/* There are NG_EXTRAS negative slots for undefined groups */

	for( group = (ngrec *)first_rec(ng_base); group;
					group =next_rec(ng_base,group) )
		ngarray[group->ngnumber] = group;
	ngarray[0] = (ngrec *)0;
}

/* Read the active file for the latest info on our groups */

/* Note that we don't read in groups in the active file that we
   haven't already seen in the program, .newsrc or .nglas files */

read_active()
{
	FILE *afile;
	ngrec *group;
	char buf[MAX_LLEN];		/* line buffer */
	long highart, lowart;		/* article limits of newsgroup */
	char *spp;			/* space position */


	afile = dfopen( news_lib_dir, "active", "r" );
	if( !afile ) 
		error( "Missing active file" );


	while( fgets( buf, sizeof(buf), afile ) ) {
		spp = strchr( buf, ' ' );
		if( !spp )
			continue;		/* report error in active? */
		*spp = 0;
		group = (ngrec *)get_rec( ng_base, buf );
		if( !group )
			continue;		/* not a subscribed group */
		if( sscanf( spp+1, "%lu %lu", &highart, &lowart ) == 2 ) {
			group->highest = (int32)highart;
			group->lowest = (int32)lowart;
			group->gflag |= GF_ACTIVE;	/* it exists */
			}
		}
	fclose( afile );
}

/* return the newsgroup number for a selected group 
 * If we get a group that we haven't seen, we assign it a negative
 * number and put a temporary negative entry in the newsgroup table
 * so that we can still refer to the group name.   Up to 20 unknown
 * groups can come in per article, this should be plenty.  The table
 * is reset with every article */

int extra_groups;		/* number of unknown groups, this article */
int ex_group_base;		/* base for extra groups */

int
ng_number( str )
char *str;		/* name of newsgroup */
{
	ngrec *group;
	extern bool wants_dist;
	extern ngrec *extra_g_mem;

	group = (ngrec *)get_rec( ng_base, str );
	if( group ) 
		return group->ngnumber;
	 else 
		if( extra_groups < NG_EXTRAS ) {
			group = &extra_g_mem[extra_groups];
			++extra_groups;
			zero( group, sizeof( ngrec ) );
			group->key = str;	/* already temp alloced */
			group->ngnumber = -extra_groups;
			ngarray[-extra_groups] = group;
			if( wants_dist )
				set_distribution( group );
			return -extra_groups;
			}
		 else
			return -1;	/* 20 extra groups!  return first */
		
		
}

static char nfname[MAX_NGLEN];

/* Change a newsgroup name into a subdirectory name in the news spools */

char *
ngdir( groupname )
char *groupname;		/* name of newsgroup, with dots */
{
	char *p;

	strcpy( nfname, groupname );

	/* map dots to slashes */
	for( p = nfname; *p; p++ )
		if( *p == '.' )
			*p = '/';
	return nfname;
}

/* Read in list of distributions, and assign a distribution to each
   newsgroup */


handle_distrs()
{
	char ng[MAX_NGLEN];	/* newsgroup distribution name */
	FILE *distfile;		/* file of distribution codes */
	char distline[MAX_LLEN];/* buffer line for distribution */
	ngrec *group;
	int dlevel;		/* distribution level */
	extern char *news_lib_dir;
	extern bool wants_dist;	/* are distributions even desired? */

	distfile = dfopen( dotdir, DISTLIST, "r" );
	if( !distfile )
		distfile = dfopen( news_lib_dir, DISTLIST, "r" );
	if( !distfile )
		distfile = dfopen( ".", DISTLIST, "r" );
	if( !distfile ) {
		warning( 1, "No distribution file %s\n", DISTLIST );
		wants_dist = FALSE;
		return;
		}

	while( fgets( distline, sizeof(distline), distfile ) ) {
		if( distline[0] == '#' )
			continue;	/* comment */
		if( sscanf( distline, "%s %d", ng, &dlevel ) != 2 )
			continue;
		group = (ngrec *)add_rec(ng_base, ng, AR_CREATE);
		if( group->ngnumber == 0 )
			group->ngnumber = group_count++;
		group->distribution = dlevel;
		}
	fclose( distfile );

	for( group = (ngrec *)first_rec(ng_base); group;
					group =next_rec(ng_base,group) )
		set_distribution( group );
}

/* Default distribution if we can't figure it out */
/* It's hard to say what this should be or what meaning it has.  The
   user can extern it and set it, I guess */
 
int def_distribution = 10;

/* figure out and set the distribution for a given group */

set_distribution( group )
ngrec *group;
{
	ngrec *drec;			/* distribution record */
	char gname[MAX_NGLEN];		/* buffer for placing group name */
	char *p;

	if( group->distribution == 0 ) {
		strcpy( gname, group->key );
		p = gname + strlen(gname) - 1;	/* point at end */
		/* loop through stripping off suffixes, and testing to see
		   if there is a distribution number for them */
		while( p > gname ) {
			if( *p == '.' ) {
				*p = 0;
				if( (drec = (ngrec*)get_rec( ng_base, gname)) &&
						drec->distribution > 0) {
					group->distribution =drec->distribution;
					return;
					}
				}
			p--;
			}
		/* set default as we found nothing */
		group->distribution = def_distribution;
		}

		
}
