
#include "nc.h"
/*
 * General library for the compiler
 */
 /*
  * Newsclip(TM) Compiler Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip compiler for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed before compiling.
  * A short time evaluation of this product is also permitted.  See the file
  * 'Licence' in the library source directory for details.
  */

char *
checkalloc( size )
unsigned int size;
{
	char *p, *malloc();

	p = malloc( size );
	if( p )
		return p;
	 else
		fatal( TRUE, "Out of memory" );
}

char *
perm_alloc(size)
unsigned int size;
{
	return checkalloc(size);
}

perm_free(mem)
char *mem;
{
	free(mem);
}
/*
 * error message routines 
 * These routines use the non-portable variable arguments method of
 * just passing a bunch of int arguments on the stack and using them.
 * Then again, there really isn't a portable way to write these routines.
 * This method works on most machines you find Unix on.
 * For those where it doesn't, these routines are easy to redo.
 */

/* error detected while parsing */
int got_error = 0;

parerror( form, a, b, c, d, e, f )
char *form;
int a,b,c,d,e,f;
{
	extern char *yyfilename;
	extern int yylineno;


	if( yylineno )
		fprintf( stderr, "%s(%d): ", yyfilename, yylineno );
	fprintf( stderr, form, a,b,c,d,e,f );
	fprintf( stderr, "\n" );

	got_error |= SYNTAX_ERROR;

}

error( form, a, b, c, d, e, f )
char *form;
int a,b,c,d,e,f;
{
	fatal(TRUE, form,a,b,c,d,e,f );
}

fatal( giveline, form, a, b, c, d, e, f )
bool giveline;			/* give the line number and file name */
char *form;
int a,b,c,d,e,f;
{
	extern char *yyfilename;
	extern int yylineno;

	if( giveline && yylineno )
		fprintf( stderr, "%s(%d): ", yyfilename, yylineno );
	fprintf( stderr, form, a,b,c,d,e,f );
	fprintf( stderr, "\n" );
	wrapup();
}

cprintf( form, a,b,c,d,e,f,g,h,i,j,k )
char *form;
int a,b,c,d,e,f,g,h,i,j,k;
{
	extern FILE *outstream;

	/* at this point line numbers don't matter */

	/* check for write error? */
	fprintf( outstream, form, a,b,c,d,e,f,g,h,i,j,k );
}

wrapup()
{
	exit(1);
}

lowercase( str )
register char *str;
{
	while( *str ) {
		if( isupper( *str ) )
			*str |= 0x20;
		str++;
		}
}

char *
allocstring( str )
char *str;
{
	char *res;

	res = perm_alloc( strlen(str) + 1 );
	strcpy( res, str );
	return res;
}

/* type error in the tree */

terror( tp, format, a,b,c,d,e,f )
nodep tp;		/* node at which the error took place */
char *format;		/* main string of error */
int a,b,c,d,e,f;
{
	extern char *findfile AC((nodep));

	/* scan up to a list node to file line number and file */
	fprintf( stderr, "%s(%d): ", findfile(tp), tp->line_num );

	fprintf( stderr, format, a,b,c,d,e,f );
	fprintf( stderr, "\n" );

	got_error |= TYPE_ERROR;
}
/* Zero out a region of memory.  Your system may have a routine around to
   do this faster.  If so, remove this and use your own. */

zero( mem, bytes )
char *mem;
int bytes;
{
	register int *p;
	register char *cp;
	int words, extra;

	words = bytes/sizeof(int);
	extra = bytes - sizeof(int)*words;

	p = (int *)mem;
	while( words-- )
		*p++ = 0;
	cp = (char *)p;
	while( extra-- )
		*cp++ = 0;
}
