

#include "nl.h"

/*
 * Master routine to call the user's code on an article
 * Returns true if the article is to be accepted.
 */

 /*
  * Newsclip(TM) Library Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip library for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed.
  * Use of this code for a short term evaluation of the product, as defined
  * in the associated file, 'Licence', is permitted.
  */


int num_links;			/* number of links to file */
int article_size;		/* size of article in bytes */
datehold write_time;		/* time article was written */
newsgroup dir_newsgroup;	/* directory newsgroup */
int distribution_level;		/* level of distribution for this article */
int accept_all = 0;		/* accept all articles in a group? */
int reject_all = 0;		/* reject all articles in a group? */

username dummy_user = {
"", ""
};

#include <sys/stat.h>

static FILE *art_desc;		/* article descriptor */

bool
accept_article( filename )
char *filename;		/* name of the article file, or null if a pipe */
{
	struct stat ourstat;		/* stat of file, if possible */
	extern bool needs_stat;		/* is a stat of the article needed? */
	extern datehold time_now;	/* time this program was run */
	extern newsgroup main_newsgroup;	/* the 'current newsgroup' */
	extern array *newsgroups;	/* array of newsgroups for this art */
	extern int extra_groups;	/* number of temporary groups */
	extern int ex_group_base;	/* base for temporary group count */
	extern int score;		/* score of article test */
	extern int io_mode;		/* style of article reading */
	FILE *art;		/* file stream of the article */
	bool filemode;			/* are we using a file */
	extern char *article_filename;	/* global for user program */
	extern int reading_mode;	/* style of file reading */

	/* first we check if global accept/reject flags are on for this group */

	if( accept_all ) {
		score = 1000;
		return TRUE;
		}
	 else if( reject_all ) {
		score = -1000;
		return FALSE;
		}

	score = 1;		/* default is to accept */

	filemode = reading_mode != PIPE_READ;

	/* Next open the file, if the article is indeed in a file */

	if( filemode ) {
		art = fopen( filename, "r" );

		if( !art ) {
			warning( 3, "Could not open article %s\n", filename );
			score = -1;
			return FALSE;
			}
		article_filename = filename;
		}
	 else {
		art = (FILE *)0;
		article_filename = "";
		}

	/* Get statistics from the inode if the article is in a file and
	   the user program wants these statistics */

	if( needs_stat && reading_mode == FILE_FULL &&
				fstat( fileno(art), &ourstat ) == 0 ) {
		num_links = ourstat.st_nlink;
		if( (int)ourstat.st_size != ourstat.st_size )
			article_size = MAXINT;
		 else
			article_size = ourstat.st_size;
		write_time = (datehold)ourstat.st_mtime;
		}
	 else {
		num_links = 1;
		article_size = -1;
		write_time = time_now;
		}

	/* clear region for temporary newsgroups */
	extra_groups = ex_group_base;

	/* scan the header.  If there are fewer than 3 header items
	   in it, it's a bogus article and is rejected */
	if( reading_mode != FILE_FULL )
		if( ask_for_header() == ERRCODE )
			return ERRCODE;

	if( read_header( art ) < 3 ) {
		warning( 3, "Invalid header in file %s\n", article_filename );
		return FALSE;
		}


	/* An article without a Newsgroups line is a bogus one */
	if( newsgroups == (array *)0 ) {
		warning( 3, "Missing Newsgroups in file %s\n", article_filename );
		return FALSE;
		}

	/* Initialize the routines that might scan the article body */

	prepare_body( io_mode );

	/* If there isn't really a current newsgroup, invent one by
	   taking the first group on the newsgroups line */

	if( main_newsgroup == NULL_NEWSGROUP )
		main_newsgroup = newsgroups->vals[0].uinteger;

	/* Set the newsgroup expanded in ~N codes in filenames */

	dir_newsgroup = main_newsgroup;

	/* prepare the calculated items */
	calc_items();

	/* now run the code on the article */

	art_desc = art;			/* external with file descriptor */

	/* call the user routines that set the score and deal with it */

	Uarticle();
	Upost_article(score);


	if( filemode && art )
		fclose( art );

	/* A positive score means accept.  0 or less is reject */

	return score > 0;
}

username *rsender;		/* Sender, or From: if no sender */
username *rreply_to;		/* Reply-to, or From: if no reply-to */
array *rdistribution;		/* Distribution, or newsgroups if none */
array *rfollowup_to;		/* followup-to, or newsgroups if none */
int followup;			/* indicates if the message is a followup */

/* This routine generates the guaranteed defined field variables, for
   header items that are optional, but which have a default should they
   not be present */

calc_items()
{
	/* various header items we calculate from */
	extern username *sender;
	extern username *from;
	extern username *reply_to;
	extern char *subject;
	extern char *message_id;
	extern array *distribution;
	extern array *followup_to;
	extern array *newsgroups;
	extern int followup;
	extern array *references;
	extern bool wants_dist;			/* does the user need a
						distribution calculation? */
	extern int distribution_level;

	/* Set up dummys if the required headers are missing */
	/* Usually if this happens we have a manged article and should
	   probably reject it */

	if( from == (username *)0 )
		from = &dummy_user;
	if( subject == (char *)0 )
		subject = "";
	if( message_id == (char *)0 )
		message_id = "<NULL>";

	rsender = sender ? sender : from;
	rreply_to = reply_to ? reply_to : from;
	rdistribution = distribution && distribution->arsize > 0 ?
				distribution : newsgroups;
	rfollowup_to = followup_to ? followup_to : newsgroups;
	followup = references && references->arsize > 0;

	/* figure out the integer representing the widest distribution
	   this article will get */

	if( wants_dist ) {
		int i;
		int gdist;
		int newsgroup_glevel;
		distribution_level = 1;		/* local */

		/* find the maximal distribution from dist line */
		for( i = 0; i < rdistribution->arsize; i++ ) {
			gdist = ngarray[rdistribution->vals[i].uinteger]
						->distribution;
			if( gdist > distribution_level )
				distribution_level = gdist;
			}
		newsgroup_glevel = 1;
		for( i = 0; i < newsgroups->arsize; i++ ) {
			gdist = ngarray[newsgroups->vals[i].uinteger]
						->distribution;
			if( gdist > newsgroup_glevel )
				newsgroup_glevel = gdist;
			}
		/* if the groups had a smaller distribution, use it, as
			the distribution line only restricts distribution,
			it does not expand it */
		if( newsgroup_glevel < distribution_level )
			distribution_level = newsgroup_glevel;
		}

}

/* Routine called by body reading code to get file descriptor */

FILE *
get_body_desc(size)
int size;
{
	extern int reading_mode;
	if( reading_mode != FILE_FULL )
		ask_for_body();
	return art_desc;
}

/* This function gets the size of the article for user programs */

art_bytes()
{
	extern int header_size;
	long calc_size;

	if( article_size >= 0 )
		return article_size;
	 else
		return makeint((long)header_size + byte_count(7));
}

/* When the current group changes, we call user code and clear global
   accept/reject flags */

finish_group()
{
	extern int accept_all, reject_all;	/* global flags */

	Uendgroup();
	accept_all = reject_all = FALSE;
}
