/*
	eepmisc.c  -- Miscellaneous functions 
*/

#include	<stdio.h>
#include	<ctype.h>
#include	"eep.h"

int	time_out = TIMEOUT; /* keyboard inactivity timer */

/* Process the alarm signal here.  This will cause a keyboard timeout
   to occur, and exit from the system.  */

int	catchalarm(signo)
int	signo;
{
	printf("Keyboard inactivity timer caused exit.\r\n");
	fflush(stdout);
	exit(0);
}


/* wrap -- this function will take a string, and word wrap it to
within the defined width by inserting CRLF at appropriate places. 
The result will be output directly.  An offset may be defined, 
which will not be used on the first line only. */

wrap(string,width,offset)
char	*string;
int	width,
	offset;
{
char	temp[80];	/* temporary buffer */
char	*p,*q;	/* traverse the string with this */
int	count;	/* keep track of characters */
int	offcount;
int	first_line;

	if (width == 0) {
		printf("Can't wrap to zero width, sorry!");
		printf(CRLF);
		return(-1);
	}
	if (strlen(string) == 0) return;
	p = string;
	q = temp;
	count = 0;
	first_line = 0;	/* no offset for first line */
	while (*p != '\000') {
		*q = *p;
		if (count == width) { /* check for wrapping */
			while (*p != ' ') {
				q--;
				p--;
				if (--count == 0) { /* can't wrap! */
					/* so we truncate */
					q = temp + width;
					p = p + width; /* carry on... */
					break;
				}
			}
			*q = '\0';  /* terminate output here */
			if (first_line != 0) {
				offcount = offset;
				while (offcount-- > 0) printf(" ");
			}
			first_line = 1;
			printf(temp);
			printf(CRLF);
			count = -1;	/* new line */
			q = temp - 1;
		}
		count++;
		p++;
		q++;
	}
	*q = '\0';
	if (first_line != 0) {
		offcount = offset;
		while (offcount-- > 0) printf(" ");
	}
	printf(temp);
	printf(CRLF);
}

/* These next two routines simply lifted from the Elm mail package, 
by Dave Taylor.  If you need a nice mail system, you won't have to 
look much further than Elm!  -- P.G. */

char	*shift_lower(string)
char	*string;
{
	/** return 'string' shifted to lower case.  Do NOT touch the
	    actual string handed to us! **/

	static char buf[BUFSIZE];
	register char *bufptr = buf;

	for (; *string; string++, bufptr++)
	  if (isupper(*string))
	    *bufptr = tolower(*string);
	  else
	    *bufptr = *string;
	
	*bufptr = 0;
	
	return( (char *) buf);
}


int	in_string(buf, pat)
char	*buf, *pat;
{
	/** Returns TRUE iff pat occurs IN ITS ENTIRETY in buf. **/ 

	register int i = 0, j = 0;
	
	while (buf[i] != '\0') {
	  while (buf[i++] == pat[j++]) 
	    if (pat[j] == '\0') 
	      return(TRUE);
	  i = i - j + 1;
	  j = 0;
	}
	return(FALSE);
}
