/*  eep.h

This is the common header file for the eep program.

*/

#define NEWSBASE "/usr/spool/news/"  /* where news lives */
#define ACTIVEFILE "/usr/lib/news/active" /* active file */
#define NEWSGROUPS "/usr/lib/news/newsgroups" /* descriptions of newsgroups */
#define NEWSLOCAL "/usr/lib/news/newslocal" /* local newsgroups */
#define NEWSDIST "/usr/lib/news/distributions" /* news distributions */
#define CRLF	"\n"	/* may differ for non-UNIX */
#define FALSE 0
#define TRUE 1
#define EEPLINES 24	/* lines shown on screen */
#define EEPCOLUMNS 80	/* columns shown on screen */
#define EEPPAGE 20	/* page size for scrolling */
#define BUFSIZE 1024	/* general line buffer length */
#define MAXLEVELS 20	/* depth of news hierachies */
#define MAXLINES 3000	/* max. number of news groups */
#define MAXDIST 40	/* number of top level distribution names */
#define TIMEOUT 2	/* keyboard inactivity timer in minutes */
#define SHELLDENY 3	/* uid for user to deny shell access to */
#define SHELL "/bin/ksh" /* default shell */

/* This is the primary data storage structure.  It combines both the
active file and the .newsrc file.  We'll malloc() space for each
element of the structure, and use an array of pointers to access it
*/

struct actif	{

char	*name,  /* news group */
	*desc,	/* description of newsgroup */
	*hilo;	/* hilo range from my .newsrc */

int	hi,lo,	/* hi and low from active file */
	index,	/* used as alternate index into array */
	my_hi, my_lo;	/* high and low from .newsrc */

char	flag,	/* [ynm] from active file */
	status;	/* [:!] from .newsrc file */

/* This record will be part of two linked lists.  One will be based
upon the ``depth'' of the newsgroup (i.e. the number of dots in the
name), while the other will be used to maintain the order that it
was found in the .newsrc */

struct  actif *depth;	/* pointer to next entry in ``depth'' list */
struct  actif *order;	/* pointer to next entry in ``order'' list */
};

